

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGettingStartedInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppGettingStartedInfo							|
--	|  Procedure to get info for getting started page					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGettingStartedInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGettingStartedInfo')
	drop procedure AppGettingStartedInfo
IF EXISTS (select * from GxQscripts where name='AppGettingStartedInfo')
	delete from GxQscripts where name = 'AppGettingStartedInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGettingStartedInfo')
	delete from GXDBVersions where aliasname = 'AppGettingStartedInfo'
GO
print '... Creating Procedure: AppGettingStartedInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGettingStartedInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @packageInfo NVARCHAR(10) = ''
	DECLARE @webConsoleURL		NVARCHAR(MAX) = ''
	SET @o_xmlString = '<App_GetDLOGettingStartedInfoResp/>'
	SELECT @webConsoleURL = value FROM GXGlobalParam
	WHERE name = 'WebConsoleURL' AND modified = 0
	DECLARE @posIdx INT = PATINDEX('%/webconsole/%', @webConsoleURL)
	IF @posIdx = 0
	BEGIN
		SET @posIdx = PATINDEX('%/webconsole%', @webConsoleURL)
		IF @posIdx = 0
		BEGIN
			--SET @errorCode = 2
			--SET @errorString = 'Error : Invalid webserver information.'
			GOTO ERROR_EXIT
		END
		SET @webConsoleURL =  REVERSE(RIGHT(REVERSE (@webConsoleURL), len(@webConsoleURL) -
			NULLIF(charindex('elosnocbew/', REVERSE(@webConsoleURL)) - 2,0))) + '/'
	END
	ELSE
	BEGIN
		SET @webConsoleURL = LEFT(@webConsoleURL, @posIdx+LEN('/webconsole/')-1)
	END
	SET @webConsoleURL = @webConsoleURL + 'downloadcenter/downloadPackage.do?packageId='
	SET @packageInfo = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'DLOPackageIsReady' AND modified = 0), '0')
	SET @o_xmlString =
	(
		(SELECT	@packageInfo AS '@packageIsReady',
			(
				SELECT C.id AS '@clientId', C.name '@clientName'
				FROM APP_Client C (NOLOCK)
				WHERE C.id IN (SELECT (clientId) FROM App_FirewallOptions (NOLOCK) WHERE isDMZ = 1)
				FOR XML PATH('proxyClient'), TYPE
			),
			(
				SELECT  (@webConsoleURL + CAST(P.PackageId AS NVARCHAR(10))) '@downloadLink', F.PlatformName '@PlatformName', F.PlatformId '@PlatformId',
				P.PackageId AS 'gsPackageName/@packageId', P.PackageName 'gsPackageName/@packageName'
				FROM DCPackage P (NOLOCK)
				JOIN DCPackagePlatform L (NOLOCK) ON L.PackageId = P.PackageId
				JOIN DCPlatform F (NOLOCK) ON F.PlatformId = L.PlatformId
				WHERE PackageName IN ('x64 LAPTOP Package', 'Win32 LAPTOP Package', 'MAC LAPTOP Package')
				FOR XML PATH('packages'), TYPE
			)
			FOR XML PATH('App_GetDLOGettingStartedInfoResp')
		)
	)
ERROR_EXIT:
	SELECT @o_xmlString AS 'o_xmlString'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGettingStartedInfo')
	delete from GxQscripts where name = 'AppGettingStartedInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGettingStartedInfo')
	delete from GXDBVersions where aliasname = 'AppGettingStartedInfo'
GO

insert into GXDBVersions values(2, 'AppGettingStartedInfo',  '00000000000000000000', 'AppGettingStartedInfo', '00000000000000000000')
GO

