

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetclientlistAndPropsForAdminConsole.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetclientlistAndPropsForAdminConsole.sp,v $ $Id: AppGetclientlistAndPropsForAdminConsole.sp,v 1.1.2.128.8.1 2021/01/15 09:43:04 arathi Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetclientlistAndPropsForAdminConsole"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetclientlistAndPropsForAdminConsole')
BEGIN
	print '>>> Drop Stored Procedure: AppGetclientlistAndPropsForAdminConsole <<<'
	drop procedure AppGetclientlistAndPropsForAdminConsole
END
IF EXISTS (select * from GxQscripts where name='AppGetclientlistAndPropsForAdminConsole')
	delete from GxQscripts where name = 'AppGetclientlistAndPropsForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetclientlistAndPropsForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetclientlistAndPropsForAdminConsole'
GO
print '... Creating Procedure: AppGetclientlistAndPropsForAdminConsole'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetclientlistAndPropsForAdminConsole
  @xmlText XML,
  @o_xmlResp NVARCHAR(MAX) OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @o_xmlText XML
-- In this SP, we won't be returning some types of clients. They will be removed.
-- 1. Dummy Index server client - APP_Client Prop - attrname ='Index Server Type' and attrval in ('6','7','8') will be removed
 DECLARE @i_userId INTEGER=0
     SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
 DECLARE @i_localeId INTEGER=0
     SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/processinginstructioninfo/locale') R ( ref )),0)
 DECLARE  @i_getCommNetClients INTEGER = 0
  SET @i_getCommNetClients = ISNULL((SELECT  ref.value('@includeCommnetClients', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )),0)
  DECLARE @i_includeHiddenClients INTEGER = 0
    SET @i_includeHiddenClients = ISNULL((SELECT  ref.value('@hiddenclients', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )),0)
  -- filter for client for Mongo Cache
  DECLARE @getAllClients INT = 0
   SET @getAllClients = ISNULL((SELECT  ref.value('@getAllClients', 'INT') AS client
	                FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )), 0)
	DECLARE @i_arrayBasedFilter INTEGER = 0
    SET @i_arrayBasedFilter = ISNULL((SELECT  ref.value('@arrayBasedFilter', 'int')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @i_hideLaptopAndDummyclients INTEGER = 0
    SET @i_hideLaptopAndDummyclients = ISNULL((SELECT  ref.value('@hideLaptopAndDummyClients', 'int')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @i_includeIDASummary INTEGER = 0
    SET @i_includeIDASummary = ISNULL((SELECT  ref.value('@includeIdaSummary', 'INT')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @i_associationtype INTEGER = 0
    SET @i_associationtype = ISNULL((SELECT  ref.value('@associationtype', 'int')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	 DECLARE @i_arrayId NVARCHAR(1024) = 0
     SET @i_arrayId = ISNULL((SELECT  ref.value('@arrayId', 'NVARCHAR(1024)')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @i_includeVMClients INTEGER = 0
     SET @i_includeVMClients = ISNULL((SELECT  ref.value('@includeVMClients', 'INT')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )),0)
	DECLARE @i_vendorTypes NVARCHAR(1024)
	SET @i_vendorTypes = (SELECT  ref.value('@vendorTypes', 'NVARCHAR(1024)')
                        FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref ))
	DECLARE @i_includeClientReadinessInfo INTEGER = ISNULL((SELECT  ref.value('@includeClientReadinessInfo', 'INT')
	FROM @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @i_getArchiverClients INTEGER = 0
	SET @i_getArchiverClients = ISNULL((SELECT  ref.value('@getArchiverClients', 'INT')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref )),0)
    declare @i_idaGroupList varchar(max) = ''--'35,26'
	declare @i_hideEnabled integer = 0 -- to do
	-- sec_isHideEnabled is moved down
	DECLARE @i_distributedClusterType INTEGER = 0
	SET @i_distributedClusterType = ISNULL((SELECT  ref.value('@clusterType', 'INT')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )),0)
	DECLARE @i_excludeInfrastructureClients  INTEGER = 0
    SET @i_excludeInfrastructureClients  = ISNULL((SELECT  ref.value('@excludeInfrastructureClients', 'INT')
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter') R ( ref )),0)
	-- filter Infrastructure, Non-Infrastructure clients
    DECLARE @infrastructureMachineFilter INT = 0
	SET @infrastructureMachineFilter = ISNULL((SELECT  ref.value('@infrastructureMachineFilter', 'int') AS client
	                    FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref )), 0)
	-- include fileServer type filter
	DECLARE @includeFileServerType INT = 0
	SET @includeFileServerType = ISNULL((SELECT TOP 1 ref.value('@appGroupId', 'int') AS FileServerType
	                    FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )), 0)
	-- Install type filters
	DECLARE @i_installTypeFilter INT = 0
	SET @i_installTypeFilter = ISNULL((SELECT  ref.value('@installTypeFilter', 'int') AS InstallType
	                    FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref )), 0)
	IF ((@infrastructureMachineFilter = 0) AND (@i_excludeInfrastructureClients <> 0))
        SET @infrastructureMachineFilter = 2
	--All = 0,
	--NonEpicClient = 1,
	--EpicClientOnly = 2
	DECLARE @epicClientFilter int = 0
	DECLARE @i_getOnlyEpicClients INT = 0 --for FS client request do not send epic clients
	--when the request has onlyEpicClients filter, send only the epic clients. This request is sent by the epic center page
	--for servers page still return the epic clients
	SET @epicClientFilter = ISNULL((SELECT  ref.value('@epicClientFilter', 'int') AS InstallType
	                    FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref )), 0)
	-- Get commcell info for comet
DECLARE @commCellName NVARCHAR(256)
SELECT  @commCellName = aliasName FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	-- Disable Change Tracking Functionality, revert to original implementations
	DECLARE @debug TINYINT = 0
	DECLARE @disableCTClientProperties	INT = 0
	SELECT
		@disableCTClientProperties = (CASE WHEN value <> '0' THEN 1 ELSE 0 END)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = 'CTDisablePropertyCaching'
	IF (@debug > 0 AND @disableCTClientProperties > 0)
	BEGIN
		PRINT 'AppGetclientlistAndPropsForAdminConsole: disableCTClientProperties = ' + CAST(@disableCTClientProperties AS VARCHAR(12))
	END
	DECLARE @appType35Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
	INSERT INTO @appType35Table
		SELECT DISTINCT appTypeId
		FROM GetAppTypesForAppGroup(35,0)
WHERE appTypeId <> 64
-- create the client list temporary table
IF object_id('tempdb.dbo.#ClientListTbl') IS NOT null DROP TABLE #ClientListTbl
CREATE TABLE #ClientListTbl	(
	[r_id]				INT PRIMARY KEY,
	[r_name]			NVARCHAR(255),
	[r_displayName]		NVARCHAR(255),
	[r_guid]    		VARCHAR(255),
	[r_OSId]			INT,
	[r_netHostName]			NVARCHAR(255),
	[r_desc]			NVARCHAR(MAX),
	[r_status]			INT,
	[r_releaseId]     		INT,
	[r_isMA]     		INT DEFAULT(0),
	[r_OSType]     		VARCHAR(64) DEFAULT(''),
	[r_OSSubType]     	VARCHAR(64) DEFAULT(''),
	[r_OSName]			NVARCHAR(255)	DEFAULT(''),
	[r_hwId]			INT		DEFAULT(0),
	[r_hwName]			VARCHAR(255)	DEFAULT(''),
	[r_bkpEnabled]			INT		DEFAULT(null),
	[r_rstEnabled]			INT		DEFAULT(null),
	[r_deleted]			INT		DEFAULT(null),
	[r_isVirtualClient]				INT		DEFAULT(null),
	[r_isLicensed]			INT		DEFAULT(null),
	[r_physClientId]		INT		DEFAULT(null),
	[r_updateStatus]		INT		DEFAULT(0),
	[r_OSInfo]			VARCHAR(1024)	DEFAULT(null),
	[r_proxyFSClientId]		INT		DEFAULT(null),
	[r_ccpId]			INT		DEFAULT(0),
	[r_specialStatusFlags]			INT		DEFAULT(0),
	[r_clientVersion] 			VARCHAR(255)	DEFAULT(''),
	[r_SPVersionInfo]	varchar(255) DEFAULT(null),
	[r_SPVersionAndPatchInfo]	varchar(MAX) DEFAULT(null),
	[r_MAdeleted]			INT		DEFAULT(null),
	[r_snapBKPenabled]			INT		DEFAULT(0),
	[r_arrayIds]			VARCHAR(MAX)		DEFAULT(''),
	[r_isBackedUpVMClient]			    INT  DEFAULT(0),
	[r_lastBackupJobId]			BIGINT  DEFAULT(0),
	[r_cAppType]				INT DEFAULT(0),
	[r_isUserCentricClient]		INT DEFAULT (0),
	[r_physicalClientID]		INT DEFAULT (0),
	[r_planId]					INT DEFAULT (0),
	[r_planName]				NVARCHAR(255) DEFAULT '',
	[r_lastActivationUserId]	INT DEFAULT (0),
	[r_lastActivationUserName]	NVARCHAR(255) DEFAULT '',
	[r_vmVendor]				INT  DEFAULT (null),
	[r_isExchangeOnePassClient]	VARCHAR(10) DEFAULT(''),
	[r_isFarmClient]		INT DEFAULT (0),
	[r_isIndexingV2]		INT DEFAULT (0),
	[r_clusterType]			INT DEFAULT (0),
	[r_IsInfrastructureMachine]		INT DEFAULT(0),
	[r_InfrastructureMachineType]		INT DEFAULT(0),
	[r_isIndexingV2VSA]		INT DEFAULT (0),
	[r_vmGuid]				VARCHAR(255) DEFAULT(null),
	[r_SLAStatus] INT DEFAULT(4), --"Yet to be Protected" by default. For new clients we may not have an entry in RptSlaClient table.
	[r_installJobId] INT DEFAULT(0),
	[r_SLACategory] INT DEFAULT(0),
	[r_SLACategoryDescription]	NVARCHAR(255) DEFAULT '',
	[r_slaMissReasonList]	XML,
	[r_isVirtualServerDiscoveredClient]  INT  DEFAULT(0),
	[r_isApplicableForServersPage] INT DEFAULT (NULL),
	[r_nwReadiness]	INT DEFAULT(0),
	[r_nwReadinessUpdatedTime]	BIGINT DEFAULT(null),
	[r_lastOnlineTime]	BIGINT DEFAULT(null),
	[r_lastOfflineTime]	BIGINT DEFAULT(null),
	[r_retireClientPhase]   INT DEFAULT (0),
	[r_ReInstallJobStatus]	INT DEFAULT(0),
	[r_fileServerType] INT DEFAULT(0)
)
-- create the client property temporary table
IF object_id('tempdb.dbo.#clientPropTbl') IS NOT null DROP TABLE #clientPropTbl
CREATE TABLE #clientPropTbl (
	clientId			INT,
	deleted				INT,
	virtualClient			INT,
	islicensed			INT,
	physClientId			INT,
	OSInfo				VARCHAR(1024),
	proxyFSClientId			INT,
	clientVersion 			VARCHAR(255),
	SPVersionInfo			nvarchar(MAX),
	SPVersionAndPatchInfo		nvarchar(MAX),
	snapBackupsEnabled		INT,
	arrays				NVARCHAR(MAX),
	virtualServerDiscovered 	INT,
	lastBackupJobId		 	BIGINT,
	clusterType			INT,
	isUserCentricClient 		INT DEFAULT 0,
	physicalClientID 		INT DEFAULT 0,
	planId 				INT DEFAULT 0,
	physicalClientIdOnHold 		INT DEFAULT 0,
	planIdOnHold 			INT DEFAULT 0,
	isExchangeOnePass		VARCHAR(10),
	sharePointFarmClient		INT DEFAULT 0,
	isIndexingV2			INT DEFAULT 0,
	osName				VARCHAR(256),
	hwName				VARCHAR(256),
	IsInfrastructureMachine		INT DEFAULT 0,
	InfrastructureMachineType   INT DEFAULT 0,
	isIndexingV2VSA			INT DEFAULT 0,
	installJobId			INT DEFAULT 0,
	reInstallJobStatus		INT DEFAULT 0,
	clientAppType			INT DEFAULT 0
)
CREATE CLUSTERED INDEX clientPropTbl_idx ON #clientPropTbl(clientId)
DECLARE @selectiveAppType int = 0
IF object_id('tempdb.dbo.#idaGroupListTbl') IS NOT null DROP TABLE #idaGroupListTbl
    CREATE TABLE #idaGroupListTbl
    (
        [r_groupAppId] INT
    )
IF object_id('tempdb.dbo.#idaListTbl') IS NOT null DROP TABLE #idaListTbl
CREATE TABLE #idaListTbl
(
    [r_appId] INT
)
IF object_id('tempdb.dbo.#idaInfoTbl') IS NOT null DROP TABLE #idaInfoTbl
CREATE TABLE #idaInfoTbl
(
    [r_clientId] INT DEFAULT(0),
    [r_appId]               INT DEFAULT(0),
    [r_appName] nvarchar(MAX) DEFAULT(NULL),
	[r_cAppType] int DEFAULT(0),
	[r_defaultBackupSetId] int DEFAULT(0),
	[r_defaultSubClientId] int DEFAULT(0),
	[r_defaultBackupSetName] NVARCHAR(MAX) DEFAULT(NULL),
	[r_defaultBackupSetPlanId] int DEFAULT(NULL),
	[r_defaultBackupSetPlanName] NVARCHAR(MAX) DEFAULT(NULL),
	[r_defaultBackupSetPlanSubType] int DEFAULT(NULL),
	[r_lastBackupTime] int DEFAULT(0),
	[r_isSLAMet] int DEFAULT(0),
	[r_SLAStatus] int DEFAULT(4),
	[r_SLADescription]  NVARCHAR(256),
	[r_slaMissReasonList] XML,
	[r_idaSize] bigint DEFAULT(0),
	[r_lastBackupJobInfo] XML DEFAULT(NULL),
	[r_isAccessTimeCollected] INT DEFAULT(0),
	[r_status]	INT DEFAULT(0),
	[r_SLACategory] INT DEFAULT(0)
)
DECLARE @tempServerCnt INT = 0
DECLARE @tempServerGrpCnt INT = 0
--Get the list of specific client Ids provided in XML input
DECLARE @tempServerIdList TABLE(
    clientId      int primary key
);
INSERT INTO @tempServerIdList
SELECT DISTINCT ref.value('@clientId', 'int') AS client
FROM    @xmlText.nodes('App_GetClientPropertiesRequest/association/entity') R ( ref )
	INNER JOIN APP_Client AC WITH(NOLOCK) ON AC.id = ref.value('@clientId', 'int')
SET @tempServerCnt = @@ROWCOUNT
--Get the list of specific client group ids provided in XML input
DECLARE @tempClientGroupIdList TABLE(
    clientGroupId      int primary key
);
INSERT INTO @tempClientGroupIdList
SELECT DISTINCT ref.value('@clientGroupId', 'int') AS client
FROM    @xmlText.nodes('App_GetClientPropertiesRequest/association/entity') R ( ref )
	INNER JOIN APP_ClientGroup ACG WITH(NOLOCK) ON ACG.id = ref.value('@clientGroupId', 'int')
SET @tempServerGrpCnt = @@ROWCOUNT
-- Temp table for better query execution
IF OBJECT_ID('tempdb.dbo.#ExcludeSCs') IS NOT NULL DROP TABLE #ExcludeSCs
CREATE TABLE #ExcludeSCs (
	  scId   INT PRIMARY KEY
)
IF object_id('tempdb.dbo.#JobBkupTime') IS NOT NULL DROP TABLE #JobBkupTime
CREATE TABLE #JobBkupTime
(
	[lastBackupTime] 	INT DEFAULT(0),
	[applicationSize]	BIGINT DEFAULT(0),
	[clientId] 			INT DEFAULT(0),
    [appTypeId] 		INT DEFAULT(0)
)
IF object_id('tempdb.dbo.#companyListTbl') IS NOT null DROP TABLE #companyListTbl
CREATE TABLE #companyListTbl
(
    [r_companyId] INT
)
IF object_id('tempdb.dbo.#planMetricsTbl') IS NOT null DROP TABLE #planMetricsTbl
CREATE TABLE #planMetricsTbl
(
	[r_clientId] INT,
    [r_TotalSubclients] INT,
	[r_SubClientWithSnapPlan] INT
)
-- This temp table is used to populate information like data source Id, data source List, etc. for old archiving point solution clients
IF OBJECT_ID('tempdb.dbo.#archiveClientInfo') IS NOT NULL
	DROP TABLE #archiveClientInfo
CREATE TABLE #archiveClientInfo
(
	r_clientId INT PRIMARY KEY,
	r_DSCLientID VARCHAR(10) DEFAULT '',
	r_DSListSubclient VARCHAR(MAX) DEFAULT '',
	r_DSListBackupSet VARCHAR(MAX) DEFAULT '',
	r_DSFullList VARCHAR(MAX) DEFAULT ''
)
IF object_id('tempdb.dbo.#DistributedClusterTypeClients') IS NOT NULL DROP TABLE #DistributedClusterTypeClients
CREATE TABLE #DistributedClusterTypeClients(id INT, clusterType INT)
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
CREATE TABLE #RetireInProgressClientListTbl(retireClientId INT)
IF object_id('tempdb.dbo.#checkReadinessInfoTbl') IS NOT NULL DROP TABLE #checkReadinessInfoTbl
CREATE TABLE #checkReadinessInfoTbl
(
	[clientId] INT DEFAULT (0),
	[CCRId] INT DEFAULT (0),
	[readinessStatus] INT DEFAULT (0),
	[CCRTime] INT DEFAULT (0)
)
IF object_id('tempdb.dbo.#instanceInfoTbl') IS NOT NULL DROP TABLE #instanceInfoTbl
CREATE TABLE #instanceInfoTbl (
	[instanceId] INT DEFAULT (0),
	[instanceName] NVARCHAR(512),
	[clientId] INT DEFAULT (0)
)
IF object_id('tempdb.dbo.#distributedClusterTypeInstanceListXml') IS NOT NULL DROP TABLE #distributedClusterTypeInstanceListXml
CREATE TABLE #distributedClusterTypeInstanceListXml (
	[clusterInstanceList] XML
)
IF object_id('tempdb.dbo.#FSLicensedOrBackupClients') IS NOT NULL DROP TABLE #FSLicensedOrBackupClients
CREATE TABLE #FSLicensedOrBackupClients
(
	[cId] INT primary key
)
IF object_id('tempdb.dbo.#LicenseAppSizeTbl') IS NOT null DROP TABLE #LicenseAppSizeTbl
CREATE TABLE #LicenseAppSizeTbl	(subclientId INT PRIMARY KEY,AppSizeMB	BIGINT)
-- This table contains clientId, appTypeId and their default(first) one-pass/archiver set subclient.
IF OBJECT_ID('tempdb.dbo.#ArchiverSetsTbl') IS NOT NULL
	DROP TABLE #ArchiverSetsTbl
CREATE TABLE #ArchiverSetsTbl
(
	r_clientId INT,
	r_appTypeId INT,
	r_defaultSubclientId INT,			-- Default subclient of default archiver set (or) first one-pass subclient if no archiver set. We use this to fetch plan details, etc.
	UNIQUE CLUSTERED (r_clientId, r_appTypeId)
)
CREATE NONCLUSTERED INDEX ArchiverSetsTbl_Idx1 ON #ArchiverSetsTbl (r_defaultSubclientId);;
-- When get archiver clients = 0 (FS solutions list), this table contains clients that should be excluded from output.
	-- All clients that were newly-added from archiver solutions which are yet to be added from FS solutions page will be included in this table, and thereby excluded from output.
-- When get archiver clients = 1 (archiver solutions list), this table contains clients that ONLY should come in the output.
	-- All clients that have at least one archiver set (created either via Java GUI / Admin console /  REST API, etc.) will ONLY be included.
IF OBJECT_ID('tempdb.dbo.#Archivalclients') IS NOT NULL
	DROP TABLE #Archivalclients
CREATE TABLE #Archivalclients
(
	clientId INT PRIMARY KEY,
	isBackedUp INT DEFAULT 0
)
INSERT INTO #ArchiverSetsTbl
	SELECT A.clientId,
		A.appTypeId,
		MIN(A.id)						-- Default subclient Id of the first/default archiver set.
	FROM APP_Application A
		INNER JOIN APP_BackupsetProp BP
			ON BP.componentNameId = A.backupset
			AND BP.attrName = 'Is Archiving Enabled'
			AND BP.attrVal = '1'
			AND BP.modified = 0
			AND A.subclientStatus & 8 /*CV_STATUS_DEFAULT*/ <> 0
		INNER JOIN APP_AppTypeGroupAssoc AGA
			ON (A.appTypeId = AGA.appTypeId) AND (AGA.appGroupId = 35)		-- 35 is File System group iDAs. We want only FS iDAs in archival clients response.
	GROUP BY A.clientId, A.appTypeId
IF @i_getArchiverClients  = 1
BEGIN
	-- Get the clients that do not have archiver set, but have one-pass subclients.
	INSERT INTO #ArchiverSetsTbl
		SELECT DISTINCT A.clientId,
						A.appTypeId,
						MIN(A.id)			-- First one pass subclient ID. That can be used for fetching other details.
		FROM APP_Application A
			INNER JOIN APP_SubclientProp SP
				ON A.id = SP.componentNameId
				AND SP.attrName = 'Turbo Mode Enable Stubbing'
				AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
				AND SP.attrVal = '1'
				AND SP.modified = 0
			LEFT OUTER JOIN #ArchiverSetsTbl ST
				ON A.clientId = ST.r_clientId
			INNER JOIN APP_ClientProp CP			-- Hide V1 indexing clients.
				ON CP.componentNameId = A.clientId
				AND CP.attrName = N'IndexingV2'
				AND CP.attrVal = '1'
				AND CP.modified = 0
			INNER JOIN APP_AppTypeGroupAssoc AGA
				ON (A.appTypeId = AGA.appTypeId) AND (AGA.appGroupId = 35)		-- 35 is File System group iDAs. We want only FS iDAs in archival clients response.
		WHERE
			ST.r_clientId IS NULL
			AND A.appTypeId <> 1030		-- Ignore SCP subclients if they have this property set.
		GROUP BY A.clientId, A.appTypeId
		INSERT INTO #ArchiverSetsTbl
			SELECT DISTINCT A.clientId,
						A.appTypeId,
						MIN(A.id)			-- First associated subclient policy's subclient ID. That can be used for fetching other details.
		FROM APP_Application A
			INNER JOIN APP_SubclientProp SCP_ASP WITH (NOLOCK)
				ON A.id = SCP_ASP.componentNameId
AND SCP_ASP.attrName = N'Associated subclient Policy'
AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
				AND SCP_ASP.attrVal <> '0'
				AND SCP_ASP.modified = 0
			INNER JOIN APP_SubclientProp SP
              			ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
              			AND SP.attrVal = '1'
              			AND SP.modified = 0
			LEFT JOIN APP_SubclientProp SCP_PLAN WITH (NOLOCK)
				ON A.id = SCP_PLAN.componentNameId
AND SCP_PLAN.attrName = 'Associated Plan'
AND SCP_PLAN.cs_attrName = CHECKSUM(N'Associated Plan')
				AND SCP_PLAN.attrVal <> '0'
				AND SCP_PLAN.modified = 0
			LEFT OUTER JOIN #ArchiverSetsTbl ST
				ON A.clientId = ST.r_clientId
		WHERE
			ST.r_clientId IS NULL AND SCP_PLAN.componentNameId IS NULL
		GROUP BY A.clientId, A.appTypeId
	INSERT INTO #Archivalclients (clientId)
		SELECT DISTINCT r_clientId			-- DISTINCT needed because, a single client can contain 2 app types with archiver sets. Eg.: NAS.
		FROM #ArchiverSetsTbl
END
ELSE
BEGIN
	-- #Archivalclients table will contains client ids with below properties and we will exclude them from response
		--	1.	DefaultBackupset having "FS Backupset created for archival solution" property saved in APP_BackupsetProp table
		--	2.	Plan not associated with defaultSubclient of defaultBackupset.
	/*
		Reason for handling NAS client in a specific way
			NAS Clients might have both Windows and Unix FS.
			In that case, if one of them has FS with a proper default backupset (not one that was created as subsidary of archival solution),
			then we need to remove those clients out of Archivalclients table.
	*/
	INSERT INTO #Archivalclients (clientId)
		SELECT DISTINCT AST.r_clientId
			FROM #ArchiverSetsTbl AST
				INNER JOIN APP_Application APP WITH(NOLOCK)
						ON AST.r_clientId = APP.clientId AND APP.appTypeId = AST.r_appTypeId
				INNER JOIN APP_Backupsetname ABN WITH(NOLOCK)
						ON APP.backupset = ABN.id
AND (ABN.status & 0x00010) <> 0x00010 AND (ABN.status & 0x00008) = 0x00008
				INNER JOIN APP_BackupsetProp ABP WITH(NOLOCK)
						ON APP.backupset = ABP.componentNameID
AND ABP.attrName = 'FS Backupset created for archival solution'
						AND ABP.attrVal = '1'
						AND ABP.modified = 0
				LEFT JOIN APP_SubClientProp ASP WITH(NOLOCK)
						ON APP.id = ASP.componentNameId
AND (APP.subclientStatus & 0x00008) = 0x00008
						AND ASP.attrName = N'Associated Plan'
						AND ASP.cs_attrName = CHECKSUM(N'Associated Plan')
						AND ASP.attrVal <> '0'
						AND ASP.modified = 0
		WHERE ASP.componentNameId IS NULL
		EXCEPT
		SELECT DISTINCT AST.r_clientId
			FROM #ArchiverSetsTbl AST
			INNER JOIN APP_Client C WITH(NOLOCK)
				ON AST.r_clientId = C.id
			INNER JOIN SimOperatingSystem OS WITH(NOLOCK)
				ON C.simOperatingSystemId = OS.id AND OS.subType = 'NAS'
			INNER JOIN APP_Application APP WITH(NOLOCK)
ON  AST.r_clientId = APP.clientId AND APP.appTypeId IN (33, 29)
			INNER JOIN APP_Backupsetname ABN WITH(NOLOCK)
				ON APP.backupset = ABN.id
AND (ABN.status & 0x00010) <> 0x00010 AND (ABN.status & 0x00008) = 0x00008
			LEFT JOIN APP_BackupsetProp ABP WITH(NOLOCK)
				ON APP.backupset = ABP.componentNameID
AND ABP.attrName = N'FS Backupset created for archival solution'
				AND ABP.attrVal = '1'
				AND ABP.modified = 0
			LEFT JOIN APP_SubClientProp ASP WITH(NOLOCK)
				ON APP.id = ASP.componentNameId
AND (APP.subclientStatus & 0x00008) = 0x00008
				AND ASP.attrName = N'Associated Plan'
				AND ASP.cs_attrName = CHECKSUM(N'Associated Plan')
				AND ASP.attrVal <> '0'
				AND ASP.modified = 0
			WHERE ABP.componentNameID IS NULL OR ASP.componentNameId IS NOT NULL
END
IF @i_getArchiverClients  = 1
BEGIN
	IF object_id('tempdb.dbo.#BackedUpArchivalClients') IS NOT null DROP TABLE #BackedUpArchivalClients
	CREATE TABLE #BackedUpArchivalClients
	(
		clientId INT PRIMARY KEY
	)
	INSERT INTO #BackedUpArchivalClients
	SELECT DISTINCT clientid
      FROM   (SELECT aap.clientid AS clientId,
                     aap.id       AS scid
              FROM   #archivalclients acl
                     INNER JOIN app_application aap WITH(NOLOCK)
                             ON acl.clientid = aap.clientid
                     INNER JOIN app_subclientprop asp WITH(NOLOCK)
                             ON aap.id = asp.componentnameid
                                AND asp.cs_attrname = Checksum(N'Turbo Mode Enable Stubbing')
                                AND asp.attrname = N'Turbo Mode Enable Stubbing'
                                AND asp.attrval = N'1'
                                AND asp.modified = 0
              UNION
              SELECT aap.clientid AS clientId,
                     aap.id       AS scid
              FROM   #archivalclients acl
                     INNER JOIN app_application aap WITH(NOLOCK)
                             ON acl.clientid = aap.clientid
                     INNER JOIN app_backupsetprop abp WITH(NOLOCK)
                             ON aap.backupset = abp.componentnameid
                                AND
                     abp.attrname = N'Is Archiving Enabled'
                                AND abp.attrval = N'1'
                                AND abp.modified = 0) backupInfo
             INNER JOIN app_subclientprop ascp WITH(NOLOCK)
                    ON backupInfo.scid = ascp.componentnameid
					   AND ascp.cs_attrname = Checksum(N'Last Data Protected TIme' )
                       AND ascp.attrname = N'Last Data Protected TIme'
                       AND ascp.modified = 0
	UPDATE AC
	SET    isbackedup = IIF(BAC.clientId IS NULL, 0, 1)
	FROM   #archivalclients AC
	       LEFT JOIN #BackedUpArchivalClients BAC
               ON AC.clientid = BAC.clientid
END
INSERT INTO #FSLicensedOrBackupClients
SELECT CId FROM LicUsage L
INNER JOIN APP_IDAName I on l.CId=I.clientId and L.AppType=I.appTypeId
INNER JOIN @appType35Table fs ON fs.appTypeId=I.appTypeId
WHERE  L.optype = 'Install'
UNION
SELECT clientId FROM APP_Application AP WITH(NOLOCK)
INNER JOIN @appType35Table fs ON fs.appTypeId=AP.appTypeId
INNER JOIN APP_SubClientProp ASCP  WITH(NOLOCK)
ON ASCP.componentNameId=AP.id AND ASCP.attrName=N'Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
IF object_id('tempdb.dbo.#EligibleClientsForInstallType') IS NOT NULL DROP TABLE #EligibleClientsForInstallType
CREATE TABLE #EligibleClientsForInstallType
(
	[clientId] INT primary key,
	[clientType] INT DEFAULT(3)
)
DECLARE @clientTypeAndInstallTypeMap TABLE(cType INT, supportedInstallType INT)
INSERT INTO @clientTypeAndInstallTypeMap VALUES
			(1, 1),					-- CSClient - Supports only 1 -install
			(2, 1), (2, 2),			-- Non CS client greater than or equal to CS release ID - supports 1 - install and 2 - uninstall
			(3, 1), (3, 2), (3, 3)	-- Non CS Client lesser than CS release ID - supports 1 - install, 2 - uninstall and 3- upgrade
IF object_id('tempdb.dbo.#clientAndInstallTypeMap') IS NOT NULL DROP TABLE #clientAndInstallTypeMap
CREATE TABLE #clientAndInstallTypeMap(cId INT, supportedInstallType INT)
-- InstallType: 1. Install, 2. Uninstall and 3. Upgrade
DECLARE @csClientId INT = ISNULL((SELECT clientId FROM APP_Platform  WHERE platformType = 1), 2) -- Default 2
DECLARE @csReleaseId INT = (SELECT releaseId FROM APP_Client WHERE id = @csClientId)
INSERT INTO #EligibleClientsForInstallType
	SELECT DISTINCT Client.id,
			CASE WHEN client.id = @csClientId THEN 1			-- CS Client. Only Install  is allowed
				WHEN Client.releaseId >= @csReleaseId THEN 2	-- Non CS Clients with Version greater than CS. Only Install and uninstall are allowed
				ELSE 3											-- Non CS clients with version lesser than CS. Install, uninstall and upgrade are allowed
			END
	FROM APP_Client Client
			INNER JOIN simOperatingSystem OS
				ON Client.simOperatingSystemId = OS.id
					AND  NOT(OS.Name = N'NetWare' AND Client.releaseId < 11)
			LEFT OUTER JOIN APP_ClientProp Virtual
				ON Virtual.componentNameId = Client.id
					AND Virtual.attrName = N'Virtual client'
					AND Virtual.modified = 0
			LEFT OUTER JOIN APP_ClientProp DELETED
				ON DELETED.componentNameId = Client.id
					AND DELETED.attrName = N'PlatformDeleted 4'
					AND DELETED.modified = 0
			LEFT OUTER JOIN APP_ClientProp ADDIN
				ON ADDIN.componentNameId = Client.id
					AND ADDIN.attrName = N'Outlook Addin Client'
					AND ADDIN.modified = 0
			LEFT OUTER JOIN APP_Platform MA
				ON Client.id = MA.clientId AND MA.platformType = 2
			WHERE releaseId > 9
AND Client.status & (CONVERT(INT,0x200000) | CONVERT(INT,0x0040) | CONVERT(INT,0x0200) | CONVERT(INT,0x0400) ) = 0
AND Client.specialClientFlags & (CONVERT(INT,0x2) | CONVERT(INT,0x20)) = 0
AND Client.simOperatingSystemId <> 49
				AND (Client.id = @csClientId
					OR Virtual.attrVal IS NULL
					OR CAST(Virtual.attrVal AS BIGINT) & 2 <> 2)
				AND (DELETED.attrVal IS NULL
					OR DELETED.attrVal <> N'1'
OR Client.specialClientFlags & CONVERT(INT,0x2) = 0
					OR Client.id = @csClientId
					OR MA.clientId IS NOT NULL)
				AND (ADDIN.attrVal IS  NULL
					OR ADDIN.attrVal <> N'1')
INSERT INTO #clientAndInstallTypeMap
SELECT ECIT.clientId, supportedInstallType
FROM #EligibleClientsForInstallType ECIT
	LEFT JOIN @clientTypeAndInstallTypeMap CTIM
		ON ECIT.clientType = CTIM.cType
INSERT INTO #idaGroupListTbl
SELECT  ref.value('@appGroupId', 'int') AS Agent
FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )
DELETE #idaGroupListTbl WHERE r_groupAppId IS NULL
IF EXISTS(SELECT * FROM #idaGroupListTbl)
BEGIN
    INSERT INTO #idaListTbl
    SELECT appTypeId from APP_AppTypeGroupAssoc where
    appGroupId in (select [r_groupAppId] from #idaGroupListTbl) and typeOfGroup=0
END
INSERT INTO #idaListTbl
SELECT  ref.value('@applicationId', 'int') AS Agent
FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )
DELETE #idaListTbl WHERE r_appId IS NULL
IF (@i_getArchiverClients = 1)	DELETE #idaListTbl WHERE r_appId = 13
IF EXISTS (SELECT * FROM #idaListTbl)
    SET @selectiveAppType = 1
INSERT INTO #companyListTbl
SELECT  ref.value('@providerId', 'int')
FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )
DECLARE @filterProviderId AS INT = ISNULL((SELECT TOP 1 r_companyId FROM #companyListTbl WHERE r_companyId IS NOT NULL), -1)
INSERT INTO #DistributedClusterTypeClients(id, clusterType)
	SELECT DISTINCT clientId, CAST(ISNULL(instProp.attrval,0) AS INT)
       FROM App_Application app
       INNER JOIN APP_Client clients ON clients.id = app.clientId
       INNER JOIN APP_InstanceProp instProp ON (app.instance = instProp.componentNameId AND instProp.attrName = 'Distributed Cluster Type')
WHERE app.appTypeId = 64 AND instProp.modified = 0
--List of clients which are currently getting uninstalled. Shouldn't be a huge table
INSERT INTO #RetireInProgressClientListTbl
	SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
			INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
				AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
				AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
-- visibility check
-- No need to do security check for Admin user
DECLARE @isAdminUserId INT = ISNULL((SELECT 1 FROM UMUsers WHERE (id=@i_userId) AND (flags & 0x040 <> 0)) , 0)
	-- No need to populate anything for Adminuser
	IF object_id('tempdb.dbo.#clientListTmp') is not null DROP TABLE #clientListTmp
	IF (@isAdminUserId  = 0)
	BEGIN
create table  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
 			EXEC sec_getUserObjects @i_userId, 0, 0, '#clientListTmp'
			EXEC sec_isHideEnabled @i_userId, 0, @i_hideEnabled OUTPUT
			IF (@i_hideEnabled <> 0)
			BEGIN
				delete #clientListTmp
				WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
					  OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
					  OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
					  OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
					  OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
					  OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
			END
	END
------------------------------------------CACHE TABLE BEGINS HERE----------------------------------------------------------------------------------
	IF (@disableCTClientProperties = 0)
	BEGIN
		-- Use Change Tracking Client Properties implemented in V11 SP12
		-- Update client properties that are dirty by checking Change Tracking
		DECLARE @lastSyncVersion	BIGINT
		DECLARE @lastSyncTime		INT
		-- Get last time change tracking was sync'd to the CT_ClientProperties table
		SELECT
			@lastSyncVersion = ca.syncVersion,
			@lastSyncTime = ca.syncTime
		FROM CT_CacheAssociations ca WITH(NOLOCK)
		WHERE
			ca.cacheTable = 'CT_ClientProperties'
		IF OBJECT_ID('tempdb.dbo.#UpdatedClients') IS NOT NULL
			DROP TABLE #UpdatedClients
		CREATE TABLE #UpdatedClients (
			clientId	INT PRIMARY KEY
		)
		-- Capture all Clients that have had client properties changed since the last sync
		INSERT INTO #UpdatedClients
			SELECT
				ct.componentNameId clientId
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
			WHERE ct.SYS_CHANGE_OPERATION = 'D'
			UNION
			SELECT
				ct.componentNameId clientId
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					cp.id = ct.id
					AND ct.SYS_CHANGE_OPERATION <> 'D'
				INNER JOIN CT_CachePropertyAssociations cpa ON
cpa.tableType = 1
					AND cpa.propertyName = cp.attrName
			UNION
			SELECT
				c.id
			FROM APP_Client c WITH(NOLOCK)
				LEFT OUTER JOIN CT_ClientProperties cp WITH(NOLOCK) ON
					c.id = cp.clientId
					AND c.id > 1
			WHERE
				cp.clientId IS NULL		-- new client row but missing cached property row, mark client as dirty
		DECLARE @UpdateClientRows	INT = @@ROWCOUNT
		IF  (@UpdateClientRows > 0)
		BEGIN
			PRINT 'AppGetclientlistAndPropsForAdminConsole: ChangeTracking Client Properties Update Processing due to cached properties out-of-date for some clients.'
			DECLARE @comma		TINYINT = 0
			DECLARE @nl			NVARCHAR(3) = NCHAR(13) + NCHAR(10)
			DECLARE @pivotVars	NVARCHAR(MAX) = @nl
			DECLARE @attrNames	NVARCHAR(MAX) = @nl
			DECLARE @colNames	NVARCHAR(MAX) = @nl
			DECLARE @sqlCmd		NVARCHAR(MAX) = ''
			-- Generate PIVOT Query to get data for dirty client properties that need to be updated
			SELECT
				@attrNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '''' + propertyName + '''' + @nl,
				@pivotVars += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '[' + propertyName + ']' + @nl,
				@colNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + columnName + @nl,
				@comma = 1
			FROM CT_CachePropertyAssociations cpa
WHERE cpa.tableType = 1
				AND propertyName IN ('platformdeleted 4',
							'Virtual client',
							'Licensed Client',
							'Active Physical Node',
							'Sim OS Info',
							'Proxy Filesystem Client Id',
							'Client Version',
							'SP Version Info',
							'SP Version And Patch Info',
							'Snap Backups Enabled' ,
							'Arrays',
							'Virtual Server Discovered Clients',
							'Last Backup JobID',
							'Index Server Type',
							'User Centric Client',
							'Physical Client Id',
							'Associated Plan',
							'Physical Client Id On Hold',
							'Associated Plan Id On Hold',
							'Exchange OnePass Client',
							'SharePoint Farm Client',
							'IndexingV2',
							'Operating System Name',
							'Hardware Info',
							'IsInfrastructureMachine',
							'InfrastructureMachineType',
							'IndexingV2_VSA',
							'Install Job Id',
							'Reinstall Job Status',
							'Client App Type')
			-- Generate the Client Properties INSERT PIVOT Command
			DECLARE @pivotCmd		NVARCHAR(MAX) = @nl + '
				INSERT INTO #clientPropTbl (clientId, ' + @colNames + ' )
					SELECT
						clientId,' + @pivotVars + '
					FROM (
							SELECT
								c.clientId,
								cp.attrName,
								cp.attrVal
							FROM #UpdatedClients c
								LEFT OUTER JOIN App_ClientProp cp ON
									c.clientId = cp.componentNameId
									AND cp.modified = 0
									AND cp.attrName IN ( ' + @attrNames + ' )
						) AS clients
					PIVOT ( MAX(attrVal) FOR attrName IN ( ' + @pivotVars + ' ) ) AS P' + @nl
			-- Execute command to populate the CT_ClientProperties cache table
			SET @pivotCmd += ' WHERE clientId > 1' + @nl
			EXEC(@pivotCmd)
		END
		-- If client group Ids were provided in request, fetch properties for those clients.
		IF (@tempServerGrpCnt > 0)
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],	[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId], [r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient],[r_isFarmClient], [r_isIndexingV2], [r_clusterType], [r_IsInfrastructureMachine], [r_InfrastructureMachineType], [r_isIndexingV2VSA], [r_installJobId],
										[r_isVirtualServerDiscoveredClient], [r_isApplicableForServersPage], [r_ReInstallJobStatus])
			SELECT	c.id, c.name, displayName, c.GUID, C.simOperatingSystemId, net_hostname, clientDescription, c.status, c.releaseId, APF.platformType,
			 c.ccpId, specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,
					cpt.OSInfo,	cpt.proxyFSClientId,cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
					(CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
					cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId, iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
					ISNULL(DCTC.clusterType,0), cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA,
					ISNULL(cpt.installJobId, cpt2.installJobId), -- If CT_ClientProperties doesn't have the info get it from #ClientProp table which has updated rows
					(CASE WHEN (cpt.virtualServerDiscovered=1) THEN 1 ELSE 0 END),	-- Virtual Discovered Client
					CASE WHEN (
					(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
						OR
						((@i_includeVMClients=1) AND ((cpt.virtualServerDiscovered=1 AND cpt2.clientId IS NULL) OR cpt2.virtualServerDiscovered=1) AND ((cpt.lastBackupJobId <> 0 AND cpt2.clientId IS NULL) OR cpt2.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
					)
					AND
					(
						@i_hideLaptopAndDummyclients = 0
						OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL)) AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
						OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
						OR (ISNULL(cpt.installJobId, 0) > 0 AND cpt2.clientId IS NULL) -- To ensure we drop the record which still has deleted info in it
						OR (ISNULL(cpt2.installJobId, 0) > 0)
						OR (IDA.appTypeId IS NOT NULL
							AND prop.attrName IS NOT NULL)
					)
					AND
					(
					      (@infrastructureMachineFilter = 0)
						  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
						  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
					)
				) THEN 1 ELSE 0 END,
					ISNULL(cpt.reInstallJobStatus, cpt2.reInstallJobStatus)
				FROM	APP_Client c
					INNER JOIN APP_ClientGroupAssoc CG ON
						c. id = CG.clientId
					INNER JOIN @tempClientGroupIdList TCG ON
						TCG.clientGroupId = CG.clientGroupId
					LEFT OUTER JOIN #clientPropTbl cpt2 on
						c.id = cpt2.clientId
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						AP.id = ISNULL(cpt.planId, cpt2.planId)
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
					LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
					LEFT OUTER JOIN  #FSLicensedOrBackupClients licfs ON  LICfs.cid=cpt.clientId
LEFT JOIN App_IDAName IDA on C.id = IDA.clientId and IDA.appTypeId = 64
					LEFT JOIN App_IDAProp prop on IDA.id = prop.componentNameId
AND prop.attrName = N'Distributed Cluster Type'
AND prop.attrVal in (N'3', N'11', N'13')
								AND prop.modified = 0
		END
		ELSE IF (@tempServerCnt > 0)
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],	[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId], [r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType],[r_IsInfrastructureMachine],[r_InfrastructureMachineType], [r_isIndexingV2VSA], [r_installJobId],
										[r_isVirtualServerDiscoveredClient], [r_isApplicableForServersPage], [r_ReInstallJobStatus])
			SELECT	c.id, c.name, displayName, c.GUID, simOperatingSystemId, net_hostname, clientDescription, c.status, c.releaseId, APF.platformType,
				c.ccpId,specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,cpt.OSInfo,cpt.proxyFSClientId,
				cpt.clientVersion,	cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				( CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
					cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId,
				iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
				ISNULL(DCTC.clusterType,0),cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA,
				ISNULL(cpt.installJobId, cpt2.installJobId), -- If CT_ClientProperties doesn't have the info get it from #ClientProp table which has updated rows
				(CASE WHEN (cpt.virtualServerDiscovered=1) THEN 1 ELSE 0 END),	-- Virtual Discovered Client
				CASE WHEN (
					(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
						OR
						((@i_includeVMClients=1) AND ((cpt.virtualServerDiscovered=1 AND cpt2.clientId IS NULL) OR cpt2.virtualServerDiscovered=1) AND ((cpt.lastBackupJobId <> 0 AND cpt2.clientId IS NULL) OR cpt2.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
					)
					AND
					(
						@i_hideLaptopAndDummyclients = 0
						OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL)) AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
						OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
						OR (ISNULL(cpt.installJobId, 0) > 0 AND cpt2.clientId IS NULL) -- To ensure we drop the record which still has deleted info in it
						OR (ISNULL(cpt2.installJobId, 0) > 0)
						OR (IDA.appTypeId IS NOT NULL
							AND prop.attrName IS NOT NULL)
					)
					AND
					(
					      (@infrastructureMachineFilter = 0)
						  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
						  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
					)
				) THEN 1 ELSE 0 END,
				ISNULL(cpt.reInstallJobStatus, cpt2.reInstallJobStatus)
				FROM	APP_Client c
					INNER JOIN @tempServerIdList TS on
						c.id = TS.clientId
					LEFT OUTER JOIN #clientPropTbl cpt2 on
						c.id = cpt2.clientId
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						AP.id = ISNULL(cpt.planId, cpt2.planId)
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
				LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
				LEFT OUTER JOIN  #FSLicensedOrBackupClients licfs ON  LICfs.cid=cpt.clientId
LEFT JOIN App_IDAName IDA on C.id = IDA.clientId and IDA.appTypeId = 64
				LEFT JOIN App_IDAProp prop on IDA.id = prop.componentNameId
AND prop.attrName = N'Distributed Cluster Type'
AND prop.attrVal in (N'3', N'11', N'13')
							AND prop.modified = 0
				WHERE
					-- We ignore all filters in request if [getAllClients] filter is set to TRUE
					(@getAllClients = 1) OR (
					(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
						OR
						((@i_includeVMClients=1) AND ((cpt.virtualServerDiscovered=1 AND cpt2.clientId IS NULL) OR cpt2.virtualServerDiscovered=1) AND ((cpt.lastBackupJobId <> 0 AND cpt2.clientId IS NULL) OR cpt2.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
					)
					AND
					(
						@i_hideLaptopAndDummyclients = 0
						OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL)) AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
						OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
						OR (ISNULL(cpt.installJobId, 0) > 0 AND cpt2.clientId IS NULL) -- To ensure we drop the record which still has deleted info in it
						OR (ISNULL(cpt2.installJobId, 0) > 0)
						OR (IDA.appTypeId IS NOT NULL
							AND prop.attrName IS NOT NULL)
					)
					AND
					(
					      (@infrastructureMachineFilter = 0)
						  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
						  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
					))
					AND ((@epicClientFilter=0 ) or (@epicClientFilter=1 and (cpt.clientAppType <> 11  or cpt.clientAppType is null)) or (@epicClientFilter=2 and cpt.clientAppType = 11))
		END
		ELSE IF ( @i_getCommNetClients <> 0 )
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			INSERT INTO #ClientListTbl ([r_id], [r_name],[r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
									  [r_ccpId], [r_specialStatusFlags],[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
									  [r_OSInfo],[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
									  [r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId],[r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType],[r_IsInfrastructureMachine],[r_InfrastructureMachineType], [r_isIndexingV2VSA], [r_installJobId],
									  [r_isVirtualServerDiscoveredClient], [r_ReInstallJobStatus])
				SELECT	c.id, c.name, displayName,c.GUID, simOperatingSystemId, net_hostname, clientDescription, status, c.releaseId, APF.platformType,c.ccpId,
				  specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,cpt.OSInfo,cpt.proxyFSClientId,
				  cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				  ( CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
				cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId,
				  iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
				  ISNULL(DCTC.clusterType,0), cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA,
				  ISNULL(cpt.installJobId, cpt2.installJobId), -- If CT_ClientProperties doesn't have the info get it from #ClientProp table which has updated rows
				  (CASE WHEN (cpt.virtualServerDiscovered=1) THEN 1 ELSE 0 END),	-- Virtual Discovered Client
				  ISNULL(cpt.reInstallJobStatus, cpt2.reInstallJobStatus)
				FROM	APP_Client c
					LEFT OUTER JOIN #clientPropTbl cpt2 on
						c.id = cpt2.clientId
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						AP.id = ISNULL(cpt.planId, cpt2.planId)
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
				WHERE 	@i_includeHiddenClients > 0 OR (c.id IN ( SELECT clientId FROM APP_IDAName where appTypeId = 121 )) -- 121 IS COMMNET SERVER
		END
		ELSE IF (@getAllClients = 1)
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid],[r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],[r_proxyFSClientId],	[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId],[r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType],[r_IsInfrastructureMachine],[r_InfrastructureMachineType],[r_isIndexingV2VSA], [r_installJobId],
										[r_isVirtualServerDiscoveredClient], [r_isApplicableForServersPage], [r_ReInstallJobStatus])
				SELECT	c.id, c.name, displayName, c.GUID, simOperatingSystemId, net_hostname, clientDescription, c.status, c.releaseId, APF.platformType,
				c.ccpId, specialClientFlags,cpt.deleted,cpt.virtualClient, cpt.isLicensed,	cpt.physClientId,cpt.OSInfo,
				cpt.proxyFSClientId,cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				(CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
				SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
				cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId, iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
					ISNULL(DCTC.clusterType,0),cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA,
					ISNULL(cpt.installJobId, cpt2.installJobId), -- If CT_ClientProperties doesn't have the info get it from #ClientProp table which has updated rows
					 (CASE WHEN (cpt.virtualServerDiscovered=1) THEN 1 ELSE 0 END),	-- Virtual Discoverd Client
					CASE WHEN (
								(
									(@i_getArchiverClients = 0 AND ArcC.clientId IS NULL)
											OR
									(@i_getArchiverClients = 1 AND ArcC.clientId IS NOT NULL)
								)
								AND
								(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
									OR
									((@i_includeVMClients=1) AND ((cpt.virtualServerDiscovered=1 AND cpt2.clientId IS NULL) OR cpt2.virtualServerDiscovered=1) AND ((cpt.lastBackupJobId <> 0 AND cpt2.clientId IS NULL) OR cpt2.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
								)
								AND
								(
									@i_hideLaptopAndDummyclients = 0
									OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL AND (@i_getArchiverClients = 0 OR ArcC.isBackedUp = 1)))
										AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
									OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
									OR (ISNULL(cpt.installJobId, 0) > 0 AND cpt2.clientId IS NULL ) -- To ensure we drop the record which still has deleted info in it
									OR (ISNULL(cpt2.installJobId, 0) > 0)
									OR (IDA.appTypeId IS NOT NULL
										AND prop.attrName IS NOT NULL)
								)
								AND
								(
									((cpt.clusterType IS NULL) OR (cpt.clusterType NOT IN (6,7,8)))
								)
								AND
								(
								(@infrastructureMachineFilter = 0)
									  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
									  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
								)
					) THEN 1 ELSE 0 END,
					ISNULL(cpt.reInstallJobStatus, cpt2.reInstallJobStatus)
				FROM
					APP_Client c
					LEFT OUTER JOIN #clientPropTbl cpt2 on
						c.id = cpt2.clientId
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						AP.id = ISNULL(cpt.planId, cpt2.planId)
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN simOperatingSystem SIM ON c.simOperatingSystemId = sim.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
					LEFT OUTER JOIN  #FSLicensedOrBackupClients licfs ON  licfs.cid=cpt.clientId
					LEFT OUTER JOIN #Archivalclients ArcC ON c.id = ArcC.clientId
LEFT JOIN App_IDAName IDA on C.id = IDA.clientId and IDA.appTypeId = 64
					LEFT JOIN App_IDAProp prop on IDA.id = prop.componentNameId
AND prop.attrName = N'Distributed Cluster Type'
AND prop.attrVal in (N'3', N'11', N'13')
								AND prop.modified = 0
					WHERE c.id > 1
		END
		ELSE
		BEGIN
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid],[r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],[r_proxyFSClientId],	[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId],[r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType],[r_IsInfrastructureMachine],[r_InfrastructureMachineType],[r_isIndexingV2VSA], [r_installJobId],
										[r_isVirtualServerDiscoveredClient], [r_ReInstallJobStatus])
				SELECT	c.id, c.name, displayName, c.GUID, simOperatingSystemId, net_hostname, clientDescription, c.status, c.releaseId, APF.platformType,
				c.ccpId, specialClientFlags,cpt.deleted,cpt.virtualClient, cpt.isLicensed,	cpt.physClientId,cpt.OSInfo,
				cpt.proxyFSClientId,cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				(CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
				SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
				cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId, iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
					ISNULL(DCTC.clusterType,0),cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA,
					ISNULL(cpt.installJobId, cpt2.installJobId), -- If CT_ClientProperties doesn't have the info get it from #ClientProp table which has updated rows
					(CASE WHEN (cpt.virtualServerDiscovered=1) THEN 1 ELSE 0 END),	-- Virtual Discoverd Client
					ISNULL(cpt.reInstallJobStatus, cpt2.reInstallJobStatus)
				FROM
					APP_Client c
					LEFT OUTER JOIN #clientPropTbl cpt2 on
						c.id = cpt2.clientId
					LEFT OUTER JOIN CT_ClientProperties cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						AP.id = ISNULL(cpt.planId, cpt2.planId)
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN simOperatingSystem SIM ON c.simOperatingSystemId = sim.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
					LEFT OUTER JOIN  #FSLicensedOrBackupClients licfs ON  licfs.cid=cpt.clientId
					LEFT OUTER JOIN #Archivalclients ArcC ON c.id = ArcC.clientId
LEFT JOIN App_IDAName IDA on C.id = IDA.clientId and IDA.appTypeId = 64
					LEFT JOIN App_IDAProp prop on IDA.id = prop.componentNameId
AND prop.attrName = N'Distributed Cluster Type'
AND prop.attrVal in (N'3', N'11', N'13')
								AND prop.modified = 0
				WHERE
					(
						(@i_getArchiverClients = 0 AND ArcC.clientId IS NULL) OR (@i_getArchiverClients = 1 AND ArcC.clientId IS NOT NULL)
					)
					AND
					(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
						OR
						((@i_includeVMClients=1) AND ((cpt.virtualServerDiscovered=1 AND cpt2.clientId IS NULL) OR cpt2.virtualServerDiscovered=1) AND ((cpt.lastBackupJobId <> 0 AND cpt2.clientId IS NULL) OR cpt2.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
					)
					AND
					(
						@i_hideLaptopAndDummyclients = 0
						OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL AND (@i_getArchiverClients = 0 OR ArcC.isBackedUp = 1)))
							AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
						OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
						OR (ISNULL(cpt.installJobId, 0) > 0 AND cpt2.clientId IS NULL ) -- To ensure we drop the record which still has deleted info in it
						OR (ISNULL(cpt2.installJobId, 0) > 0)
						OR (IDA.appTypeId IS NOT NULL
							AND prop.attrName IS NOT NULL)
					)
					AND
					(
						((cpt.clusterType IS NULL) OR (cpt.clusterType NOT IN (6,7,8)))
					)
					AND
					(
					(@infrastructureMachineFilter = 0)
						  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
						  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
					)
					AND ((@epicClientFilter=0 ) or (@epicClientFilter=1 and (cpt.clientAppType <> 11  or cpt.clientAppType is null)) or (@epicClientFilter=2 and cpt.clientAppType = 11))
		END
		IF (@UpdateClientRows > 0)
		BEGIN
			-- Update the Client List with the updated client properties for the dirty clients
			UPDATE ctl
				SET [r_deleted] = cpt.deleted,
					[r_isVirtualClient] = cpt.virtualClient,
					[r_isLicensed] = cpt.isLicensed,
					[r_physClientId] = cpt.physClientId,
					[r_OSInfo] = cpt.OSInfo,
					[r_proxyFSClientId] = cpt.proxyFSClientId,
					[r_clientVersion] = cpt.clientVersion,
					[r_SPVersionInfo] = cpt.SPVersionInfo,
					[r_SPVersionAndPatchInfo] = cpt.SPVersionAndPatchInfo,
					[r_snapBKPenabled] = cpt.snapBackupsEnabled,
					[r_arrayIds] = cpt.arrays,
					[r_isBackedUpVMClient] = (CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1 ELSE 0 END),
					[r_lastBackupJobId] = cpt.lastBackupJobId,
					[r_isUserCentricClient] = cpt.isUserCentricClient,
					[r_physicalClientID] = cpt.physicalClientID,
					[r_planId] = cpt.planId,
					[r_isExchangeOnePassClient] = cpt.isExchangeOnePass,
					[r_isFarmClient] = cpt.sharePointFarmClient,
					[r_isIndexingV2] = cpt.isIndexingV2,
					[r_OSName] = cpt.osName,
					[r_hwName] = cpt.hwName,
					[r_IsInfrastructureMachine] = cpt.IsInfrastructureMachine,
					[r_InfrastructureMachineType] = cpt.InfrastructureMachineType,
					[r_isIndexingV2VSA] = cpt.isIndexingV2VSA,
					[r_installJobId] = cpt.installJobId,
					[r_ReInstallJobStatus] = cpt.reInstallJobStatus
			FROM #ClientListTbl ctl
				INNER JOIN #clientPropTbl cpt ON
					cpt.clientId = ctl.r_id
		END
	END
	------------------------------------------CACHE TABLE ENDS HERE ----------------------------------------------------------------------------------
	ELSE
	BEGIN
		-- If client group Ids were provided in request, fetch properties for those clients.
		IF (@tempServerGrpCnt > 0)
		BEGIN
			INSERT INTO #clientPropTbl
				SELECT	componentNameId							AS clientId,
						[platformdeleted 4]					AS deleted,
						[Virtual client]					AS virtualClient,
						[Licensed Client]					AS islicensed,
						[Active Physical Node]					AS physClientId,
						[Sim OS Info]						AS OSInfo,
						[Proxy Filesystem Client Id]				AS proxyFSClientId,
						[Client Version] AS clientVersion,[SP Version Info]	AS SPVersionInfo,
						[SP Version And Patch Info]				AS SPVersionAndPatchInfo,
						[Snap Backups Enabled]					As snapBackupsEnabled,
						[Arrays]						As arrays,
						[Virtual Server Discovered Clients] 			AS virtualServerDiscovered,
						[Last Backup JobID]					AS lastBackupJobId,
						[Index Server Type]					AS clusterType,
						[User Centric Client]					AS isUserCentricClient,
						[Physical Client Id]					AS physicalClientID,
						[Associated Plan]					AS planId,
						[Physical Client Id On Hold]				AS physicalClientIdOnHold ,
						[Associated Plan Id On Hold]				AS planIdOnHold,
						[Exchange OnePass Client]				AS isExchangeOnePass,
						[SharePoint Farm Client]				AS isFarmClient,
						[IndexingV2]						AS isIndexingV2,
						[Operating System Name]					AS osName,
						[Hardware Info]						AS hwName,
						[IsInfrastructureMachine]					AS IsInfrastructureMachine,
						[InfrastructureMachineType]			AS InfrastructureMachineType,
						[IndexingV2_VSA]					AS isIndexingV2VSA,
						[Install Job id]						AS installJobId,
						[Reinstall Job Status]					AS reInstallJobStatus,
						[Client App Type]						AS clientAppType
				FROM (
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							APP_Client c
							INNER JOIN APP_ClientGroupAssoc CG ON
								c. id = CG.clientId
							INNER JOIN @tempClientGroupIdList TCG ON
							    CG.clientGroupId = TCG.clientGroupId
							LEFT OUTER JOIN App_ClientProp cp ON
								c.id = cp.componentNameId
								AND cp.modified = 0
								AND attrName IN ('platformdeleted 4',
										'Virtual client',
										'Licensed Client',
										'Active Physical Node',
										'Sim OS Info',
										'Proxy Filesystem Client Id',
										'Client Version',
										'SP Version Info',
										'SP Version And Patch Info',
										'Snap Backups Enabled' ,
										'Arrays',
										'Virtual Server Discovered Clients',
										'Last Backup JobID',
										'Index Server Type',
										'User Centric Client',
										'Physical Client Id',
										'Associated Plan',
										'Physical Client Id On Hold',
										'Associated Plan Id On Hold',
										'Exchange OnePass Client',
										'SharePoint Farm Client',
										'IndexingV2',
										'Operating System Name',
										'Hardware Info',
										'IsInfrastructureMachine',
										'InfrastructureMachineType',
										'IndexingV2_VSA',
										'Install Job Id',
										'Reinstall Job Status')
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN ([platformdeleted 4],
															[Virtual client],
															[Licensed Client],
															[Active Physical Node],
															[Sim OS Info],
															[Proxy Filesystem Client Id],
															[Client Version],
															[SP Version Info],
															[SP Version And Patch Info],
															[Snap Backups Enabled] ,
															[Arrays],
															[Virtual Server Discovered Clients],
															[Last Backup JobID],
															[Index Server Type],
															[User Centric Client],
															[Physical Client Id],
															[Associated Plan],
															[Physical Client Id On Hold],
															[Associated Plan Id On Hold],
															[Exchange OnePass Client],
															[SharePoint Farm Client],
															[IndexingV2],
															[Operating System Name],
															[Hardware Info],
															[IsInfrastructureMachine],
															[InfrastructureMachineType],
   														[IndexingV2_VSA],
														[Install Job Id],
														[Reinstall Job Status],
														[Client App Type]
														)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],	[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId], [r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient],[r_isFarmClient],[r_isIndexingV2],[r_clusterType], [r_IsInfrastructureMachine],[r_InfrastructureMachineType], [r_isIndexingV2VSA], [r_installJobId], [r_ReInstallJobStatus])
			SELECT	c.id, c.name, displayName, c.GUID, C.simOperatingSystemId, net_hostname, clientDescription, status, c.releaseId, APF.platformType,
			 c.ccpId, specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,
					cpt.OSInfo,	cpt.proxyFSClientId,cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
					(CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
					cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId, iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
					ISNULL(DCTC.clusterType,0),cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA, cpt.installJobId, cpt.reInstallJobStatus
				FROM	APP_Client c
					INNER JOIN APP_ClientGroupAssoc CG ON
						c. id = CG.clientId
					LEFT OUTER JOIN #clientPropTbl cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						cpt.planId=AP.id
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
					LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
		END
		ELSE IF (@tempServerCnt <> 0)
		BEGIN
			INSERT INTO #clientPropTbl
				SELECT	componentNameId							AS clientId,
						[platformdeleted 4]					AS deleted,
						[Virtual client]					AS virtualClient,
						[Licensed Client]					AS islicensed,
						[Active Physical Node]					AS physClientId,
						[Sim OS Info]						AS OSInfo,
						[Proxy Filesystem Client Id]				AS proxyFSClientId,
						[Client Version] AS clientVersion,[SP Version Info]	AS SPVersionInfo,
						[SP Version And Patch Info]				AS SPVersionAndPatchInfo,
						[Snap Backups Enabled]					AS snapBackupsEnabled,
						[Arrays]						AS arrays,
						[Virtual Server Discovered Clients] 			AS virtualServerDiscovered,
						[Last Backup JobID]					AS lastBackupJobId,
						[Index Server Type]					AS clusterType,
						[User Centric Client]					AS isUserCentricClient,
						[Physical Client Id]					AS physicalClientID,
						[Associated Plan]					AS planId,
						[Physical Client Id On Hold]				AS physicalClientIdOnHold ,
						[Associated Plan Id On Hold]				AS planIdOnHold,
						[Exchange OnePass Client]				AS isExchangeOnePass,
						[SharePoint Farm Client]				AS isFarmClient,
						[IndexingV2]						AS isIndexingV2,
						[Operating System Name]					AS osName,
						[Hardware Info]						AS hwName,
						[IsInfrastructureMachine]					AS IsInfrastructureMachine,
						[InfrastructureMachineType]			AS InfrastructureMachineType,
						[IndexingV2_VSA]					AS isIndexingV2VSA,
						[Install Job Id]						AS installJobId,
						[Reinstall Job Status]					AS reInstallJobStatus,
						[Client App Type]						AS clientAppType
				FROM (
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp INNER JOIN @tempServerIdList TS on cp.componentnameid = TS.clientId and cp.modified = 0
						WHERE
							attrName IN (	'platformdeleted 4',
										'Virtual client',
										'Licensed Client',
										'Active Physical Node',
										'Sim OS Info',
										'Proxy Filesystem Client Id',
										'Client Version',
										'SP Version Info',
										'SP Version And Patch Info'	,
										'Snap Backups Enabled' ,
										'Arrays',
										'Virtual Server Discovered Clients',
										'Last Backup JobID',
										'Index Server Type',
										'User Centric Client',
										'Physical Client Id',
										'Associated Plan',
										'Physical Client Id On Hold',
										'Associated Plan Id On Hold',
										'Exchange OnePass Client',
										'SharePoint Farm Client',
										'IndexingV2',
										'Operating System Name',
										'Hardware Info',
										'IsInfrastructureMachine',
										'InfrastructureMachineType',
										'Install Job Id',
										'Reinstall Job Status',
										'Client App type'
							)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4],
										[JMPriority],
										[Content Indexing Engine],
										[Encrypt: encryption], [Encrypt: rsaPubKey], [Encrypt: rsaPriKeySF],
										[Virtual client],
										[Licensed Client],
										[Active Physical Node],
										[Sim OS Info],
										[Proxy Filesystem Client Id],
										[Client Version],
										[SP Version Info], [SP Version And Patch Info],
										[Snap Backups Enabled] ,
										[Arrays],
										[Virtual Server Discovered Clients],
										[Last Backup JobID],
										[Index Server Type],
										[User Centric Client],
										[Physical Client Id],
										[Associated Plan],
										[Physical Client Id On Hold],
										[Associated Plan Id On Hold],
										[Exchange OnePass Client],
										[SharePoint Farm Client],
										[IndexingV2],
										[Operating System Name],
										[Hardware Info],
										[IsInfrastructureMachine],
										[InfrastructureMachineType],
										[IndexingV2_VSA],
										[Install Job Id],
										[Reinstall Job Status],
										[Client App Type]
										)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],	[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId], [r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType], [r_IsInfrastructureMachine], [r_InfrastructureMachineType], [r_isIndexingV2VSA], [r_installJobId], [r_ReInstallJobStatus])
			SELECT	c.id, c.name, displayName, c.GUID, simOperatingSystemId, net_hostname, clientDescription, status, c.releaseId, APF.platformType,
				c.ccpId,specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,cpt.OSInfo,cpt.proxyFSClientId,
				cpt.clientVersion,	cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				( CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
					cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId,
				iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
				ISNULL(DCTC.clusterType,0),cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA, cpt.installJobId, cpt.reInstallJobStatus
				FROM	APP_Client c
					INNER JOIN @tempServerIdList TS on
					    c.id = TS.clientId
					LEFT OUTER JOIN #clientPropTbl cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						cpt.planId=AP.id
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
		END
		ELSE IF ( @i_getCommNetClients <> 0 )
		BEGIN
			--PERF 8/17/2015 AEB flatten all required client properties.
			INSERT INTO #clientPropTbl
				SELECT	componentNameId							AS clientId,
						[platformdeleted 4]					AS deleted,
						[Virtual client]					AS virtualClient,
						[Licensed Client]					AS islicensed,
						[Active Physical Node]					AS physClientId,
						[Sim OS Info]						AS OSInfo,
						[Proxy Filesystem Client Id]				AS proxyFSClientId,
						[Client Version] AS clientVersion,[SP Version Info]	AS SPVersionInfo,
						[SP Version And Patch Info]				AS SPVersionAndPatchInfo,
						[Snap Backups Enabled]					AS snapBackupsEnabled,
						[Arrays]						AS arrays,
						[Virtual Server Discovered Clients] 			AS virtualServerDiscovered,
						[Last Backup JobID]					AS lastBackupJobId,
						[Index Server Type]					AS clusterType,
						[User Centric Client]					AS isUserCentricClient,
						[Physical Client Id]					AS physicalClientID,
						[Associated Plan]					AS planId,
						[Physical Client Id On Hold]				AS physicalClientIdOnHold ,
						[Associated Plan Id On Hold]				AS planIdOnHold,
						[Exchange OnePass Client]				AS isExchangeOnePass,
						[SharePoint Farm Client]				AS isFarmClient,
						[IndexingV2]						AS isIndexingV2,
						[Operating System Name]					AS osName,
						[Hardware Info]						AS hwName,
						[IsInfrastructureMachine]					AS IsInfrastructureMachine,
						[InfrastructureMachineType]          AS InfrastructureMachineType,
						[IndexingV2_VSA]					AS isIndexingV2VSA,
						[Install Job Id]						AS installJobId,
						[Reinstall Job Status]					AS reInstallJobStatus,
						[Client App Type]						AS clientAppType
				FROM (
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp
						WHERE
							(
								@i_includeHiddenClients > 0
								OR (cp.componentNameId IN (SELECT clientId FROM APP_IDAName where appTypeId = 121))
							)
							AND cp.modified = 0
							AND attrName IN ('platformdeleted 4',
										'Virtual client',
										'Licensed Client',
										'Active Physical Node',
										'Sim OS Info',
										'Proxy Filesystem Client Id',
										'Client Version',
										'SP Version Info',
										'SP Version And Patch Info'	,
										'Snap Backups Enabled' ,
										'Arrays',
										'Virtual Server Discovered Clients',
										'Last Backup JobID',
										'Index Server Type',
										'User Centric Client',
										'Physical Client Id',
										'Associated Plan',
										'Physical Client Id On Hold',
										'Associated Plan Id On Hold',
										'Exchange OnePass Client',
										'SharePoint Farm Client',
										'IndexingV2',
										'Operating System Name',
										'Hardware Info',
										'IsInfrastructureMachine',
										'InfrastructureMachineType',
										'Install Job Id',
										'Reinstall Job Status',
										'Client App Type'
							)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (		[platformdeleted 4],
															[Virtual client],
															[Licensed Client],
															[Active Physical Node],
															[Sim OS Info],
															[Proxy Filesystem Client Id],
															[Client Version],
															[SP Version Info],
															[SP Version And Patch Info],
															[Snap Backups Enabled] ,
															[Arrays],
															[Virtual Server Discovered Clients],
															[Last Backup JobID],
															[Index Server Type],
															[User Centric Client],
															[Physical Client Id],
															[Associated Plan],
															[Physical Client Id On Hold],
															[Associated Plan Id On Hold],
															[Exchange OnePass Client],
															[SharePoint Farm Client],
															[IndexingV2],
															[Operating System Name],
															[Hardware Info],
															[IsInfrastructureMachine],
															[InfrastructureMachineType],
															[IndexingV2_VSA],
															[Install Job Id],
															[Reinstall Job Status],
															[Client App Type]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name],[r_displayName],[r_guid], [r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
									  [r_ccpId], [r_specialStatusFlags],[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
									  [r_OSInfo],[r_proxyFSClientId],[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
									  [r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId],[r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType], [r_IsInfrastructureMachine],[r_InfrastructureMachineType],[r_isIndexingV2VSA], [r_installJobId], [r_ReInstallJobStatus])
				SELECT	c.id, c.name, displayName,c.GUID, simOperatingSystemId, net_hostname, clientDescription, status, c.releaseId, APF.platformType,c.ccpId,
				  specialClientFlags,cpt.deleted,cpt.virtualClient,cpt.isLicensed,cpt.physClientId,cpt.OSInfo,cpt.proxyFSClientId,
				  cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				  ( CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
					SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
				cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId,
				  iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
				  ISNULL(DCTC.clusterType,0), cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA, cpt.installJobId, cpt.reInstallJobStatus
				FROM	APP_Client c
					LEFT OUTER JOIN #clientPropTbl cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						cpt.planId=AP.id
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
					LEFT OUTER JOIN simOperatingSystem SIM
							ON C.simOperatingSystemId = sim.id
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
				WHERE 	@i_includeHiddenClients > 0 OR (c.id IN ( SELECT clientId FROM APP_IDAName where appTypeId = 121 )) -- 121 IS COMMNET SERVER
		END
		ELSE
		BEGIN
			INSERT INTO #clientPropTbl
				SELECT	componentNameId							AS clientId,
						[platformdeleted 4]					AS deleted,
						[Virtual client]					AS virtualClient,
						[Licensed Client]					AS islicensed,
						[Active Physical Node]					AS physClientId,
						[Sim OS Info]						AS OSInfo,
						[Proxy Filesystem Client Id]				AS proxyFSClientId,
						[Client Version] AS clientVersion,[SP Version Info]	AS SPVersionInfo,
						[SP Version And Patch Info]				AS SPVersionAndPatchInfo,
						[Snap Backups Enabled]					AS snapBackupsEnabled,
						[Arrays]						AS arrays,
						[Virtual Server Discovered Clients] 			AS virtualServerDiscovered,
						[Last Backup JobID]					AS lastBackupJobId,
						[Index Server Type]					AS clusterType,
						[User Centric Client]					AS isUserCentricClient,
						[Physical Client Id]					AS physicalClientID,
						[Associated Plan]					AS planId,
						[Physical Client Id On Hold]				AS physicalClientIdOnHold ,
						[Associated Plan Id On Hold]				AS planIdOnHold,
						[Exchange OnePass Client]				AS isExchangeOnePass,
						[SharePoint Farm Client]				AS isFarmClient,
						[IndexingV2]						AS isIndexingV2,
						[Operating System Name]					AS osName,
						[Hardware Info]						AS hwName,
						[IsInfrastructureMachine]					AS IsInfrastructureMachine,
						[InfrastructureMachineType]			AS InfrastructureMachineType,
						[IndexingV2_VSA]					AS isIndexingV2VSA,
						[Install Job Id]						AS installJobId,
						[Reinstall Job Status]					AS reInstallJobStatus,
						[Client App Type]					AS clientAppType
				FROM (
						SELECT
							componentNameId,
							attrName,
							attrVal
						FROM
							App_ClientProp cp
						WHERE
							cp.modified = 0
							AND attrName IN (	'platformdeleted 4',
										'Virtual client',
										'Licensed Client',
										'Active Physical Node',
										'Sim OS Info',
										'Proxy Filesystem Client Id',
										'Client Version',
										'SP Version Info',
										'SP Version And Patch Info',
										'Snap Backups Enabled' ,
										'Arrays',
										'Virtual Server Discovered Clients',
										'Last Backup JobID',
										'Index Server Type',
										'User Centric Client',
										'Physical Client Id',
										'Associated Plan',
										'Physical Client Id On Hold',
										'Associated Plan Id On Hold',
										'Exchange OnePass Client',
										'SharePoint Farm Client',
										'IndexingV2',
										'Operating System Name',
										'Hardware Info',
										'IsInfrastructureMachine',
										'InfrastructureMachineType',
										'Install Job Id',
										'Reinstall Job Status',
										'Client App Type'
									)
					) AS clients
				PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4],
															[Virtual client],
															[Licensed Client],
															[Active Physical Node],
															[Sim OS Info],
															[Proxy Filesystem Client Id],
															[Client Version],
															[SP Version Info],
															[SP Version And Patch Info],
															[Snap Backups Enabled] ,
															[Arrays],
															[Virtual Server Discovered Clients],
															[Last Backup JobID],
															[Index Server Type],
															[User Centric Client],
															[Physical Client Id],
															[Associated Plan],
															[Physical Client Id On Hold],
															[Associated Plan Id On Hold],
															[Exchange OnePass Client],
															[SharePoint Farm Client],
															[IndexingV2],
															[Operating System Name],
															[Hardware Info],
															[IsInfrastructureMachine],
															[InfrastructureMachineType],
															[IndexingV2_VSA],
															[Install Job Id],
															[Reinstall Job Status],
															[Client App Type]
						)
					) AS P
			INSERT INTO #ClientListTbl ([r_id], [r_name], [r_displayName],[r_guid],[r_OSId], [r_netHostName], [r_desc], [r_status], [r_releaseId], [r_isMA],
										[r_ccpId],	[r_specialStatusFlags],	[r_deleted],[r_isVirtualClient],[r_isLicensed],	[r_physClientId],
										[r_OSInfo],[r_proxyFSClientId],	[r_clientVersion],[r_SPVersionInfo],[r_SPVersionAndPatchInfo],
										[r_MAdeleted],[r_OSType], [r_OSSubType], [r_OSName], [r_hwName], [r_snapBKPenabled],[r_arrayIds],[r_isBackedUpVMClient],[r_lastBackupJobId],[r_cAppType],[r_isUserCentricClient],[r_physicalClientID],[r_planId], [r_planName], [r_isExchangeOnePassClient], [r_isFarmClient],[r_isIndexingV2],[r_clusterType], [r_IsInfrastructureMachine],[r_InfrastructureMachineType],[r_isIndexingV2VSA], [r_installJobId], [r_ReInstallJobStatus])
				SELECT	c.id, c.name, displayName, c.GUID, simOperatingSystemId, net_hostname, clientDescription, c.status, c.releaseId, APF.platformType,
				c.ccpId, specialClientFlags,cpt.deleted,cpt.virtualClient, cpt.isLicensed,	cpt.physClientId,cpt.OSInfo,
				cpt.proxyFSClientId,cpt.clientVersion,cpt.SPVersionInfo,cpt.SPVersionAndPatchInfo,
				(CASE  WHEN (LIC.id <> 0 AND APF.platformType=2) THEN 0
							WHEN (LIC.id IS NULL AND APF.platformType=2) THEN 1
							ELSE NULL END),
				SIM.type, SIM.SubType, cpt.osName, cpt.hwName,
				cpt.snapBackupsEnabled, cpt.arrays,
					(CASE WHEN (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0) THEN 1
						ELSE 0 END)
					,cpt.lastBackupJobId, iprop.attrVal cAppType,cpt.isUserCentricClient, cpt.physicalClientID, cpt.planId, AP.name, cpt.isExchangeOnePass, cpt.sharePointFarmClient, cpt.isIndexingV2,
					ISNULL(DCTC.clusterType,0), cpt.IsInfrastructureMachine, cpt.InfrastructureMachineType, cpt.isIndexingV2VSA, cpt.installJobId, cpt.reInstallJobStatus
				FROM
					APP_Client c
					LEFT OUTER JOIN #clientPropTbl cpt ON
						c.id = cpt.clientId
					LEFT OUTER JOIN APP_PLAN AP ON
						cpt.planId=AP.id
					LEFT OUTER JOIN APP_Platform APF ON
						APF.clientId=cpt.clientId AND APF.platformType=2
					LEFT OUTER JOIN LicUsage LIC ON
						LIC.cid=cpt.clientId AND LIC.apptype = 1002 AND LIC.lictype NOT IN (71, 10, 26, 33554432) AND LIC.optype = 'Install' AND LIC.InstallFlag = 0
								LEFT OUTER JOIN (select a.clientId, iprop.attrVal
									 from APP_InstanceName I
											INNER JOIN APP_Application a with (nolock) ON I.id = a.instance and a.appTypeId = 134
											INNER JOIN APP_InstanceProp iProp with (nolock) ON I.id = iprop.componentNameId and iProp.attrName = N'Cloud Apps Instance Type' and iProp.attrVal in (N'1',N'2',N'3') and iProp.modified = 0
									 group by a.clientId, iprop.attrVal) iprop on iprop.clientId = c.id
					LEFT OUTER JOIN simOperatingSystem SIM ON c.simOperatingSystemId = sim.id
					LEFT OUTER JOIN #DistributedClusterTypeClients DCTC ON c.id = DCTC.id
					LEFT OUTER JOIN #FSLicensedOrBackupClients licfs ON  licfs.cid=cpt.clientId
					LEFT OUTER JOIN #Archivalclients ArcC ON c.id = ArcC.clientId
LEFT JOIN App_IDAName IDA on C.id = IDA.clientId and IDA.appTypeId = 64
					LEFT JOIN App_IDAProp prop on IDA.id = prop.componentNameId
AND prop.attrName = N'Distributed Cluster Type'
AND prop.attrVal in (N'3', N'11', N'13')
								AND prop.modified = 0
				WHERE
					(
						((@i_getArchiverClients = 0 AND ArcC.clientId IS NULL) OR (@i_getArchiverClients = 1 AND ArcC.clientId IS NOT NULL))
					)
					AND
					(
((@i_includeHiddenClients > 0 OR (c.specialClientFlags & 0x1 <> 0x1))
						OR
						((@i_includeVMClients=1) AND (cpt.virtualServerDiscovered=1) AND (cpt.lastBackupJobId <> 0)))   -- We are only going to include protected or backed up with error VM's
					)
					AND
					(
						@i_hideLaptopAndDummyclients = 0
						OR ((c.specialClientFlags = 0 OR (licfs.cId IS NOT NULL AND (@i_getArchiverClients = 0 OR ArcC.isBackedUp = 1)))
							AND (c.status & 0x1000 = 0))
OR (c.specialClientFlags & 0x20 = 0x20)
						OR cpt.virtualClient = 1
OR (SIM.SubType= 'NAS' )
OR (SIM.id in (49,118))
						OR (ISNULL(cpt.installJobId, 0) > 0)
						OR (IDA.appTypeId IS NOT NULL
							AND prop.attrName IS NOT NULL)
					)
					AND
					(
						((cpt.clusterType IS NULL) OR (cpt.clusterType NOT IN (6,7,8)))
					)
					AND
					(
					     (@infrastructureMachineFilter = 0)
						  OR (@infrastructureMachineFilter = 1 AND cpt.IsInfrastructureMachine = 1)
						  OR (@infrastructureMachineFilter = 2 AND (cpt.IsInfrastructureMachine = 0 OR cpt.IsInfrastructureMachine is null OR LICfs.cid is not null))
					)
					AND ((@epicClientFilter=0 ) or (@epicClientFilter=1 and (cpt.clientAppType <> 11  or cpt.clientAppType is null)) or (@epicClientFilter=2 and cpt.clientAppType = 11))
		END
	END
------------------------------------------ ENDS Get Client List ----------------------------------------------------------------------------------
IF (@getAllClients = 0)
BEGIN
	-- removes clients that were "hard deleted"
	DELETE ct
	FROM  #ClientListTbl ct
		LEFT OUTER JOIN APP_Platform p WITH(NOLOCK) ON
			p.clientId = ct.r_id
			AND p.platformType = 4
	WHERE
		p.clientId IS NULL
	--
	--Exclude psuedo client which are created for solr cloud & content analyzer cloud
	--these are dummy clients which does not needs be shown in the admin console page
	DELETE T
	FROM #ClientListTbl T
	WHERE dbo.IsDistributedPseudoClient(T.r_id) = 1
	--
END
ELSE
BEGIN
	--Update the property of clients which are of Cloud App Types
	IF @getAllClients = 1
	BEGIN
		UPDATE CLT
			SET r_isApplicableForServersPage = 0
		FROM   #clientListTbl CLT
			 INNER JOIN App_Application app WITH (nolock)
					 ON CLT.r_id = app.clientid
			 LEFT JOIN app_instanceprop iProp WITH (nolock)
					ON app.instance = iprop.componentnameid
		WHERE
(app.appTypeId = 134  -- 134 - Cloud apps
				AND iProp.attrName = N'Cloud Apps Instance Type'
				AND iProp.attrVal IN (N'1',N'2',N'7', N'35', N'36')  -- 1, 2 - G-suite instances, 7, 35, 36 - Office 365 instances
				AND iProp.modified = 0) OR
(app.appTypeId = 137)	-- 137 - Office 365 Apps
	END
	-- In get all client for Mongo.. just mark them not applicable for Servers Page
	UPDATE ct
		SET ct.r_isApplicableForServersPage = 0
	FROM  #ClientListTbl ct
		LEFT OUTER JOIN APP_Platform p WITH(NOLOCK) ON
			p.clientId = ct.r_id
			AND p.platformType = 4
	WHERE
		p.clientId IS NULL
	UPDATE T
		SET T.r_isApplicableForServersPage = 0
	FROM #ClientListTbl T
	WHERE dbo.IsDistributedPseudoClient(T.r_id) = 1
END
DECLARE @linkedCSClient TABLE(ClientID int)
INSERT INTO @linkedCSClient
SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'Linked CS Client' AND modified = 0
-- Hide the Active Dummy client in Commcell Console GUI in failover environment.
IF @@RowCount>0
BEGIN
	DELETE ct
	FROM #ClientListTbl ct
	INNER JOIN @linkedCSClient linkedCSClient ON ct.r_id = linkedCSClient.clientId
END
-- Sets the SLA status. 1 - Met, 2 - Missed, 3 - Exclude
UPDATE CL
SET CL.r_SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
	CL.r_SLACategory = SLA.Category,
	CL.r_SLACategoryDescription = dbo.WR_GetSLACategoryString(@i_localeId,SLA.Category)
FROM #ClientListTbl CL
INNER JOIN RptSLAClient SLA ON SLA.clientId = CL.r_id AND SLA.fullJobsOnly = 0
UPDATE CL
SET CL.r_SLAStatus = 5,/*MIGHT_MISS_SLA*/
	CL.r_SLACategoryDescription = '',
	CL.r_slaMissReasonList = CAST(Prop.stringVal AS XML)
FROM #ClientListTbl CL
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = CL.r_id AND Prop.componentType =  3 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
if(@selectiveAppType=1)
BEGIN
	-- Security Check
	-- Check if user has permission on commcell
	DECLARE @hasPermissionOnCommcell INTEGER = 0
	IF (@isAdminUserId  = 0)
	BEGIN
IF EXISTS (SELECT 1 FROM #clientListTmp ct WHERE ct.commCellId=2 AND ct.clientGroupId=0 AND ct.clientId=0 AND ct.appTypeId=0 AND ct.instanceId=0 AND ct.backupsetId=0 AND ct.subClientId=0 AND ct.mediaAgentId=0 AND ct.libraryId=0 AND ct.archGroupId=0 AND ct.vtContainerId=0 AND ct.vtPolicyId=0 AND ct.vtShelfId=0 AND ct.reviewSetId=0 AND ct.querySetId=0 AND ct.downloadSetId=0 AND ct.ermId=0 AND ct.legalHoldId=0 AND ct.tagId=0 AND ct.cdPolicyId=0 AND ct.complianceReportId=0 AND ct.taskId=0 AND ct.workflowId=0 AND ct.logMonitoringPolicyId=0 AND ct.arrayId=0 AND ct.cloudId=0 AND ct.userGroupId=0 AND ct.providerId=0 AND ct.entityId1=0 AND ct.entityId2=0 AND ct.entityId3=0 AND ct.entityId4=0 AND ct.entityId5=0									AND ct.entityId6=0 AND ct.entityId7=0 AND ct.entityId8=0 AND ct.entityId9=0)
			SET @hasPermissionOnCommcell = 1
	END
	IF (@isAdminUserId  = 1 OR @hasPermissionOnCommcell = 1)
		DELETE #ClientListTbl
		WHERE NOT EXISTS
			(
				SELECT 1 FROM APP_IDAName
					INNER JOIN #idaListTbl ON
						APP_IDAName.clientId = r_id and #idaListTbl.r_appId=APP_IDAName.appTypeId
			)
	ELSE
		DELETE #ClientListTbl
			WHERE NOT EXISTS
			(
					SELECT 1 FROM APP_IDAName
						INNER JOIN #idaListTbl ON
							APP_IDAName.clientId = r_id and #idaListTbl.r_appId=APP_IDAName.appTypeId
						INNER JOIN #clientListTmp ct on
						 (ct.clientId = r_id and (ct.appTypeId = 0  OR ct.appTypeId = #idaListTbl.r_appId))
			)
END
	--get ida information
	INSERT INTO #idaInfoTbl ([r_clientId] ,[r_appId] ,[r_appName] , [r_cAppType], [r_isAccessTimeCollected], [r_status]  )
	SELECT #ClientListTbl.r_id, APP_iDAType.type, APP_iDAType.name, #ClientListTbl.r_cAppType, CAST(IProp.attrVal AS INT), APP_IDAName.status
	FROM #ClientListTbl
	INNER JOIN APP_IDAName ON APP_IDAName.clientId=#ClientListTbl.r_id
	INNER JOIN APP_iDAType ON APP_iDAType.type=APP_IDAName.appTypeId
	LEFT OUTER JOIN App_IdaProp IProp ON IProp.componentNameId = App_IdaName.id AND IProp.attrName = 'Enable Access Time Collection' AND IProp.modified = 0
--remove agent info that are not of requested
if(@selectiveAppType=1)
	DELETE #idaInfoTbl WHERE NOT EXISTS(SELECT * fROM #idaListTbl WHERE #idaListTbl.r_appId=#idaInfoTbl.[r_appId])
-- visibility check
if (@i_userId <> 0)
BEGIN
	IF (@i_hideEnabled <> 0)
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM #clientListTmp WHERE clientId = 0)
		BEGIN
			delete cl
			FROM #ClientListTbl cl
			WHERE NOT EXISTS (SELECT 1 FROM #clientListTmp t WHERE t.clientId = cl.r_id)
		END
	END
	IF object_id('tempdb.dbo.#clientListTmp') is not null DROP TABLE #clientListTmp
END
IF @i_getArchiverClients = 1
BEGIN
	-- NAS Clients have both Windows and Linux FS iDAs.
	-- We want to send only those app Types that have archiver set present.
	DELETE T
	FROM #idaInfoTbl T
		LEFT JOIN #ArchiverSetsTbl Arc
			ON T.r_clientId = Arc.r_clientId
			AND T.r_appId = Arc.r_appTypeId
	WHERE
		Arc.r_appTypeId IS NULL
END
IF @filterProviderId <> -1
BEGIN
	IF object_id('tempdb.dbo.#CompanyClients') IS NOT NULL
		DROP TABLE #CompanyClients
	CREATE TABLE #CompanyClients
	(
		clientId	INT
	)
	CREATE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
	INSERT INTO #CompanyClients
		SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group'AND ACP.cs_attrName = checksum('Associated Smart Client Group') AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
	DELETE
	FROM #ClientListTbl
	WHERE r_id NOT IN
				( SELECT clientId FROM #CompanyClients)
END
IF @i_arrayBasedFilter = 1
BEGIN
	IF (@disableCTClientProperties = 0)
	BEGIN
		DELETE FROM #ClientListTbl
			WHERE r_id NOT IN (
				SELECT r_id from #ClientListTbl CLT
					INNER JOIN CT_ClientProperties CP
						ON CP.clientId=CLT.r_id
					WHERE @i_arrayId IN (SELECT _ID from dbo.SplitIDs(CP.arrays)) AND
							CP.snapBackupsEnabled='1' AND @i_associationtype = 0
				UNION
				SELECT r_id from #ClientListTbl CLT
					INNER JOIN CT_ClientProperties CP
						ON CP.clientId=CLT.r_id
						WHERE @i_associationtype = 1 AND (CP.snapBackupsEnabled IS NULL OR CP.snapBackupsEnabled='0') AND (CP.arrays IS NULL OR CP.arrays = '0')
				) AND @i_associationtype <> 2 -- Don't delete any client from list if user asked for all clients
	END
	ELSE
	BEGIN
		DELETE FROM #ClientListTbl
			WHERE r_id NOT IN (
				SELECT r_id from #ClientListTbl CLT
					INNER JOIN #clientPropTbl CP
						ON CP.clientId=CLT.r_id
					WHERE @i_arrayId IN (SELECT _ID from dbo.SplitIDs(CP.arrays)) AND
						CP.snapBackupsEnabled='1' AND @i_associationtype = 0
				UNION
				SELECT r_id from #ClientListTbl CLT
					INNER JOIN #clientPropTbl CP
						ON CP.clientId=CLT.r_id
						WHERE @i_associationtype = 1 AND (CP.snapBackupsEnabled IS NULL OR CP.snapBackupsEnabled='0') AND (CP.arrays IS NULL OR CP.arrays = '0')
					) AND @i_associationtype <> 2 -- Don't delete any client from list if user asked for all clients
	END
	IF(@selectiveAppType=1)
	BEGIN
		INSERT INTO #planMetricsTbl (r_clientId, r_TotalSubclients)
		SELECT CL.r_id, COUNT (DISTINCT AAP.id)  FROM #ClientListTbl CL
				INNER JOIN APP_Application AAP  WITH(NOLOCK)
					ON AAP.clientId=CL.r_id
				INNER JOIN #idaListTbl IDA
					ON AAP.appTypeId=IDA.r_appId
				GROUP BY CL.r_id
		UPDATE #planMetricsTbl SET r_SubClientWithSnapPlan=InnerTbl.snapSubclientCount
		FROM (
				SELECT CL.r_id AS ID, COUNT (DISTINCT ASP.id) AS snapSubclientCount  FROM #ClientListTbl CL
					INNER JOIN APP_Application AAP  WITH(NOLOCK)
						ON AAP.clientId=CL.r_id
					INNER JOIN #idaListTbl IDA
						ON AAP.appTypeId=IDA.r_appId
					INNER JOIN APP_SubClientProp ASP  WITH(NOLOCK)
ON ASP.componentNameId= AAP.id AND ASP.attrName=N'Associated Plan' AND ASP.cs_attrName=CHECKSUM(N'Associated Plan')AND ASP.modified <> 0
					INNER JOIN App_Plan AP  WITH(NOLOCK)
						ON AP.id=ASP.attrVal AND AP.type=4
					GROUP BY CL.r_id ) InnerTbl
			WHERE InnerTbl.ID=r_clientId
		END
		ELSE
		BEGIN
			INSERT INTO #planMetricsTbl (r_clientId, r_TotalSubclients)
				SELECT CL.r_id, COUNT (DISTINCT AAP.id)  FROM #ClientListTbl CL
						INNER JOIN APP_Application AAP  WITH(NOLOCK)
							ON AAP.clientId=CL.r_id
						GROUP BY CL.r_id
			UPDATE #planMetricsTbl SET r_SubClientWithSnapPlan=InnerTbl.snapSubclientCount
			FROM (
					SELECT CL.r_id AS ID, COUNT (DISTINCT ASP.id) AS snapSubclientCount  FROM #ClientListTbl CL
						INNER JOIN APP_Application AAP  WITH(NOLOCK)
							ON AAP.clientId=CL.r_id
						INNER JOIN APP_SubClientProp ASP  WITH(NOLOCK)
ON ASP.componentNameId= AAP.id AND ASP.attrName=N'Associated Plan' AND ASP.cs_attrName=CHECKSUM('Associated Plan') AND ASP.modified <> 0
						INNER JOIN App_Plan AP
							ON AP.id=ASP.attrVal AND AP.type=4
						GROUP BY CL.r_id ) InnerTbl
				WHERE InnerTbl.ID=r_clientId
		END
END
IF @i_includeClientReadinessInfo = 1
BEGIN
-- Taken from https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/Db/Sp/SummPageGetClientInfo.sp#155
	INSERT INTO #checkReadinessInfoTbl (clientId, CCRId, readinessStatus, CCRTime)
	SELECT CL.r_id, ISNULL(ccrtos.CCRId,0) AS CCRId,
(CASE WHEN ccrtos.CCRId IS NULL THEN (371 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE (CASE WHEN ccrtos.CCRResultFlag <> 0 THEN (897 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE (896 | (CAST(POWER(2, 24) AS BIGINT) * 61)) END) END) as readinessStatus,
	ISNULL(ccr.CCREndTime,0) AS CCRTime
	FROM #ClientListTbl AS CL
	LEFT JOIN (
		SELECT ClientId, CCRId, CCRResultFlag
		FROM CCRToSubClient ccro
		INNER JOIN (
			SELECT ClientId AS cid, ISNULL(MAX(CCRid),0) AS crid
			FROM CCRToSubClient
			GROUP BY ClientId
		) ccri ON ccro.ClientId = ccri.cid AND ccro.CCRid = ccri.crid
	) AS ccrtos ON ccrtos.ClientId = CL.r_id
	LEFT JOIN CCRCommCellReadiness ccr ON ccrtos.CCRId = ccr.CCRId
END
DECLARE @o_clusterInstanceList XML
INSERT INTO #distributedClusterTypeInstanceListXml
EXEC [AppGetDistributedClusterTypeInstanceList] 1, 64
SELECT @o_clusterInstanceList = clusterInstanceList FROM #distributedClusterTypeInstanceListXml
INSERT INTO #instanceInfoTbl
SELECT ref.value('@instanceId', 'int'), ref.value('@instanceName', 'NVARCHAR(512)'), ref.value('@clientId', 'int')
FROM @o_clusterInstanceList.nodes('App_BigDataAppInstanceDetailsResponse/instanceList/instanceEntity') R ( ref )
-- Include IDA Summary only if requested
IF @i_includeIDASummary = 1
BEGIN
	IF @getAllClients = 1
	BEGIN
		-- Update the r_isApplicableForServersPage Property for clients
		-- which only has share point apps in it
		UPDATE CLT
			SET r_isApplicableForServersPage = 0
		FROM #ClientListTbl CLT
		INNER JOIN (SELECT r_clientId, COUNT(r_appId) idaCount
					FROM #idaInfoTbl IDA
					GROUP BY IDA.r_clientId) IDACount on CLT.r_id = IDACount.r_clientId AND IDACount.idaCount = 1
INNER JOIN #idaInfoTbl IDA on IDA.r_clientId = CLT.r_id AND IDA.r_appId = 78
		-- For the other client which has Share point IDA, remove only the share point IDA from IDA table
		DELETE IDA FROM #idaInfoTbl IDA
WHERE r_appId = 78 -- 78 - SharePoint Apps
	END
	IF @i_getArchiverClients = 0
	UPDATE IDA
		SET	IDA.r_defaultBackupSetId = ABP.id,
			IDA.r_defaultSubClientId = AAP.id,
			IDA.r_defaultBackupSetName = ABP.name,
			IDA.r_defaultBackupSetPlanId = AP.id,
			IDA.r_defaultBackupSetPlanName = AP.name,
			IDA.r_defaultBackupSetPlanSubType = AP.subType
	FROM #idaInfoTbl IDA
	INNER JOIN APP_Application AAP  WITH(NOLOCK)
ON AAP.clientId=IDA.r_clientId AND IDA.r_appId=AAP.appTypeId AND AAP.subclientStatus&0x00008<>0
	INNER JOIN APP_BackupSetName ABP  WITH(NOLOCK)
ON ABP.id=AAP.backupSet AND ABP.status&0x00008<>0
	LEFT OUTER JOIN APP_BackupSetProp ABSP  WITH(NOLOCK)
ON ABSP.componentNameId=ABP.id AND ABSP.attrName='Associated Plan' AND ABSP.modified=0
	LEFT OUTER JOIN App_Plan AP  WITH(NOLOCK)
		ON CAST(AP.id AS NVARCHAR(32))=ABSP.attrVal
	ELSE			-- Get default archiver set, plan associated with that.
		UPDATE IDA
			SET	IDA.r_defaultBackupSetId = ABP.id,
				IDA.r_defaultSubClientId = AAP.id,
				IDA.r_defaultBackupSetName = ABP.name,
				IDA.r_defaultBackupSetPlanId = AP.id,
				IDA.r_defaultBackupSetPlanName = AP.name,
				IDA.r_defaultBackupSetPlanSubType = AP.subType
		FROM #idaInfoTbl IDA
		INNER JOIN #ArchiverSetsTbl ArcSets
			ON IDA.r_clientId = ArcSets.r_clientId AND IDA.r_appId = ArcSets.r_appTypeId
		INNER JOIN APP_Application AAP  WITH(NOLOCK)
			ON AAP.id = ArcSets.r_defaultSubclientId
		INNER JOIN APP_BackupSetName ABP WITH(NOLOCK)
			ON ABP.id = AAP.backupset
		LEFT OUTER JOIN APP_BackupSetProp ABSP  WITH(NOLOCK)
ON ABSP.componentNameId=ABP.id AND ABSP.attrName='Associated Plan' AND ABSP.modified=0
		LEFT OUTER JOIN App_Plan AP  WITH(NOLOCK)
			ON CAST(AP.id AS NVARCHAR(32))=ABSP.attrVal
			AND AP.type = 9
AND AP.subtype = 150994951
	INSERT INTO #ExcludeSCs
              SELECT
                     ASCP.componentNameId
              FROM APP_SubClientProp ASCP WITH(NOLOCK)
              WHERE
                     ASCP.attrName IN (N'DDB Backup', N'Index SubClient')
                     AND ASCP.cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
                     AND ASCP.modified = 0
	INSERT INTO #LicenseAppSizeTbl
	SELECT subclientid, AppSizeMB
	FROM (
			SELECT subclientid, AppsizeMB,
			ROW_NUMBER() OVER(PARTITION BY subclientid ORDER BY rankOrder ASC) AS rownum
			FROM(
					SELECT
						LC.subclientid,
						LC.AppsizeMB,
						(CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
				    FROM   #idainfotbl IDA
						INNER JOIN App_Application AAP WITH(NOLOCK)
							ON AAP.clientId = IDA.r_clientId
							AND IDA.r_appid = AAP.apptypeid
						INNER JOIN 	Lic_CurrentUsage LC WITH(NOLOCK)
							ON LC.subclientid = AAP.ID
					WHERE LC.UsageType in (1,2,3,4)
			) TMP
		)LIC
	WHERE LIC.rownum=1
	IF @i_getArchiverClients = 0
	INSERT INTO #JobBkupTime
	SELECT MAX(SP.attrval) AS lastBackupTime,
		   					   SUM(DISTINCT
									ISNULL(
											NULLIF((CAST(ISNULL(ABP.attrval,0) AS BIGINT) + CAST(ISNULL(ASP.attrval,0) AS BIGINT)),0)
											,ISNULL(LIC.AppSizeMB * 1024 * 1024 ,0) -- to bytes
										  )
								  ) applicationSize,
							   clientid,
							   apptypeid
				FROM   #idainfotbl IDA
				INNER JOIN App_Application AAP WITH(NOLOCK) ON
					AAP.clientId = IDA.r_clientId AND IDA.r_appid = AAP.apptypeid
								   INNER JOIN App_subclientProp SP WITH(NOLOCK)
											ON SP.componentNameid= AAP.id
											  AND SP.attrname = N'Last Data Protected Time'
											  AND SP.cs_attrname = CHECKSUM(N'Last Data Protected Time')
											  AND SP.modified = 0
								   LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
										   ON AAP.backupSet=ABP.componentNameId
											  AND ABP.attrName=N'Application Size'
											  AND ABP.modified=0
											  AND ISNUMERIC(ABP.attrVal) = 1
								   LEFT OUTER JOIN APP_SubclientProp ASP WITH(NOLOCK) ON AAP.id = ASP.componentNameId
											  AND ASP.modified = 0
											  AND ASP.cs_attrName = CHECKSUM(N'Application Size')
											  AND ASP.attrName = N'Application Size'
								   LEFT OUTER JOIN #LicenseAppSizeTbl LIC ON AAP.id = LIC.subclientid
								   LEFT OUTER JOIN #ExcludeSCs e ON e.scId = AAP.id
								   LEFT OUTER JOIN App_BackupsetProp ArcBkp WITH (NOLOCK)
											ON ArcBkp.componentNameId = AAP.backupset
											AND ArcBkp.attrName = 'Is archiving enabled'
											AND ArcBkp.attrVal = '1'
											AND ArcBkp.modified = 0
							WHERE e.scId IS NULL
								AND ArcBkp.componentNameId IS NULL			-- Exclude archiver set related details in FS page.
							GROUP  BY clientid,
									  apptypeid
	ELSE			-- Get last backup time and application size for the archiver set.
	INSERT INTO #JobBkupTime
	SELECT MAX(SP.attrval) AS lastBackupTime,
		   					   SUM(DISTINCT
									ISNULL(
											NULLIF((CAST(ISNULL(ABP.attrval,0) AS BIGINT) + CAST(ISNULL(ASP.attrval,0) AS BIGINT)),0)
											,ISNULL(LIC.AppSizeMB * 1024 * 1024 ,0)
										  )
								  ) applicationSize,
							   clientid,
							   apptypeid
				FROM   #idainfotbl IDA
				INNER JOIN App_Application AAP WITH(NOLOCK) ON
					AAP.clientId = IDA.r_clientId AND IDA.r_appid = AAP.apptypeid
								-- Get both archiver set and one-pass subclients.
							   LEFT OUTER JOIN APP_BackupsetProp ArcBkp (NOLOCK)
											ON AAP.backupset = ArcBkp.componentNameID
											AND ArcBkp.attrName = 'Is archiving enabled'
											AND ArcBkp.attrVal = '1'
											AND ArcBkp.modified = 0
							   LEFT OUTER JOIN APP_SubclientProp ArcSC WITH(NOLOCK)
											ON AAP.id = ArcSC.componentNameID
											AND ArcSC.attrName = 'Turbo Mode Enable Stubbing'
											AND ArcSC.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
											AND ArcSC.attrVal = '1'
											AND ArcSC.modified = 0
							   INNER JOIN App_subclientProp SP WITH(NOLOCK)
										ON SP.componentNameid= AAP.id
										  AND SP.attrname = N'Last Data Protected Time'
										  AND SP.cs_attrname = CHECKSUM(N'Last Data Protected Time')
										  AND SP.modified = 0
							   LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
									   ON AAP.backupSet=ABP.componentNameId
										  AND ABP.attrName=N'Application Size'
										  AND ABP.modified=0
										  AND ISNUMERIC(ABP.attrVal) = 1
							   LEFT OUTER JOIN APP_SubclientProp ASP WITH(NOLOCK) ON AAP.id = ASP.componentNameId
										  AND ASP.modified = 0
										  AND ASP.cs_attrName = CHECKSUM(N'Application Size')
										  AND ASP.attrName = N'Application Size'
							   LEFT OUTER JOIN #LicenseAppSizeTbl LIC ON AAP.id = LIC.subclientid
							   LEFT OUTER JOIN #ExcludeSCs e ON e.scId = AAP.id
						WHERE e.scId IS NULL
							AND (ArcBkp.componentNameID IS NOT NULL OR ArcSC.componentNameId IS NOT NULL)
						GROUP  BY clientid,
								  apptypeid
	UPDATE IDA
		SET IDA.r_lastbackuptime = RP.lastbackuptime,
		IDA.r_idaSize = RP.applicationSize
	FROM   #idainfotbl IDA
		   INNER JOIN #JobBkupTime RP
				   ON RP.clientid = IDA.r_clientid
					  AND IDA.r_appid = RP.apptypeid
	UPDATE IDA
		SET IDA.r_lastBackupJobInfo = AP.attrval
	FROM   #idainfotbl IDA
	INNER JOIN APP_IDAName(NOLOCK) A ON A.clientId = IDA.r_clientId AND A.apptypeid = IDA.r_appid
	INNER JOIN APP_IDAProp (NOLOCK) AP ON AP.componentNameId = A.id
										  AND AP.attrname = N'Last Backup Job Info'
										  AND AP.modified = 0
	DECLARE @latestDateRptRpoRtoClient DATETIME = (SELECT MAX(date) FROM RptRpoRtoClient  WITH(NOLOCK))
	-- 4 : Compute SLA for IDA
	IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
	CREATE TABLE #SLA_EntityInfo (
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
	status INT, category INT, slaDays INT)
	insert into #SLA_EntityInfo(clientId, appTypeId)
	SELECT  r_clientId, r_appId
	FROM #idaInfoTbl
	exec RptGetSLAOfEntities 2
	UPDATE IDA
	SET r_slaStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
		r_slaCategory = SLA.Category,
		r_slaDescription = dbo.WR_GetSLACategoryString(@i_localeId,SLA.Category)
	FROM #idaInfoTbl IDA
		INNER JOIN #SLA_EntityInfo SLA
			ON IDA.r_clientId = SLA.clientId and IDA.r_appId = SLA.appTypeId
   -- Following need to be changed to set predicted values to new fields.
	UPDATE IDA
	SET IDA.r_SLAStatus = 5,/*MIGHT_MISS_SLA*/
		IDA.r_SLADescription = '',
		IDA.r_slaMissReasonList = CAST(Prop.stringVal AS XML)
	FROM #idaInfoTbl IDA
	INNER JOIN APP_idaName IDN ON IDN.apptypeId = IDA.r_appId AND IDN.clientId = r_clientId
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = IDN.id AND Prop.componentType =  4 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
END
-- APP_Client table has VM guid in all caps
-- For VM Browse to work fine, it need actual VM guid which is only save in APP_VMPROP
UPDATE CL SET	CL.r_vmGuid = AVP.attrVal
FROM #ClientListTbl CL
INNER JOIN APP_VMProp AVP
	ON AVP.VMclientId=CL.r_id AND AVP.jobId=CL.r_lastBackupJobId AND AVP.attrName='vmGUID'
WHERE CL.r_isBackedUpVMClient=1
-- Since we have unprotected VM too.. let's update GUID in case needed
UPDATE CL
	SET	CL.r_vmGuid = ACP.attrVal
FROM #ClientListTbl CL
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
    ON ACP.componentNameId=CL.r_id AND ACP.attrName='Virtual Machine Instance UUID' AND ACP.modified=0
WHERE (CL.r_vmGuid IS NULL OR CL.r_vmGuid='') AND CL.r_isVirtualServerDiscoveredClient=1
-- Delete all VM which are backed up but don't have required GUID set
IF (@getAllClients = 0)
BEGIN
	DELETE FROM #ClientListTbl WHERE r_isBackedUpVMClient=1 AND (r_vmGuid IS NULL OR r_vmGuid='')
END
ELSE
BEGIN
	UPDATE CT
		SET	CT.r_isApplicableForServersPage = 0
	FROM #ClientListTbl CT WHERE r_isBackedUpVMClient=1 AND (r_vmGuid IS NULL OR r_vmGuid='')
END
-- Update Vendor
UPDATE CL
	SET	[r_vmVendor] = dbo.MapVSVendorId(CAST(IP.attrVal AS INT), -1)
FROM #ClientListTbl CL
		INNER JOIN APP_IDAName IDA WITH(NOLOCK)      ON (IDA.clientId = CL.r_id)
        INNER JOIN APP_Application APP WITH(NOLOCK)   ON (APP.clientId = CL.r_id AND App.appTypeId = IDA.appTypeId)
        INNER JOIN APP_InstanceProp IP WITH(NOLOCK)   ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
INNER JOIN #idaInfoTbl IIT      ON (IIT.r_clientId = CL.r_id AND IIT.r_appId=106)
IF @i_vendorTypes IS NOT NULL AND LEN(@i_vendorTypes) >0
BEGIN
	-- We should not check for NULL as Pure Storage is open for all IDA's
	-- If we are requested for specific vendor type along with other IDA's, then NULL check will lead to removal of all other IDA's client, as they don't have any vendor type.
    -- In summary, if only 106 apptype is provided in filter, then all clients should have vendor type. If not, then those clients are applicable
	-- Since default value for r_vmVendor is NULL, thos clients which don't have vendor type are not considered for delete
	DELETE FROM #ClientListTbl WHERE r_vmVendor NOT IN (SELECT _ID FROM dbo.SplitIDs(@i_vendorTypes))
END
IF (@disableCTClientProperties = 0)
BEGIN
	UPDATE CL SET
		CL.r_physicalClientID= ISNULL (AC.id, CL.r_physicalClientID),
		CL.r_planId = ISNULL(AP.id, CL.r_planId) ,
		CL.r_planName = ISNULL(AP.name, CL.r_planName),
		CL.r_lastActivationUserName = ISNULL(UU.name, CL.r_lastActivationUserName),
		CL.r_lastActivationUserId = ISNULL(UU.id, CL.r_lastActivationUserId)
		FROM #ClientListTbl CL
	INNER JOIN CT_ClientProperties CPT
		ON CPT.clientId = CL.r_id
	LEFT OUTER JOIN APP_Client AC WITH(NOLOCK)
ON Ac.id=CPT.physicalClientIdOnHold AND (AC.status&0x1000=0x1000) AND (AC.specialClientFlags&0x00002 <> 0x00002) AND (AC.specialClientFlags&0x00004 <> 0x00004) AND (CPT.physicalClientIdOnHold IS NOT NULL) AND CL.r_isUserCentricClient=1 AND ((CL.r_physicalClientID IS NULL) OR (CL.r_physicalClientID = 0))  AND CL.r_IsInfrastructureMachine=1
	LEFT OUTER JOIN APP_Plan AP  WITH(NOLOCK)
		ON AP.id = planIdOnHold AND flag=0 AND (CL.r_planId IS NULL OR CL.r_planId = 0) AND (CL.r_deleted <> 0)
	LEFT OUTER JOIN UMOwners UM WITH(NOLOCK)
ON UM.entityId=CL.r_id AND UM.entityType=3  AND UM.isUser=1 AND (((CL.r_planId IS NOT NULL) AND (CL.r_planId <> 0)) OR ((AP.id IS NOT NULL) AND (AP.id <> 0)))  AND (CL.r_status&0x1000=0x1000)
	LEFT OUTER JOIN UMUsers UU
		ON UU.id=UM.userOrGroupId
END
ELSE
BEGIN
	UPDATE CL SET
		CL.r_physicalClientID= ISNULL (AC.id, CL.r_physicalClientID),
		CL.r_planId = ISNULL(AP.id, CL.r_planId) ,
		CL.r_planName = ISNULL(AP.name, CL.r_planName),
		CL.r_lastActivationUserName = ISNULL(UU.name, CL.r_lastActivationUserName),
		CL.r_lastActivationUserId = ISNULL(UU.id, CL.r_lastActivationUserId)
		FROM #ClientListTbl CL
	INNER JOIN #clientPropTbl CPT
		ON CPT.clientId = CL.r_id
	LEFT OUTER JOIN APP_Client AC WITH(NOLOCK)
ON Ac.id=CPT.physicalClientIdOnHold AND (AC.status&0x1000=0x1000) AND (AC.specialClientFlags&0x00002 <> 0x00002) AND (AC.specialClientFlags&0x00004 <> 0x00004) AND (CPT.physicalClientIdOnHold IS NOT NULL) AND CL.r_isUserCentricClient=1 AND ((CL.r_physicalClientID IS NULL) OR (CL.r_physicalClientID = 0))  AND CL.r_IsInfrastructureMachine=1
	LEFT OUTER JOIN APP_Plan AP  WITH(NOLOCK)
		ON AP.id = planIdOnHold AND flag=0 AND (CL.r_planId IS NULL OR CL.r_planId = 0) AND (CL.r_deleted <> 0)
	LEFT OUTER JOIN UMOwners UM WITH(NOLOCK)
ON UM.entityId=CL.r_id AND UM.entityType=3  AND UM.isUser=1 AND (((CL.r_planId IS NOT NULL) AND (CL.r_planId <> 0)) OR ((AP.id IS NOT NULL) AND (AP.id <> 0)))  AND (CL.r_status&0x1000=0x1000)
	LEFT OUTER JOIN UMUsers UU
		ON UU.id=UM.userOrGroupId
END
UPDATE #ClientListTbl SET [r_physClientId] = (select attrVal from app_clientprop where componentNameId = r_id and attrName = 'CS Active Physical Node' )
where r_id = 2 and r_isVirtualClient = 1
UPDATE #ClientListTbl SET [r_physClientId] = (select attrVal from app_clientprop where componentNameId = r_id and attrName = 'Active Physical Node' )
where r_isVirtualClient = 1
UPDATE #ClientListTbl
	SET [r_SPVersionInfo] = (select attrVal from app_clientprop where componentNameId = [r_physClientId] and attrName = 'SP Version Info' ),
		[r_SPVersionAndPatchInfo] = (select attrVal from app_clientprop where componentNameId = [r_physClientId] and attrName = 'SP Version And Patch Info' )
where r_isVirtualClient = 1
UPDATE ct
	SET	[r_status] = f.status,
		[r_bkpEnabled]     	= t.bkpEnabled,
		[r_rstEnabled]     	= t.rstEnabled,
		--[r_OSName] = CASE f.osName WHEN '' THEN f.osName2 ELSE f.osName END,
		--[r_hwName] = dbo.GetClientHardwareName([r_id], [r_OSInfo]),
		[r_updateStatus] =ISNULL(bl.baseline, 8)
FROM #ClientListTbl ct
	INNER JOIN (SELECT
					r_id cid,
					CASE
						WHEN p.simPackageID IS NULL THEN 0
						WHEN p.simPackageID = 1401 THEN 256
						WHEN p.simPackageID = 255 THEN 512
						ELSE 0
					END pkg,
					--CASE WHEN m.ClientId IS NOT NULL THEN (1024 | m.OSType) ELSE 0 END ndmp,
					--osName,
					--S.Name osName2,
					CASE WHEN [r_ccpID] <> 0 THEN ([r_status] + 262144) ELSE [r_status] END status
				FROM #ClientListTbl
					INNER JOIN simOperatingSystem S ON r_OSId = S.id
					--LEFT OUTER JOIN ClientOSNameView CV ON Cv.clientId = r_id
					LEFT OUTER JOIN simInstalledPackages p ON p.simPackageID IN (1401, 255)
						AND (
								([r_isVirtualClient] = 1 AND [r_physClientId] = p.ClientId)
								OR ([r_isVirtualClient] <> 1 AND [r_id] = p.ClientId)
							)
					LEFT OUTER JOIN MMNDMPHostInfo m ON
						m.ClientId = r_id
		) f ON
			f.cid = ct.r_id
	LEFT OUTER JOIN (
						SELECT	clientId,
							[4]		AS bkpEnabled,
							[5]		AS rstEnabled,
							ISNULL([57], 1)	AS CIEnabled
						FROM
							(SELECT
								ja.clientId, ja.optype, ja.action
							FROM #ClientListTbl ct
								INNER JOIN JMJobAction ja ON ja.clientId = ct.r_id AND appType = 0	AND mediaAgentId = 1
							--WHERE	clientId IN (select [r_id] from #ClientListTbl) AND appType = 0 AND mediaAgentId = 1
							) AS clients
							PIVOT	(	MAX(action) FOR optype IN ([4], [5], [57])	) AS P
		) AS t ON
			t.clientId = ct.r_id
	LEFT OUTER JOIN (
		select
			q.r_id id,
			q.r_physClientId physClientId,
			q.r_isVirtualClient isVirtualClient,
			sum(q.Baseline) baseline
		from (
			select
				[r_id],
				[r_physClientId],
				r_isVirtualClient,
				p.Baseline
			from
				simInstalledPackages p, #ClientListTbl ct
			where
				p.simPackageID NOT BETWEEN 6000 AND 7000
				and r_isVirtualClient = 1
				and p.clientId in ([r_id], [r_physClientId])
			union
			select
				[r_id],
				[r_physClientId],
				r_isVirtualClient,
				p.Baseline
			from
				simInstalledPackages p, #ClientListTbl ct
			where
				p.simPackageID NOT BETWEEN 6000 AND 7000
				and r_isVirtualClient <> 1
				and p.clientId = [r_id]
			) q
		group by
			q.r_id,
			q.r_physClientId,
			q.r_isVirtualClient
	) bl ON
		bl.id = ct.r_id
-- Using the last four bits for vendor Type and the other properties is not valid for NAS client. The last 4 bits is not used for any other prop.
--UPDATE	#ClientListTbl SET [r_clientFlag] = ([r_clientFlag] | 1024 | OSType) FROM MMNDMPHostInfo WHERE ClientId = [r_id]
--For the 9.0 and lesser release clients 'Has Diag' will take the precedence than 'Needs Update'.
--For the 10.0 and above release clients 'Needs Update' will take the precedence than 'Has Diag'.
UPDATE	#ClientListTbl SET [r_updateStatus] = dbo.simGetBaseline([r_updateStatus])
UPDATE	#ClientListTbl
SET	[r_updateStatus] = (CASE	WHEN [r_updateStatus] < 0							THEN 7	-- Pending
						WHEN ([r_updateStatus] & 8) > 0 	THEN 4	-- N/A	App::BaselineStatusType_NOT_APPLICABLE
						WHEN ([r_updateStatus] & 2) > 0 						THEN 2	-- Behind	App::BaselineStatusType_NEEDS_UPDATE
						WHEN ([r_updateStatus] & 16) > 0 						THEN 5	-- Diag		App::BaselineStatusType_HAS_DIAGNOSTIC_UPDATES
						WHEN EXISTS (select * from simInstalledPackages where clientId=[r_id] and Baseline=0)	THEN 0	-- Unknown
						WHEN ([r_updateStatus] & 4) > 0 						THEN 3	-- Ahead App::BaselineStatusType_AHEAD_OF_CACHE
						WHEN ([r_updateStatus] & 1) > 0 						THEN 1	-- Uptodate App::BaselineStatusType_UP_TO_DATE
						ELSE 0 END)--App::BaselineStatusType_UNKNOWN
-- Delete the physical machines on the cluster CS
delete from #ClientListTbl where [r_id] IN (select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
IF @i_distributedClusterType > 0
BEGIN
	DELETE finaltbl
	FROM #ClientListTbl finaltbl
	WHERE finaltbl.r_clusterType <> @i_distributedClusterType
END
;WITH nwReadniess(clientId, latestUpdateTime)
AS
(
	SELECT ToClientId, MAX(LastUpdateTime) FROM CCRClientToClient WITH(NOLOCK) WHERE FromClientId = 2 AND serviceType = 0 GROUP BY ToClientId
)
UPDATE clientTbl
SET r_nwReadiness = CASE WHEN flag = 1 THEN 1 ELSE 2 END, r_lastOnlineTime = lastOnlineTime, r_lastOfflineTime = lastOfflineTime, r_nwReadinessUpdatedTime = lastUpdateTime
FROM  nwReadniess R
		INNER JOIN CCRClientToClient CCR WITH(NOLOCK)
			ON R.clientId = CCR.ToClientId AND R.latestUpdateTime = CCR.LastUpdateTime
		INNER JOIN #ClientListTbl clientTbl
			ON clientTbl.[r_id] = CCR.ToClientId AND FromClientId = 2 AND serviceType = 0
UPDATE clientTbl
SET r_nwReadiness = 3
FROM #ClientListTbl clientTbl
	INNER JOIN App_Client C WITH(NOLOCK)
ON clientTbl.[r_id] = C.id AND C.specialClientFlags & CONVERT(INT,0x2) <> 0
UPDATE #ClientListTbl
SET [r_retireClientPhase] = 1
WHERE [r_id] IN (SELECT retireClientId FROM #RetireInProgressClientListTbl)
-- This code is used to populate information like data source Id, data source List, etc. for old archiving point solution clients
-- Logic taken from SimGetClientsWithAnalyticsJobs stored procedure.
IF @i_getArchiverClients = 1
BEGIN
	INSERT INTO #archiveClientInfo (r_clientId, r_DSCLientID)
		SELECT C.clientid,
			   ISNULL(CP.attrVal, '0')
		FROM #Archivalclients C
			LEFT OUTER JOIN APP_ClientProp CP (NOLOCK)
				ON C.clientid = CP.componentNameId
				AND CP.attrName = N'Indexing datasource id'
				AND CP.attrVal <> '0'
				AND CP.modified = 0
	UPDATE #archiveClientInfo
	SET r_DSListSubclient = ISNULL((
										SELECT DISTINCT SP.attrVal + ','
										FROM APP_SubclientProp SP(NOLOCK)
											INNER JOIN APP_Application A(NOLOCK)
												ON SP.componentNameId = A.id
												AND SP.attrName = N'Indexing datasource id'
												AND SP.cs_attrName = CHECKSUM(N'Indexing datasource id')
												AND SP.modified = 0
												AND A.clientId = r_clientId
										FOR XML PATH('')
									), '')
	UPDATE #archiveClientInfo
	SET r_DSListBackupSet = ISNULL((
										SELECT DISTINCT BP.attrVal + ','
										FROM APP_BackupsetProp BP(NOLOCK)
											INNER JOIN APP_Application A(NOLOCK)
												ON BP.componentNameId = A.backupset
												AND BP.attrName = N'Indexing datasource id'
												AND BP.modified = 0
												AND A.clientId = r_clientId
										FOR XML PATH('')
									), '')
	UPDATE #archiveClientInfo
	SET r_DSFullList = r_DSListSubclient + r_DSListBackupset + r_DSClientID
	WHERE
		r_DSListSubclient <> '' OR r_DSListBackupset <> '' OR r_DSClientID <> '0'
END
-- Add file server type - computing and adding the file server type for each client
IF @includeFileServerType = 35 OR @i_getArchiverClients = 1
BEGIN
	UPDATE ct
		SET ct.r_fileServerType =
			CASE
				WHEN (ct.r_OSName = 'Nutanix' OR I.r_appId = 94)
				THEN 4  -- Nutanix
WHEN (ct.r_OSId = 49)
				THEN 8  -- OpenVMS
WHEN (ct.r_OSId = 118)
				THEN 7  -- IBMI
				WHEN (ct.r_clusterType = 3)
				THEN 9  -- GPFS
				WHEN (ct.r_clusterType = 11)
				THEN 10 -- GLUSTERFS
				WHEN (ct.r_clusterType = 13)
				THEN 11 -- LUSTREFS
				WHEN (ct.r_isVirtualClient <> 0 AND @i_getArchiverClients = 0)
				THEN 6  -- ClusterFileSystem
				WHEN (ct.r_OSName = 'Qumulo')
				THEN 5  -- Qumulo
WHEN (ct.r_OSId IN (16, 17, 18, 19, 29, 45, 55))
				THEN 3  -- NASOs
				WHEN (I.r_appId IN (33, 34, 42, 43, 1, 11))
				THEN 1  -- Windows
				WHEN (I.r_appId IN (17, 63, 18, 19, 20, 36, 29, 74, 21, 38))
				THEN 2  -- UNIX
				ELSE 0
			END
		FROM #ClientListTbl as ct INNER JOIN #idaInfoTbl as I ON ct.r_id=I.r_clientId
END
-- End add file Server type
SET @o_xmlResp=CAST((SELECT (SELECT r_isApplicableForServersPage AS '@isServerClient',
			(SELECT 	r_deleted as '@IsDeletedClient', r_isVirtualServerDiscoveredClient AS '@isVirtualServerDiscoveredClient', r_status as '@clientStatus', r_specialStatusFlags as '@specialClientFlags' , r_snapBKPenabled	AS '@EnableSnapBackups', r_arrayIds AS '@arrayIds',
						ISNULL(r_isUserCentricClient,0) as '@isUserCentricClient', r_vmVendor as '@vendorType', r_fileServerType '@fileServerType', r_SLAStatus '@slaStatus', r_SLACategory '@slaCategory', r_SLACategoryDescription '@slaCategoryDescription', r_installJobId '@installJobId', r_ReInstallJobStatus '@reInstallJobStatus',
						r_isExchangeOnePassClient AS '@IsExchangeOnePassClient', r_isVirtualClient AS '@IsVirtualClient',r_isFarmClient AS '@isFarmClient', r_isIndexingV2 AS '@isIndexingV2',  ISNULL(r_clusterType,0) AS '@clusterType', ISNULL(r_IsInfrastructureMachine,0) AS '@isInfrastructure', ISNULL(r_isIndexingV2VSA, 0) AS '@isIndexingV2VSA', r_vmGuid AS '@vmguid',
						r_retireClientPhase AS '@retireClientPhase',
						(CASE r_isMA WHEN 2 THEN 1
							ELSE NULL END) '@isMA',
(CASE (r_status & 0x200000)
WHEN 0x200000 THEN '1'
								ELSE NULL
								END) '@isPseudoDAG',
(CASE (r_status & 0x1000000)
WHEN 0x1000000 THEN '1'
								ELSE NULL
								END) '@isDAGAssociatedClient',
(CASE (r_specialStatusFlags & 0x2)  --SAME_COMMCELL_GALAXY_PACKAGES_ABSENT = 0x2
WHEN 0x2 THEN 'true'
                                ELSE 'false'
                                END) AS '@isCommCellPackageAbsent',
(CASE (r_specialStatusFlags & 0x20) --GRC_MIGRATED_CLIENT = 0x20
WHEN 0x20 THEN 'true'
                                ELSE 'false'
                                END) AS '@grcMigratedClient',
						(SELECT CASE WHEN (r_physicalClientID = 0 OR r_physicalClientID IS NULL) THEN NULL
								ELSE ( SELECT r_physicalClientID AS '@clientId',
												3 '@_type_',
												ISNULL((select AC.name from  APP_Client AC where AC.id=r_physicalClientID),'') as '@clientName'
										FOR XML PATH ('physicalClient'), TYPE)
								END),
						(SELECT CASE WHEN (r_planId = 0 OR r_planId IS NULL) THEN NULL
									ELSE (
											SELECT r_planId AS '@planId',
												158 '@_type_',
												r_planName AS '@planName'
											FOR XML PATH('plan'), TYPE)
								END),
						(SELECT CASE WHEN (r_lastActivationUserName IS NULL) OR (r_lastActivationUserName='') THEN NULL
									ELSE (
											SELECT r_lastActivationUserId AS '@userId',
												13 '@_type_',
												r_lastActivationUserName AS '@userName'
											FOR XML PATH('lastActivationUser'),TYPE)
								END),
			(SELECT CASE WHEN r_MAdeleted IS NULL THEN NULL
				ELSE (SELECT 'Is Unlicensed MA' AS '@name',
                                r_MAdeleted AS '@value'
                         FOR XML PATH('attributes'), TYPE) END),
			(SELECT
			 pkg.id AS '@packageId',
			 pkg.DisplayName AS '@packageName',
			infrastructureClientFlag AS 'infrastructureMachineType'
			FROM App_InfrastructurePkgToFlagMap PkgToMap INNER JOIN
			simPackage pkg ON pkg.id = PkgToMap.infrastructureClientPkgId
			WHERE r_InfrastructureMachineType & PkgToMap.infrastructureClientFlag = PkgToMap.infrastructureClientFlag
			FOR XML PATH('infrastructureMachineDetails'), TYPE),
			(SELECT r_TotalSubclients AS '@totalSubClients', r_SubClientWithSnapPlan AS '@subClientWithSnapPlan' FROM #planMetricsTbl WHERE r_clientId=finaltbl.r_id FOR XML PATH('subClientMetrics'), TYPE),
			CASE WHEN @i_includeClientReadinessInfo = 1 THEN (SELECT readinessStatus AS '@readinessStatus', (SELECT CCRTime AS '@time' FOR XML PATH('ccrTime'),TYPE) FROM #checkReadinessInfoTbl WHERE clientId = finaltbl.r_id FOR XML PATH('clientReadiness'), TYPE) ELSE NULL END,
			(SELECT r_nwReadiness AS '@status',
				(SELECT r_nwReadinessUpdatedTime AS '@time', 55 AS '@_type_' FOR XML PATH('lastUpdatedTime'), TYPE),
				(SELECT r_lastOnlineTime AS '@time', 55 AS '@_type_' FOR XML PATH('lastOnlineTime'), TYPE),
				(SELECT r_lastOfflineTime AS '@time', 55 AS '@_type_' FOR XML PATH('offlineTime'), TYPE)
				FOR XML PATH('networkReadiness'), TYPE),
			CASE WHEN @i_getArchiverClients = 1 THEN
			(
				SELECT  r_DSClientId AS '@DataSourceId',
						r_DSFullList AS '@DataSourceList',
						1 AS '@IsArchiveEnabled'			-- Always 1 since we are getting only archive enabled clients.
				FROM #archiveClientInfo
				WHERE
					r_clientId = finalTbl.r_id
				FOR XML PATH ('archiveClientInfo'), TYPE
			)
			ELSE
				NULL
			END,
			r_slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList,
			(SELECT supportedInstallType
			FROM #clientAndInstallTypeMap
			WHERE cId = finaltbl.r_id
			FOR XML PATH (''), TYPE)
			FOR XML PATH('clientProps'), TYPE),
(SELECT  @commCellName AS '@commCellName', 1 '@_type_' FOR XML PATH('_commcell_'), TYPE),
			(SELECT
			(SELECT r_id AS '@clientId',
					r_name AS '@clientName',
					r_netHostName AS '@hostName',
					r_displayName AS '@displayName',
                    r_guid AS '@clientGUID'
					FOR XML PATH('clientEntity'), TYPE),
			(SELECT [r_SPVersionInfo] as '@version',
					[r_updateStatus] as '@UpdateStatus' ,
					(select r_releaseId as '@ReleaseID' FOR XML PATH('GalaxyRelease'), TYPE)
					FOR XML PATH('versionInfo'), TYPE),
				 (select 	I.r_status '@status',
				 			(SELECT I.r_appId  '@applicationId',
                             I.r_appName        '@appName',
							 4 as "@_type_"
                        FOR XML PATH('idaEntity'),TYPE),
CASE WHEN I.r_appId = 64 THEN
						(
						SELECT (SELECT instanceInfo.instanceId '@instanceId', instanceInfo.instanceName '@instanceName' FOR XML PATH ('instEntity'), TYPE)
						FROM #instanceInfoTbl instanceInfo WHERE finaltbl.r_id = instanceInfo.clientId
						FOR XML PATH ('instanceList'), TYPE
						) ELSE NULL END,
						(select I.r_isSLAMet '@isSLAMet',I.r_SLAStatus '@slaStatus',I.r_SLADescription '@slaCategoryDescription', I.r_idaSize '@size', I.r_lastBackupTime '@lastBackupTime',
							(select
								(select I.r_defaultBackupSetId '@backupsetId', I.r_defaultBackupSetName '@backupsetName' FOR XML PATH('backupSetEntity'),TYPE),
								(select I.r_defaultBackupSetPlanId '@planId', I.r_defaultBackupSetPlanName '@planName', I.r_defaultBackupSetPlanSubType '@planSubtype' FOR XML PATH('planEntity'),TYPE),
								(SELECT
									(SELECT I.r_defaultSubClientId '@subclientId' FOR XML PATH('subClientEntity'),TYPE)
								FOR XML PATH('subClientList'),TYPE)
							FOR XML PATH('defaultBackupset'),TYPE),
							I.r_slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList
							WHERE I.r_defaultBackupSetId > 0
							FOR XML PATH('summary'),TYPE),
						(select 'cAppType' '@name', I.r_cAppType '@value' where i.r_cAppType is not null FOR XML PATH('propertyList'),TYPE),
						(select
							ISNULL(r_isAccessTimeCollected,0) AS '@isAccessTimeCollected',
							(CASE WHEN (I.r_status & 2 > 0) THEN 1 ELSE 0 END) as 'isMarkedDeleted',
							(select I.r_SLAStatus '@slaStatus', I.r_SLACategory '@slaCategory', I.r_SLADescription '@slaCategoryDescription',
									CAST(I.r_lastBackupJobInfo AS XML) FOR XML PATH('commonProperties'),TYPE)
						FOR XML PATH('AgentProperties'),TYPE)
					FROM #idaInfoTbl I
					WHERE  I.r_clientId  = finaltbl.r_id
					ORDER BY I.r_idaSize DESC
                    FOR XML PATH('idaList'),TYPE),
					(SELECT r_OSId as '@osId',
							r_OSType as '@Type',
							r_OSSubType as '@SubType',
							(SELECT r_OSName AS '@OSName',
									r_hwName AS '@ProcessorType'
									FOR XML PATH('OsDisplayInfo'), TYPE)
                    FOR XML PATH('osInfo'), TYPE)
				FOR XML PATH('client'), TYPE),
				(SELECT     distinct ACG.id AS '@clientGroupId',
							ACG.name AS '@clientGroupName'
                FROM        APP_ClientGroup ACG inner join APP_ClientGroupAssoc ACGA on ACG.id = ACGA.clientGroupId
				WHERE		ACGA.clientId = finaltbl.r_id
                FOR XML PATH('clientGroups'), TYPE),
				(SELECT
							CASE WHEN (r_isVirtualClient = 1 ) THEN (
										SELECT r_physClientId AS '@clientId',
												3 '@_type_',
												ISNULL((select AC.name from  APP_Client AC where AC.id=r_physClientId),'') as '@clientName'
										FOR XML PATH ('ActivePhysicalNode'), TYPE)
									ELSE NULL
							END
				)
FROM	#ClientListTbl finaltbl
LEFT JOIN #clientAndInstallTypeMap CIT ON finaltbl.r_id = CIT.cId AND @i_installTypeFilter > 0 -- join only if installTypeFilter is present
WHERE (@i_installTypeFilter = 0 OR CIT.supportedInstallType = @i_installTypeFilter)
   FOR XML PATH('clientProperties'),TYPE)
   FOR XML PATH('App_GetClientPropertiesResponse'),TYPE) AS NVARCHAR(MAX))
DROP TABLE #ClientListTbl
DROP TABLE #clientPropTbl
IF object_id('tempdb.dbo.#DistributedClusterTypeClients') IS NOT NULL DROP TABLE #DistributedClusterTypeClients
IF object_id('tempdb.dbo.#LicenseAppSizeTbl') IS NOT null DROP TABLE #LicenseAppSizeTbl
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
	IF (@o_xmlResp is NULL) OR LEN(@o_xmlResp) = 0
	SET @o_xmlResp = '<App_GetClientPropertiesResponse/>'
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetclientlistAndPropsForAdminConsole')
	delete from GxQscripts where name = 'AppGetclientlistAndPropsForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetclientlistAndPropsForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetclientlistAndPropsForAdminConsole'
GO

insert into GXDBVersions values(2, 'AppGetclientlistAndPropsForAdminConsole',  'v1.1.2.128.8.1', 'AppGetclientlistAndPropsForAdminConsole', 'v1.1.2.128.8.1')
GO

