

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetZookeeperDetails.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetZookeeperDetails
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables
--  |
--  |			create solr servers cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetZookeeperDetails.sp,v $ $Id: AppGetZookeeperDetails.sp,v 1.1.4.6 2019/02/03 03:27:06 ssanur Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetZookeeperDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetZookeeperDetails <<<'
	drop procedure AppGetZookeeperDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetZookeeperDetails')
	delete from GxQscripts where name = 'AppGetZookeeperDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetZookeeperDetails')
	delete from GXDBVersions where aliasname = 'AppGetZookeeperDetails'
GO
print '... Creating Procedure: AppGetZookeeperDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetZookeeperDetails
  @i_userId INT,
  @i_zkCloudClientId INT
AS
  DECLARE @o_clientId INT
  DECLARE @o_zkHostName NVARCHAR(256)
  DECLARE @o_zkListenerPort INT
  DECLARE @o_zkElectionPort INT
  DECLARE @o_zkDataPort INT
  DECLARE @o_zkNodeStatus INT
  DECLARE @o_zkServerID INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @l_zookeeperCloudId INT
SELECT @l_zookeeperCloudId = cloudId FROM DM2Cloud WHERE pseudoClientId = @i_zkCloudClientId AND CloudType = 6
	DECLARE @zkNodes TABLE (
		clientId INT,
		zkHostName NVARCHAR(1024),
		zkListenerPort INT ,
        zkDataPort    INT ,
        zkElectionPort INT ,
        zkServerID    INT,
		zkNodeStatus INT,
		t_metaXML XML)
	INSERT INTO @zkNodes (clientId, zkHostName, t_metaXML, zkNodeStatus)
	SELECT CI.ClientId, ISNULL (net_hostname,N''), CAST(CI.NodeProps AS XML), CI.status FROM
	DM2SearchServerCoreInfo AS CI INNER JOIN
	APP_Client C ON CI.ClientId = C.id
WHERE CI.CloudId = @l_zookeeperCloudId AND CloudType = 6
	UPDATE @zkNodes
	SET zkListenerPort = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkListenerPort"]/@value)[1]', 'VARCHAR(10)'),
		zkDataPort = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkDataPort"]/@value)[1]', 'VARCHAR(10)'),
		zkElectionPort  = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkElectionPort"]/@value)[1]', 'VARCHAR(10)'),
		zkServerId = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkServerId"]/@value)[1]', 'VARCHAR(10)')
	SELECT Z.clientId, Z.zkHostName, Z.zkListenerPort, Z.zkElectionPort, Z.zkDataPort, Z.zkNodeStatus, Z.zkServerID FROM @zkNodes as Z
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetZookeeperDetails')
	delete from GxQscripts where name = 'AppGetZookeeperDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetZookeeperDetails')
	delete from GXDBVersions where aliasname = 'AppGetZookeeperDetails'
GO

insert into GXDBVersions values(2, 'AppGetZookeeperDetails',  '00010001000400060000', 'AppGetZookeeperDetails', '00010001000400060000')
GO

