

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetXmlForPeriodRepGroupFailoverFailback.sp] ---------- 

--  +===============================================================================================================================+
--  |                       Name: AppGetXmlForPeriodRepGroupFailoverFailback()
--  | Description: Fetches replicationInfo xml for all vms belonging to a replication group for failover/failback operation
--  |
--  |       Input: repGroupId
--  |      Output: replicationInfo XML
--  |      Author: sravanan
--  +================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetXmlForPeriodRepGroupFailoverFailback')
BEGIN
	print '>>> Drop Stored Procedure: AppGetXmlForPeriodRepGroupFailoverFailback <<<'
	drop procedure AppGetXmlForPeriodRepGroupFailoverFailback
END
IF EXISTS (select * from GxQscripts where name='AppGetXmlForPeriodRepGroupFailoverFailback')
	delete from GxQscripts where name = 'AppGetXmlForPeriodRepGroupFailoverFailback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXmlForPeriodRepGroupFailoverFailback')
	delete from GXDBVersions where aliasname = 'AppGetXmlForPeriodRepGroupFailoverFailback'
GO
print '... Creating Procedure: AppGetXmlForPeriodRepGroupFailoverFailback'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetXmlForPeriodRepGroupFailoverFailback
  @repGroupId INT,
  @repInfoXML XML OUTPUT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @repInfoXML = (SELECT
						(SELECT	(
								(SELECT VSA.replicationId AS '@val'
									FROM App_replicationGroupAssociation REPASSOC WITH(NOLOCK) JOIN App_VsaReplication VSA WITH(NOLOCK) ON VSA.taskId = REPASSOC.taskId
									WHERE REPASSOC.componentNameId = @repGroupId
									FOR XML PATH('replicationId'), TYPE)
									)
								FOR XML PATH(''), ROOT('TMMsg_DRReplicationInfo')
						))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
	BEGIN
	    ;THROW;   -- rethrow the DEADLOCK so XE captures.
	END
END CATCH
PROC_EXIT:
	IF(@errorCode <> 0)
	BEGIN
		SET @repInfoXML = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetXmlForPeriodRepGroupFailoverFailback')
	delete from GxQscripts where name = 'AppGetXmlForPeriodRepGroupFailoverFailback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXmlForPeriodRepGroupFailoverFailback')
	delete from GXDBVersions where aliasname = 'AppGetXmlForPeriodRepGroupFailoverFailback'
GO

insert into GXDBVersions values(2, 'AppGetXmlForPeriodRepGroupFailoverFailback',  '00000000000000000000', 'AppGetXmlForPeriodRepGroupFailoverFailback', '00000000000000000000')
GO

