

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetXmlForContRepGroupFailoverFailback.sp] ---------- 

--  +===============================================================================================================================+
--  |                       Name: AppGetXmlForContRepGroupFailoverFailback()
--  | Description: Fetches block operation xml for all pairs belonging to a replication group based on failover/failback operation
--  |
--  |       Input: repGroupId, operationType, rpTimeOfDay
--  |      Output: BlockLevelOperation XML
--  |      Author: sravanan
--  +================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetXmlForContRepGroupFailoverFailback')
BEGIN
	print '>>> Drop Stored Procedure: AppGetXmlForContRepGroupFailoverFailback <<<'
	drop procedure AppGetXmlForContRepGroupFailoverFailback
END
IF EXISTS (select * from GxQscripts where name='AppGetXmlForContRepGroupFailoverFailback')
	delete from GxQscripts where name = 'AppGetXmlForContRepGroupFailoverFailback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXmlForContRepGroupFailoverFailback')
	delete from GXDBVersions where aliasname = 'AppGetXmlForContRepGroupFailoverFailback'
GO
print '... Creating Procedure: AppGetXmlForContRepGroupFailoverFailback'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetXmlForContRepGroupFailoverFailback
  @repGroupId INT,
  @operationType INT,
  @rpTimeOfDay INT,
  @blockXML XML OUTPUT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @emergencyFailover INT = 0
	-- Currently assuming latest recovery point for all pairs inside replication group. Need to make changes in replication code from SP23 onwards to support non zero rpTimeOfDay.
	IF(@rpTimeOfDay = 0)
	BEGIN
		SET @rpTimeOfDay = -1
	END
IF(@operationType = 1)
	BEGIN
		SET @emergencyFailover = 0
	END
ELSE IF(@operationType = 2)
	BEGIN
		SET @emergencyFailover = 1
	END
IF (@operationType = 1 OR @operationType = 2)
	BEGIN
		-- opType (2) means VSA_FAIL_OVER in BlockReplication.x
		SET @blockXML = (SELECT
							(SELECT	(
									(SELECT 2 AS '@opType',
									BLR.subClientId AS '@appId',
									BLR.tailClientId AS '@dstProxyClientId',
									@emergencyFailover AS '@emergencyFailover',
									(SELECT BLR.dstName AS '@vmName', @rpTimeOfDay as '@rpTimeOfDay', 1 AS '@bootFromLatestPointInTime', BLR.dstGuid AS '@vmUUId', BLR.id AS '@blrPairId' FOR XML PATH('vmBootInfo'), TYPE)
										FROM App_replicationGroupAssociation REPASSOC WITH(NOLOCK) JOIN BlrPair BLR WITH(NOLOCK) ON BLR.id = REPASSOC.blrpairId
											WHERE REPASSOC.componentNameId = @repGroupId
									FOR XML PATH('operations'), TYPE)
									)
									FOR XML PATH(''), ROOT('TMMsg_BlockLevelOperation')
							))
	END
ELSE IF(@operationType = 3)
	BEGIN
		-- opType (11) means VSA_FAIL_BACK in BlockReplication.x
		SET @blockXML = (SELECT
							(SELECT	(
									(SELECT 11 AS '@opType',
									BLR.subClientId AS '@appId',
									BLR.tailClientId AS '@dstProxyClientId',
									(SELECT BLR.id AS '@blrPairId' FOR XML PATH('vmBootInfo'), TYPE)
										FROM App_replicationGroupAssociation REPASSOC WITH(NOLOCK) JOIN BlrPair BLR WITH(NOLOCK) ON BLR.id = REPASSOC.blrpairId
											WHERE REPASSOC.componentNameId = @repGroupId
									FOR XML PATH('operations'), TYPE)
									)
									FOR XML PATH(''), ROOT('TMMsg_BlockLevelOperation')
							))
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
	BEGIN
	    ;THROW;   -- rethrow the DEADLOCK so XE captures.
	END
END CATCH
PROC_EXIT:
	IF(@errorCode <> 0)
	BEGIN
		SET @blockXML = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetXmlForContRepGroupFailoverFailback')
	delete from GxQscripts where name = 'AppGetXmlForContRepGroupFailoverFailback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXmlForContRepGroupFailoverFailback')
	delete from GXDBVersions where aliasname = 'AppGetXmlForContRepGroupFailoverFailback'
GO

insert into GXDBVersions values(2, 'AppGetXmlForContRepGroupFailoverFailback',  '00000000000000000000', 'AppGetXmlForContRepGroupFailoverFailback', '00000000000000000000')
GO

