

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetXMLRequestInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetXMLRequestInfo.sp,v $ $Id: AppGetXMLRequestInfo.sp,v 1.1.2.5 2018/09/02 03:34:44 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetXMLRequestInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetXMLRequestInfo')
	drop procedure AppGetXMLRequestInfo
IF EXISTS (select * from GxQscripts where name='AppGetXMLRequestInfo')
	delete from GxQscripts where name = 'AppGetXMLRequestInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXMLRequestInfo')
	delete from GXDBVersions where aliasname = 'AppGetXMLRequestInfo'
GO
print '... Creating Procedure: AppGetXMLRequestInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetXMLRequestInfo
  @i_firstTime INTEGER,
  @i_requestId INTEGER,
  @i_requestGUID VARCHAR(40),
  @i_perfromCleanUp INTEGER
AS
  DECLARE @requestId INTEGER
  DECLARE @userId INTEGER
  DECLARE @sequenceNumber INTEGER
  DECLARE @localeId INTEGER
  DECLARE @status INTEGER
  DECLARE @createTime INTEGER
  DECLARE @lastUpdateTime INTEGER
  DECLARE @retryCount INTEGER
  DECLARE @waitTimeOut INTEGER
  DECLARE @GUID VARCHAR(40)
  DECLARE @workQueueId BIGINT
  DECLARE @requestXML XML
  DECLARE @responseXML XML 
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
IF @i_perfromCleanUp = 1
BEGIN
	BEGIN TRY
		BEGIN TRANSACTION
			DECLARE @inputXML XML
			DECLARE @isIDSet INT = 0
			SET @inputXML = (SELECT workQueueId as '@nWorkQueueID',
									8 as '@nFlag'
								FROM APP_XMLRequestInfo
									WHERE (status IN (8,16,32,64) AND lastUpdateTime < (@now - (1 * 24 * 60 * 60)))
										OR (lastUpdateTime <> 0 AND lastUpdateTime < (@now - (2 * 24 * 60 *60)))
										OR (createTime < (@now - (4 * 24 * 60 *60)))
								FOR XML PATH('lRequestList'),ROOT('App_WorkQueueRequestStatusList'))
			SET @isIDSet = @inputXML.exist('/App_WorkQueueRequestStatusList')
			IF @isIDSet > 0
			BEGIN
				exec AppWorkQueueUpdateRequest @inputXML
			END
			DELETE FROM APP_XMLRequestInfo
			WHERE (status IN (8,16,32,64) AND lastUpdateTime < (@now - (1 * 24 * 60 * 60)))
										OR (lastUpdateTime <> 0 AND lastUpdateTime < (@now - (2 * 24 * 60 *60)))
										OR (createTime < (@now - (4 * 24 * 60 *60)))
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION
	END CATCH
END
IF @i_firstTime = 1
BEGIN
	SELECT requestId,userId,sequenceNumber,localeId,status,createTime,lastUpdateTime,retryCount,waitTimeOut,GUID,workQueueId,requestXML,responseXML
		FROM APP_XMLRequestInfo WHERE status NOT IN (4,8,16,32,64) AND waitTimeOut <> -1
END
ELSE
BEGIN
	SELECT requestId,userId,sequenceNumber,localeId,status,createTime,lastUpdateTime,retryCount,waitTimeOut,GUID,workQueueId,requestXML,responseXML
		FROM APP_XMLRequestInfo WHERE requestId = @i_requestId AND GUID = @i_requestGUID
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetXMLRequestInfo')
	delete from GxQscripts where name = 'AppGetXMLRequestInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetXMLRequestInfo')
	delete from GXDBVersions where aliasname = 'AppGetXMLRequestInfo'
GO

insert into GXDBVersions values(2, 'AppGetXMLRequestInfo',  '00010001000200050000', 'AppGetXMLRequestInfo', '00010001000200050000')
GO

