

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetWebservers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetWebservers.sp,v $ $Id: AppGetWebservers.sp,v 1.1.4.9 2020/05/19 18:45:26 pankajkumar Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetWebservers()
--  |
--  | Description:  SP for retrieving all webservers
--  |
--  |       Input:  GetWebserversRequest XML containing client id which is optional--  |
--  |      Output:  GetEdgeAuditNotificationFlagsResponse containing webserver url, client, errorString to determine status of the operation--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	To get list of webservers
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetWebservers')
BEGIN
	print '>>> Drop Stored Procedure: AppGetWebservers <<<'
	drop procedure AppGetWebservers
END
IF EXISTS (select * from GxQscripts where name='AppGetWebservers')
	delete from GxQscripts where name = 'AppGetWebservers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebservers')
	delete from GXDBVersions where aliasname = 'AppGetWebservers'
GO
print '... Creating Procedure: AppGetWebservers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetWebservers
  @i_xml XML	
AS
DECLARE @clientId INT =0
IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
	DROP TABLE #webserverTbl
CREATE TABLE #webserverTbl (
	clientId int,
	net_hostname nvarchar(510),
	alias nvarchar(2048),
	port nvarchar(2048),
	indexGatewayAlias nvarchar(2048),
	indexGatewayport nvarchar(2048),
	isIndexServer int,
	isWebconsoleAssociated int
)
CREATE CLUSTERED INDEX webserverTbl_clientId_idx ON #webserverTbl (clientId)
IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
	DROP TABLE #clientPropTbl
CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
CREATE CLUSTERED INDEX clientPropTbl_Id_idx ON #clientPropTbl (id)
DECLARE @webconsolePackage varchar(50)
DECLARE @webserverClientId varchar(50)
DECLARE @webserverInfoXml XML
DECLARE @error XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
SET @webconsolePackage = 'PackageStateForId ' + CONVERT(varchar,  726)
	SET @webserverClientId = 'WebServerClientId'
	SET  @clientId   = ISNULL((SELECT ref.value('@clientId','int') FROM @i_xml.nodes('Api_GetWebserversRequest/client') R ( ref )), 0)
	INSERT INTO #webserverTbl(clientId , net_hostname ,alias , port,indexGatewayAlias, indexGatewayport,isIndexServer, isWebconsoleAssociated)
	-- GET All webservers
	SELECT componentNameId,
	net_hostname,
	ISNULL(MAX(CASE WHEN attrName='DM2WebService Search Web Alias' THEN attrVal END),0 ) AS alias,
	ISNULL(MAX(CASE WHEN attrName='DM2WebService Web Site Port' THEN attrVal END),0) AS port,
	ISNULL(MAX(CASE WHEN attrName='IndexStore Search Web Alias' THEN attrVal END),0 ) AS indexGatewayAlias,
	ISNULL(MAX(CASE WHEN attrName='IndexStore Web Site Port' THEN attrVal END),0) AS indexGatewayport,
	0,
	0
	FROM APP_ClientProp AS appClientProp WITH(NOLOCK)
	INNER JOIN APP_Client AS appClient WITH(NOLOCK)
	ON appClient.id = appClientProp.componentNameId
WHERE appClientProp.componentNameId in (SELECT clientId FROM SimInstalledpackages WITH(NOLOCK) WHERE simpackageid IN (252, 1174))
	GROUP BY componentNameId, name, net_hostname
	INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
	--Get client props
	SELECT
	(CASE attrName
		WHEN @webserverClientId THEN 1
		WHEN @webconsolePackage THEN 2
	END) as id,
	componentNameId, attrName, attrval
	FROM APP_ClientProp	WITH(NOLOCK) WHERE attrName in (@webserverClientId, @webconsolePackage)
	-- update isWebconsoleAssociated if there are is any webconsole pointing to the webserver
	UPDATE #webserverTbl SET isWebconsoleAssociated = 1
	WHERE clientId in
	(
		-- returns webserver associated to any webconsole if two properties match
		-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
		-- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
		SELECT wsTbl.clientId
		FROM #clientPropTbl cpTbl1
		INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = wsTbl.clientId
		INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
		WHERE cpTbl1.id = 1 --@webserverClientId
		AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = 1
	)
	-- update isIndexServer if the webserver is also a index server
	UPDATE #webserverTbl SET isIndexServer = 1
	WHERE clientId in (
						SELECT DM.ClientId
						FROM App_EdgeDriveAssociation EA (NOLOCK)
						INNER JOIN DM2Cloud CL (NOLOCK) ON EA.entityId = CL.pseudoClientId
						INNER JOIN DM2SearchServerCoreInfo DM (NOLOCK) ON CL.CloudId = DM.CloudId
						WHERE entityType =3 /**CLIENTENTITY**/ AND  (@clientId =0 OR EA.clientId = @clientId)
					  )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @error = ( SELECT
                            ERROR_NUMBER() '@errorCode',
                            'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
                           FOR XML PATH('error'), TYPE
                         )
END  CATCH
	SET @webserverInfoXml =	 (	SELECT
									'http://' + net_hostname + ':' +
										(CASE WHEN port<>'0' THEN port ELSE indexGatewayport END)
									+ '/' +
										(CASE WHEN alias<>'' THEN alias ELSE indexGatewayAlias END)
									+ '/' as '@webserverUrl',
									isIndexServer as '@isIndexServer',
									isWebconsoleAssociated as '@isWebconsoleAssociated',
									(SELECT clientId '@clientId' FOR XML PATH('webserverClient'), TYPE)
									FROM #webserverTbl
									WHERE (alias<>'' OR indexGatewayAlias<>'') and ((port<>'' AND port<>'0') OR (indexGatewayport<>'' AND indexGatewayport<>'0'))
									ORDER BY isIndexServer desc, isWebconsoleAssociated desc
								FOR xml PATH('webserverList'), TYPE
							)
IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
	DROP TABLE #webserverTbl
IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
	DROP TABLE #clientPropTbl
	select @webserverInfoXml, @error FOR XML PATH('Api_GetWebserversResponse'),TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetWebservers')
	delete from GxQscripts where name = 'AppGetWebservers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebservers')
	delete from GXDBVersions where aliasname = 'AppGetWebservers'
GO

insert into GXDBVersions values(2, 'AppGetWebservers',  '00010001000400090000', 'AppGetWebservers', '00010001000400090000')
GO

