

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetWebconsoleList.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------
--  SP Name :   AppGetWebconsoleList
--  Purpose :   for fetching the list of all Web application(webconsole/vWeb) URLs according to
--              given criteria
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetWebconsoleList <<<'

IF EXISTS (select * from sysobjects where name='AppGetWebconsoleList')
	drop procedure AppGetWebconsoleList
IF EXISTS (select * from GxQscripts where name='AppGetWebconsoleList')
	delete from GxQscripts where name = 'AppGetWebconsoleList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebconsoleList')
	delete from GXDBVersions where aliasname = 'AppGetWebconsoleList'
GO
print '... Creating Procedure: AppGetWebconsoleList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetWebconsoleList
  @xmlText XML
AS
declare @userId             integer
declare @localeId           integer
declare @isAdminUser        integer
declare @errorCode          integer
declare @dm2WebServerId     integer
declare @errorMessage       nvarchar(MAX)
declare @errorXml           xml
declare @webAppURLList      xml
--Constants
declare @ADMIN_CONSOLE_KEYWORD  nvarchar(MAX) = 'AdminConsoleURL'
declare @VWEB_CONSOLE_KEYWORD nvarchar(MAX) = 'vWebConsoleURL'
declare @WEB_CONSOLE_APP_TYPE   integer = 1
declare @ADMIN_CONSOLE_APP_TYPE integer = 2
declare @webAppTypeListTbl table
(
appType integer
)
--For cases where all webconsole URls are required,
--1. Get all Dm2 Web server Ids
--2. Now get all web console(s) pointing to this Dm2 web server
declare @dm2WebServerList table
(
    o_componentNameId   integer,
    o_portNumber        integer,
    o_apachePortNumber  integer,
    o_clientName        char(1024),
    o_clientHostName    char(1024)
)
declare @webconsoleforDm2ServerList table
(
    o_webconsoleId      integer
)
declare @AdminConsoleEnabledClient table
(
    o_AdminConsoleClientId      integer
)
SET @userId = isnull((select  ref.value('@userId', 'int') AS col1
                         from    @xmlText.nodes('App_GetWebconsoleUrlListRequest/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = isnull((select  ref.value('@localeId', 'int') AS col1
                         from    @xmlText.nodes('App_GetWebconsoleUrlListRequest/processinginstructioninfo/locale') R ( ref )),0)
set transaction isolation level read uncommitted
begin try
    set @errorCode      = 0
    set @errorMessage   = ''
    --First and foremost, check for the requesting user detail
    IF (not exists(select 1 from UMUsers where id = @userId))
    begin
        set @errorCode  = 1
set @errorMessage = ( select message from EvLocaleMsgs where messageId = (475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  and [localeId] = @localeId )
        set @errorMessage = replace( @errorMessage, '^1%s', @userId)
        goto SEND_RESPONSE
    end
    --Only users belonging to the "MASTER" user group should be able to view app details for now, may be changed in the future
    --Although this might seem to be an extra check, especially after checking fo existing user, in future , if we allow other kind of users to access this list,
    --we might need to keep checks for 1. existing user 2. allowed user ,as separate.
    --Only those clients which are visible to caller , their webconsoles will be returned
	/*
EXEC sec_checkPermissionOnEntity @userId ,1, @isAdminUser OUT,1,2
    if(@isAdminUser = 0)
    begin
        set @errorCode  = 1
set @errorMessage = ( select message from EvLocaleMsgs where messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and [localeId] = @localeId )
        goto SEND_RESPONSE
    end
	*/
    insert into @webAppTypeListTbl
    select isnull(ref.value('@val', 'int') , 0) AS Agent1
    from    @xmlText.nodes('App_GetWebconsoleUrlListRequest/webAppTypes') R ( ref )
    declare @WebAppUrlInfoTbl table
    (
     appType    integer,
     appURL     nvarchar(MAX)
    )
	declare @reqClient int = ( select isnull(ref.value('@id', 'int') , 0)
    from    @xmlText.nodes('App_GetWebconsoleUrlListRequest/clients') R ( ref ))
    --Check for the WebAppType flags sent in the request and for the response based on that
    if exists(select * from @webAppTypeListTbl where appType = @WEB_CONSOLE_APP_TYPE) --Web Console
    begin
        if ( @reqClient != Null or @reqClient <> '' )
			begin
						 Insert into @dm2WebServerList(o_componentNameId,o_portNumber,o_apachePortNumber,o_clientName,o_clientHostName)
						 select attrVal,0,0,'','' from app_clientprop where attrname = 'WebServerClientId' and componentNameId = @reqClient and modified = 0
			end
        else
		begin
                     Insert into @dm2WebServerList(o_componentNameId,o_portNumber,o_apachePortNumber,o_clientName,o_clientHostName)
                     exec SimGetAvaliableDM2WebServers 1
		end
        if exists (select 1 from @dm2WebServerList where o_componentNameId <> 0)
        begin
            --Now, loop over the list of Dm2 webserver clients and fetch all web console clients pointing to them
            declare @dm2TableCur cursor
            --if cursor is already open , close it
            if ( CURSOR_STATUS('variable', '@dm2TableCur') > 0) /* cursor is open */
            close @dm2TableCur
            set @dm2TableCur = cursor
            for select distinct o_componentNameId
             from @dm2WebServerList
                open @dm2TableCur
                    fetch next from @dm2TableCur into @dm2WebServerId
                    while @@FETCH_STATUS = 0
                    begin
                        --Fetch all configured web console clients
                        insert into @webconsoleforDm2ServerList(o_webconsoleId)
                        exec  simGetAssociatedWebConsoles  @dm2WebServerId , 1
                        fetch next from @dm2TableCur into @dm2WebServerId
                    end
				--Checking on which clients the caller has rights
				IF OBJECT_ID('tempdb.dbo.#visibleClient') IS NOT NULL DROP TABLE #visibleClient
			    CREATE TABLE #visibleClient
				(
					t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
				)
exec sec_getIdaObjectsForUser @userId,3,0,0,#visibleClient
				delete W from @webconsoleforDm2ServerList as W Left outer join #visibleClient as V on W.o_webconsoleId = V.t_clientId where V.t_clientId is null
                insert into @WebAppUrlInfoTbl
                select distinct 1,                  --app type: Webconsole
                                attrVal as '@val'
                from    app_clientprop ACP join @webconsoleforDm2ServerList WSL on ACP.componentNameId = WSL.o_webconsoleId
                where   ACP.attrName = 'WebURL'
            if ( CURSOR_STATUS('variable', '@dm2TableCur') > 0) /* cursor is open */
                close  @dm2TableCur
            if ( CURSOR_STATUS('variable', '@dm2TableCur') = -1) /* cursor is closed */
                deallocate @dm2TableCur
        end
    end
    if exists(select 1 from @webAppTypeListTbl where appType = @ADMIN_CONSOLE_APP_TYPE) --Admin Console
    begin
        --First insert all Admin Console client Ids which have vWeb package installed
        insert into @AdminConsoleEnabledClient(o_AdminConsoleClientId)
        select  distinct ClientId
        from    simInstalledPackages SIP
        where   SIP.simPackageID = 728
        --Filter out those Admin Console client IDs which do not have vWeb configured or Enabled
        delete from @AdminConsoleEnabledClient
        where not exists (select 1 from App_ClientProp ACP where componentNameId = o_AdminConsoleClientId and ACP.attrName = 'PackageStateForId 728' and ACP.attrVal = '1' )
		--Checking on which clients the caller has rights
		IF OBJECT_ID('tempdb.dbo.#visibleClients') IS NOT NULL DROP TABLE #visibleClients
		CREATE TABLE #visibleClients
		(
			t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
		)
exec sec_getIdaObjectsForUser @userId,3,0,0,#visibleClients
		delete W from @AdminConsoleEnabledClient as W Left outer join #visibleClients as V on W.o_AdminConsoleClientId = V.t_clientId where V.t_clientId is null
        --Now take all Admin Console URLs for clients from above List
        insert into @WebAppUrlInfoTbl
        select  distinct 2,                 --Admin Console app type
                isnull(ACP.attrVal , '') as '@val'
        from    @AdminConsoleEnabledClient VEC inner join App_ClientProp ACP on VEC.o_AdminConsoleClientId = ACP.componentNameId
        where   ACP.attrName like @ADMIN_CONSOLE_KEYWORD or ACP.attrName like @VWEB_CONSOLE_KEYWORD
        --Finally , remove all clients which have no vWeb URL or have some EMPTY URL
        delete from @WebAppUrlInfoTbl where appURL like '' OR appURL IS NUll
    end
    --Now that we have the list, put it into the webconsole list XML
    set @webAppURLList = (  select  appURL  as '@url',
                                    (select appType as '@val'
                                    for xml path('webAppType'),type)
                                from    @WebAppUrlInfoTbl
                                for xml path('webAppUrlInfo')
                             )
end try
begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    if ( CURSOR_STATUS('variable', '@dm2TableCur') > 0) /* cursor is open */
        close  @dm2TableCur
    IF ( CURSOR_STATUS('variable', '@dm2TableCur') = -1) /* cursor is closed */
        deallocate @dm2TableCur
    SET @errorCode = ERROR_NUMBER()
    SET @errorMessage = 'DB Error during SP Execution. Error Message' + ERROR_MESSAGE()
end catch
SEND_RESPONSE:
SET @errorXml = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@errorXml,'') ,
                         ISNULL(@webAppURLList ,'')
                 FOR xml path('') , ROOT('App_GetWebconsoleUrlListResponse')
               )
select @xmlText 'out_xml'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetWebconsoleList')
	delete from GxQscripts where name = 'AppGetWebconsoleList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebconsoleList')
	delete from GXDBVersions where aliasname = 'AppGetWebconsoleList'
GO

insert into GXDBVersions values(2, 'AppGetWebconsoleList',  '00000000000000000000', 'AppGetWebconsoleList', '00000000000000000000')
GO

