

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetWebconsoleDynamicAppSupport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetWebconsoleDynamicAppSupport.sp,v $ $Id: AppGetWebconsoleDynamicAppSupport.sp,v 1.1.2.2 2020/09/30 12:16:47 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetWebconsoleDynamicAppSupport()
--  |
--  | Description:  SP for getting all webconsoles and dynamic app support property
--  |
--  |       Input:  GetWebconsoleDynamicAppSupportList xml
--  |
--  |      Output:  GetWebconsoleDynamicAppSupport xml
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	SP for getting all webconsoles and dynamic app support property
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetWebconsoleDynamicAppSupport')
BEGIN
	print '>>> Drop Stored Procedure: AppGetWebconsoleDynamicAppSupport <<<'
	drop procedure AppGetWebconsoleDynamicAppSupport
END
IF EXISTS (select * from GxQscripts where name='AppGetWebconsoleDynamicAppSupport')
	delete from GxQscripts where name = 'AppGetWebconsoleDynamicAppSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebconsoleDynamicAppSupport')
	delete from GXDBVersions where aliasname = 'AppGetWebconsoleDynamicAppSupport'
GO
print '... Creating Procedure: AppGetWebconsoleDynamicAppSupport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetWebconsoleDynamicAppSupport
  @i_xml XML	
AS
SET NOCOUNT ON
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(510)
BEGIN TRY
	DECLARE @webconsoledynamicApp XML
	DECLARE @webconsolePackageWindows varchar(50)
	DECLARE @webconsolePackageUnix varchar(50)
	DECLARE @webserverClientIdParam varchar(50)
	-- webconsoles
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, dynamicAppEnabled INT DEFAULT(0))
	-- webconsole package and webserverclientId attribute
    	IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
     	   DROP TABLE #clientPropTbl
    	CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
	    -- available webservers
    	IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
    	    DROP TABLE #webserverTbl
   	 CREATE TABLE #webserverTbl (clientId int PRIMARY KEY)
	 SET @webconsolePackageWindows = 'PackageStateForId 726'
	 SET @webconsolePackageUnix = 'PackageStateForId 1135'
     SET @webserverClientIdParam = 'WebServerClientId'
	-- Get webservers
    INSERT INTO #webserverTbl(clientId)
    SELECT cl.id
    FROM APP_Client AS CL WITH(NOLOCK)
        INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND sim.simPackageID IN (252,1174)
    --Get client props
    INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
    SELECT
    (CASE
        WHEN attrName=@webserverClientIdParam THEN 1
        WHEN attrName=@webconsolePackageWindows OR attrName = @webconsolePackageUnix THEN 2
    END) as id,
    componentNameId, attrName, attrval
    FROM APP_ClientProp WITH(NOLOCK) WHERE attrName in (@webserverClientIdParam, @webconsolePackageWindows,@webconsolePackageUnix)
	AND modified = 0
	-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
    -- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
    INSERT INTO #webConsoleTbl(clientId)
    SELECT distinct cpTbl2.componentNameId
        FROM #clientPropTbl cpTbl1
        INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = CAST(wsTbl.clientId AS NVARCHAR(12))
        INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
        WHERE cpTbl1.id = 1 --@webserverClientId
        AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = N'1'
		UPDATE WC SET dynamicAppEnabled = 1
		FROM #webConsoleTbl WC
		INNER JOIN APP_ClientProp CP
		ON WC.clientId = CP.componentNameId AND
		CP.attrName = N'Side by Side Loading of Multiple SP Instance Enabled' AND CP.attrVal = N'1'  AND CP.modified = 0
		WHERE WC.clientId iS NOT NULL
	-- get default webconsole
	DECLARE @webConsoleURL NVARCHAR(MAX) = ''
	DECLARE @defaultWebconsoleHostname nvarchar(510);
	DECLARE @defaultWebconsoleClientId INT
	SELECT @webConsoleURL = value FROM GXGlobalParam(nolock) WHERE name = N'WebConsoleURL' AND modified = 0
	IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
	BEGIN
		SET @defaultWebconsoleHostname = DBO.GetHostnameFromUrl(@webConsoleURL)
		SELECT @defaultWebconsoleClientId = id
		FROM
		APP_Client CL (NOLOCK)
		INNER JOIN #webConsoleTbl WC ON CL.ID = WC.clientId
		WHERE (CL.net_hostname = @defaultWebconsoleHostname OR CL.name = @defaultWebconsoleHostname)
	END
	--
--
		SET @webconsoledynamicApp =
			(SELECT
				WC.dynamicAppEnabled '@isSupported',
				IIF(@defaultWebconsoleClientId=WC.clientId,1,0) '@isPrimary',
				(SELECT CL.id '@clientId',CL.name '@clientName', CL.displayName '@displayName',cl.net_hostname '@hostName',cl.GUID '@clientGUID' FOR XML PATH('webconsoleClient'),TYPE)
		FROM #webConsoleTbl WC
		INNER JOIN App_Client(nolock) CL ON CL.ID = WC.clientId
		FOR XML PATH('webconsoles'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
SELECT
	@webconsoledynamicApp,
	(SELECT  @errorCode as '@errorCode',
        @errorMsg as  '@errorMessage'
	FOR  XML PATH('error'),TYPE)
	FOR  XML PATH('Api_WebconsoleDynamicAppSupportList'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetWebconsoleDynamicAppSupport')
	delete from GxQscripts where name = 'AppGetWebconsoleDynamicAppSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetWebconsoleDynamicAppSupport')
	delete from GXDBVersions where aliasname = 'AppGetWebconsoleDynamicAppSupport'
GO

insert into GXDBVersions values(2, 'AppGetWebconsoleDynamicAppSupport',  '00010001000200020000', 'AppGetWebconsoleDynamicAppSupport', '00010001000200020000')
GO

