

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVirtualAppJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVirtualAppJobDetails.sp,v $ $Id: AppGetVirtualAppJobDetails.sp,v 1.1.2.12 2019/04/09 23:31:05 pktr Exp $";
-- +-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVirtualAppJobDetails"
--	|	This Procedure is used to get the Virtual app job details
-- +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVirtualAppJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVirtualAppJobDetails <<<'
	drop procedure AppGetVirtualAppJobDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetVirtualAppJobDetails')
	delete from GxQscripts where name = 'AppGetVirtualAppJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVirtualAppJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetVirtualAppJobDetails'
GO
print '... Creating Procedure: AppGetVirtualAppJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVirtualAppJobDetails
-- Input arguments
  @i_uid INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @i_client			INT
DECLARE @i_replicationId	INT
DECLARE @i_vAppId			INT
DECLARE @i_jobId			INT
DECLARE @errorString			NVARCHAR(MAX)
DECLARE @errorCode			INT = 0
DECLARE @flags				INT = 0
SELECT @i_client = isnull(ref.value('client[1]/@clientId', 'int'),0),
	   @i_replicationId = isnull(ref.value('@replicationId', 'int'),0),
	   @i_vAppId = isnull(ref.value('entity[1]/@vAppId', 'int'),0),
	   @i_jobId  = isnull(ref.value('@jobId', 'int'),-1)
FROM @i_xmlText.nodes ('Api_VirtualAppJobDetailsReq') R(ref)
DECLARE @defaultAppid int
select @defaultAppId = id from App_virtualApp where name ='_NO_NAME_'
IF ( @i_jobId = -1)
BEGIN
	SELECT @i_jobId = MAX(jobId) from App_VirtualAppJobStats
	WHERE
		  (( clientId != 0 and @i_client = clientId )
	       or ( replicationId !=0 and replicationId = @i_replicationId ) or (@i_replicationId =0 and @i_client =0))
		  and ( vappId = @i_vAppId or vappId =@defaultAppId)
END
IF object_id('tempdb.dbo.#jobList') IS NOT null DROP TABLE #jobList
CREATE TABLE #jobList
(
	jobId  int,
	replicationId int,
	clientId int,
	vappId int,
	clientName nvarchar(1024)
)
INSERT INTO #jobList
SELECT distinct jobId, replicationId, clientId, vappId, NULL
FROM App_VirtualAppJobStats
WHERE jobId = @i_jobId
AND (( replicationId = 0 and @i_client = clientId )
	       or ( replicationId = @i_replicationId and clientId =0 ) or (@i_replicationId =0 and @i_client =0))
AND phase not in (13,26)
update #jobList
set clientname = r.sourceName
from #jobList J
inner join APP_VSAReplication r
on j.replicationId = r.replicationId
update #jobList
set clientname = c.displayName
from #jobList J
inner join APP_Client c
on j.clientId = c.id
and clientId >0
SET @r_ReturnResult = ISNULL((
					SELECT jobId AS '@jobId',
						   replicationId as'@replicationId',
						   clientId as 'client/@clientId',
						   clientName as 'client/@clientName',
						   vappId as 'vapp/@vAppId',
						(
							SELECT phase AS '@phase',
							status as '@status',
							(SELECT startTime '@time' , 55 '@_type_'
										FOR XML PATH('startTime'), TYPE),
							(SELECT case when isnull(endtime,0) =0  then null else endTime end '@time' , 55 '@_type_'
										FOR XML PATH('endTime'), TYPE),
							(SELECT (CASE WHEN isnull(details.value('(Api_VirtualAppPhaseInfo/job/entity/@clientName)[1]', 'nvarchar(1024)'),'') != ''
											THEN isnull(details.value('(Api_VirtualAppPhaseInfo/job/entity/@clientName)[1]', 'nvarchar(1024)'),'')
											ELSE  J.clientName END ) as '@clientName'
										FOR XML PATH('entity'), TYPE),
							(SELECT details.query('Api_VirtualAppPhaseInfo/job')
							        FOR XML PATH('phaseInfo'), TYPE)
							FROM         [dbo].[App_VirtualAppJobStats]
							WHERE 	vappId = J.vappId and jobId = J.JobId and clientId = J.clientId and replicationId = J.replicationId
							ORDER BY startTime
							FOR XML PATH('phase'), TYPE
						)
						FROM #jobList J
					FOR XML PATH('job'), ROOT ('Api_VirtualAppJobDetailsResp')
					), '<Api_VirtualAppJobDetailsResp/>')
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVirtualAppJobDetails')
	delete from GxQscripts where name = 'AppGetVirtualAppJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVirtualAppJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetVirtualAppJobDetails'
GO

insert into GXDBVersions values(2, 'AppGetVirtualAppJobDetails',  '00010001000200120000', 'AppGetVirtualAppJobDetails', '00010001000200120000')
GO

