

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVirtualApp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVirtualApp.sp,v $ $Id: AppGetVirtualApp.sp,v 1.1.2.17 2019/12/27 13:11:17 rpolimera Exp $";
-- +-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVirtualApp"
--	|	This Procedure is used to get the VM Policy
-- +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVirtualApp')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVirtualApp <<<'
	drop procedure AppGetVirtualApp
END
IF EXISTS (select * from GxQscripts where name='AppGetVirtualApp')
	delete from GxQscripts where name = 'AppGetVirtualApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVirtualApp')
	delete from GXDBVersions where aliasname = 'AppGetVirtualApp'
GO
print '... Creating Procedure: AppGetVirtualApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVirtualApp
-- Input arguments
  @i_uid INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @i_scope				INT
DECLARE @i_vAppId			INT
DECLARE @errorString			NVARCHAR(MAX)
DECLARE @errorCode			INT = 0
DECLARE @flags				INT = 0
DECLARE @i_operationType    INT = 0 -- Default is Fail over Group
DECLARE @i_version		INT = 0 -- Default is return vapps with version 1 and no version set
DECLARE @testBootworkflowId  int
DECLARE @plannedFaileverWorkflowId int
DECLARE @i_proxyClientId int = 0
--get how much information is required
SET	@i_scope 	= ISNULL (( SELECT ref.value('@deep', 'INT')
					FROM  @i_xmlText.nodes ('Api_GetVirtualAppReq') R(ref)), 0)
SET	@i_vAppId = ISNULL (( SELECT ref.value('@vappId', 'INT')
					FROM  @i_xmlText.nodes ('Api_GetVirtualAppReq') R(ref)), 0)
SET	@flags = ISNULL (( SELECT ref.value('@flags', 'INT')
					FROM  @i_xmlText.nodes ('Api_GetVirtualAppReq') R(ref)), 0)
SET @i_operationType = ISNULL((SELECT ref.value('@operationType', 'INT')
						FROM @i_xmlText.nodes('Api_GetVirtualAppReq/filters') R(ref)),0)
SET @i_version = ISNULL((SELECT ref.value('@version', 'INT')
						FROM @i_xmlText.nodes('Api_GetVirtualAppReq/filters') R(ref)),0)
SET @i_proxyClientId = ISNULL((SELECT ref.value('@proxyClientId', 'INT')
						FROM @i_xmlText.nodes('Api_GetVirtualAppReq/filters') R(ref)),0)
IF @i_operationType = 0 AND @i_vAppId > 0
	SELECT @i_operationType = isnull(ref.value('@operationType','int'),0) FROM App_VirtualApp CROSS APPLY vxml.nodes('Api_VirtualAppReq[1]/vApp[1]') R(ref) WHERE id = @i_vAppId
DECLARE @isUserAdmin int
EXECUTE sec_isUserAdmin   @i_userid = @i_uid ,@o_isUserAdmin = @isUserAdmin  OUTPUT
IF object_id('tempdb.dbo.#selectedList') is not null DROP TABLE #selectedList
CREATE TABLE #selectedList  (
							 vappId int,
							 policyId int,
							 clientId INT,
                             canSee INT
                            )
IF ( @isUserAdmin !=1 )
BEGIN
	   IF @i_operationType = 64
       BEGIN
              INSERT #selectedList
              select id,
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/policy[1]/entity[1]/@vmAllocPolicyId', 'int'),
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/config[1]/vmPolicy[1]/@vmAllocPolicyId', 'int'),0)),
                        e.value('@clientId','int'),
                        0
              from App_VirtualApp
              cross apply vxml.nodes('/Api_VirtualAppReq[1]/vApp[1]/oraEBSConfig[1]/cloneTabProxy') s(e)
       END
       ELSE	IF @i_operationType = 128
       BEGIN
              INSERT #selectedList
              select id,
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/policy[1]/entity[1]/@vmAllocPolicyId', 'int'),
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/config[1]/vmPolicy[1]/@vmAllocPolicyId', 'int'),0)),
                        e.value('cvClient[1]/@clientId','int'),
                        0
              from App_VirtualApp
              cross apply vxml.nodes('/Api_VirtualAppReq[1]/vApp[1]/genericApp[1]/enterpriseNodes') s(e)
       END
       ELSE
       BEGIN
              INSERT #selectedList
              select id,
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/policy[1]/entity[1]/@vmAllocPolicyId', 'int'),
                        isnull(vxml.value('/Api_VirtualAppReq[1]/vApp[1]/config[1]/vmPolicy[1]/@vmAllocPolicyId', 'int'),0)),
                        e.value('@clientId','int'),
                        0
              from App_VirtualApp
              cross apply vxml.nodes('/Api_VirtualAppReq[1]/vApp[1]/clientList') s(e)
       END
IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
DROP TABLE #clientLstWithAgentMgmtCap
CREATE TABLE #clientLstWithAgentMgmtCap
(
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
)
EXEC sec_getIdaObjectsForUser @i_uid, 3 /*CLIENT_ENTITY*/ , 0, 0, '#clientLstWithAgentMgmtCap'
update SL
set canSee =1
from  #selectedList SL
inner join #clientLstWithAgentMgmtCap CL
on SL.clientId = CL.clientId
delete from #selectedList
where vappId in ( select vappId from #selectedList where canSee =0 and policyId =0)
update #selectedList
set canSee =1
where policyId !=0 and
dbo.AppCheckVMPolicySecurityPermissions(@i_uid, policyId,0) =1
delete from #selectedList where canSee=0
END
IF (@i_scope = 0)
BEGIN
	IF (@i_proxyClientId <> 0)
	BEGIN
		IF (@i_vAppId = 0)
		BEGIN
			DECLARE @autoFailoverNotConfigured			INT = 7
			SELECT TOP 1 @i_vAppId = vapp.id
			FROM  [dbo].[APP_VirtualApp] AS vapp
			WHERE vapp.vxml.exist('/Api_VirtualAppReq/vApp/autofailover') = 1
			and vapp.vxml.exist('/Api_VirtualAppReq/vApp/autofailover[@status = sql:variable("@autoFailoverNotConfigured")]') <> 1
			and vapp.vxml.exist('/Api_VirtualAppReq/vApp/autofailover/machine/client[@clientId = sql:variable("@i_proxyClientId")]') = 1
			and deleted = 0 and flags = 0
		END
	END
	SET @r_ReturnResult = (
					SELECT description AS '@description',
					operationType as '@operationType',
					ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@replicationType', 'int'),0) as '@replicationType',
					ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@isVirtualLab', 'int'),0) as '@isVirtualLab'	,
					ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@source', 'int'),1) as '@source',
					id AS 'vAppEntity/@vAppId',
					name AS 'vAppEntity/@vAppName',
					vap.vxml.query('Api_VirtualAppReq/vApp/clientList'),
					vap.vxml.query('Api_VirtualAppReq/vApp/policy')
					FROM         [dbo].[APP_VirtualApp] AS vap
					WHERE 	(id = @i_vAppId or @i_vAppid =0)
					and (operationType & @i_operationType >0 or @i_operationType =0)
										and ( (@i_version in  (1,2 ) and @i_version  = ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0))
											 or (@i_version = 3 and ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0) in (0,1,2))-- admin console request
											 or (@i_version = 0 and ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0) in (0,1))) -- java gui request
                                        and flags !=1 and isnull(deleted ,0) =0
							and  (@isUserAdmin =1
								 OR vap.id in ( select vappid from #selectedList )
								 )
					FOR XML PATH('vApp'), ROOT('Api_GetVirtualAppResp')
					)
END
ELSE
BEGIN
SELECT @testBootworkflowId = workflowid from WF_Definition where name ='FailoverTestBootVM'
SELECT @plannedFaileverWorkflowId = workflowid from WF_Definition where name ='PlannedFailover'
	SET @r_ReturnResult = (
					SELECT vxml.query('Api_VirtualAppReq/vApp')
					FROM         [dbo].[APP_VirtualApp] AS vap
					WHERE 	(id = @i_vAppId or @i_vAppid =0) and (operationType = @i_operationType or @i_operationType =0)
										and ( (@i_version in  (1,2 ) and @i_version  = ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0))
											 or (@i_version = 3 and ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0) in (0,1,2)) -- admin console request
											 or (@i_version = 0 and ISNULL(vap.vxml.value('Api_VirtualAppReq[1]/vApp[1]/@version', 'int'),0) in (0,1))) -- java gui request
                                        and flags !=1 and isnull(deleted ,0) =0
							and  (@isUserAdmin =1
								 OR vap.id in ( select vappid from #selectedList )
								 )
					FOR XML PATH(''), ROOT('Api_GetVirtualAppResp')
					)
	 IF (@r_ReturnResult is not null)
	 BEGIN
	 	DECLARE @tempXML xml
	 	set @tempXML = (select (select '7' as '@type',
		                        (select @testBootworkflowId as '@workflowId'
	                             for xml path ('entity'),type)
	 					        for xml path('workflow'), TYPE),
	 					        (select '1' as '@type',
								 (select @plannedFaileverWorkflowId as '@workflowId'
	 					          for xml path('entity'),type)
	 					        for xml path('workflow'), TYPE)
							for xml path('') )
	 	SET @r_ReturnResult.modify('
            insert (
                sql:variable("@tempXML")
                ) after (/Api_GetVirtualAppResp/vApp/clientList)[1]
            ');
	 END
END
SELECT ISNULL(@r_ReturnResult, '<Api_GetVirtualAppResp/>');
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVirtualApp')
	delete from GxQscripts where name = 'AppGetVirtualApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVirtualApp')
	delete from GXDBVersions where aliasname = 'AppGetVirtualApp'
GO

insert into GXDBVersions values(2, 'AppGetVirtualApp',  '00010001000200170000', 'AppGetVirtualApp', '00010001000200170000')
GO

