

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVersionOfClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVersionOfClient.sp,v $ $Id: AppGetVersionOfClient.sp,v 1.1.2.2 2018/03/27 09:02:51 jiechen Exp $";
--  +========================================================================+
--  |      Cursor:  AppGetVersionOfClient()
--  |
--  | Description:  Retrieves the version of the Galaxy Client
--  |               It will just check one of the products installed on the
--  |               client assuming that every product is from the same
--  |               release
--  |
--  |       Input:  ClientID
--  |
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:   This cursor have a problem at the moment where the client
--  |               is being installed since we might have two different
--  |               versions at the same time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira  Initial release
--  |   1.2        madeira  Added buildId to OUT parameter
--  |   1.10       aebilbrey	Converted from cursor to SP template file
--  +========================================================================+
--
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVersionOfClient <<<'

IF EXISTS (select * from sysobjects where name='AppGetVersionOfClient')
	drop procedure AppGetVersionOfClient
IF EXISTS (select * from GxQscripts where name='AppGetVersionOfClient')
	delete from GxQscripts where name = 'AppGetVersionOfClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionOfClient')
	delete from GXDBVersions where aliasname = 'AppGetVersionOfClient'
GO
print '... Creating Procedure: AppGetVersionOfClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVersionOfClient
-- Input arguments
  @itemId integer,
  @itemType integer
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @releaseID integer
  DECLARE @clientID integer
  DECLARE @simOperatingSystemId integer
BEGIN
	SET NOCOUNT ON
	IF @itemType = 5
	BEGIN
		set @clientId = (select TOP 1 clientId from APP_Application WITH(NOLOCK) where id = @itemId)
	END ELSE IF @itemType = 1
	BEGIN
		set @clientId = @itemId
	END ELSE IF @itemType = 2
	BEGIN
		set @clientId = (select TOP 1 clientId from APP_Application WITH(NOLOCK) where appTypeId = @itemId)
	END ELSE IF @itemType = 3
	BEGIN
		set @clientId = (select TOP 1 clientId from APP_Application WITH(NOLOCK) where instance = @itemId)
	END ELSE IF @itemType = 4
	BEGIN
		set @clientId = (select TOP 1 clientId from APP_Application WITH(NOLOCK) where backupset = @itemId)
	END
	SELECT releaseId, id as clientID, simOperatingSystemId FROM APP_Client WITH(NOLOCK) where id = @clientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVersionOfClient')
	delete from GxQscripts where name = 'AppGetVersionOfClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionOfClient')
	delete from GXDBVersions where aliasname = 'AppGetVersionOfClient'
GO

insert into GXDBVersions values(2, 'AppGetVersionOfClient',  '00010001000200020000', 'AppGetVersionOfClient', '00010001000200020000')
GO

