

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVersionInfoForCommCell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppGetVersionInfoForCommCell
--  |
--  | Description:
--  |  To get the Version Info properties of CommCell
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To get Version Info of CommCell
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVersionInfoForCommCell')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVersionInfoForCommCell <<<'
	drop procedure AppGetVersionInfoForCommCell
END
IF EXISTS (select * from GxQscripts where name='AppGetVersionInfoForCommCell')
	delete from GxQscripts where name = 'AppGetVersionInfoForCommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfoForCommCell')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfoForCommCell'
GO
print '... Creating Procedure: AppGetVersionInfoForCommCell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVersionInfoForCommCell
  @commCellId INT,
  @xmlText XML OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @baseline TABLE(nodeName NVARCHAR(MAX), simPackageID INT, appTypeName NVARCHAR(MAX),  baseline INT, baselineDeltaSP NVARCHAR(MAX),
                        baselineDataUpdate NVARCHAR(MAX), nodeDisplayName NVARCHAR(MAX))
DECLARE @versionString NVARCHAR(MAX)
DECLARE @VMToPMMap CURSOR
DECLARE @PMClientId INT
DECLARE @UpdateStatus INT
DECLARE @sGalaxyRelease NVARCHAR(MAX)
	SET @versionString = (SELECT attrVal FROM APP_CLIENTPROP WHERE modified=0 and componentNameId = @commCellID
							and attrName = 'SP Version and Patch Info')
	SET @sGalaxyRelease = (SELECT tmpsimAllGalaxyRel.release
							FROM simAllGalaxyRel as tmpsimAllGalaxyRel, APP_Client
							WHERE tmpsimAllGalaxyRel.id = APP_Client.releaseId AND APP_Client.id = @commCellID)
	INSERT INTO @baseline EXEC [dbo].[rptGetUpdateBaseline] @i_clientId = @commCellID
	SET @VMToPMMap = CURSOR
	FOR SELECT PMClientId FROM APP_VMToPMMap WHERE VMClientId = @commCellID
	OPEN @VMToPMMap
	FETCH NEXT FROM @VMToPMMap INTO @PMClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @baseline EXEC [dbo].[rptGetUpdateBaseline] @i_clientId = @PMClientId
		FETCH NEXT FROM @VMToPMMap INTO @PMClientId
	END
	DEALLOCATE @VMToPMMap
	SET @UpdateStatus =  (SELECT TOP(1)baseline FROM @baseline)
	SET @UpdateStatus = (case
			WHEN @UpdateStatus = 0 		THEN 0	-- N/A
			WHEN @UpdateStatus = 1 		THEN 1	-- Uptodate
			WHEN @UpdateStatus = 2 		THEN 2	-- Behind
			WHEN @UpdateStatus = 4 		THEN 3	-- Ahead
			WHEN @UpdateStatus = 8 		THEN 4	-- N/A
			WHEN @UpdateStatus = 16 	THEN 5	-- Diag
			ELSE 0
		END)
	DECLARE @xmlQuery XML
	SET @xmlQuery = (SELECT @UpdateStatus AS 'UpdateStatus',
							@versionString AS 'version',
							(SELECT @sGalaxyRelease AS 'ReleaseString'
								FOR XML PATH('GalaxyRelease'), TYPE),
							(SELECT
CASE WHEN baselineDeltaSP IS NOT NULL AND baselineDeltaSP <> '' AND (baseline & 16 ) = 0
									THEN
										'SP' + baselineDeltaSP
									ELSE
										baselineDataUpdate
									END AS '@BaselineUpdates',
CASE WHEN baselineDeltaSP IS NOT NULL AND baselineDeltaSP <> '' AND (baseline & 16 ) = 0
									THEN
										1 -- BaselineDeltaSP
									ELSE
										0 -- BaselineDeltaUpdates
									END AS '@IsBaseLineDeltaSP',
									(case
											WHEN baseline = 0 		THEN 0	-- N/A
WHEN (baseline & 1) > 0			THEN 1	-- Uptodate
WHEN (baseline & 2) > 0 		THEN 2	-- Behind
WHEN (baseline & 4) > 0 		THEN 3	-- Ahead
WHEN (baseline & 8) > 0	THEN 4	-- N/A
WHEN (baseline & 16) > 0		THEN 5	-- Diag
											ELSE 0
										END) AS '@BaselineStatus',
									(SELECT appTypeName+ ' ('+ nodeName +')' AS 'packageName'
									FOR XML PATH('packageInfo'), TYPE)
							FROM @baseline
							FOR XML PATH('PatchStatus'), TYPE)
					FOR XML PATH(''), TYPE)
	SET @xmlText = @xmlQuery
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVersionInfoForCommCell')
	delete from GxQscripts where name = 'AppGetVersionInfoForCommCell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfoForCommCell')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfoForCommCell'
GO

insert into GXDBVersions values(2, 'AppGetVersionInfoForCommCell',  '00000000000000000000', 'AppGetVersionInfoForCommCell', '00000000000000000000')
GO

