

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVersionInfoForClient.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVersionInfoForClient"
--	|	This Procedure is used to get version info of a client
--	|	internally calls AppGetVersionInfo.sp - this is needed since we need
--	|	AppGetVersionInfo.sp returns us a xml and requires both client id and
--	|	physical client id as inputs
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVersionInfoForClient <<<'

IF EXISTS (select * from sysobjects where name='AppGetVersionInfoForClient')
	drop procedure AppGetVersionInfoForClient
IF EXISTS (select * from GxQscripts where name='AppGetVersionInfoForClient')
	delete from GxQscripts where name = 'AppGetVersionInfoForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfoForClient')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfoForClient'
GO
print '... Creating Procedure: AppGetVersionInfoForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVersionInfoForClient
  @clientId INT
AS
  DECLARE @versionInfo NVARCHAR(MAX)
DECLARE @physicalClientId AS INT
IF EXISTS (SELECT * FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = 'Virtual Client' AND attrVal = '1' AND modified = 0)		--virtual client
BEGIN
	IF @clientId <> 2
		SET @physicalClientId = (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = 'Active Physical Node' AND modified = 0)
	ELSE
		SET @physicalClientId = (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = 'CS Active Physical Node' AND modified = 0)
END
ELSE
	SET @physicalClientId = @clientId
DECLARE @versionInfoReturn XML
EXEC [dbo].[AppGetVersionInfo] @clientId, @physicalClientId, 1, @versionInfoReturn OUTPUT
SET @versionInfo = CAST((SELECT @versionInfoReturn.value('(//*/ReleaseString)[1]','NVARCHAR(MAX)')) AS NVARCHAR(MAX))
SELECT @versionInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVersionInfoForClient')
	delete from GxQscripts where name = 'AppGetVersionInfoForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfoForClient')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfoForClient'
GO

insert into GXDBVersions values(2, 'AppGetVersionInfoForClient',  '00000000000000000000', 'AppGetVersionInfoForClient', '00000000000000000000')
GO

