

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVersionInfo.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVersionInfo"
--	|	This Procedure is used to get version info of a client
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVersionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVersionInfo <<<'
	drop procedure AppGetVersionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetVersionInfo')
	delete from GxQscripts where name = 'AppGetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfo'
GO
print '... Creating Procedure: AppGetVersionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVersionInfo
  @cliID INT,
  @physClID INT,
  @getCachedUpdatesOnly INT=1,
  @xmlText XML		OUTPUT
AS
DECLARE @clientcur CURSOR
DECLARE @UpdateStatus INT
DECLARE @AppTypeStatus INT
DECLARE @i_ClientId INT
DECLARE @i_AppTypeID INT
DECLARE @i_BaseLineDeltaSP NVARCHAR(255)
DECLARE @i_BaseLineDeltaUpdate NVARCHAR(255)
DECLARE @i_IsActive INT
DECLARE @i_StatusFlag INT
DECLARE @i_Node NVARCHAR(255)
DECLARE @oneUnknown INT
DECLARE @noEntriesInTable INT
DECLARE @true INT
DECLARE @false INT
DECLARE @status INT
DECLARE @NOT_APLICABLE INT
DECLARE @HAS_DIAG_UPDATES INT
DECLARE @BELOW_BASELINE INT
DECLARE @BASELINE_UNKNOWN INT
DECLARE @ABOVE_BASELINE INT
DECLARE @MATCH_BASELINE INT
DECLARE @PENDING INT
DECLARE @IsBaselineComparedToClient INT = 0
SET @true=0
SET @false=1
SET @NOT_APLICABLE=@false
SET @HAS_DIAG_UPDATES=@false
SET @BELOW_BASELINE=@false
SET @BASELINE_UNKNOWN=@false
SET @ABOVE_BASELINE=@false
SET @MATCH_BASELINE=@false
SET @PENDING=@false
--SET @cliID=2
SET @noEntriesInTable=@true
DECLARE @debug integer
SET @debug = 0
DECLARE @FinalClientUpdateStatus TABLE ( AppType INT,
				BaseLineStatus INT,
				BaseLineUpdate NVARCHAR(255), IsBaseLineDeltaSP INT)
SET @clientcur = CURSOR
FOR	SELECT clientid,IsActive, dbo.simGetBaseline(Baseline), Node, simPackageID, BaseLineDeltaSP, BaseLineDeltaUpdate FROM simInstalledPackages where clientid in (@cliID, @physClID)
DECLARE @xmlQuery1 XML
SET @xmlQuery1 = (SELECT @UpdateStatus AS 'UpdateStatus'
				FOR XML PATH(''), ROOT('PatchStatus'), TYPE)
OPEN @clientcur
FETCH NEXT FROM @clientcur INTO @i_ClientId,@i_IsActive, @i_StatusFlag, @i_Node, @i_AppTypeID, @i_BaseLineDeltaSP, @i_BaseLineDeltaUpdate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @noEntriesInTable=@false
	IF @i_ClientId = 2 AND @i_IsActive = 0
	BEGIN
		FETCH NEXT FROM @clientcur INTO @i_ClientId,@i_IsActive, @i_StatusFlag, @i_Node, @i_AppTypeID, @i_BaseLineDeltaSP, @i_BaseLineDeltaUpdate
		continue
	END
	IF @i_StatusFlag < 0
		SET @PENDING = @true
	IF @i_StatusFlag = 0
		SET @oneUnknown = @true
	IF (@i_StatusFlag & 1) > 0
		SET @MATCH_BASELINE = @true
	IF (@i_StatusFlag & 2) > 0
		SET @BELOW_BASELINE = @true
	IF (@i_StatusFlag & 4) > 0
		SET @ABOVE_BASELINE = @true
	IF (@i_StatusFlag & 8) > 0
		SET @NOT_APLICABLE = @true
	IF (@i_StatusFlag & 16) > 0
		SET @HAS_DIAG_UPDATES = @true
	SET @AppTypeStatus = (case
							WHEN @i_StatusFlag < 0			THEN 7	-- Pending
							WHEN @i_StatusFlag = 0 			THEN 0	-- N/A
							WHEN (@i_StatusFlag & 1) > 0	THEN 1	-- Uptodate
							WHEN (@i_StatusFlag & 2) > 0 	THEN 2	-- Behind
							WHEN (@i_StatusFlag & 4) > 0 	THEN 3	-- Ahead
							WHEN (@i_StatusFlag & 8) > 0 	THEN 4	-- N/A
							WHEN (@i_StatusFlag & 16) > 0 	THEN 5	-- Diag
							ELSE 0
						END)
		INSERT INTO @FinalClientUpdateStatus(AppType, BaseLineStatus) VALUES (@i_AppTypeID, @AppTypeStatus)
		IF @debug = 1
			PRINT 'AppType=' + convert(varchar(10), @i_AppTypeID) + ', BaselineStatus=' + convert(varchar(10), @AppTypeStatus)
		IF (@i_StatusFlag & 16) > 0
		BEGIN
			UPDATE @FinalClientUpdateStatus SET BaseLineUpdate = @i_BaseLineDeltaUpdate, IsBaseLineDeltaSP = 0 where  AppType = @i_AppTypeID
		END
		Else
		BEGIN
			if @i_BaseLineDeltaSP = ''
				UPDATE @FinalClientUpdateStatus SET BaseLineUpdate = @i_BaseLineDeltaUpdate, IsBaseLineDeltaSP = 0 where  AppType = @i_AppTypeID --PRINT 'BaselineUpdates=' + @i_BaseLineDeltaUpdate
			else
				UPDATE @FinalClientUpdateStatus SET BaseLineUpdate =  'SP' + convert(varchar(32), @i_BaseLineDeltaSP), IsBaseLineDeltaSP = 1 where  AppType = @i_AppTypeID --PRINT 'BaselineUpdates=' + 'SP' + @i_BaseLineDeltaSP
		END
	FETCH NEXT FROM @clientcur INTO @i_ClientId, @i_IsActive, @i_StatusFlag, @i_Node, @i_AppTypeID, @i_BaseLineDeltaSP, @i_BaseLineDeltaUpdate
END
DECLARE @clRelId INT
SET @clRelId = (SELECT releaseId FROM  APP_Client WHERE id = @cliID)
--For the 9.0 and lesser release clients Has Diag will take the precedence
--For the 10.0 and above release clients Needs Update will take the precedence
IF @PENDING = @true
	SET @status = -1
ELSE IF @noEntriesInTable = @true OR @NOT_APLICABLE = @true
	SET @status = 8
ELSE IF @clRelId < 15 AND @HAS_DIAG_UPDATES = @true
	SET @status = 16
ELSE IF @BELOW_BASELINE = @true
	SET @status = 2
ELSE IF @clRelId >= 15 AND @HAS_DIAG_UPDATES = @true
	SET @status = 16
ELSE IF @oneUnknown = @true
	SET @status = 0
ELSE IF @ABOVE_BASELINE = @true
	SET @status = 4
ELSE IF @MATCH_BASELINE = @true
	SET @status = 1
	SET @UpdateStatus = (case
							WHEN @status < 0		THEN 7	-- Pending
							WHEN @status = 0 		THEN 0	-- N/A
							WHEN @status = 1 		THEN 1	-- Uptodate
							WHEN @status = 2 		THEN 2	-- Behind
							WHEN @status = 4 		THEN 3	-- Ahead
							WHEN @status = 8 		THEN 4	-- N/A
							WHEN @status = 16 		THEN 5	-- Diag
							ELSE 0
						END)
	IF @debug = 1
		print @UpdateStatus
DEALLOCATE @clientcur
DECLARE @sGalaxyBuildNumber NVARCHAR(255)
DECLARE @sGalaxyRelease NVARCHAR(255)
DECLARE @versionString NVARCHAR(MAX)
DECLARE @friendlySPName NVARCHAR(256)
SET @sGalaxyRelease = (SELECT tmpsimAllGalaxyRel.release
							FROM simAllGalaxyRel as tmpsimAllGalaxyRel, APP_Client
							WHERE tmpsimAllGalaxyRel.id = APP_Client.releaseId AND APP_Client.id = @cliID)
--If it is 10.0 and service pack level is greater than 7, then we need to display the version string in client properties as 10 R2.
--Property will be something like this in APP_ClientProp table
--ServicePack:4b,AdditionalUpdates:,7720,7722,7734,7740,7742,7775,7789,7816,7826,7834,7840,7842,7858,7860,7867,7869,7870,7876,7891,7912,7916,7923,7926
IF ((SELECT releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @cliId) >= 15)
BEGIN
	DECLARE @servicepackinfo AS NVARCHAR(MAX)
	DECLARE @servicepacknostartposition AS INT
	SET @servicepackinfo = ISNULL((SELECT attrval
								   FROM APP_ClientProp WITH (NOLOCK)
							       WHERE componentNameId = @physClID AND attrName = 'SP Version Info' AND modified = 0), '')
	--servicepackinfo = 10, 10 SP4, 10 SP4+, 10 SP4b, 10 SP4b+
	--servicepackinfo = 10, 10 SP10, 10 SP10+, 10 SP10b, 10 SP10b+
	IF @servicepackinfo <> ''
	BEGIN
		SET @servicepacknostartposition = CHARINDEX('SP', @servicepackinfo)			--will be the position of "S" in the string "10 SP4b+"
																					--if no service pack is installed it will be 0
		IF @servicepacknostartposition > 0
		BEGIN
			--10 SP4, 10 SP4b, 10 SP4b+, 10 SP4+
			SET @servicepacknostartposition = @servicepacknostartposition + LEN('SP')		--we need to start after SP
			DECLARE @majorversionstring AS NVARCHAR(MAX)
			SET @majorversionstring = RTRIM(SUBSTRING(@servicepackinfo, 1, CHARINDEX('SP', @servicepackinfo)-1))		--extract 10 alone we need it later
			SET @servicepackinfo = SUBSTRING(@servicePackInfo, @servicepacknostartposition, LEN(@servicepackinfo)-(@servicepacknostartposition-1))
			--4, 4+, 4b, 4b+
			IF PATINDEX('%[a-zA-Z]%', @servicepackinfo) > 0				--4b, 4b+
				SET @servicepackinfo = LEFT(@servicepackinfo, PATINDEX('%[a-zA-Z]%', @servicepackinfo) - 1)
			IF PATINDEX('%[+-]%', @servicepackinfo) > 0					--4+
				SET @servicepackinfo = LEFT(@servicepackinfo, PATINDEX('%[+-]%', @servicepackinfo) - 1)
			--Now it is just a number, compare against 7 and decide, do it only for 10.0 for 11.0 we will decide later
			IF ((CAST(@servicepackinfo AS DECIMAL) >= 7) AND (SUBSTRING(@majorversionstring, 1, 2) = '10'))
				SET @sGalaxyRelease = @majorversionstring + ' R2'
			ELSE
				SET @sGalaxyRelease = @majorversionstring
		END
		ELSE				--there is no service pack installed so release string is the same
		BEGIN
			SET @sGalaxyRelease = @servicepackinfo
		END
	END
END
SET @versionString = (SELECT attrVal FROM APP_CLIENTPROP WHERE modified=0 and componentNameId = @physClID
						and attrName = 'SP Version and Patch Info')
IF @getCachedUpdatesOnly = 0
BEGIN
	IF object_id('tempdb.dbo.#AppGetVersionInfoUpdatesList') IS NOT null DROP TABLE #AppGetVersionInfoUpdatesList
	CREATE TABLE #AppGetVersionInfoUpdatesList    ([updateName] VARCHAR(255) NOT NULL PRIMARY KEY)
	INSERT INTO #AppGetVersionInfoUpdatesList
	SELECT Distinct upd._ID
	FROM simInstalledPackages sip
	CROSS APPLY dbo.SplitStringByDelimiter(sip.AdditionalPatches, ',') as upd
	WHERE sip.ClientId = @physClID AND _ID != 'None'
	IF EXISTS (SELECT 1 FROM #AppGetVersionInfoUpdatesList)
	BEGIN
		SET @versionString = SUBSTRING(@versionString, 1, CHARINDEX(',', @versionString))
		SELECT @versionString = @versionString + 'Additional Updates:,' +
				STUFF((SELECT ',' + updateName
					  FROM #AppGetVersionInfoUpdatesList
					  ORDER BY updateName
					  FOR XML PATH('')), 1, 1, '')
	END
	DROP TABLE #AppGetVersionInfoUpdatesList
END
SET @friendlySPName = (SELECT TOP 1 psp.friendlyName
						FROM simInstalledPackages sip
						JOIN PatchSPVersion psp on sip.SPVersionID = psp.id
						WHERE sip.clientId = @physClID)
SET @IsBaselineComparedToClient =  COALESCE ((SELECT DISTINCT 1 FROM simInstalledPackages WITH (NOLOCK)
							   WHERE SPVersionID IN (SELECT C.SPVersionID FROM PatchMultiCache C WITH (NOLOCK) JOIN simInstalledPackages P WITH (NOLOCK) ON P.ClientId = 2 AND P.HighestSP <> C.HighestSP)
							   AND ClientId IN (@cliID, @physClID)), 0)
DECLARE @xmlQuery XML
SET @xmlQuery = (SELECT @UpdateStatus AS 'UpdateStatus',
						@versionString AS 'version',
						@friendlySPName AS 'friendlyName',
						@IsBaselineComparedToClient AS 'IsBaselineComparedToClient',
						(SUBSTRING(@sGalaxyBuildNumber,2,len(@sGalaxyBuildNumber)-1)) AS 'GalaxyBuildNumber',
						(SELECT @sGalaxyRelease AS 'ReleaseString'
								FOR XML PATH('GalaxyRelease'), TYPE),
						(SELECT
								TmpFinalClientUpdateStatus.BaseLineStatus AS '@BaselineStatus',
								TmpFinalClientUpdateStatus.BaseLineUpdate AS '@BaselineUpdates',
								TmpFinalClientUpdateStatus.IsBaseLineDeltaSP	  AS '@IsBaseLineDeltaSP',
								(SELECT TmpAPP_SimPkg.displayName AS 'packageName',TmpAPP_SimPkg.id AS 'packageId'
								FROM simPackage AS TmpAPP_SimPkg
								WHERE TmpAPP_SimPkg.id = TmpFinalClientUpdateStatus.AppType
								FOR XML PATH('packageInfo'), TYPE)
						FROM @FinalClientUpdateStatus AS TmpFinalClientUpdateStatus
						FOR XML PATH('PatchStatus'), TYPE)
				FOR XML PATH(''), TYPE)
SET @xmlText = @xmlQuery
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVersionInfo')
	delete from GxQscripts where name = 'AppGetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetVersionInfo'
GO

insert into GXDBVersions values(2, 'AppGetVersionInfo',  '00000000000000000000', 'AppGetVersionInfo', '00000000000000000000')
GO

