

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSPseudoClientsForUser.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:      Sasikala Raju
-- Create date: 03/07/2019
-- Description: Returns the list of VSA virtual clients on which user have given permission
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSPseudoClientsForUser')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSPseudoClientsForUser <<<'
	drop procedure AppGetVSPseudoClientsForUser
END
IF EXISTS (select * from GxQscripts where name='AppGetVSPseudoClientsForUser')
	delete from GxQscripts where name = 'AppGetVSPseudoClientsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClientsForUser')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClientsForUser'
GO
print '... Creating Procedure: AppGetVSPseudoClientsForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSPseudoClientsForUser
  @xmlText XML
AS
-- uncommitted is ok
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @o_xmlText XML
DECLARE @debug  AS INT = 0
DECLARE @userId AS INT =  (SELECT ref.value('@userId', 'INT') FROM @xmlText.nodes('App_GetVSAVirtualClientsReq/user') R(ref))
DECLARE @permissionId AS INT = (SELECT ref.value('@categoryId', 'INT') FROM @xmlText.nodes('App_GetVSAVirtualClientsReq/permission') R(ref))
DECLARE @vendor AS INT =  ISNULL(@xmlText.value('(/App_GetVSAVirtualClientsReq/@vendor)[1]','int'),0)
DECLARE @filterAdminClient AS INT =  ISNULL(@xmlText.value('(/App_GetVSAVirtualClientsReq/@filterAdminClient)[1]','bit'),0)
IF OBJECT_ID('tempdb.dbo.#PseudoClients_tmp__ClientsList')       IS NOT null DROP TABLE #PseudoClients_tmp__ClientsList
IF OBJECT_ID('tempdb.dbo.#getAssociatedClients') IS NOT NULL DROP TABLE #getAssociatedClients
--temp table that will hold clients on which current user have given permission
CREATE TABLE #getAssociatedClients
(
    ClientId        INT,
    ApptypeId       INT,
    InstanceID      INT,
    BackupsetId     INT,
    SubclientID     INT
)
CREATE CLUSTERED INDEX Idx_AssObjects_1 ON #getAssociatedClients (ClientId)
-- temp table  that will hold list of all pseudo clients
CREATE TABLE #PseudoClientList_tmp__ClientsList
(
    ClientId            INT,
    ClientName          NVARCHAR(510)                 DEFAULT(''),
    ClientDisplayName   NVARCHAR(510)                 DEFAULT(''),
    ClientHostName      NVARCHAR(510)                 DEFAULT(''),
    ClientGUID          UNIQUEIDENTIFIER            NOT null,
    InstanceId          INT                         NOT null,
    InstanceName        NVARCHAR(1024)                DEFAULT(''),
    InstanceGuid        UNIQUEIDENTIFIER,
    Status              INT,
    IsTenantClient      INT,
    AdminInstanceId     INT
)
CREATE CLUSTERED INDEX Idx_Clients_1 ON #PseudoClientList_tmp__ClientsList (ClientId)
--#1. Get all VSA pseudo clients
INSERT INTO #PseudoClientList_tmp__ClientsList (ClientId, ClientName, ClientDisplayName, ClientHostName,  ClientGUID, InstanceId, InstanceName, InstanceGuid, status)
    SELECT  DISTINCT CL.id, CL.name, CL.displayName, CL.net_hostname, CL.GUID,
                     APP.instance, AIN.name, AIN.GUID, CL.Status
    FROM    APP_Client CL INNER JOIN APP_IDAName IDA      ON (IDA.clientId = CL.id AND IDA.appTypeId = 106) -- only VSA pseudo clients
                          INNER JOIN APP_Application APP  ON (APP.clientId = CL.id AND App.appTypeId = IDA.appTypeId)
                          INNER JOIN APP_InstanceProp IP  ON
						  (IP.componentNameId = APP.instance AND
						  IP.attrName = 'Virtual Server Instance Type' AND
						  IP.modified = 0 AND
						  (@vendor = 0 OR dbo.MapVSVendorId(CAST(IP.attrVal AS INT), -1) = @vendor)) -- vendor (VMWare, Amazon..)
                          INNER JOIN APP_InstanceName AIN ON (AIN.id = APP.instance)
--Delete Clients which is not admin
IF @filterAdminClient >0
BEGIN
	DELETE CL FROM #PseudoClientList_tmp__ClientsList CL
	INNER JOIN APP_InstanceProp AP
		ON CL.InstanceId = AP.componentNameId AND AP.attrName = 'Amazon Enable Admin Account' AND AP.modified = 0 AND AP.attrVal = 1
END
-- Update instance prop
UPDATE #PseudoClientList_tmp__ClientsList
        SET IsTenantClient = (SELECT attrVal FROM APP_InstanceProp AP where InstanceId = AP.componentNameId AND AP.attrName = 'Amazon Enable Admin Account' AND AP.modified = 0),
            AdminInstanceId = (SELECT attrVal FROM APP_InstanceProp AP where InstanceId = AP.componentNameId AND AP.attrName = 'Amazon Admin Instance Id' AND AP.modified = 0)
IF @debug = 1 BEGIN
    SELECT 'client', * FROM #PseudoClientList_tmp__ClientsList
END
--#2. Get clients on which current user have given permission
IF @permissionID <> 252
EXEC sec_getIdaObjectsForUser @userId, 3, @permissionId, 0, '#getAssociatedClients'
ELSE
EXEC sec_getIdaObjectsForUser @userId, 3, @permissionId, 0, '#getAssociatedClients', 1
IF @debug = 1
BEGIN
    SELECT 'Permision', * FROM #getAssociatedClients
END
--#3. Filter out entities not available for current user
DELETE FROM #PseudoClientList_tmp__ClientsList
    FROM  #PseudoClientList_tmp__ClientsList CL LEFT OUTER JOIN #getAssociatedClients  AC  ON CL.ClientId = AC.ClientId
	WHERE AC.ClientId IS NULL
IF @debug = 1
BEGIN
    SELECT 'filtered client', * FROM #PseudoClientList_tmp__ClientsList
END
--#4. Generate response
SET @o_xmlText = (SELECT
                        (SELECT Client.Status                   AS '@status',
                                Client.IsTenantClient           AS '@isTenantClient',
                                Client.AdminInstanceId          AS '@adminInstanceId',
                                --Client entity
                                (SELECT Client.ClientId                 AS '@clientId',
                                        Client.ClientName               AS '@clientName',
                                        Client.ClientDisplayName        AS '@displayName',
                                        Client.ClientHostName           AS '@hostName',
                                        Client.ClientGUID               AS '@clientGUID'
                                FOR XML PATH('client'), TYPE),
                                --Instance entity
                                (SELECT Client.InstanceId               AS '@instanceId',
                                        Client.InstanceGuid             AS '@instanceGUID',
                                        Client.InstanceName             AS '@instanceName',
                                        Client.ClientId                 AS '@clientId',
                                        Client.ClientName               AS '@clientName',
                                        Client.ClientDisplayName        AS '@displayName',
                                        Client.ClientHostName           AS '@hostName',
                                        Client.ClientGUID               AS '@clientGUID'
                                FOR XML PATH('instance'), TYPE)
                        FROM #PseudoClientList_tmp__ClientsList Client
                        FOR XML PATH('vsaVirtualClientList'), TYPE)
                  FOR XML PATH(''), ROOT('App_GetVSAVirtualClientsResponse'))
SELECT @o_xmlText
--#5. clean up
IF OBJECT_ID('tempdb.dbo.#PseudoClients_tmp__ClientsList')       IS NOT null DROP TABLE #PseudoClients_tmp__ClientsList
IF OBJECT_ID('tempdb.dbo.#getAssociatedClients') IS NOT NULL DROP TABLE #getAssociatedClients
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSPseudoClientsForUser')
	delete from GxQscripts where name = 'AppGetVSPseudoClientsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClientsForUser')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClientsForUser'
GO

insert into GXDBVersions values(2, 'AppGetVSPseudoClientsForUser',  '00000000000000000000', 'AppGetVSPseudoClientsForUser', '00000000000000000000')
GO

