

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSPseudoClients.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVSPseudoClients.sp,v $ $Id: AppGetVSPseudoClients.sp,v 1.13.2.18 2020/08/14 13:29:23 logeshg Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 02/20/2014
-- Description:
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSPseudoClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSPseudoClients <<<'
	drop procedure AppGetVSPseudoClients
END
IF EXISTS (select * from GxQscripts where name='AppGetVSPseudoClients')
	delete from GxQscripts where name = 'AppGetVSPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClients')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClients'
GO
print '... Creating Procedure: AppGetVSPseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSPseudoClients
  @o_xmlText XML OUTPUT
AS
-- uncommitted is ok
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @debug  AS INT = 0
DECLARE @userId AS INT = (SELECT ref.value('@userId', 'INT') FROM @o_xmlText.nodes('App_VSPseudoClientsRequest/user') R(ref))
DECLARE @filterProviderId AS INT = ISNULL((SELECT ref.value('@providerId', 'INT') FROM @o_xmlText.nodes('App_VSPseudoClientsRequest/provider') R(ref)), -1)
DECLARE @vOrgGuid AS NVARCHAR(128) = (SELECT ref.value('@vOrgGuid', 'NVARCHAR(128)') FROM @o_xmlText.nodes('App_VSPseudoClientsRequest') R(ref))
--Extract Vendor Type filters
DECLARE @filterVendorType INT = ISNULL((SELECT ref.value('@filterVendorType', 'INT') FROM @o_xmlText.nodes('App_VSPseudoClientsRequest') R(ref)), -1)
DECLARE @excludeVendorType INT = ISNULL((SELECT ref.value('@excludeVendorType', 'INT') FROM @o_xmlText.nodes('App_VSPseudoClientsRequest') R(ref)), -1)
DECLARE @tempVSClientListCnt INT = 0
IF OBJECT_ID('tempdb.dbo.#Assoc_VS_PseudoClientList') IS NOT null DROP TABLE #Assoc_VS_PseudoClientList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__ClientsList')       IS NOT null DROP TABLE #PseudoClientList_tmp__ClientsList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__ActivitiesList')    IS NOT null DROP TABLE #PseudoClientList_tmp__ActivitiesList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__CompanyClients')    IS NOT null DROP TABLE #PseudoClientList_tmp__CompanyClients
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL           DROP TABLE #RetireInProgressClientListTbl
--Temp table will hold all clients that user has permission on
CREATE TABLE #Assoc_VS_PseudoClientList
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
CREATE CLUSTERED INDEX Assoc_VS_PseudoClientList_Idx ON #Assoc_VS_PseudoClientList(t_clientId)
-- table variable that will hold list of pseudo clients
CREATE TABLE #PseudoClientList_tmp__ClientsList
(
	ClientId            INT,
	ClientName          NVARCHAR(510)                 DEFAULT(''),
	ClientDisplayName   NVARCHAR(510)                 DEFAULT(''),
    ClientHostName      NVARCHAR(510)                 DEFAULT(''),
    ClientGUID          UNIQUEIDENTIFIER    NOT null,
    VSVendor            INT                 NOT null,
    InstanceId          INT                 NOT null,
    InstanceName        NVARCHAR(1024)                DEFAULT(''),
    InstanceGuid        UNIQUEIDENTIFIER,
    Status              INT,
	adminInstanceId		INT,
	adminClientId		INT,
adminClientName		NVARCHAR(255),
	adminClientDisplayName		NVARCHAR(255),
	vOrgGuid			NVARCHAR(1024),
	vOrgCompanyId		INT,
vOrgCompanyName		NVARCHAR(255),
	retireClientPhase   INT DEFAULT(0)
)
CREATE CLUSTERED INDEX Idx_ClientsList_1 ON #PseudoClientList_tmp__ClientsList (ClientId)
-- table that will hold information about activities (backups, restores, etc) available for the client
CREATE TABLE #PseudoClientList_tmp__ActivitiesList
(
    ClientId            INT                 NOT null,
    ActivityType        INT                 NOT null,
    ActivityStatus      INT                 NOT null,
    ActivityStatusDelay INT                 NOT null,
    EnableTime          INT                 NOT null,
    EnableTimeZone      INT                 NOT null
)
CREATE CLUSTERED INDEX Idx_ActivitiesList_1 ON #PseudoClientList_tmp__ActivitiesList (ClientId)
CREATE TABLE #PseudoClientList_tmp__CompanyClients
(
	clientId INT
)
CREATE CLUSTERED INDEX CompanyClients_Idx ON #PseudoClientList_tmp__CompanyClients(clientId)
CREATE TABLE #RetireInProgressClientListTbl(retireClientId INT)
--Get the list of specific virtual server client Ids provided in XML input
DECLARE @tempVSClientList TABLE(
    clientId      INT PRIMARY KEY
);
--If caller provided a VS GUID, extract VS client Id based on GUID
IF @vOrgGuid IS NOT NULL
BEGIN
	INSERT INTO @tempVSClientList
	SELECT AC.id
	FROM App_Client AC WITH (NOLOCK)
inner join App_ClientProp ACP WITH (NOLOCK) on AC.id = ACP.componentNameId AND ACP.attrName = 'Vcloud VOrg Guid' AND ACP.modified = 0
	WHERE ACP.attrVal = @vOrgGuid
	SET @tempVSClientListCnt = @@ROWCOUNT
END
ELSE --Get the list of clients that caller explicitely provided in request
BEGIN
	INSERT INTO @tempVSClientList
	SELECT ref.value('@clientId', 'int') AS client
	FROM    @o_xmlText.nodes('App_VSPseudoClientsRequest/filterClients') R ( ref )
	WHERE   ISNULL(ref.value('@clientId', 'int'), 0) > 0
	SET @tempVSClientListCnt = @@ROWCOUNT
	--If caller provided a list of clients, check validity of the clients provided
	IF (@tempVSClientListCnt > 0)
	BEGIN
		--Delete all entries which are not clients
	    DELETE TCL
	    FROM @tempVSClientList TCL LEFT OUTER JOIN App_Client AC WITH (NOLOCK) ON AC.id = TCL.clientId
	    WHERE AC.ID IS NULL
	    SET @tempVSClientListCnt -= @@ROWCOUNT
	    --If none of the client Ids provided by caller are actually clients, exit immediately
	    IF (@tempVSClientListCnt <= 0)
	    BEGIN
	        GOTO OUTPUT_EXIT
	    END
	END
END
--At this point, the only clients (if any) in @tempVSClientList would be virtual machines. Proceeding further..
IF EXISTS (SELECT 1 FROM UMUsers WITH (NOLOCK) WHERE id = @userId AND (flags & 0x040 <> 0))	--ADMIN USER
BEGIN
    --If the caller explictely provided clientIds, blindly insert those into #Assoc_VS_PseudoClientList as its admin user
    IF (@tempVSClientListCnt > 0)
    BEGIN
        insert into #Assoc_VS_PseudoClientList
        select distinct VS.clientId, AP.appTypeId, AP.instance, AP.backupSet, AP.id
        from @tempVSClientList VS INNER JOIN APP_Application AP WITH (NOLOCK) on VS.clientId = AP.clientId
    END
    ELSE
    BEGIN
        --Get all clients on which user has view all capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#Assoc_VS_PseudoClientList'
    END
END
ELSE     --NON-ADMIN user
BEGIN
    --If calling user is NOT ADMIN user, get clients on which user has VIEW capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#Assoc_VS_PseudoClientList'
    --Get rid of all entries where either the user does not have direct VIEW capability on client OR the user has indirect view capability on client inherited from a non-virtualization iDA.
    DELETE FROM #Assoc_VS_PseudoClientList WHERE t_appTypeId NOT IN (0, 106)
    --If the caller explictely provided clientIds, only retain those that were provided in the list
    IF (@tempVSClientListCnt > 0)
    BEGIN
        delete CL
        from #Assoc_VS_PseudoClientList CL left outer join @tempVSClientList VS on CL.t_clientId = VS.clientId
        where VS.clientId is null
    END
END
-- 1st, get all clients of a certain type with certain attributes into temporary table
INSERT INTO #PseudoClientList_tmp__ClientsList (ClientId, ClientName, ClientDisplayName, ClientHostName,  ClientGUID, VSVendor, InstanceId, InstanceName, InstanceGuid, status)
SELECT  DISTINCT CL.id, CL.name, CL.displayName, CL.net_hostname, CL.GUID,  dbo.MapVSVendorId(CAST(IP.attrVal AS INT), -1), APP.instance, AIN.name, AIN.GUID, CL.Status
FROM    APP_Client CL WITH (NOLOCK) INNER JOIN APP_IDAName IDA      ON (IDA.clientId = CL.id)
					  INNER JOIN #Assoc_VS_PseudoClientList PCL on CL.id = PCL.t_clientId
                      INNER JOIN APP_Application APP WITH (NOLOCK)  ON (APP.clientId = CL.id AND App.appTypeId = IDA.appTypeId)
                      INNER JOIN APP_InstanceProp IP WITH (NOLOCK)  ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
					  INNER JOIN APP_InstanceName AIN WITH (NOLOCK) ON (AIN.id = APP.instance)
WHERE       (IDA.appTypeId = 106)
IF @debug = 1 BEGIN
    SELECT t_clientId, t_appTypeId, t_instanceId, t_backupsetId, t_subclientId
    FROM #Assoc_VS_PseudoClientList
END
IF @filterProviderId <> -1
BEGIN
    INSERT INTO #PseudoClientList_tmp__CompanyClients
	    SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
		    INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.cs_attrName = checksum('Associated Smart Client Group') AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
    DELETE  FROM #PseudoClientList_tmp__ClientsList
    WHERE   ClientId NOT IN ( SELECT clientId
                              FROM #PseudoClientList_tmp__CompanyClients)
END
--Apply inclusion/exclusion filters based on vendor type
--If filterVendorType was provided, filter out VS clients that are not associated to given vendor
IF @filterVendorType <> -1
BEGIN
    DELETE FROM #PseudoClientList_tmp__ClientsList WHERE VSVendor <> @filterVendorType
END
--If excludeVendorType was provided, filter out VMs that are associated to given vendor
IF @excludeVendorType <> -1
BEGIN
    DELETE FROM #PseudoClientList_tmp__ClientsList WHERE VSVendor = @excludeVendorType
END
-- Lets update required properties for VCloud hypervisor
UPDATE PCL
SET
	PCL.adminInstanceId	= APP2.instance,
	PCL.adminClientId	= AC.id,
	PCL.adminClientName	= AC.name,
	PCL.adminClientDisplayName	= AC.displayName,
	PCL.vOrgGuid		= ACP2.attrval,
	PCL.vOrgCompanyId	= UD.id,
	PCL.vOrgCompanyName = UD.domainName
FROM #PseudoClientList_tmp__ClientsList PCL
LEFT OUTER JOIN APP_ClientProp ACP1	ON ACP1.componentNameId=PCL.ClientId AND ACP1.attrname='VCloud associated company id' AND ACP1.modified=0
LEFT OUTER JOIN UMDSProviders	UD	ON CAST(UD.id AS NVARCHAR(32))=ACP1.attrval AND UD.servicetype = 5
LEFT OUTER JOIN APP_ClientProp ACP2	ON ACP2.componentNameId=PCL.ClientId AND ACP2.attrname='Vcloud VOrg Guid' AND ACP1.modified=0
LEFT OUTER JOIN APP_InstanceProp AIP2	ON AIP2.componentNameId=PCL.InstanceId AND AIP2.attrname='Amazon Admin Instance Id' AND AIP2.modified=0
LEFT OUTER JOIN APP_Application APP2  ON CAST(APP2.instance AS NVARCHAR(32))=AIP2.attrval
LEFT OUTER JOIN APP_Client AC  ON AC.id=APP2.clientId
WHERE PCL.VSVendor=15	-- 15 - enum VSVendor - VCLOUD
--List of clients which are currently getting uninstalled. Shouldn't be a huge table
INSERT INTO #RetireInProgressClientListTbl
SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
	INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
		AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
		AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
UPDATE #PseudoClientList_tmp__ClientsList
	SET retireClientPhase = 1
	WHERE ClientId IN (SELECT retireClientId FROM #RetireInProgressClientListTbl)
-- 3rd. get each entity activity control
-- .x EntityActivityType enum is defined at http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/App.x#5176
-- values in JMJobAction table are defined at http:--ncvs/source/xref/win/vaultcxtools/BrowseSIChunk/cvconstdef.h#114
INSERT INTO #PseudoClientList_tmp__ActivitiesList (ClientId, ActivityType, ActivityStatus, ActivityStatusDelay, EnableTime, EnableTimeZone)
    SELECT  A.clientId,
            CASE A.opType
                WHEN   4 THEN    1  -- Backup
                WHEN   5 THEN    2  -- Restore
                WHEN  13 THEN    4  -- Aux Copy
                WHEN  11 THEN    8  -- DR Backup
                WHEN  10 THEN   16  -- Archive Prune
                WHEN   9 THEN   32  -- Media Recycle
                WHEN  14 THEN   64  -- Synthetic Full
                WHEN   1 THEN  128  -- All Activity
                WHEN  28 THEN  256  -- Schedule
                WHEN  57 THEN  512  -- ContentIndexing
                WHEN  53 THEN 1024  -- ContentIndexing Offline
                WHEN 100 THEN 2048  -- DDB Activity
                ELSE A.opType * -1
            END,
            CASE A.action
                WHEN 2     THEN 1
                ELSE 0
            END,
            CASE A.enableTime
                WHEN 0 THEN 0
                ELSE 1
            END,
            A.enableTime, A.enableTimeZone
    FROM    JMJobAction A
    WHERE   A.appType = 106 AND A.clientId IN (SELECT DISTINCT ClientId FROM #PseudoClientList_tmp__ClientsList)
IF @debug = 1 BEGIN
    SELECT 'activity', * FROM #PseudoClientList_tmp__ActivitiesList
END
DECLARE @commCellName NVARCHAR(256)
DECLARE @csGuid NVARCHAR(40)
SELECT @commCellName = aliasName,
	   @csGuid = csGUID
FROM APP_CommCell
WHERE id = 2
-- 4th. generate xml message
OUTPUT_EXIT:
SET @o_xmlText = (SELECT
                    (SELECT  CL.VSVendor                            AS '@VSInstanceType',
                             CL.[status]                            AS '@status',
							 CL.vOrgGuid                            AS '@vOrgGuid',
							 CL.retireClientPhase					AS '@retireClientPhase',
                            (SELECT CL.ClientId                     AS '@clientId',
                                    CL.ClientName                   AS '@clientName',
                                    CL.ClientDisplayName            AS '@displayName',
                                    CL.ClientHostName               AS '@hostName',
                                    CL.ClientGUID                   AS '@clientGUID',
									@commCellName					AS '@commCellName',
									@csGuid							AS '@csGUID'
                             FOR XML PATH('client'), TYPE),
                            (SELECT
                                    -- Entity Types are defined at http:--ncvs/source/xref/win/vaultcx/Source/Common/XmlMessage/CvEntities.x#11
                                    -- use CLIENT_ENTITY
                                    (SELECT '3'                     AS '@_type_'
                                     FOR XML PATH('entity'), TYPE),
                                    (SELECT AL.ActivityType         AS '@activityType',
                                            AL.ActivityStatus       AS '@enableActivityType',
                                            AL.ActivityStatusDelay  AS '@enableAfterADelay',
                                            (SELECT CONVERT(NVARCHAR, dbo.GetDateTime(AL.EnableTime), 20)                            AS '@timeValue',
                                                    AL.EnableTime                                                                    AS '@time',
                                                    AL.EnableTimeZone                                                                AS '@TimeZoneID',
                                                    '56'                                                                             AS '@_type_',
                                                    (SELECT TimeZoneStdName FROM SchedTimeZone WHERE TimeZoneID = AL.EnableTimeZone) AS '@TimeZoneName'
                                                WHERE  AL.EnableTime <> 0
                                                FOR XML PATH('dateTime'), TYPE)
                                     FROM   #PseudoClientList_tmp__ActivitiesList AL
                                     WHERE  AL.ClientId = CL.ClientId
                                     FOR XML PATH('activityControlOptions'), TYPE)
                             FOR XML PATH('clientActivityControl'), TYPE),
                            (SELECT  CL.InstanceId					 AS '@instanceId',
                                     CL.InstanceName				 AS '@instanceName',
                                     CL.InstanceGuid				 AS '@instanceGUID',
									 CL.ClientId                     AS '@clientId',
									 CL.ClientName                   AS '@clientName',
                                     CL.ClientDisplayName            AS '@displayName',
                                     CL.ClientHostName               AS '@hostName',
                                     CL.ClientGUID                   AS '@clientGUID'
                             FOR XML PATH('instance'), TYPE),
							 (SELECT CL.adminInstanceId				 AS '@instanceId',
									 CL.adminClientId                AS '@clientId',
									 CL.adminClientName                   AS '@clientName',
                                     CL.adminClientDisplayName            AS '@displayName'
								FOR XML PATH('adminInstanceInfo'), TYPE),
							(SELECT
								(SELECT vOrgCompanyId AS '@id', vOrgCompanyName AS '@domainName'
									FOR XML PATH('shortName'), TYPE)
								FOR XML PATH('vCloudAssociatedOrganization'), TYPE),
                            (SELECT CP.propertyTypeId       AS '@clientCustomAttributeType',
                                    CP.stringVal            AS '@attributeValue'
                             FROM   APP_ComponentProp CP
                             WHERE      CP.componentId = CL.ClientId
AND CP.componentType = 3
AND CP.propertyTypeId >= 3000
AND CP.propertyTypeId <= 3199
                             FOR XML PATH('customAttributes'), TYPE)
                     FROM    #PseudoClientList_tmp__ClientsList CL
                     FOR XML PATH('VSPseudoClientsList'), TYPE)
                FOR XML PATH(''), ROOT('App_VSPseudoClientsResponse'))
-- 5th. clean up
IF OBJECT_ID('tempdb.dbo.#Assoc_VS_PseudoClientList') IS NOT null DROP TABLE #Assoc_VS_PseudoClientList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__ClientsList') IS NOT null DROP TABLE #PseudoClientList_tmp__ClientsList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__ActivitiesList')    IS NOT null DROP TABLE #PseudoClientList_tmp__ActivitiesList
IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__CompanyClients')    IS NOT NULL DROP TABLE #PseudoClientList_tmp__CompanyClients
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl')           IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSPseudoClients')
	delete from GxQscripts where name = 'AppGetVSPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClients')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClients'
GO

insert into GXDBVersions values(2, 'AppGetVSPseudoClients',  '00010013000200180000', 'AppGetVSPseudoClients', '00010013000200180000')
GO

