

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSPseudoClientServerInfo.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVSPseudoClientServerInfo.sp,v $ $Id: AppGetVSPseudoClientServerInfo.sp,v 1.6.34.8 2020/09/15 04:57:06 nshah Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 03/07/2014
-- Description:
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSPseudoClientServerInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSPseudoClientServerInfo <<<'
	drop procedure AppGetVSPseudoClientServerInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetVSPseudoClientServerInfo')
	delete from GxQscripts where name = 'AppGetVSPseudoClientServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClientServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClientServerInfo'
GO
print '... Creating Procedure: AppGetVSPseudoClientServerInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSPseudoClientServerInfo
  @i_clientId INT,
  @i_clientName NVARCHAR(512),
  @o_instanceId INT            OUTPUT,
  @o_serverType INT            OUTPUT,
  @o_machineName NVARCHAR(512)  OUTPUT,
  @o_userName NVARCHAR(512)  OUTPUT,
  @o_userPassword NVARCHAR(1024) OUTPUT
AS
-- table APP_InstanceProp contains one of these values as virtual server type
-- this values are defined at http:--ncvs/source/xref/win/vaultcx/Source/Include/AppMgr/AppMgrDefines.h#528
DECLARE @APP_VIRTSERV_UNKNOWN_INSTANCE_TYPE AS INT = 0
DECLARE @APP_VIRTSERV_ESX                   AS INT = 100
DECLARE @APP_VIRTSERV_VIRTUAL_CENTER        AS INT = 101
DECLARE @APP_VIRTSERV_MS_VIRTUAL_SERVER     AS INT = 102
DECLARE @APP_VIRTSERV_XEN_SERVER            AS INT = 201
DECLARE @APP_VIRTSERV_XEN_CENTER            AS INT = 202
DECLARE @APP_VIRTSERV_AMAZON         AS INT = 301
DECLARE @APP_VIRTSERV_AZURE                 AS INT = 401
DECLARE @APP_VIRTSERV_AZURE_V2              AS INT = 402
DECLARE @APP_VIRTSERV_RHEV                  AS INT = 501
DECLARE @APP_VIRTSERV_NUTANIX               AS INT = 601
DECLARE @APP_VIRTSERV_ORACLEVM              AS INT = 701
DECLARE @APP_VIRTSERV_FUSIONCOMPUTE         AS INT = 801
DECLARE @APP_VIRTSERV_OPENSTACK             AS INT = 901
DECLARE @APP_VIRTSERV_DOCKER                AS INT = 1001
DECLARE @APP_VIRTSERV_ORACLE_CLOUD          AS INT = 1101
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
IF @i_clientId = 0 BEGIN
    SET @i_clientId = (SELECT TOP 1 clientId
                           FROM   APP_Application
WHERE      (subclientStatus & 0x00002) = 0
AND (subclientStatus & 0x00004) = 0
                                  AND instance IN (SELECT componentNameId
                                                   FROM   APP_InstanceProp
                                                   WHERE      attrName = 'Virtual Server Instance Type'
                                                          AND dbo.MapVSVendorId(CAST(attrVal AS INT), -1) = @o_serverType)
                      )
END
-- determine clients instance
SET @o_instanceId = CASE WHEN LEN(@i_clientName) = 0 THEN (
		SELECT DISTINCT  APP.instance
		FROM APP_Application APP WITH(nolock)
		LEFT JOIN APP_InstanceProp P WITH(nolock) ON P.componentNameId=APP.instance AND attrName='Discovered VM Instance' and P.modified = 0
		WHERE APP.clientId = @i_clientId AND APP.appTypeId = 106 AND (P.attrVal IS NULL OR P.attrVal = '0')
		)
 ELSE
	(SELECT DISTINCT  APP.instance
	FROM   APP_Application APP WITH(nolock) INNER JOIN APP_Client CL WITH(nolock) ON APP.clientId = CL.id
	LEFT JOIN APP_InstanceProp P WITH(nolock) ON P.componentNameId=APP.instance AND attrName='Discovered VM Instance'  and P.modified = 0
	WHERE  (CL.name = @i_clientName OR CL.displayName = @i_clientName) AND (APP.appTypeId = 106) AND (P.attrVal IS NULL OR P.attrVal = '0'))
END
--if instance id was not found
IF(@o_instanceId IS NULL)
BEGIN
SET @o_instanceId = CASE WHEN LEN(@i_clientName) = 0 THEN
                        (SELECT DISTINCT TOP 1 APP.instance FROM APP_Application APP WITH(nolock) WHERE APP.clientId = @i_clientId AND APP.appTypeId = 106)
                    ELSE
                        (SELECT DISTINCT TOP 1 APP.instance
                         FROM   APP_Application APP WITH(nolock) INNER JOIN APP_Client CL WITH(nolock) ON APP.clientId = CL.id
                         WHERE  (CL.name = @i_clientName OR CL.displayName = @i_clientName) AND (APP.appTypeId = 106))
                    END
END
-- select corresponded values
SELECT @o_serverType    = dbo.MapVSVendorId(CAST((SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Instance Type') AS INT), -1)
SELECT @o_machineName   = ISNULL((SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Host'), '')
-- SELECT @o_userName      = (SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server User')
SET @o_userPassword  = NULL
SET @o_userName      = NULL
DECLARE @credAssocId  INT = 0
SET @credAssocId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Credential Assoc Id' and modified=0),0)
IF @credAssocId > 0
BEGIN
	-- Update user name and password
    EXEC GetCredentialsFromCredentialAssocIds @credAssocId,  @o_userName OUTPUT, @o_userPassword OUTPUT
END
ELSE IF EXISTS(SELECT 1 FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Password') BEGIN
    SELECT @o_userPassword  = (SELECT dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Password')
    SELECT @o_userName      = (SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server User')
	IF @o_serverType = dbo.MapVSVendorId(@APP_VIRTSERV_OPENSTACK, -1) BEGIN
		DECLARE @domainName NVARCHAR(512) = (SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Virtual Server Domain')
		IF LEN(ISNULL(@domainName, '')) > 0 BEGIN
			SET @o_userName = @domainName + CHAR(0x12) + @o_userName
		END
	END
END
-- for HyperV lets keep machine name empty.
IF (LEN(LTRIM(RTRIM(@o_machineName))) = 0) AND (@o_serverType <> @APP_VIRTSERV_MS_VIRTUAL_SERVER) BEGIN
    DECLARE @memberServerClientId INT = @i_clientId -- ISNULL((SELECT  TOP 1 ref.value('client[1]/@clientId', 'INTEGER') FROM @xmlMemberServers.nodes('App_MemberServers/memberServers') R ( ref )), @i_clientId)
    SELECT @o_machineName = net_hostname FROM APP_Client WITH(nolock) WHERE id = @memberServerClientId
END
--IF LEN(LTRIM(RTRIM(@o_machineName))) = 0 BEGIN
--    DECLARE @xmlMemberServers AS XML = (SELECT attrVal FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @o_instanceId AND attrName = 'Vs Member Servers')
--    DECLARE @memberServerClientId INT = ISNULL((SELECT  TOP 1 ref.value('client[1]/@clientId', 'INTEGER') FROM @xmlMemberServers.nodes('App_MemberServers/memberServers') R ( ref )), @i_clientId)
--    SELECT @o_machineName = net_hostname FROM APP_Client WITH(nolock) WHERE id = @memberServerClientId
--END
RETURN @i_clientId
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSPseudoClientServerInfo')
	delete from GxQscripts where name = 'AppGetVSPseudoClientServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSPseudoClientServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetVSPseudoClientServerInfo'
GO

insert into GXDBVersions values(2, 'AppGetVSPseudoClientServerInfo',  '00010006003400080000', 'AppGetVSPseudoClientServerInfo', '00010006003400080000')
GO

