

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSMemberServersXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Note on this SP: This stored procedure will take teh pseudoVSA clients as XML and returns the list of Virtual Server clients related to the pseudo client
--  (this sp is used in rptCCReadinessCheck and other CCR related SP's)
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSMemberServersXML')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSMemberServersXML <<<'
	drop procedure AppGetVSMemberServersXML
END
IF EXISTS (select * from GxQscripts where name='AppGetVSMemberServersXML')
	delete from GxQscripts where name = 'AppGetVSMemberServersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSMemberServersXML')
	delete from GXDBVersions where aliasname = 'AppGetVSMemberServersXML'
GO
print '... Creating Procedure: AppGetVSMemberServersXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSMemberServersXML
  @pseudoVSAClients XML,
  @i_Needexpand INT= 0,
  @tableOutput NVARCHAR(MAX)= ''
AS
  DECLARE @pseudoClientId INT
  DECLARE @VSA_MSNode INT
IF object_id('tempdb.dbo.#pseudoVSAClientsTab') IS NOT NULL drop table #pseudoVSAClientsTab
CREATE TABLE #pseudoVSAClientsTab (clientId int);
insert into #pseudoVSAClientsTab
select [clientId] = ref.value('@id','INTEGER')
from @pseudoVSAClients.nodes('pseudoVSAClients/client') R (ref)
--select * from @pseudoVSAClientsTab--gets the pseudo vsa clients in the CS as rows into a table
IF object_id('tempdb.dbo.#pseudoEntityIdTable') IS NOT NULL drop table #pseudoEntityIdTable
CREATE TABLE #pseudoEntityIdTable (pseudoClientId int, pseudoEntity int);
insert into #pseudoEntityIdTable
SELECT DISTINCT
		App.clientId,
		App.instance
	FROM APP_Application App WITH (READUNCOMMITTED)
		INNER JOIN #pseudoVSAClientsTab Tab ON
			Tab.clientId = App.clientId
AND App.appTypeId = 106
			AND (App.subclientStatus & 6) = 0
IF object_id('tempdb.dbo.#vsMemberServersXml') IS NOT NULL drop table #vsMemberServersXml
CREATE TABLE #vsMemberServersXml (pseudoClientId int, vsMemberServers xml, instanceId INT,subClientId integer );
insert into #vsMemberServersXml  (pseudoClientId , vsMemberServers , instanceId, subClientId )
select ent.pseudoClientId, prop.attrVal,ent.pseudoEntity,0
FROM #pseudoEntityIdTable ent
		INNER JOIN APP_InstanceProp prop WITH (READUNCOMMITTED) ON
			prop.componentNameId = ent.pseudoEntity
			AND prop.attrName = N'VS Member Servers'
			AND prop.modified = 0
TRUNCATE TABLE #pseudoEntityIdTable --freeing @pseudoEntityIdTable, to reuse it to get vs member servers using subclient entity
insert into #pseudoEntityIdTable
SELECT DISTINCT
		App.clientId ,
		App.id
	FROM #pseudoVSAClientsTab Tab
		INNER JOIN APP_Application App WITH (READUNCOMMITTED) ON
			App.clientId = Tab.clientId
			AND (App.subclientStatus & 6) = 0
insert into #vsMemberServersXml (pseudoClientId , vsMemberServers, instanceId , subClientId )
SELECT
		ent.pseudoClientId,
		prop.attrVal,
		App.instance,
		ent.pseudoEntity
	FROM App_SubClientProp prop WITH (READUNCOMMITTED)
		INNER JOIN #pseudoEntityIdTable ent ON
			prop.componentNameId = ent.pseudoEntity
			AND prop.attrName = N'Virtual Server Proxy Client List'
			AND prop.cs_attrName = CHECKSUM(N'Virtual Server Proxy Client List')
			AND prop.modified = 0
		INNER JOIN APP_Application App WITH (READUNCOMMITTED) ON
			App.ID = ent.pseudoEntity
			AND (App.subclientStatus & 6) = 0
IF object_id('tempdb.dbo.#clientListVSA') IS NOT NULL drop table #clientListVSA
CREATE TABLE #clientListVSA (pseudoClientId int, clientId int, clientGroupId int)
insert into #clientListVSA
SELECT
	[pseudoClientId],
    [clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
    [clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
FROM  #vsMemberServersXml srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
delete #clientListVSA where clientId = 0 and clientGroupId = 0
IF (@i_Needexpand = 0)
BEGIN
	insert into #clientListVSA
	select
		E.pseudoClientId,
		CGA.clientId, 0
		from #clientListVSA E,
		APP_ClientGroupAssoc CGA WITH (READUNCOMMITTED)
		where E.clientId =0
		and E.clientGroupId = CGA.clientGroupId
		and not exists (select clientId from #clientListVSA T where CGA.clientId = T.clientId)
	delete from #clientListVSA where clientId =0 -- we have already expanded the groups, so eliminate the group entries
		-- Backup Proxy List : delete clients with no VSA packages. 713 is VSA package for Windows and 1136 is VSA package for UNIX.
		delete #clientListVSA where clientId not in (select E.clientId from  #clientListVSA E,simInstalledPackages SIP WITH (READUNCOMMITTED) where
		E.clientId = SIP.ClientId and SIP.simPackageID IN (713, 1136))
		-- Backup Proxy List : So delete clients with deconfigured/deleted VSA agents.
		delete #clientListVSA where clientId in (select E.clientId from  #clientListVSA E,App_IdaName Ida WITH (READUNCOMMITTED) where
		E.clientId = Ida.ClientId and Ida.appTypeId = 106 and (status & 4) = 4)
	--delete duplicate rows
	;WITH numbered AS
		(
			 SELECT clientId, row_number() OVER ( PARTITION BY clientId ORDER BY clientId ) AS RN
			 FROM     #clientListVSA
		)
	DELETE FROM numbered WHERE RN > 1
	select pseudoClientId, clientId from #clientListVSA order by pseudoClientId
END
ELSE
BEGIN
DECLARE @ExistingTempTable INT = 1
IF object_id('tempdb.dbo.#AppGetVSMemberServersXML_InputTbl') IS NULL
BEGIN
	SET @ExistingTempTable = 0
	CREATE TABLE #AppGetVSMemberServersXML_InputTbl(pseudoClient int, clientId int, clientGroupId int,instanceId integer,subClientId integer)
END
INSERT INTO #AppGetVSMemberServersXML_InputTbl (pseudoClient , clientId, clientGroupId,instanceId,subClientId )
	SELECT
		[pseudoClientId],
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0),
		instanceId,
		subClientId
	FROM  #vsMemberServersXml srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
IF (LEN(@tableOutput) <= 0)
	BEGIN
		SELECT pseudoClient , clientId, clientGroupId,instanceId,subClientId from #AppGetVSMemberServersXML_InputTbl
	END
IF (@ExistingTempTable = 0)
IF object_id('tempdb.dbo.#AppGetVSMemberServersXML_InputTbl') IS NOT null  DROP TABLE #AppGetVSMemberServersXML_InputTbl
IF object_id('tempdb.dbo.#pseudoEntityIdTable') IS NOT NULL drop table #pseudoEntityIdTable
IF object_id('tempdb.dbo.#vsMemberServersXml') IS NOT NULL drop table #vsMemberServersXml
IF object_id('tempdb.dbo.#clientListVSA') IS NOT NULL drop table #clientListVSA
IF object_id('tempdb.dbo.#pseudoVSAClientsTab') IS NOT NULL drop table #pseudoVSAClientsTab
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSMemberServersXML')
	delete from GxQscripts where name = 'AppGetVSMemberServersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSMemberServersXML')
	delete from GXDBVersions where aliasname = 'AppGetVSMemberServersXML'
GO

insert into GXDBVersions values(2, 'AppGetVSMemberServersXML',  '00000000000000000000', 'AppGetVSMemberServersXML', '00000000000000000000')
GO

