

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSMemberServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVSMemberServers')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSMemberServers <<<'
	drop procedure AppGetVSMemberServers
END
IF EXISTS (select * from GxQscripts where name='AppGetVSMemberServers')
	delete from GxQscripts where name = 'AppGetVSMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetVSMemberServers'
GO
print '... Creating Procedure: AppGetVSMemberServers'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVSMemberServers
  @xmlText XML
AS
--INPUTS
DECLARE  @psuedoEntityId INTEGER
DECLARE  @psuedoEntityType INTEGER
DECLARE  @expand INTEGER=1
DECLARE  @inheritedLevel INTEGER=0
DECLARE  @vsMemberServers XML
DECLARE @userId INTEGER =0
DECLARE @pseudoClientId INTEGER = 0
DECLARE @appTypeId INTEGER= 106  -- By default set apptype as VSA
DECLARE @servicePack INT = 0
DECLARE @inJobID  BIGINT = 0
DECLARE @useHigherPrecedenceForSCProxy INTEGER = 0
DECLARE @instanceType INTEGER = 0
DECLARE @includeInstanceLevelAccessNodes INTEGER = 0
SET @vsMemberServers = @xmlText
/*
set @vsMemberServers = '<App_MemberServers>
  <memberServers>
    <client _type_="3" clientId="2" clientName="proxy10" />
  </memberServers>
    <memberServers>
    <client _type_="4" clientId="3" clientName="proxy10" />
  </memberServers>
  <memberServers>
    <client _type_="4" clientGroupId="3" />
  </memberServers>
  <memberServers>
    <client _type_="5" clientId="4" clientName="proxy10" />
  </memberServers>
</App_MemberServers>'
*/
IF object_id('tempdb.dbo.#vsaClientInfo') IS NOT null  DROP TABLE #vsaClientInfo
CREATE TABLE #vsaClientInfo(clientId INT, servicepackId INT DEFAULT 0);
SELECT @expand = ISNULL(ref.value('@expandClientGroup', 'INTEGER'), 0), @psuedoEntityType = ISNULL(ref.value('entity[1]/@_type_', 'INTEGER'),0), @servicePack = ISNULL(ref.value('@servicePack', 'INTEGER'), 0),
@appTypeId = ISNULL(ref.value('@appTypeId', 'INT'), 106), @inJobID = ISNULL(ref.value('@jobId', 'BIGINT'), 0), @instanceType = ISNULL(ref.value('@instanceType', 'INT'), 0), @includeInstanceLevelAccessNodes = ISNULL(ref.value('@includeInstanceLevelAccessNodes', 'INT'), 0)
	FROM @vsMemberServers.nodes('App_GetVSMemberServersRequest') R ( ref )
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetVSMemberServersRequest/processinginstructioninfo/user') R ( ref )),0)
--select @vsMemberServers
DECLARE @EntityList TABLE ( priority INT IDENTITY, clientId INT, clientGroupId INT )
DECLARE @EntityListCrossVCenter TABLE ( priority INT IDENTITY, clientId INT, clientGroupId INT )
SELECT @useHigherPrecedenceForSCProxy = ISNULL(value, 0) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'useHigherPrecedenceForSCProxy'
IF @inJobID != 0
BEGIN
	INSERT INTO @EntityList
	SELECT
		[clientId] = ISNULL(CONVERT(xml,value).value('(memberServers/client/@clientId)[1]','INTEGER'),0),
		[clientGroupId] = ISNULL(CONVERT(xml,value).value('(memberServers/client/@clientGroupId)[1]','INTEGER'),0)
FROM dbo.GetAllJobOptions(@inJobID) where optionId = 1351783534
	DELETE FROM @EntityList WHERE clientId = 0 AND clientGroupId = 0 -- Delete garbage entries if any
	IF((SELECT COUNT(*) FROM @EntityList) = 0) -- Memeber servers not set at job level, let us query subclient
	BEGIN
		SET @psuedoEntityType = 7-- EntityType_SUBCLIENT_ENTITY
	END
	ELSE
	BEGIN
		SET @inheritedLevel = 0
		SET @psuedoEntityType = 0 -- Resetting the entity type so that no further query happens
	END
END
-- Modify the request to instance level if client level request is made for cosmos db
-- and we already have an cosmos db instance configured
IF @appTypeId = 134 AND @psuedoEntityType = 3 AND @instanceType = 23 AND (SELECT ISNULL(@vsMemberServers.value('/App_GetVSMemberServersRequest[1]/entity[1]/@instanceId', 'INT'), 0)) = 0
BEGIN
	DECLARE @instanceId INT = ISNULL(( SELECT DISTINCT TOP 1 app.instance FROM APP_Application app WITH (NOLOCK)
					INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON app.instance = IP.componentNameId
					WHERE IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal = @instanceType
					AND app.subclientStatus & 0x00004 = 0 AND app.subclientStatus & 0x00002 = 0 -- subclient status is not deleted / uninstalled
AND app.appTypeId = 134
					AND app.clientId = @vsMemberServers.value('/App_GetVSMemberServersRequest[1]/entity[1]/@clientId', 'INT') ), 0)
	IF @instanceId <> 0
	BEGIN
		SET @vsMemberServers.modify('
		insert attribute instanceId {sql:variable("@instanceId")}
		into (/App_GetVSMemberServersRequest/entity)[1] ')
		SET @psuedoEntityType = 5
	END
END
IF @psuedoEntityType = 4 -- EntityType_APPTYPE_ENTITY
BEGIN
	DECLARE @apptypeParam INT
	SELECT @apptypeParam = ISNULL(ref.value('entity[1]/@applicationId', 'INTEGER'),0)
			FROM    @vsMemberServers.nodes('App_GetVSMemberServersRequest') R ( ref )
	INSERT INTO @EntityList
	SELECT
		clientId, 0
		FROM	APP_iDAName
		WHERE	appTypeId = @apptypeParam AND (Status & 4) = 0
	-- Security check will happen later.
END
IF @psuedoEntityType = 7 -- EntityType_SUBCLIENT_ENTITY
BEGIN
	SELECT @psuedoEntityId = ISNULL(ref.value('entity[1]/@subclientId', 'INTEGER'),0)
			FROM    @vsMemberServers.nodes('App_GetVSMemberServersRequest') R ( ref )
	--This API might be called even before Job is inserted into JM tables, Hence checking TM tables for the operation Type.
	DECLARE @operationType INTEGER = ISNULL((SELECT TOP 1 operationType FROM TM_JobRequest WITH(NOLOCK) WHERE jobReQuestId = (SELECT TOP 1 jobReQuestId FROM TM_Jobs WITH(NOLOCK) WHERE jobid =  @inJobID)),0)
	IF((SELECT COUNT(*) FROM @EntityList) = 0)
	BEGIN
		--Get the parent subclient if IndexingV2
		DECLARE @parentsubclientId INT =0
		select TOp 1 @parentsubclientId = parentAppid from JMJobDataLink where childAppid=@psuedoEntityId order by childJobId desc
		IF  @parentsubclientId <> 0
			SET @psuedoEntityId = @parentsubclientId
		set @vsMemberServers = (select attrVal from App_SubClientProp where componentNameId = @psuedoEntityId and attrName = 'Virtual Server Proxy Client List' and modified =0)
		set @pseudoClientId = (select distinct clientId from App_Application with (nolock) where id = @psuedoEntityId)
		INSERT INTO @EntityList
		([clientId],[clientGroupId])
		SELECT
			[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
			[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
		FROM    @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
		IF(((SELECT COUNT(*) FROM @EntityList) = 0) OR (((SELECT COUNT(*) FROM @EntityList) > 0) AND @useHigherPrecedenceForSCProxy = 0))--If no proxy is set at subclient level
		BEGIN
			--For backup copy jobs look for cross vcenter proxy
IF  @operationType = 4028 --SNAPTOTAPE
			BEGIN
				DECLARE @vCenterProxyStr VARCHAR(MAX) = (select attrVal from APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @psuedoEntityId  AND attrName = 'Virtual Server SNAP info' and modified = 0)
				IF  @vCenterProxyStr IS NOT NULL
				BEGIN
					DECLARE @vCenterProxyXML XML = CONVERT(XML,@vCenterProxyStr)
					DECLARE @vCenterProxyClient INTEGER = 0
					DECLARE @proxyInstance INTEGER = 0
					SELECT
							@vCenterProxyClient = ISNULL(ref.value('vsInstance[1]/@clientId', 'INTEGER'),0),
							@proxyInstance = ISNULL(ref.value('vsInstance[1]/@instanceId', 'INTEGER'),0)
						FROM    @vCenterProxyXML.nodes('VirtualServer_VSSnapInfo') R ( ref )
					IF @vCenterProxyClient != 0
					BEGIN
						IF @proxyInstance = 0
							SET @proxyInstance = ISNULL((SELECT TOP 1 instance FROM APP_Application WITH(NOLOCK) WHERE clientId = @vCenterProxyClient AND appTypeId = 106),0)
						--Only if cross VCenter is configured
						IF @proxyInstance <> (select instance from APP_Application where id = @psuedoEntityId)
						BEGIN
							set @vsMemberServers = (select attrVal from APP_InstanceProp WITH(NOLOCK) where componentNameId = @proxyInstance and attrName = 'VS Member Servers' and modified =0)
							INSERT INTO @EntityListCrossVCenter
							([clientId],[clientGroupId])
								SELECT
									[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
									[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
								FROM    @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
							IF(((SELECT COUNT(*) FROM @EntityList) > 0) AND (SELECT COUNT(*) FROM @EntityListCrossVCenter) > 0)
								DELETE FROM @EntityList
							INSERT INTO @EntityList([clientId],[clientGroupId])
							SELECT [clientId],[clientGroupId] FROM @EntityListCrossVCenter
							IF((SELECT COUNT(*) FROM @EntityList) > 0)
							BEGIN
								set @pseudoClientId =  @vCenterProxyClient
								SET  @inheritedLevel = 5
								SET @psuedoEntityType = 0 -- Resetting the entity type so that no further query happens
							END
						END
					END
				END
			END
			--Still no proxy found, Lets look at the instance level
			IF((SELECT COUNT(*) FROM @EntityList) = 0 OR @includeInstanceLevelAccessNodes = 1)
			BEGIN
				SET @psuedoEntityType = 5-- EntityType_INSTANCE_ENTITY
				SET @psuedoEntityId = (select instance from APP_Application where id = @psuedoEntityId)
			END
			ELSE
				SET @inheritedLevel = 7 -- EntityType_SUBCLIENT_ENTITY
		END
	END
END
IF  @psuedoEntityType = 5 -- EntityType_INSTANCE_ENTITY
BEGIN
	SELECT @psuedoEntityId = ISNULL(ref.value('entity[1]/@instanceId', 'INTEGER'),0)
			FROM    @vsMemberServers.nodes('App_GetVSMemberServersRequest') R ( ref )
	DECLARE @pseudoInstanceId INTEGER = @psuedoEntityId
	--If admin account is enabled, fetch proxy from the admin instance
	IF EXISTS (select * from APP_InstanceProp where componentNameId = @psuedoEntityId and attrName = 'Amazon Enable Admin Account' and attrVal = '1' and modified = 0)
	BEGIN
		set @pseudoInstanceId = CAST(ISNULL((select attrVal from APP_InstanceProp where componentNameId = @psuedoEntityId and attrName = 'Amazon Admin Instance Id' and modified = 0),0) AS int)
	END
	set @vsMemberServers = (select attrVal from APP_InstanceProp where componentNameId = @pseudoInstanceId and attrName = 'VS Member Servers' and modified =0)
	set @pseudoClientId = (select distinct clientId from App_Application with (nolock) where instance = @psuedoEntityId)
	INSERT INTO @EntityList
	([clientId],[clientGroupId])
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
	FROM    @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
	--Delete duplicate entries
	DELETE FROM @EntityList WHERE priority NOT IN (SELECT MIN(priority) FROM @EntityList GROUP BY clientId, clientGroupId)
	IF((SELECT COUNT(*) FROM @EntityList) = 0)
	BEGIN
		SET  @inheritedLevel = 0
		GOTO ENDSP
	END
	ELSE
		SET @inheritedLevel = 3 -- EntityType_INSTANCE_ENTITY
END
IF  @psuedoEntityType = 3 -- EntityType_CLIENT_ENTITY
BEGIN
	SELECT @psuedoEntityId = ISNULL(ref.value('entity[1]/@clientId', 'INTEGER'),0)
			FROM    @vsMemberServers.nodes('App_GetVSMemberServersRequest') R ( ref )
	set @vsMemberServers = (select attrVal from APP_ClientProp where componentNameId = @psuedoEntityId and attrName = 'VS Member Servers' and modified =0)
	set @pseudoClientId = @psuedoEntityId
	INSERT INTO @EntityList
	([clientId],[clientGroupId])
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
	FROM    @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
	IF((SELECT COUNT(*) FROM @EntityList) = 0)
	BEGIN
		SET  @inheritedLevel = 0
		GOTO ENDSP
	END
	ELSE
		SET @inheritedLevel = 3 -- EntityType_CLIENT_ENTITY
END
IF @inJobID = 0 AND @psuedoEntityType = 0 -- if job id and pseudoEntityType is not set, check if access nodes passed in request
BEGIN
	INSERT INTO @EntityList
	([clientId],[clientGroupId])
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
	FROM    @vsMemberServers.nodes('App_GetVSMemberServersRequest/accessNodes/memberServers') R ( ref )
	IF((SELECT COUNT(*) FROM @EntityList) = 0)
	BEGIN
		SET  @inheritedLevel = 0
		GOTO ENDSP
	END
	ELSE
		SET @inheritedLevel = 0
END
-- Security check. (Do all the security check in this part. Call one stored procedure, it will get all details in one shot).
-- Previous version of this stored procedure was first calling Get User Objects, then filtering the result set with Get Permissions On Entities based on Use Proxy / Agent Management permission check.
-- This version does all this in one call. If use proxy check is not disabled, then it gets all clients with any permission. Else it will get those clients on which user has Use Proxy / Agent Management.
IF @userID > 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getIdaObjectsOutput') IS NOT NULL
		DROP TABLE #getIdaObjectsOutput
	CREATE TABLE #getIdaObjectsOutput
	(
		clientId INT,
		appTypeId INT,
		instanceId INT,
		backupsetId INT,
		subclientId INT
	)
	DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
	IF @disableUseProxyCheck = 1			-- Get all clients this user can see.
	BEGIN
EXEC sec_getIdaObjectsForUser @userId, 3, 0, 0, '#getIdaObjectsOutput'
	END
	ELSE									-- Specifically check for Use Proxy / Agent Management permission.
	BEGIN
EXEC sec_getIdaObjectsForUser @userId, 3, 0, 0, '#getIdaObjectsOutput', 1, '252, 2'
	END
	IF @pseudoClientId = 0 OR (NOT EXISTS (SELECT clientId FROM #getIdaObjectsOutput WHERE clientId = @pseudoClientId))
	BEGIN
		DELETE E
		FROM @EntityList E
			LEFT JOIN #getIdaObjectsOutput O
				ON E.clientId = O.clientId
		WHERE
			O.clientId IS NULL
	END
END
IF @servicePack > 0
BEGIN
	INSERT INTO #vsaClientInfo
	(clientId, servicepackId)
	SELECT E.clientId, V.spLevel
	FROM @EntityList E
	CROSS APPLY GetSpVersionInfo(E.clientId) V
	DELETE @EntityList
	WHERE clientId IN (SELECT clientId FROM #vsaClientInfo WHERE servicepackId < @servicePack)
END
DECLARE @ClientList TABLE ( priority INT , clientId INT )
--SELECT ONLY CLIENT MEMBER SERVERS
INSERT INTO @ClientList
select priority,
clientId
from @EntityList
where (clientGroupId = 0 and clientId <> 0)
order by priority
IF EXISTS ( SELECT 1
			FROM (SELECT ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0) AS clientGroupId
					FROM @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )) AS TEMP
			WHERE clientGroupId > 0
		  )
BEGIN
	INSERT INTO @EntityList
	([clientId],[clientGroupId])
	SELECT
		[clientId] = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0),
		[clientGroupId] = ISNULL(ref.value('client[1]/@clientGroupId', 'INTEGER'),0)
	FROM    @vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
END
IF @expand=1
BEGIN
	DECLARE @tempFinalClientList table( priority integer, clientId integer)
	--SELECT ONLY CLIENT GROUP MEMBER SERVERS
	INSERT INTO @tempFinalClientList
	select priority,
	CGA.clientId
	from @EntityList E Join
	APP_ClientGroupAssoc CGA
	ON E.clientGroupId = CGA.clientGroupId
	where E.clientId =0
	order by E.priority
	INSERT INTO @ClientList
	select MIN(priority),clientId FROM @tempFinalClientList
	group by clientId
END
DECLARE @PackageList TABLE ( packageID INT )
IF @appTypeId = 125
BEGIN
INSERT INTO @PackageList VALUES (1209) , (362)
END
ELSE IF @appTypeId = 104
BEGIN
INSERT INTO @PackageList VALUES (1208) , (358)
END
ELSE IF @appTypeId = 22
BEGIN
INSERT INTO @PackageList VALUES (1204) , (352)
END
ELSE IF @appTypeId = 134 AND @instanceType = 23 -- cosmos db
BEGIN
INSERT INTO @PackageList VALUES (1140), (730), (1136) , (713)
END
ELSE IF @appTypeId = 134 AND @instanceType = 3 -- salesforce
BEGIN
INSERT INTO @PackageList VALUES (1140)
END
ELSE
BEGIN
INSERT INTO @PackageList VALUES (1136) , (713)
END
-- Backup Proxy List : delete clients with no selected packages.
IF @appTypeId = 134 AND @instanceType = 23
	-- in case of cosmos db select access nodes with both cloud apps and vsa package
	DELETE C FROM @ClientList C
	INNER JOIN (
		   SELECT E.clientId, COUNT(sim.simPackageID) AS pkgCount FROM @ClientList E
		   INNER JOIN simInstalledPackages sim ON E.clientId = sim.ClientId
		   WHERE sim.simPackageID IN (SELECT packageID FROM @PackageList)
		   GROUP BY E.clientId
	) T ON T.clientId = C.clientId AND T.pkgCount < 2
ELSE
	delete @ClientList where clientId not in (select E.clientId from  @ClientList E, @PackageList PKGLIST, simInstalledPackages SIP WHERE
	E.clientId = SIP.ClientId AND SIP.simPackageID = PKGLIST.packageID)
-- Backup Proxy List : So delete clients with deconfigured/deleted selected agents.
delete @ClientList where clientId in (select E.clientId from  @ClientList E JOIN App_IdaName Ida ON
E.clientId = Ida.ClientId WHERE Ida.appTypeId = @appTypeId and (status & 4) = 4)
--delete all clients with MA in maintenance mode
delete clList FROM @ClientList clList
INNER JOIN MMHost MH ON clList.clientId = MH.clientId
WHERE MH.Attribute & 16 != 0
--delete all clients with version less than current version
IF @pseudoClientId <> 0
BEGIN
	-- 9.0 to 11.0 return the member server of same version as pseudoclient
	delete  @ClientList
	FROM @ClientList T join App_Client C
	ON T.clientId = C.id
	where C.releaseId < IsNULL( ( select releaseId from
		App_client with (nolock) where id = @pseudoClientId
		and releaseId <= 16),0)
END
-- Security check already done.
IF @expand=1
BEGIN
	set @vsMemberServers = (select (select C.id as '@clientId',
										   C.name as '@clientName',
										   C.net_hostname as '@hostName'
									FROM APP_Client C
									where C.id = clientId
									FOR XML PATH('client'),TYPE)
							FROM @ClientList order by priority
							FOR XML PATH('memberServers'),TYPE)
END
ELSE
BEGIN
	delete @EntityList
	where clientGroupId = 0 and
	clientId not in (select clientId from @ClientList )
	IF @psuedoEntityType = 4
	BEGIN
		set @vsMemberServers = (select (select C.id as '@clientId',
										   C.name as '@clientName',
										   C.net_hostname as '@hostName'
									FROM APP_Client C
									where C.id = clientId
									FOR XML PATH('client'),TYPE)
						FROM @EntityList order by priority
						FOR XML PATH('memberServers'),TYPE)
	END
	ELSE
	BEGIN
		-- For fast proceeding not filling up names.
		set @vsMemberServers = (select (select clientId as '@clientId',
					  clientGroupId as '@clientGroupId'
				FOR XML PATH('client'),TYPE)
		FROM @EntityList order by priority
		FOR XML PATH('memberServers'),TYPE)
	END
END
ENDSP:
	SET @xmlText = (select  @inheritedLevel as 'associatedClientsSetLevel',
							(select @vsMemberServers
							 FOR XML PATH ('associatedClients'),TYPE)
					FOR XML PATH(''),ROOT('App_GetVSMemberServersResponse'))
IF OBJECT_ID('tempdb..#lt_AppGetVSMemberServersOutput') IS NOT NULL
	INSERT INTO #lt_AppGetVSMemberServersOutput
	SELECT @xmlText
ELSE
	SELECT @xmlText as o_xmlString
IF object_id('tempdb.dbo.#vsaClientInfo') IS NOT null  DROP TABLE #vsaClientInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSMemberServers')
	delete from GxQscripts where name = 'AppGetVSMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetVSMemberServers'
GO

insert into GXDBVersions values(2, 'AppGetVSMemberServers',  '00000000000000000000', 'AppGetVSMemberServers', '00000000000000000000')
GO

