

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSInstancesList.sp] ---------- 

--  +-----------------------------------------------------------------------+
--  |           Procedure : "AppGetVSInstancesList"
--  |   This Procedure is used to get the list of available virtual server instances.
--	|	This will be called while launching VirtualizeMe dialog from GUI
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
--Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVSInstancesList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSInstancesList <<<'
	drop procedure AppGetVSInstancesList
END
IF EXISTS (select * from GxQscripts where name='AppGetVSInstancesList')
	delete from GxQscripts where name = 'AppGetVSInstancesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSInstancesList')
	delete from GXDBVersions where aliasname = 'AppGetVSInstancesList'
GO
print '... Creating Procedure: AppGetVSInstancesList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVSInstancesList
--Input Arguments
  @inXml XML  OUTPUT
AS
DECLARE @i_vendor       int=0
DECLARE @instanceType   int =0
DECLARE @userId			int
SET @userId = ( SELECT ISNULL(@inXml.value('/App_GetVSInstancesListReq[1]/userEntity[1]/@userId', 'INT'),0) )
set @i_vendor = (SELECT ISNULL(@inXml.value('/App_GetVSInstancesListReq[1]/@vendor', 'INT'),0) )
set @instanceType = ISNULL(( case when @i_vendor =1 then 101
	                when @i_vendor =2 then 102
					when @i_vendor =4 then 301
					when @i_vendor =5 then 401
					when @i_vendor =7 then 402
					when @i_vendor =13 then 1101
					when @i_vendor =11 then 1001
					when @i_vendor =17 then 403
				end
			),0)
CREATE TABLE #clientLstWithAgentMgmtCap
(
    clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
)
EXEC sec_getIdaObjectsForUser @userId, 3 , 2, 0, '#clientLstWithAgentMgmtCap'
DECLARE @tempTable TABLE
(
	instanceId INT,
	clientId INT,
	vcenterName NVARCHAR(255),
	clientName NVARCHAR(255)
)
INSERT INTO @tempTable(instanceId, clientId, clientName)
	SELECT DISTINCT I.id , Cli.id, Cli.name
	FROM APP_InstanceName I
	INNER JOIN APP_InstanceProp Prop ON I.id = Prop.componentNameId
						AND Prop.attrName LIKE 'Virtual Server Instance Type'
						AND Prop.modified = 0
						AND ( @instanceType =0 or prop.attrVal = @instanceType )
	INNER JOIN APP_Application Apl ON Apl.instance = I.id
	INNER JOIN APP_Client Cli ON Cli.id = Apl.clientId
	INNER JOIN #clientLstWithAgentMgmtCap clientList
	on clientList.clientId = Cli.id
	WHERE (Cli.status & 2 = 0) AND (I.status & 2 = 0)
	and not exists ( select id from APP_InstanceProp where componentNameId = I.id and attrName = 'Cloud Apps Instance Type' and modified =0)
UPDATE Tbl
SET vcenterName = Prop.attrVal
FROM @tempTable AS Tbl INNER JOIN APP_InstanceProp Prop ON Tbl.instanceId = Prop.componentNameId
WHERE Prop.attrName = 'Virtual Server Host' AND modified = 0
SET @inXml = ISNULL(
						(SELECT tmpTbl.vcenterName AS '@vCenterName',
							(SELECT tmpTbl.instanceId AS '@instanceId', tmpTbl.clientId AS '@clientId', tmpTbl.clientName AS '@clientName'
							FOR XML PATH('instanceEntity'),TYPE)
						FROM @tempTable AS tmpTbl
						FOR XML PATH('dataCenterList'),
						ROOT('Ida_GetDataCenterListResp')), '<Ida_GetDataCenterListResp/>')
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSInstancesList')
	delete from GxQscripts where name = 'AppGetVSInstancesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSInstancesList')
	delete from GXDBVersions where aliasname = 'AppGetVSInstancesList'
GO

insert into GXDBVersions values(2, 'AppGetVSInstancesList',  '00000000000000000000', 'AppGetVSInstancesList', '00000000000000000000')
GO

