

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSAProxiesVersionInfo.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVSAProxiesVersionInfo"
--	|	This Procedure is used to get version info of a client
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSAProxiesVersionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSAProxiesVersionInfo <<<'
	drop procedure AppGetVSAProxiesVersionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetVSAProxiesVersionInfo')
	delete from GxQscripts where name = 'AppGetVSAProxiesVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAProxiesVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetVSAProxiesVersionInfo'
GO
print '... Creating Procedure: AppGetVSAProxiesVersionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSAProxiesVersionInfo
  @vsaClientID INT
AS
  DECLARE @proxyClientId INT
  DECLARE @servicepackinfo VARCHAR(256)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @pseudoVSAClients XML
    IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null  DROP TABLE #pseudoVSANodes
    CREATE TABLE #pseudoVSANodes(pseudoClient INT, node INT);
    IF object_id('tempdb.dbo.#vsaClientInfo') IS NOT null  DROP TABLE #vsaClientInfo
    CREATE TABLE #vsaClientInfo(clientId INT, servicepackinfo INT DEFAULT 0);
	SET @pseudoVSAClients = (SELECT (
	SELECT @vsaClientID  AS '@id'
	FOR XML PATH('client'), TYPE) FOR XML PATH('pseudoVSAClients'));
	INSERT INTO #pseudoVSANodes
	EXEC AppGetVSMemberServersXML @pseudoVSAClients
	DECLARE @servicepacknostartposition AS INT
	INSERT INTO #vsaClientInfo
	(clientId, servicepackinfo)
	SELECT E.node, V.spLevel
	FROM #pseudoVSANodes E
	CROSS APPLY GetSpVersionInfo(E.node) V
	SELECT clientId, servicepackinfo
	FROM #vsaClientInfo
    IF object_id('tempdb.dbo.#vsaClientInfo') IS NOT null  DROP TABLE #vsaClientInfo
    IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null  DROP TABLE #pseudoVSANodes
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSAProxiesVersionInfo')
	delete from GxQscripts where name = 'AppGetVSAProxiesVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAProxiesVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetVSAProxiesVersionInfo'
GO

insert into GXDBVersions values(2, 'AppGetVSAProxiesVersionInfo',  '00000000000000000000', 'AppGetVSAProxiesVersionInfo', '00000000000000000000')
GO

