

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSAMemberServersByClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===========================================================================+
--  |			AppGetVSAMemberServersByClientGroup									|
--  |   Procedure to get VSA Members list from given client group					|
--  +===========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSAMemberServersByClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSAMemberServersByClientGroup <<<'
	drop procedure AppGetVSAMemberServersByClientGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetVSAMemberServersByClientGroup')
	delete from GxQscripts where name = 'AppGetVSAMemberServersByClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAMemberServersByClientGroup')
	delete from GXDBVersions where aliasname = 'AppGetVSAMemberServersByClientGroup'
GO
print '... Creating Procedure: AppGetVSAMemberServersByClientGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSAMemberServersByClientGroup
-----------------------------------------------------------
---    PARAMETERS				                         ---
  @inXmlReq XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(1024) = ''
	DECLARE @i_userId				INT = 0
	DECLARE @OutXmlReq				XML = NULL
	DECLARE @i_clientGrpId			INT = 0
	IF OBJECT_ID('tempdb.dbo.#tmpVSAMembers') IS NOT NULL
		DROP TABLE #tmpVSAMembers
	CREATE TABLE #tmpVSAMembers (clientId INT , clientName NVARCHAR(MAX))
	CREATE CLUSTERED INDEX #tmpVSAMembers_clientId_Idx1 ON #tmpVSAMembers (clientId)
	SET @i_userId = ISNULL((select @inXmlReq.value('(App_GetVSAClientGroupMemberListReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	SET @i_clientGrpId = ISNULL((select @inXmlReq.value('(App_GetVSAClientGroupMemberListReq/@clientGroupId)[1]', 'INT')), 0)
	IF @i_userId!=0
	BEGIN
		--Security
		IF OBJECT_ID('tempdb.dbo.#tempclientSecurityObjects') IS NOT Null DROP TABLE #tempclientSecurityObjects
		create table  #tempclientSecurityObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
		CREATE CLUSTERED INDEX #tempclientSecurityObjects_clientId_Idx1 ON #tempclientSecurityObjects (clientId)
EXEC sec_getIdaObjectsForUser @i_userId,3,0,0,'#tempclientSecurityObjects'
		INSERT INTO #tmpVSAMembers ( clientId, clientName)
		SELECT C.id as clientId, C.net_hostname as clientName
		FROM APP_ClientGroupAssoc (NOLOCK) CG
		JOIN simInstalledPackages (NOLOCK) S ON S.ClientId = CG.clientId
		JOIN APP_Client (NOLOCK) C ON C.id = S.ClientId
		JOIN #tempclientSecurityObjects TMP ON TMP.clientId = S.ClientId
AND S.simPackageID IN (713, 1136) and  CG.clientGroupId = @i_clientGrpId
AND C.status & 0x00002 != 0x00002 /*UNINSTALLED*/
AND C.status & 0x00004 != 0x00004 /*DELETE*/
AND C.status & 0x00020 != 0x00020 /*Hidden*/
	END
	ELSE
	BEGIN
		INSERT INTO #tmpVSAMembers ( clientId, clientName)
		SELECT C.id as clientId, C.net_hostname as clientName
		FROM APP_ClientGroupAssoc (NOLOCK) CG
		JOIN simInstalledPackages (NOLOCK) S ON S.ClientId = CG.clientId
		JOIN APP_Client (NOLOCK) C ON C.id = S.ClientId
AND S.simPackageID IN (713, 1136) and  CG.clientGroupId = @i_clientGrpId
AND C.status & 0x00002 != 0x00002 /*UNINSTALLED*/
AND C.status & 0x00004 != 0x00004 /*DELETE*/
AND C.status & 0x00020 != 0x00020 /*Hidden*/
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @clientList table(clientId int)
	INSERT INTO @clientList SELECT DISTINCT clientId FROM #tmpVSAMembers
	SET @OutXmlReq = (
						SELECT
							(
								SELECT  clientId as '@clientId' FROM @clientList C
								FOR XML PATH ('clients'), type
							)
						FOR XML PATH('App_VSAClientGroupMemberListResp')
					 )
ERROR_EXIT:
    IF @errorCode <> 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
								AS '@errorMessage' FOR XML PATH('App_VSAClientGroupMemberListResp'))
	IF @OutXmlReq IS NULL
		SET @OutXmlReq = '<App_VSAClientGroupMemberListResp />'
	SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSAMemberServersByClientGroup')
	delete from GxQscripts where name = 'AppGetVSAMemberServersByClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAMemberServersByClientGroup')
	delete from GXDBVersions where aliasname = 'AppGetVSAMemberServersByClientGroup'
GO

insert into GXDBVersions values(2, 'AppGetVSAMemberServersByClientGroup',  '00000000000000000000', 'AppGetVSAMemberServersByClientGroup', '00000000000000000000')
GO

