

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSAClientsAndClientGroups.sp] ---------- 

--  +============================================================================================================================================================================+
--  | Stored Procedure: List all clients and client groups which have this package/apptype installed and visible to the specified user. It includes restore only agents. |
--  +============================================================================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSAClientsAndClientGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSAClientsAndClientGroups <<<'
	drop procedure AppGetVSAClientsAndClientGroups
END
IF EXISTS (select * from GxQscripts where name='AppGetVSAClientsAndClientGroups')
	delete from GxQscripts where name = 'AppGetVSAClientsAndClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAClientsAndClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetVSAClientsAndClientGroups'
GO
print '... Creating Procedure: AppGetVSAClientsAndClientGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSAClientsAndClientGroups
  @i_xml XML,
  @o_xml XML = NULL OUTPUT,
  @doSelect INT = 1
AS
    SET NOCOUNT ON
	DECLARE @userId INT = ISNULL((SELECT  ref.value('@userId', 'INT') FROM @i_xml.nodes('Api_GetVSAClientsAndClientGroups/user') R ( ref )),0)
	--<Api_GetVSAClientsAndClientGroups vendor="1"><appType applicationId="106"/><packageInfo packageId="1136"/></Api_GetVSAClientsAndClientGroups>'
	DECLARE @inputxml XML = (SELECT
							ISNULL(ref.value('@vendor', 'INT'),0) AS '@vendor',
							(SELECT ISNULL(ref.value('(appType/@applicationId)[1]', 'INT'),106)  AS '@applicationId' FOR     XML PATH('appType'), TYPE),
							(SELECT ref.value('(packageInfo/@packageId)[1]', 'INT')  AS '@packageId' FOR   XML PATH('packageInfo'), TYPE)
                            FROM @i_xml.nodes('Api_GetVSAClientsAndClientGroups') R(ref)
                        FOR  XML PATH('TMMsg_GetClientsForPackage'))
IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Clients') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Clients
    IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Visible') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Visible
    CREATE TABLE #ClientsForPackage_tmp__Clients (clientId INT PRIMARY KEY, clientName NVARCHAR (510))
    CREATE TABLE #ClientsForPackage_tmp__Visible (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
    DECLARE @vendor INT = ISNULL((SELECT ref.value('@vendor', 'INT') FROM @inputxml.nodes('TMMsg_GetClientsForPackage') R(ref)), 0)
    -- get list of clients according to the request
    EXEC GetClientsForPackage @inputxml
	DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
    -- get list of clients visible to the user
	IF @disableUseProxyCheck = 1
	BEGIN
		-- This is replaced by the "Use Proxy" check below
		EXEC sec_getIdaObjectsForUser @userId, 3, 0, 0, '#ClientsForPackage_tmp__Visible'
	END
	IF @disableUseProxyCheck = 0
	BEGIN
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
		SELECT clientId, 0, 0, 0,0 FROM #ClientsForPackage_tmp__Clients
EXEC sec_getPermissionsOnEntities @userId, 3
		DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
		INSERT INTO #ClientsForPackage_tmp__Visible
		SELECT entityId1,entityId2,entityId3,entityId4,entityId5 FROM #getPermissionsOnEntities_OutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL DROP TABLE #ClientList
	CREATE TABLE #ClientList (clientId INT PRIMARY KEY, clientName nvarchar(510), entityType int, hostName nvarchar(510), csGUID uniqueidentifier, displayName nvarchar(510))
	INSERT INTO #ClientList
	SELECT DISTINCT C.id,C.name,3,C.net_hostname,C.[GUID],c.[displayName]
    FROM    #ClientsForPackage_tmp__Clients S INNER JOIN #ClientsForPackage_tmp__Visible V ON V.clientId = S.clientId
	INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = S.clientId AND c.status & 0x00002 = 0
	IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Clients') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Clients
    IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Visible') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Visible
--
	DECLARE @ignoreGroup INT = ISNULL((SELECT ref.value('@ignoreGroup', 'INT') FROM @i_xml.nodes('Api_GetVSAClientsAndClientGroups') R(ref)), 0)
	IF OBJECT_ID('tempdb.dbo.#sec_ClientGroups') IS NOT NULL DROP TABLE #sec_ClientGroups
	CREATE TABLE #sec_ClientGroups ( entityId INT  PRIMARY KEY)
	IF @ignoreGroup = 0
	BEGIN
		 EXEC sec_getNonIdaObjectsForThisUser @userid, 28 /*CLIENT_GROUP_ENTITY (28) */ , 31 /* 31 (31) */ ,'#sec_ClientGroups'
	END
    -- create XML response including only clients present in both tables
       SET @o_xml = (SELECT @vendor  AS '@vendor',
                            (SELECT DISTINCT CL.clientId                 AS '@clientId',
	                                            CL.clientName            AS '@clientName',
												 CL.entityType AS '@_type_',
                                                CL.hostName    AS '@hostName',
                                                CL.csGUID          AS '@csGUID',
												CL.displayName AS '@displayName'
												FROM #ClientList CL
			                    ORDER BY CL.clientName
                                FOR     XML PATH('clients'), TYPE),
								(SELECT DISTINCT CG.id AS '@clientGroupId',CG.name AS '@clientGroupName',CG.GUID  AS '@guid'from #sec_ClientGroups TCG
										INNER JOIN APP_ClientGroupAssoc CGA ON TCG.entityId = CGA.clientGroupId
										INNER JOIN #ClientList CL ON CL.clientId = CGA.clientId
										INNER JOIN APP_ClientGroup CG ON CG.id = TCG.entityId
								FOR     XML PATH('clientGroups'), TYPE)
                        FOR  XML PATH('Api_GetVSAClientsAndClientGroups'))
	IF @doSelect=1
	BEGIN
		SELECT @o_xml
	END
    IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL DROP TABLE #ClientList
	IF OBJECT_ID('tempdb.dbo.#sec_ClientGroups') IS NOT NULL DROP TABLE #sec_ClientGroups
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSAClientsAndClientGroups')
	delete from GxQscripts where name = 'AppGetVSAClientsAndClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAClientsAndClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetVSAClientsAndClientGroups'
GO

insert into GXDBVersions values(2, 'AppGetVSAClientsAndClientGroups',  '00000000000000000000', 'AppGetVSAClientsAndClientGroups', '00000000000000000000')
GO

