

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVSAChildVMsClientEntity.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetVSAChildVMsClientEntity
--  | Description: It will take input as list of VM ClientIds and VSA backupset Id
--  | and retrieves backupset\subclient Id's under each VM client
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVSAChildVMsClientEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVSAChildVMsClientEntity <<<'
	drop procedure AppGetVSAChildVMsClientEntity
END
IF EXISTS (select * from GxQscripts where name='AppGetVSAChildVMsClientEntity')
	delete from GxQscripts where name = 'AppGetVSAChildVMsClientEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAChildVMsClientEntity')
	delete from GXDBVersions where aliasname = 'AppGetVSAChildVMsClientEntity'
GO
print '... Creating Procedure: AppGetVSAChildVMsClientEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVSAChildVMsClientEntity
  @i_xmlText XML
AS
  DECLARE @o_xmlMsg XML;
BEGIN TRY
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(1024) = N''
	DECLARE @vmClientId bigint
	DECLARE @VSABackupsetId int = @i_xmlText.value('(/App_GetVSAChildVMsClientEntityReq/parentBackupset/@backupsetId)[1]', 'integer')
	IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
	CREATE  TABLE #tmpVMclientInfo
	(
		clientId bigint,
		chldBackupSetId int,
		chldBackupSetGuid uniqueidentifier,
		chldSubclientId	int,
		chldSubclientGuid NVARCHAR(200)
	)
	INSERT INTO #tmpVMclientInfo
		SELECT
				cl.value('@clientId', 'int') AS clientId,
				S.ChildBackupSetId AS chldBackupSetId,
				BS.GUID AS chldBackupSetGuid,
				0 AS chldSubclientId,
				'' AS chldSubclientGuid
              FROM    @i_xmlText.nodes('App_GetVSAChildVMsClientEntityReq') R(ref)
			  CROSS APPLY ref.nodes('./vmClients') C(cl)
			  JOIN APP_VMBackupSet S (NOLOCK) ON S.VMClientId = cl.value('@clientId', 'int') AND S.ParentBackupSetId= @VSABackupsetId
			  JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = S.ChildBackupSetId
	--update subclientID of every vm. Under abckupset of vm, we will have one default subclient created
    UPDATE t
SET t.chldSubclientId = s.id,t.chldSubclientGuid = s.GUID FROM #tmpVMclientInfo t, App_application s (NOLOCK) WHERE s.backupset = t.chldBackupSetId	and s.subclientName <> 'Do Not Backup' and s.subclientStatus & 0x00008 = 0x00008
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
SET @o_xmlMsg = (
	(SELECT
		@errorCode as 'error/@errorCode',
		@errorStr as 'error/@errorMessage',
		( select
			clientId as '@clientId',
			chldBackupSetId as '@backupsetId',
			chldBackupSetGUID as '@backupsetGUID',
			chldSubclientId as '@subclientId',
			chldSubclientGuid as'@subclientGUID'
			from #tmpVMclientInfo FOR XML PATH('vmClients'), TYPE )
			FOR XML PATH('APP_GetVSAChildVMsClientEntityResp'), TYPE)
		)
SELECT @o_xmlMsg AS [o_xmlMsg]
IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVSAChildVMsClientEntity')
	delete from GxQscripts where name = 'AppGetVSAChildVMsClientEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVSAChildVMsClientEntity')
	delete from GXDBVersions where aliasname = 'AppGetVSAChildVMsClientEntity'
GO

insert into GXDBVersions values(2, 'AppGetVSAChildVMsClientEntity',  '00000000000000000000', 'AppGetVSAChildVMsClientEntity', '00000000000000000000')
GO

