

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMTemplateList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMTemplateList.sp,v $ $Id: AppGetVMTemplateList.sp,v 1.29.2.9 2018/06/25 21:01:44 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMTemplateList"
--	|	This Procedure is used to get the list of available VM Templates
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMTemplateList <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMTemplateList')
	drop procedure AppGetVMTemplateList
IF EXISTS (select * from GxQscripts where name='AppGetVMTemplateList')
	delete from GxQscripts where name = 'AppGetVMTemplateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMTemplateList')
	delete from GXDBVersions where aliasname = 'AppGetVMTemplateList'
GO
print '... Creating Procedure: AppGetVMTemplateList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMTemplateList
-- Input arguments
  @i_xmlText XML
AS
DECLARE @i_dataCenterId		INT
DECLARE @i_regionId		INT
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
SET	@i_dataCenterId = ISNULL (( SELECT ref.value('@dataCenterId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMTemplateListReq/dataCenter') R(ref)), 0)
declare @instanceId int = NULL
IF ((SELECT @i_xmlText.exist('/Ida_GetVMTemplateListReq/region')) = 1)
BEGIN
	SET @i_regionId = ISNULL (( SELECT ref.value('@regionId', 'INT')
		FROM  @i_xmlText.nodes ('Ida_GetVMTemplateListReq/region') R(ref)), 0)
	-- in case of azure , all templates are stored under Dummy Cloud services of EAST region, need to figure out if it is azure and return all these templates irrespective of the region id passed
	-- first get the Instance ID in case the region is from Azure
	SET @instanceId = (SELECT distinct dcMap.instanceId FROM APP_VMDataCenter dc
						INNER JOIN APP_VMDataCenterMap dcMap
						ON dc.id = dcMap.vDataCenterId
						AND dc.removalTimeStamp is NULL
						and dc.id = @i_regionId
						INNER JOIN APP_InstanceProp IP
						ON dcMap.instanceId = IP.componentNameId
						AND IP.attrName = 'Virtual Server Instance Type'
						AND IP.attrVal = 401)
	-- if instance id exists, then it is azure, let us get east region based on the dummy cloud service host entry
	IF (@instanceId is NOT NULL )
	BEGIN
			SET @i_regionId = ( select dc.id from APP_VMHost vhost
									   INNER JOIN APP_VMDataCenterMap vmap
									   on vmap.instanceId = @instanceId
									   inner join APP_VMDataCenter dc
									   on dc.id = vhost.vDataCenterId
									   and vmap.vDataCenterId = dc.id
									   and vhost.name = 'DummyCloudService' and vhost.removalTimestamp is null)
	END
	SET @r_ReturnResult = ISNULL ((
					SELECT CASE WHEN ISNULL(V.vxml.value('(/QSMServer_QVirtualMachineReq/@guestOS)[1]', 'nvarchar(128)'), '') = ''
								THEN SUBSTRING(CP.attrVal, 0, CHARINDEX(':-', CP.attrVal))
							ELSE V.vxml.value('(/QSMServer_QVirtualMachineReq/@guestOS)[1]', 'nvarchar(128)') END
							 AS '@operatingSystem',
					V.vxml.value('count(QSMServer_QVirtualMachineReq[1]/hardDisks[1]/hardDisk)', 'int') as '@numberOfDisks',
					(CASE WHEN (ds.value('@isTemplate', 'varchar(8)') = '1' OR cast(CP2.attrVal as int) & 2 >0) THEN '1' ELSE '0' END) AS '@isTemplate',
					V.GUID AS 'vm/@vmGUID',
					CASE WHEN IP.attrVal = 401 THEN C.net_hostname ELSE V.name END AS 'vm/@vmName'
					FROM         [dbo].[App_VM] V
					INNER JOIN [dbo].[App_VMHost] H
					ON (V.vHostId = H.id )
					AND H.removalTimeStamp IS NULL
					AND V.removalTimeStamp IS NULL
					INNER JOIN [dbo].[App_VMDataCenter] D
					ON H.vDataCenterId = D.id
					AND D.id = @i_regionId
					AND D.removalTimeStamp IS NULL
					INNER JOIN App_VMDataCenterMap VMap
					ON VMap.vDataCenterId = D.id
					AND VMap.removalTimeStamp IS NULL
					INNER JOIN APP_InstanceName AS I ON
					I.id = VMap.instanceId
					AND VMap.vDataCenterId = D.id
					AND D.removalTimeStamp IS NULL
					INNER JOIN APP_InstanceProp AS IP ON
						IP.componentNameId = I.id
					AND IP.attrName LIKE 'Virtual Server Instance Type'
					INNER JOIN APP_Client AS C
						ON V.clientId = C.id
					LEFT OUTER JOIN APP_ClientProp AS CP ON
						V.clientId = CP.componentNameID
						AND CP.attrName = 'Sim OS Info'
					LEFT OUTER JOIN APP_ClientProp AS CP2 ON
						V.clientId = CP2.componentNameID
						AND CP2.attrName = 'Virtual Entity Flags'
					CROSS APPLY V.vxml.nodes ('QSMServer_QVirtualMachineReq') M(ds)
					WHERE 	 ds.value('@isTemplate', 'varchar(8)') = '1'
					ORDER BY V.name
					FOR XML PATH('VMTemplateList'), ROOT('Ida_GetVMTemplateListResp')
					), '<Ida_GetVMTemplateListResp/>')
END
ELSE
BEGIN
	-- first get the Instance ID in case the region is from Azure
	DECLARE @instanceType int
	SELECT @instanceId = dcMap.instanceId , @instanceType = IP.attrval FROM APP_VMDataCenter dc
						INNER JOIN APP_VMDataCenterMap dcMap
						ON dc.id = dcMap.vDataCenterId
						AND dc.removalTimeStamp is NULL
						and dc.id = @i_dataCenterId
						INNER JOIN APP_InstanceProp IP
						ON dcMap.instanceId = IP.componentNameId
						AND IP.attrName = 'Virtual Server Instance Type'
	-- if instance id exists, then it is azure, let us get east region based on the dummy cloud service host entry
	IF (@instanceType =401)
	BEGIN
			SET @i_dataCenterId = ( select dc.id from APP_VMHost vhost
									   INNER JOIN APP_VMDataCenterMap vmap
									   on vmap.instanceId = @instanceId
									   inner join APP_VMDataCenter dc
									   on dc.id = vhost.vDataCenterId
									   and vmap.vDataCenterId = dc.id
									   and vhost.name = 'DummyCloudService' and vhost.removalTimestamp is null)
	END
	IF ( @instanceType = 1001 )
	BEGIN
		SET @r_ReturnResult =  ISNULL(( select operatingSystem  AS '@operatingSystem',
					1  as '@numberOfDisks',
					1 AS '@isTemplate',
					containerId AS 'vm/@vmGUID', C.name AS 'vm/@vmName'
					FROM         [dbo].[APP_Container] C
					INNER JOIN APP_VMDataCenter D
					ON D.id = @i_dataCenterId
					AND D.removalTimeStamp IS NULL
					INNER JOIN APP_VMDataCenterMap DCM
					on D.id = DCM.vDataCenterId
					and DCM.instanceId = @instanceId
					and (C.flags & 1) =1
					FOR XML PATH('VMTemplateList'), ROOT('Ida_GetVMTemplateListResp')
					), '<Ida_GetVMTemplateListResp/>')
		GOTO EXIT_PROC
	END
	IF isnull(@instanceId,-1) < 0
		SET @instanceId = 0
	SET @instanceId = ISNULL (( SELECT ref.value('@instanceId', 'INT')
			FROM  @i_xmlText.nodes ('Ida_GetVMTemplateListReq/dataCenter/instanceEntity') R(ref)), @instanceId)
	SET @r_ReturnResult = ISNULL ((
					SELECT CASE WHEN ISNULL(V.vxml.value('(/QSMServer_QVirtualMachineReq/@guestOS)[1]', 'nvarchar(128)'), '') = ''
								THEN SUBSTRING(CP.attrVal, 0, CHARINDEX(':-', CP.attrVal))
							ELSE V.vxml.value('(/QSMServer_QVirtualMachineReq/@guestOS)[1]', 'nvarchar(128)') END
							 AS '@operatingSystem',
					v.vxml.value('count(QSMServer_QVirtualMachineReq[1]/hardDisks[1]/hardDisk)', 'int') as '@numberOfDisks',
					(CASE WHEN (ds.value('@isTemplate', 'varchar(8)') = '1' OR cast(CP2.attrVal as int) & 2 >0) THEN '1' ELSE '0' END) AS '@isTemplate',
					GUID AS 'vm/@vmGUID', V.name AS 'vm/@vmName'
					FROM         [dbo].[App_VM] V
					INNER JOIN [dbo].[App_VMHost] H
					ON V.vHostId = H.id
					AND H.removalTimeStamp IS NULL
					AND V.removalTimeStamp IS NULL
					INNER JOIN [dbo].[App_VMDataCenter] D
					ON H.vDataCenterId = D.id
					AND D.id = @i_dataCenterId
					AND D.removalTimeStamp IS NULL
					INNER JOIN App_VMDataCenterMap DCM
						ON D.id = DCM.vDataCenterId
					INNER JOIN APP_InstanceProp AS IP ON
						IP.attrName = 'Virtual Server Instance Type'
						AND DCM.instanceId = (CASE
							WHEN IP.attrVal = 101
							    THEN  @instanceId
							ELSE
							    DCM.instanceId
							END)
						AND IP.modified = 0
						AND IP.componentNameId = DCM.instanceId
					LEFT OUTER JOIN APP_ClientProp AS CP ON
						V.clientId = CP.componentNameID
						AND CP.attrName = 'Sim OS Info'
					LEFT OUTER JOIN APP_ClientProp AS CP2 ON
						V.clientId = CP2.componentNameID
						AND CP2.attrName = 'Virtual Entity Flags'
					CROSS APPLY V.vxml.nodes ('QSMServer_QVirtualMachineReq') M(ds)
					WHERE 	 (ds.value('@isTemplate', 'varchar(8)') = '1'
					AND(
							(
								( ISNULL(ds.value('@toolsVersion','INT'), 0) > 8288 )
								--Only following windows versions are supported
								AND ( ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'winVista%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'winLonghorn%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'windows7%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'windows8%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'windows9%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'rhel%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'centos%' OR
									  --ISNULL(ds.value('@guestOSVersion','varchar(30)'), '') like 'freebsd%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(30)'), '') like 'ubuntu%'
								)
							 )
							 OR IP.attrVal = 401 OR IP.attrVal = 1101 OR IP.attrVal = 1001
						))
						OR IP.attrVal = 102
					ORDER BY V.name
					FOR XML PATH('VMTemplateList'), ROOT('Ida_GetVMTemplateListResp')
					), '<Ida_GetVMTemplateListResp/>')
END
EXIT_PROC:
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMTemplateList')
	delete from GxQscripts where name = 'AppGetVMTemplateList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMTemplateList')
	delete from GXDBVersions where aliasname = 'AppGetVMTemplateList'
GO

insert into GXDBVersions values(2, 'AppGetVMTemplateList',  '00010029000200090000', 'AppGetVMTemplateList', '00010029000200090000')
GO

