

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMStatusInfoForUser.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMStatusInfoForUser.sp,v $ $Id: AppGetVMStatusInfoForUser.sp,v 1.1.2.61.6.1 2021/01/13 14:35:21 mnatarajan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVMStatusInfoForUser')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMStatusInfoForUser <<<'
	drop procedure AppGetVMStatusInfoForUser
END
IF EXISTS (select * from GxQscripts where name='AppGetVMStatusInfoForUser')
	delete from GxQscripts where name = 'AppGetVMStatusInfoForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoForUser')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoForUser'
GO
print '... Creating Procedure: AppGetVMStatusInfoForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVMStatusInfoForUser
  @i_xmlVMStatusInfoReq XML,
  @o_xmlVMStatusInfoResp XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId               INT           = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@userId)[1]', 'integer')
DECLARE @status               INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@vmStatus)[1]','INT'), 0)
DECLARE @pageNo               INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@pageNo)[1]','INT'), 0)
DECLARE @pageSize             INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@pageSize)[1]','INT'), 0x7fffffff)
DECLARE @order                NVARCHAR(255) = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@order)[1]','NVARCHAR(255)'), '2 ASC')
DECLARE @o_pagesCount         INT			= 0
DECLARE @filterProviderId     INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/provider/@providerId)[1]','INT'), -1)
DECLARE @propertyLevel	      INT			= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nPropertyLevel)[1]','INT'), 5)	-- EssententialProperties
DECLARE @includeDiscovered     INT			= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/@includeDiscovered)[1]','INT'), 0)
DECLARE @i_localeId			  INT			= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/locale/@localeId)[1]', 'int'), 0)
DECLARE @filterVendorType     INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@filterVendorType)[1]','INT'), -1)
DECLARE @excludeVendorType    INT           = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@excludeVendorType)[1]','INT'), -1)
-------------Constansts---------
DECLARE @APPTYPE_MSSQL int = 81
DECLARE @APPTYPE_ORACLE int = 22
DECLARE @APPTYPE_ACTIVE_DIRECTORY int = 41
DECLARE @APPTYPE_EXCHANGE int = 53
SET @o_errCode = 0
SET @o_errString = ''
DECLARE @debug                INT = 0
-- 0. preapare temporary tables
IF LEN(ISNULL(@order, '')) = 0 BEGIN SET @order = '2 ASC' END
IF @debug <> 0 BEGIN
    SELECT @userId AS userID, @status AS [Status], @pageNo AS pageNo, @pageSize AS pageSize, @order AS [Order]
END
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfo'           ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfo
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'        ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#idaClientList'							 ) IS NOT NULL DROP TABLE #idaClientList
IF OBJECT_ID('tempdb.dbo.#CompanyClients'							 ) IS NOT NULL DROP TABLE #CompanyClients
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl'             ) IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
-- 0.0 temporary table that will hold objects available for curent user.
CREATE TABLE #idaClientList
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
CREATE TABLE #CompanyClients
(
    clientId    INT
)
CREATE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
CREATE TABLE #RetireInProgressClientListTbl(retireClientId INT)
-- 0.3 table variable that will hold protected vms info
CREATE TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
(
    clientId            INT,
    clientName          NVARCHAR(1024),
	displayName         NVARCHAR(1024),
    sGUID               NVARCHAR(1024),
    vsObjType           INT,
    jobId               INT	DEFAULT 0,
    vmStatus            NVARCHAR(1024),
    simOSName           NVARCHAR(1024),
    subclientId         INT,
    subclientName       NVARCHAR(512),
    vmSize              BIGINT,
    vmUsedSpace         BIGINT,
    vmGuestSize         BIGINT,
    bkpStartTime        INT,
    bkpEndTime          INT,
    vmHardware          NVARCHAR(1024),
    vmHost              NVARCHAR(1024),
    vmAgent             NVARCHAR(1024),
    pseudoClientId      INT,
    pseudoClientName    NVARCHAR(1024),
    pseudoClientStatus  INT,
	proxyClientType     INT,
    proxyClientId       INT,
    proxyClientName     NVARCHAR(1024),
    vmSubclientId       INT DEFAULT 0,
    vmSubclientName     NVARCHAR(512) DEFAULT N'',
	vmBackupsetId		INT DEFAULT 0,
    isIndexingV2        INT DEFAULT 0,
    vmVendor            INT,
    planId              INT,
    planName            NVARCHAR(1024) NULL,
    osType				INT,
    isDeleted			INT DEFAULT 0,
    instanceId			INT,
	backupsetId         INT DEFAULT 0,
	isContentIndexded	INT  DEFAULT 0,
	latestBackupTimeCatalogedSuccessfully	INT  DEFAULT 0,
	dcPlanID			INT  DEFAULT NULL,
	dcPlanName          NVARCHAR(1024) DEFAULT NULL,
	OldestRecoveryPoint	BIGINT DEFAULT NULL,
	LatestRecoveryTime	BIGINT  DEFAULT NULL,
	replicationResp		XML DEFAULT NULL,
	storagepolicyName   NVARCHAR(144),
	schedulePolicy		NVARCHAR(255),
	isFSAgentBackedUp	INT,
	nextBackupSubclientId			INT,
    nextBackupSubclientName			NVARCHAR(512),
	nextBackupBackupsetId			NVARCHAR(512),
	nextBackupSubclientStatus		INT,
	showBackupOption				INT DEFAULT(1),
	passkeyXML			XML DEFAULT NULL,
	slaStatus			INT DEFAULT(0),
	slaCategory			INT DEFAULT(0),
	slaCategoryDescription	NVARCHAR(255) DEFAULT '',
	retireClientPhase   INT DEFAULT 0,
	lastBackupJobInfo	XML,
	vmInstanceId int default 0,
	vmStatusErrorFlag INT,
	vmStatusError       NVARCHAR(1024),
	vmFailureReasonForWarning		NVARCHAR(MAX)
)
CREATE CLUSTERED INDEX Idx_ClientsList_1 ON #APPGetVMInfoForUser_tmp__VMInfoRaw (clientId)
CREATE TABLE #APPGetVMInfoForUser_tmp__VMInfo
(
    id                  INT IDENTITY(1,1),
    clientId            INT,
    clientName          NVARCHAR(1024),
	displayName         NVARCHAR(1024),
    sGUID               NVARCHAR(1024),
    vsObjType           INT,
    jobId               INT,
    vmStatus            NVARCHAR(1024),
    simOSName           NVARCHAR(1024),
    subclientId         INT,
    subclientName       NVARCHAR(512),
    vmSize              BIGINT,
    vmUsedSpace         BIGINT,
    vmGuestSize         BIGINT,
    bkpStartTime        INT,
    bkpEndTime          INT,
    vmHardware          NVARCHAR(1024),
    vmHost              NVARCHAR(1024),
    vmAgent             NVARCHAR(1024),
    pseudoClientId      INT,
    pseudoClientName    NVARCHAR(1024),
    pseudoClientStatus  INT,
	proxyClientType     INT,
    proxyClientId       INT,
    proxyClientName     NVARCHAR(1024),
    vmSubclientId       INT DEFAULT 0,
    vmSubclientName     NVARCHAR(512) DEFAULT N'',
	vmBackupsetId		INT DEFAULT 0,
    isIndexingV2        INT DEFAULT 0,
    vmVendor            INT,
    planId              INT,
    planName            NVARCHAR(1024) NULL,
    osType				INT,
    isDeleted			INT DEFAULT 0,
    instanceId			INT,
	backupsetId         INT DEFAULT 0,
	isContentIndexded	INT  DEFAULT 0,
	latestBackupTimeCatalogedSuccessfully	INT  DEFAULT 0,
	dcPlanID			INT  DEFAULT NULL,
	dcPlanName          NVARCHAR(1024) DEFAULT NULL,
	OldestRecoveryPoint	BIGINT DEFAULT NULL,
	LatestRecoveryTime	BIGINT DEFAULT NULL,
	replicationResp		XML DEFAULT NULL,
	storagepolicyName   NVARCHAR(144),
	schedulePolicy		NVARCHAR(255),
	isFSAgentBackedUp	INT,
	nextBackupSubclientId			INT,
    nextBackupSubclientName			NVARCHAR(512),
	nextBackupBackupsetId			NVARCHAR(512),
	nextBackupSubclientStatus		INT,
	showBackupOption				INT DEFAULT(1),
	passkeyXML			XML DEFAULT NULL,
	slaStatus			INT DEFAULT(0),
	slaCategory			INT DEFAULT(0),
	slaCategoryDescription	NVARCHAR(255) DEFAULT '',
	retireClientPhase   INT DEFAULT 0,
	lastBackupJobInfo XML,
	vmInstanceId int default 0,
	vmStatusErrorFlag INT,
	vmStatusError       NVARCHAR(1024),
	vmFailureReasonForWarning		NVARCHAR(MAX)
)
--Get the list of specific device Ids provided in XML input
DECLARE @tempVMIdList TABLE(
    clientId      int
);
INSERT INTO @tempVMIdList
SELECT ref.value('@clientId', 'int') AS client
FROM    @i_xmlVMStatusInfoReq.nodes('App_VMStatusInfoReq/vmClients') R ( ref )
WHERE   ISNULL(ref.value('@clientId', 'int'), 0) > 0
--If the caller provided individual clients, retain only those that are Virtual Machines.
IF EXISTS (SELECT TOP 1 1 FROM @tempVMIdList)
BEGIN
    --Delete all clients which are not Virtual Machines
    DELETE TM
    FROM @tempVMIdList TM LEFT OUTER JOIN APP_ClientProp ACP WITH (NOLOCK)
        ON ACP.componentnameid=TM.clientId AND ACP.attrname='Virtual Server Discovered Clients' AND ACP.attrval='1' AND ACP.modified=0
    WHERE ACP.ID IS NULL
    --If none of the client Ids provided by caller are Virtual machines, exit immediately
    IF NOT EXISTS (SELECT TOP 1 1 FROM @tempVMIdList)
    BEGIN
        GOTO ERROR_EXIT
    END
END
--At this point, the only clients (if any) in @tempVMIdList would be virtual machines
DECLARE @isAdminUserId INT = ISNULL((SELECT 1 FROM UMUsers WHERE (id=@userId) AND (flags & 0x040 <> 0)) , 0)
IF(@isAdminUserId = 0)      --NON-ADMIN user
BEGIN
    --If calling user is NOT ADMIN user, firstly get clients from security check stored proc on which user has VIEW capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#idaClientList'
    --If the caller explictely provided clientIds, only retain those that were provided in the list
    IF EXISTS (SELECT TOP 1 1 FROM @tempVMIdList)
    BEGIN
        delete CL
        from #idaClientList CL left outer join @tempVMIdList VM on CL.t_clientId = VM.clientId
        where VM.clientId is null
    END
END
ELSE            --ADMIN USER
BEGIN
    --If the caller explictely provided clientIds, blindly insert those into #idaClientList as its admin user
    IF EXISTS (SELECT TOP 1 1 FROM @tempVMIdList)
    BEGIN
        insert into #idaClientList
        select distinct VM.clientId, AP.appTypeId, AP.instance, AP.backupSet, AP.id
        from @tempVMIdList VM LEFT OUTER JOIN APP_Application AP on VM.clientId = AP.clientId
    END
    ELSE
    BEGIN
        --Get all clients on which user has view all capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#idaClientList'
    END
END
-- Following below changes, VM will not have pending state. In case we want this, we will have to revisit this SP to figure out such details.
-- get vms information into the table
-- VMStatus values in table are matched with enum VMClientBkupStatus in JobManager.x
--  COMPLETED           = 0,
--  FAILED              = 1,
--  IN_PROGRESS         = 2,
--  PARTIAL_SUCCESS     = 3,
--  WAITING             = 4,
--  KILLPENDING         = 5,
--  KILLED              = 6,
--  PENDING             = 7,
--  SUSPENDED           = 8,
--  SKIPPED_BY_USER     = 9
-- VMStatus in repsonse are matched with enum VmStatusEnum in APP.x
--  ALL = 0,
--  PROTECTED = 1,
--  NOT_PROTECTED = 2,
--  PENDING = 3,
--  BACKED_UP_WITH_ERROR = 4
--  DISCOVERED = 5,
--  FAILED = 6,
--  WARNING = 7
-- Following below changes, VM will not have pending state. In case we want this, we will have to revisit this SP to figure out such details.
-- get vms information into the table
INSERT INTO #APPGetVMInfoForUser_tmp__VMInfoRaw (clientID, vmStatus, vsObjType, jobId, pseudoClientId, proxyClientType, proxyClientId, proxyClientName, subclientId, subclientName, backupsetId, instanceId, nextBackupSubclientId, nextBackupSubclientName, nextBackupSubclientStatus, nextBackupBackupsetId)
SELECT  DISTINCT(IDA.t_clientId), CASE WHEN (VMP.attrVal = N'0') THEN 1
                                  WHEN (VMP.attrVal = N'1' OR VMP.attrVal IS NULL) THEN 2
                                  WHEN (VMP.attrVal = N'2' OR VMP.attrVal = N'4') THEN 3
                                  WHEN (VMP.attrVal = N'3') THEN 4
                                  ELSE 2
                                  END,
							9 AS [type], VMP.jobId, AAP.clientId AS pseudoClientId,
							CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') AS proxyClientType,
							CASE WHEN CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') = 3 THEN
									  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'INT') ELSE
									  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientGroupId)[1]'), 'INT') END AS proxyClientId,
							CASE WHEN CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') = 3 THEN
									  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'NVARCHAR(1024)') ELSE
									  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientGroupName)[1]'), 'NVARCHAR(1024)') END AS proxyClientName,
							AAP.ID AS subClientId, AAP.subclientName AS subclientName, AAP.backupSet, AAP.instance as instanceId,AAP.ID AS subClientId, AAP.subclientName AS subclientName, AAP.subclientStatus, AAP.backupSet
FROM	#idaClientList IDA
INNER JOIN APP_ClientProp ACPVM  WITH (NOLOCK)
	ON ACPVM.componentNameId=IDA.t_clientId AND ACPVM.attrName='Virtual Server Discovered Clients' AND ACPVM.attrval='1' AND ACPVM.modified=0
INNER JOIN APP_ClientProp ACPSUB WITH(NOLOCK)
ON ACPSUB.componentNameId=IDA.t_clientId AND ACPSUB.attrName='Last Backup Subclient' AND ACPSUB.modified=0
INNER JOIN APP_Application AAP WITH (NOLOCK)
	ON CAST(AAP.id AS NVARCHAR(64))=ACPSUB.attrVal
LEFT OUTER JOIN APP_InstanceProp AIP WITH (NOLOCK)
	ON AIP.componentNameId=AAP.instance AND AIP.attrName = 'Vs Member Servers' AND AIP.modified = 0
LEFT OUTER JOIN APP_ClientProp ACPJOB WITH(NOLOCK)
	ON ACPJOB.componentNameId=IDA.t_clientId AND ACPJOB.attrName='Last Backup JobID' AND ACPJOB.modified=0
LEFT OUTER JOIN APP_VMProp VMP WITH (NOLOCK)
	ON VMP.VMclientId=IDA.t_clientId AND CAST(VMP.jobId AS NVARCHAR(128))=ACPJOB.attrVal AND VMP.attrName='vmStatus'
UPDATE T
SET vmstatus = 7 -- Warning
from #APPGetVMInfoForUser_tmp__VMInfoRaw T
INNER JOIN App_VMProp VM ON VM.jobId = T.jobId AND VM.VMclientId = T.clientId
WHERE  VM.attrName = 'vmBackupErrorFlags' and CAST (VM.attrVal AS INT) > 0
IF @includeDiscovered=1
BEGIN
	-- Code to add discovered VMs
	INSERT INTO #APPGetVMInfoForUser_tmp__VMInfoRaw (clientID, vmStatus, vsObjType, jobId, pseudoClientId, proxyClientType, proxyClientId, proxyClientName, subclientId, subclientName, backupsetId, instanceId, nextBackupSubclientId, nextBackupSubclientName, nextBackupBackupsetId)
	SELECT  DISTINCT(IDA.t_clientId), 5 /*Discovered*/,
								9 AS [type], 0, (SELECT TOP 1 clientId FROM APP_Application WHERE instance=AIP.componentNameId),
								CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') AS proxyClientType,
								CASE WHEN CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') = 3 THEN
										  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'INT') ELSE
										  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientGroupId)[1]'), 'INT') END AS proxyClientId,
								CASE WHEN CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@_type_)[1]'), 'INT') = 3 THEN
										  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'NVARCHAR(1024)') ELSE
										  CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientGroupName)[1]'), 'NVARCHAR(1024)') END AS proxyClientName,
								0, '', 0, AIP.componentNameId,0, '', 0
	FROM	#idaClientList IDA
	INNER JOIN APP_ClientProp ACPVM  WITH (NOLOCK)
		ON ACPVM.componentNameId=IDA.t_clientId AND ACPVM.attrName='Virtual Server Discovered Clients' AND ACPVM.attrval='1' AND ACPVM.modified=0
	INNER JOIN APP_ClientProp ACPI  WITH (NOLOCK)
		ON ACPI.componentNameId=IDA.t_clientId AND ACPI.attrName='Virtual Machine Instance ID' AND ACPI.modified=0
	LEFT OUTER JOIN #APPGetVMInfoForUser_tmp__VMInfoRaw VMRaw
		ON VMRaw.clientID=ACPVM.componentNameId
	LEFT OUTER JOIN APP_InstanceProp AIP WITH (NOLOCK)
		ON CAST(AIP.componentNameId AS NVARCHAR(32))=ACPI.attrval AND AIP.attrName = 'Vs Member Servers' AND AIP.modified = 0
	WHERE VMRaw.clientID IS NULL
END
-- Update Next backup subclient Id wherever applicable
UPDATE TMP
	SET TMP.nextBackupSubclientId = AAP.id,
		TMP.nextBackupSubclientName=AAP.subclientName,
		TMP.nextBackupBackupsetId=AAP.backupSet,
		TMP.nextBackupSubclientStatus = AAP.subclientStatus
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw TMP
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
ON ACP.componentNameId=TMP.clientId AND ACP.attrName='Next Backup Subclient' AND ACP.modified=0
INNER JOIN APP_Application AAP WITH (NOLOCK)
	ON CAST(AAP.id AS NVARCHAR(32))=ACP.attrVal
-- In case of a Client Group, replace it with first client from the Client Group list
UPDATE VM
SET VM.proxyClientId = C.id,
	VM.proxyClientName = C.name,
	VM.proxyClientType = 3
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VM
INNER JOIN APP_Client C on C.id = (SELECT top 1 clientId FROM APP_ClientGroupAssoc CG WHERE CG.clientGroupId = VM.proxyClientId)
WHERE VM.proxyClientType = 28
-- and GUID to all inserted clients
UPDATE  #APPGetVMInfoForUser_tmp__VMInfoRaw
SET     sGUID = P.attrVal
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw Vm INNER JOIN APP_VMProp P WITH (NOLOCK) ON Vm.clientID = P.VMclientId AND P.jobId = VM.jobId
WHERE   P.attrName  = 'vmGUID'
-- Order by is not needed for TOP 1
UPDATE TMP
SET TMP.sGUID = (SELECT TOP 1 attrval FROM APP_VMProp WITH (NOLOCK) WHERE VMclientId=TMP.clientId AND attrName='vmGuid'),
TMP.jobId=0
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw TMP
WHERE jobId IS NULL
UPDATE TMP
SET TMP.sGUID = ACP.attrval
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw TMP
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
	ON ACP.componentNameId=TMP.clientId AND ACP.attrName='Virtual Machine Instance UUID' AND ACP.modified=0
WHERE TMP.sGUID IS NULL
IF @debug <> 0 BEGIN
    SELECT 'raw vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
IF @filterProviderId <> -1
BEGIN
	INSERT INTO #CompanyClients
		SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@filterProviderId AND ACP.modified=0 AND ACP.cs_attrName = checksum('Associated Smart Client Group')
	DELETE
	FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
	WHERE ClientId NOT IN
				( SELECT clientId FROM #CompanyClients)
	IF @debug <> 0
	BEGIN
		SELECT 'company vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
	END
END
-- fill up output table
-- client name, OS name to all inserted clients
UPDATE  VM
    SET     VM.SimOsName   = ACP.attrVal
    FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
	INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
		ON ACP.attrName = 'Operating System Name' AND ACP.componentNameId = Vm.clientID AND ACP.modified = 0
UPDATE VM
	SET VM.clientName = AC.name,
		VM.displayname = AC.displayname
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
INNER JOIN APP_Client AC WITH (NOLOCK)
	ON  Vm.clientID = AC.id
-- Update Name and status of Pseudo client
UPDATE  VM
SET     VM.pseudoClientName = Ac.displayName, VM.pseudoClientStatus=AC.status
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
    INNER JOIN APP_Client AC WITH (NOLOCK)
		ON Vm.pseudoClientId = AC.id
UPDATE  VM
SET     VM.isDeleted = 1
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
        ON Vm.clientId = ACP.componentnameId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0'
-- Cases for which "Backup Now" option won't be shown
--	-- VM is deleted from hypervisor
--	-- VM for which VSA client is marked as deconfigured
--	-- Subclient that is associated for backup is makred as deleted
UPDATE  VM
SET     VM.showBackupOption = 0
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
WHERE (isDeleted=1) OR (pseudoClientStatus&2<>0) OR (nextBackupSubclientStatus&0x00004<>0)
-- Delete VM's which are unprotected and also deleted from hypervisor
-- There is no point in returning them as showing them on UI won't suffice anything (since they are unprotected , they cannot be restored and not backed up further)
--  ALL = 0,
--  PROTECTED = 1,
--  NOT_PROTECTED = 2,
--  PENDING = 3,
--  BACKED_UP_WITH_ERROR = 4,
--  DISCOVERED = 5,
--  FAILED = 6,
--  WARNING = 7
DELETE FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
WHERE isDeleted=1 AND vmStatus NOT IN (1,4,7)
-- and backup properties
;WITH VMs(jobId, vmclientId, attrName, attrVal)
AS
(
	SELECT VP.JobId, VMclientId, attrName, attrVal
	FROM APP_VMProp VP	WITH (NOLOCK)
		INNER JOIN #APPGetVMInfoForUser_tmp__VMInfoRaw V
			on V.jobId = VP.jobId AND VP.VMclientId = V.clientID AND VP.attrName IN ('vmSize','vmUsedSpace','vmGuestSize','vmBackupStartTime', 'vmBackupEndTime', 'vmHost', 'vmAgent','vmBackupErrorFlags','vmFailureReason')
)
UPDATE VM
SET vmSize = CAST(S.[vmSize] AS BIGINT),
	vmUsedSpace = CAST(S.[vmUsedSpace] AS BIGINT),
	vmGuestSize = CAST(S.[vmGuestSize] AS BIGINT),
	bkpStartTime = CAST(S.[vmBackupStartTime] AS INT),
	bkpEndTime = CAST([vmBackupEndTime] AS INT),
	vmHost = S.[vmHost],
	vmAgent = S.[vmAgent],
	vmStatusErrorFlag = S.[vmBackupErrorFlags],
	vmFailureReasonForWarning = S.[vmFailureReason]
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VM
	INNER JOIN
		(SELECT jobId, vmclientId, [vmSize],[vmUsedSpace],[vmGuestSize],[vmBackupStartTime], [vmBackupEndTime], [vmHost], [vmAgent],[vmBackupErrorFlags],[vmFailureReason]
		FROM VMs
		PIVOT
		(
			MAX(attrVal)
			FOR attrName IN ([vmSize],[vmUsedSpace],[vmGuestSize],[vmBackupStartTime], [vmBackupEndTime], [vmHost], [vmAgent],[vmBackupErrorFlags],[vmFailureReason])
		) as P) S
			ON VM.jobId = S.jobId AND VM.clientID = S.VMclientId
UPDATE T
SET vmStatusError = 'Guest quiesce failures'
from #APPGetVMInfoForUser_tmp__VMInfoRaw T
	where vmStatusErrorFlag & 1 > 0
UPDATE T
SET vmStatusError = CASE WHEN LEN(vmStatusError) > 0 THEN vmStatusError +', 'ELSE ''END + 'Unsupported disk'
from #APPGetVMInfoForUser_tmp__VMInfoRaw T
	where vmStatusErrorFlag & 2 > 0
UPDATE T
SET vmStatusError = CASE WHEN LEN(vmStatusError) > 0 THEN vmStatusError +', 'ELSE ''END + 'File details collection error'
from #APPGetVMInfoForUser_tmp__VMInfoRaw T
	where vmStatusErrorFlag & 4 > 0
UPDATE VM
SET vmHardware = attrVal
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VM
	INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
		ON ACP.componentNameId = VM.clientID AND ACP.attrName = 'Virtual Machine Hardware Version' AND ACP.modified = 0
--updating planid,planname information.
UPDATE  S
SET     S.planId = AP.id,
        S.planName = AP.name
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw S
INNER JOIN APP_SubClientProp sprop WITH(NOLOCK)
    ON S.nextBackupSubclientId = sprop.componentNameId
AND sprop.cs_attrName = CHECKSUM(N'Associated Plan') AND sprop.attrName = 'Associated Plan'
    AND sprop.modified =0
INNER JOIN App_Plan AP WITH(NOLOCK)
     ON sprop.attrVal=CAST(AP.id AS NVARCHAR(12))
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
 --update os type
update VMInfo
set osType = case when simOS.type ='Windows' then 1 else 2 end
from #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
INNER JOIn APP_Client C  WITH(NOLOCK)
	on VMInfo.clientId = C.id
INNER JOIN simOperatingSystem simOS  WITH(NOLOCK)
	ON simOS.id = C.simOperatingSystemId
--add storagepolicyName
UPDATE VMInfo
SET storagepolicyName = AG.Name
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
INNER JOIN APP_Application AP WITH(NOLOCK) ON VMInfo.subclientId = AP.id
INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = AP.dataArchGrpID
-- Fill Schedule Policy
UPDATE VMInfo
SET schedulePolicy = ST.subTaskName
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
INNER JOIN TM_Associations TAC (NOLOCK) ON  VMInfo.subclientId = TAC.subclientId
INNER JOIN TM_SubTask ST WITH(NOLOCK) ON ST.taskId = TAC.taskId
-- Fill info if any VM is backed up using installed agent
--	-- current Code is only for FS. We should extend same code in csae we want to support more IDA's later
UPDATE VMInfo
SET isFSAgentBackedUp = 1
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
INNER JOIN APP_Application AP WITH(NOLOCK)
	ON VMInfo.clientId = AP.clientId
INNER JOIN APP_AppTypeGroupAssoc AATG WITH(NOLOCK)
	ON AATG.appTypeId = AP.appTypeId AND AATG.appGroupId=35 /*FS App Group ID*/ AND AATG.typeOfGroup=0
INNER JOIN APP_SubClientProp ASCP  WITH(NOLOCK)
	ON ASCP.componentNameId=AP.id AND ASCP.attrName='Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
-- Fetch passkey settings for the VM if any
IF OBJECT_ID('tempdb.dbo.#tempTableForPasskey') IS NOT NULL DROP TABLE #tempTableForPasskey
CREATE TABLE #tempTableForPasskey
(
	clientId					INT,
	authType					INT DEFAULT 1,
	authUsers					XML DEFAULT NULL,
	expirationTimeStamp			INT DEFAULT 0,
	enableAuthorizeForRestore	INT DEFAULT 0
)
CREATE CLUSTERED  INDEX idx_tempTableForPasskey_clientId_authType ON #tempTableForPasskey(clientId,authType)
DECLARE @currTime INT = dbo.GetUnixTime(GETUTCDATE())
INSERT INTO #tempTableForPasskey(clientId, authType, authUsers)
	SELECT VMInfo.clientId,
			ISNULL(CONVERT(INT,CP1.attrVal),1),
			ISNULL(CAST(CP2.attrVal as xml),'')
	FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo LEFT JOIN App_ClientProp CP1 ON
		CP1.componentNameId = VMInfo.clientId
AND CP1.attrName='AuthorizationType' AND CP1.attrVal = '2' AND CP1.modified = 0
		LEFT JOIN App_ClientProp CP2 ON
		CP2.componentNameId = VMInfo.clientId
AND CP2.attrName='AuthorizedUsersForRestore' AND CP2.modified = 0 AND CP1.attrVal = '2'
-- AuthType = 2 indicates passkey is set for that client
UPDATE #tempTableForPasskey
SET expirationTimeStamp = ISNULL((select T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]','integer') from
								authUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
									WHERE T.c.value('@userId','int') = @userId),0)
WHERE authType = 2
UPDATE #tempTableForPasskey
SET enableAuthorizeForRestore = 1
WHERE
	expirationTimeStamp > @currTime AND
	authType = 2
UPDATE VMInfo
SET VMInfo.passkeyXML = (SELECT (
							SELECT authType AS '@authType',
							(SELECT enableAuthorizeForRestore as '@enableAuthorizeForRestore',
							(SELECT expirationTimeStamp as '@time'
								FOR XML PATH('expirationTime'), TYPE)
							FOR XML PATH('passkeySettings'), TYPE)
							FOR XML PATH('advancedPrivacySettings'),TYPE
						)FOR XML PATH(''),TYPE)
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
JOIN #tempTableForPasskey PasskeyInfo ON PasskeyInfo.clientId = VMInfo.clientId
--Fetch retireClientPhase for VMs incase they are deconfigured(2) or retire in progress(1)
--List of clients which are currently getting uninstalled. Shouldn't be a huge table
INSERT INTO #RetireInProgressClientListTbl
	SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
			INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
				AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
				AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
UPDATE VM
SET VM.retireClientPhase = 2
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw VM
JOIN APP_Client AC WITH (NOLOCK) ON AC.id = Vm.clientId AND AC.status & 0x00002 <> 0
UPDATE #APPGetVMInfoForUser_tmp__VMInfoRaw
SET retireClientPhase = 1
WHERE clientId IN (SELECT retireClientId FROM #RetireInProgressClientListTbl)
IF @debug <> 0 BEGIN
    SELECT 'complete vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
-- 3.2 copy data into output table
DECLARE @sql AS NVARCHAR(256) = N'INSERT INTO #APPGetVMInfoForUser_tmp__VMInfo SELECT * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw ORDER BY ' +  @order
EXEC sp_executeSql @sql
DECLARE @totalRecords INT = (SELECT COUNT(clientId) FROM #APPGetVMInfoForUser_tmp__VMInfoRaw)
-- 3.3 remove from output table rows that will not be sent over to the caller
DELETE FROM #APPGetVMInfoForUser_tmp__VMInfo WHERE (id <= @pageNo * @pageSize) OR (id > (@pageNo + 1) * @pageSize)
IF @debug = 1 BEGIN
    SELECT 'output vms', * FROM #APPGetVMInfoForUser_tmp__VMInfo
END
UPDATE  O
SET     vmSubclientId = AAP2.id,
        vmSubclientName = AAP2.subclientName,
		vmBackupsetId = AAP2.backupSet,
		vmInstanceId = AAP2.instance,
        isIndexingV2 = 1
FROM #APPGetVMInfoForUser_tmp__VMInfo O
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
    ON ACP.componentnameId=O.clientId AND ACP.attrName='IndexingV2_VSA' AND ACP.modified=0 AND ACP.attrVal=N'1'
INNER JOIN APP_Application APP1  WITH (NOLOCK)
        ON APP1.id=O.subclientId
INNER JOIN APP_VMBackupSet AVM WITH (NOLOCK)
    ON AVM.ParentBackupSetId=APP1.backupSet AND O.clientId=AVM.VMClientId
INNER JOIN APP_Application AAP2 WITH (NOLOCK)
    ON AAP2.backupSet=AVM.ChildBackupSetId AND AAP2.clientId=O.clientId
-- 3.4 get vendor
UPDATE  O
SET     O.vmVendor = dbo.MapVSVendorId(CAST(attrVal AS INT), -1)
FROM #APPGetVMInfoForUser_tmp__VMInfo O
INNER JOIN APP_InstanceProp AIP WITH (NOLOCK)
	ON AIP.componentNameId=O.instanceId AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified=0
--Apply inclusion/exclusion filters based on vendor type
--If filterVendorType was provided, filter out VMs that are not associated to given vendor
IF @filterVendorType <> -1
BEGIN
    DELETE FROM #APPGetVMInfoForUser_tmp__VMInfo WHERE vmVendor <> @filterVendorType
END
--If excludeVendorType was provided, filter out VMs that are associated to given vendor
IF @excludeVendorType <> -1
BEGIN
    DELETE FROM #APPGetVMInfoForUser_tmp__VMInfo WHERE vmVendor = @excludeVendorType
END
-- ExtentedProperties
-- As of now, we only have extended support for ExtentedProperties.
IF (@propertyLevel >= 20)
BEGIN
	UPDATE S
	SET
		S.vmSubclientId = AAP2.id,
		S.vmSubclientName = AAP2.subclientName,
		S.vmBackupsetId = AAP2.backupSet,
		S.vmInstanceId = AAP2.instance
	FROM    #APPGetVMInfoForUser_tmp__VMInfo S
	INNER JOIN APP_VMBackupSet AVM WITH (NOLOCK)
		ON AVM.ParentBackupSetId=S.backupsetId AND S.clientId=AVM.VMClientId
	INNER JOIN APP_Application AAP2 WITH (NOLOCK)
		ON AAP2.backupSet=AVM.ChildBackupSetId AND AAP2.clientId=S.clientId
	WHERE S.isIndexingV2=1
	UPDATE OT
    SET OT.isContentIndexded = CASE WHEN APCP2.attrval IS NULL THEN 0 ELSE 1 END,
    OT.latestBackupTimeCatalogedSuccessfully = CAST(APCP1.attrval AS INT)
	FROM #APPGetVMInfoForUser_tmp__VMInfo OT
	LEFT OUTER JOIN APP_ClientProp APCP1 WITH (NOLOCK)
		ON APCP1.componentNameId=OT.clientId AND APCP1.attrname='Virtual Machine Latest Backup Time Successfully Cataloged' AND APCP1.modified=0
	LEFT OUTER JOIN APP_ClientProp APCP2 WITH (NOLOCK)
		ON APCP2.componentNameId=OT.clientId AND APCP2.attrname='Content Indexing Enabled' AND APCP2.modified=0
	UPDATE OT
    SET
		OT.dcPlanID=AP.id,
		OT.dcPlanName=AP.id
	FROM #APPGetVMInfoForUser_tmp__VMInfo OT
		INNER JOIN APP_ClientProp ACP  WITH (NOLOCK)
ON ACP.componentNameId=OT.pseudoClientId AND ACP.attrName IN ('Associated Plan', 'Default Data classification Plan') AND ACP.modified=0
		INNER JOIN App_Plan AP  WITH (NOLOCK)
ON CAST(AP.id AS NVARCHAR(128))=ACP.attrVal AND AP.subType=117506053 -- Data classificaiton plan subtype
	--get oldest and latest recovery point
	;WITH dtTblV1 (clientId, oldestDt, newestDt) AS
	(
	    SELECT
	        VMP.VMclientId,
	        MIN(JMB.servStartDate) oldestDt,
	        MAX(JMB.servStartDate) newestDt
	    FROM JMBkpStats JMB WITH(NOLOCK)
	        INNER JOIN APP_VMProp VMP WITH(NOLOCK) ON
				JMB.jobId = VMP.jobId
	            AND JMB.opType IN(4, 14, 59)  -- 4 - BACKUP, 14- SYNTHFULL, 59 - SNAPBACKUP
	            AND JMB.STATUS IN(1, 3, 14)  -- 1- JMSUCCESS, 3 - PARTIALSUCCESS, 14 - JMSUCCESSWITHWARNINGS
	            AND JMB.dataStatus NOT IN (1, 2) 	-- 1- DATA_STATUS_AGED, 2 - DATA_STATUS_MEDIADELETED
				AND VMP.attrName='vmStatus' AND VMP.attrVal IN ('0', '3')/* COMPLETED, PARTIAL_SUCCESS*/
	        INNER JOIN #APPGetVMInfoForUser_tmp__VMInfo OT ON
	            VMP.VMclientId = OT.clientId
			 WHERE OT.isIndexingV2=0
	    GROUP BY VMP.VMclientId
	)
	UPDATE OT
	        SET OldestRecoveryPoint = oldestDt,
	            LatestRecoveryTime = newestDt
	    FROM  #APPGetVMInfoForUser_tmp__VMInfo OT
	        INNER JOIN dtTblV1 t ON
	            t.clientId = OT.clientId
		 WHERE OT.isIndexingV2=0
	;WITH dtTblV2 (clientId, oldestDt, newestDt) AS
	(
	    SELECT
	        OT.clientId,
	        MIN(JMB.servStartDate) oldestDt,
	        MAX(JMB.servStartDate) newestDt
	    FROM JMBkpStats JMB WITH(NOLOCK)
	        INNER JOIN APP_Application AAP WITH (NOLOCK) ON
	            AAP.id=JMB.appId
				AND AAP.appTypeId=106
	            AND JMB.opType IN(4, 14, 59)  -- 4 - BACKUP, 14- SYNTHFULL, 59 - SNAPBACKUP
	            AND JMB.STATUS IN(1, 3, 14)  -- 1- JMSUCCESS, 3 - PARTIALSUCCESS, 14 - JMSUCCESSWITHWARNINGS
	            AND JMB.dataStatus NOT IN(1, 2) 	-- 1- DATA_STATUS_AGED, 2 - DATA_STATUS_MEDIADELETED
	        INNER JOIN #APPGetVMInfoForUser_tmp__VMInfo OT ON
	            AAP.clientId=OT.clientId
	     WHERE OT.isIndexingV2=1
	    GROUP BY OT.clientId
	)
	UPDATE OT
	        SET OldestRecoveryPoint = oldestDt,
	            LatestRecoveryTime = newestDt
	    FROM  #APPGetVMInfoForUser_tmp__VMInfo OT
	        INNER JOIN dtTblV2 t ON
	            t.clientId = OT.clientId
		 WHERE OT.isIndexingV2=1
	-- Subquery version of above queries in case we run into any issue.. to debug values
	-- UPDATE OT
	-- SET OldestRecoveryPoint =  (SELECT MIN (servStartDate) FROM JMBkpStats JMB  WITH (NOLOCK)
	-- 									INNER JOIN JMQinetixUpdateStatus JMQ WITH (NOLOCK)
	-- 								on JMB.jobId = JMQ.jobId AND JMQ.clientId=OT.clientId AND JMB.opType IN (4,14,59) AND JMB.status IN (1,3,14,16) AND JMB.dataStatus NOT IN (1, 2)),
	-- 	LatestRecoveryTime= (SELECT MAX (servStartDate) FROM JMBkpStats JMB  WITH (NOLOCK)
	-- 									INNER JOIN JMQinetixUpdateStatus JMQ WITH (NOLOCK)
	-- 								on JMB.jobId = JMQ.jobId AND JMQ.clientId=OT.clientId AND JMB.opType IN (4,14,59) AND JMB.status IN (1,3,14,16) AND JMB.dataStatus NOT IN (1, 2))
	-- FROM #APPGetVMInfoForUser_tmp__VMInfo OT
	-- WHERE isIndexingV2=0
	--
	-- UPDATE OT
	-- SET OldestRecoveryPoint = (SELECT MIN (servStartDate) FROM JMBkpStats JMB WITH (NOLOCK)
	-- 									INNER JOIN APP_Application AAP WITH (NOLOCK)
	-- 										ON AAP.id=JMB.appId AND AAP.clientId=OT.clientId AND JMB.opType IN (4,14,59) AND AAP.appTypeId=106 AND JMB.status IN (1,3,14) AND dataStatus NOT IN (1, 2)),
	-- 	LatestRecoveryTime= (SELECT MAX (servStartDate) FROM JMBkpStats JMB WITH (NOLOCK)
	-- 									INNER JOIN APP_Application AAP WITH (NOLOCK)
	-- 										ON AAP.id=JMB.appId AND AAP.clientId=OT.clientId AND JMB.opType IN (4,14,59) AND AAP.appTypeId=106 AND JMB.status IN (1,3,14) AND dataStatus NOT IN (1, 2))
	-- FROM #APPGetVMInfoForUser_tmp__VMInfo OT
	-- WHERE isIndexingV2=1
	DECLARE @vmClientId INT				= 0
	DECLARE @vmGuid     NVARCHAR(MAX)
	DECLARE @replicationInfoReq XML
	DECLARE VMInfoCursor CURSOR
    FOR
	SELECT clientId , sGUID FROM #APPGetVMInfoForUser_tmp__VMInfo
	OPEN VMInfoCursor
    FETCH FROM VMInfoCursor INTO @vmClientId, @vmGuid
	SELECT  @vmClientId = clientId, @vmGuid=sGUID FROM #APPGetVMInfoForUser_tmp__VMInfo ORDER BY clientId
	WHILE @@FETCH_STATUS = 0
    BEGIN
		SET @replicationInfoReq = NULL
		DECLARE @repId int = NULL
		-- Order by is not needed for TOP 1
		SELECT TOP 1 @repId =  replicationId FROM APP_VSAReplication WITH(NOLOCK) WHERE sourceGuid = @vmGuid
		IF ( @repId is NOT NULL )
		BEGIN
			SET @replicationInfoReq =	(
											SELECT 20 '@propertyLevel', --ListPropertyLevels_AllProperties
											(
												 SELECT @vmGuid '@sourceGuid' FOR XML PATH('siteInfo'),TYPE
											),
											(
												SELECT
												(
													SELECT 'skipSelectStatment' AS '@name', '1' AS '@value'
													FOR XML PATH('attributes'), TYPE
												)
												FOR XML PATH('processinginstructioninfo'), TYPE
											)
											FOR XML PATH('App_GetVSAReplicationReq')
										)
			EXEC dbo.AppVSAReplicationsGetInfo @replicationInfoReq OUTPUT
			UPDATE #APPGetVMInfoForUser_tmp__VMInfo
			SET replicationResp = @replicationInfoReq.query('App_GetVSAReplicationResp/siteInfo')
			WHERE clientId=@vmClientId
		END
		FETCH FROM VMInfoCursor INTO @vmClientId, @vmGuid
	END
	CLOSE VMInfoCursor
	DEALLOCATE VMInfoCursor
END
-- temp table for backup validated apps
IF OBJECT_ID('tempdb.dbo.#tempTableForVsaApps') IS NOT NULL DROP TABLE #tempTableForVsaApps
CREATE TABLE #tempTableForVsaApps
(
	clientId INT,
	appXML XML,
	bootStatus INT,
	lastValidationJobId INT,
	lastValidatedBackupJobId INT,
	lastValidatedBackupJobCompletionTime INT
)
-- Insert appXMl, bootstatus, lastvalidationJobId and lastValidatedBackupJobId
INSERT INTO #tempTableForVsaApps
SELECT 	componentNameId,
		CAST([Apps Discovered] as xml),
		[VM Backup Validation Boot Status],
		[VM Last Backup Validation JobId],
		[VM Last Validated Backup JobId],
		NULL
	FROM
	(
		select cp1.componentNameId, cp1.attrName, cp1.attrVal
		from #APPGetVMInfoForUser_tmp__VMInfo o
		INNER JOIN APP_ClientProp cp1 WITH(NOLOCK)
		ON cp1.componentNameId = o.clientId
		where cp1.modified = 0 AND cp1.attrName IN ('Apps Discovered', 'VM Backup Validation Boot Status', 'VM Last Backup Validation JobId', 'VM Last Validated Backup JobId')
	) as clients
	PIVOT
	(
			MAX(attrVal)
			For attrName in ([Apps Discovered],
							[VM Backup Validation Boot Status],
							[VM Last Backup Validation JobId],
							[VM Last Validated Backup JobId]
						)
	) as pvt
If(@propertyLevel >= 20)
BEGIN
	-- Update lastValidatedBackupJobCompletionTime time
	UPDATE ta
	set ta.lastValidatedBackupJobCompletionTime = CAST(P.attrVal as INT)
	FROM #tempTableForVsaApps ta inner join APP_VMProp P WITH (NOLOCK)
	on P.jobId = ta.lastValidatedBackupJobId and P.VMclientId = ta.clientId
	where P.attrName = 'vmBackupEndTime'
	-- Change appXML to accomodate new attributes
UPDATE #tempTableForVsaApps set appXML = '<discoveredApps></discoveredApps>' where ISNULL(appXML.exist('discoveredApps'), 0) = 0
UPDATE #tempTableForVsaApps set appXML.modify('insert attribute bootStatus {sql:column("bootStatus")} into /discoveredApps[1]') where bootStatus IS NOT NULL
UPDATE #tempTableForVsaApps set appXML.modify('insert attribute lastValidationJobId {sql:column("lastValidationJobId")} into /discoveredApps[1]') where lastValidationJobId IS NOT NULL
UPDATE #tempTableForVsaApps set	appXML.modify('insert attribute lastValidatedBackupJobId {sql:column("lastValidatedBackupJobId")} into /discoveredApps[1]') where lastValidatedBackupJobId IS NOT NULL
UPDATE #tempTableForVsaApps set appXML.modify('insert attribute lastValidatedBackupJobCompletionTime {sql:column("lastValidatedBackupJobCompletionTime")} into /discoveredApps[1]') where lastValidatedBackupJobCompletionTime IS NOT NULL
END
-- 4 : Compute SLA
IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
CREATE TABLE #SLA_EntityInfo (
clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
status INT, category INT, slaDays INT)
insert into #SLA_EntityInfo(clientId, appTypeId)
SELECT  clientId, 106
FROM #APPGetVMInfoForUser_tmp__VMInfo
exec RptGetSLAOfEntities 2
UPDATE VM
SET slaStatus = SLA.status,
	slaCategory = SLA.Category,
	slaCategoryDescription = dbo.WR_GetSLACategoryString(@i_localeId,SLA.Category)
FROM #APPGetVMInfoForUser_tmp__VMInfo VM
	INNER JOIN #SLA_EntityInfo SLA
		ON VM.clientId = SLA.clientId
UPDATE VM
SET VM.SLAStatus = 5,/*MIGHT_MISS_SLA*/
	VM.SLACategoryDescription = cast(stringVal as xml).value('(App_MightMissSLAList/reasonList/@mightMissReason)[1]','nvarchar(1024)')
FROM #APPGetVMInfoForUser_tmp__VMInfo VM
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = VM.clientId AND Prop.componentType =  3 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
UPDATE VM
SET lastBackupJobInfo = CAST(attrVal AS XML)
FROM #APPGetVMInfoForUser_tmp__VMInfo VM
	INNER JOIN App_ClientProp ACP WITH (NOLOCK)
		ON ACP.componentNameId = VM.clientId AND ACP.attrName= 'Last VM Backup Job Info' AND ACP.modified = 0
UPDATE T1
SET vmstatus = 6 --Failed
from #APPGetVMInfoForUser_tmp__VMInfo T1
INNER JOIN APP_VMProp prop WITH(NOLOCK) ON prop.jobId = ISNULL(lastBackupJobInfo.value('(/lastBackupJobInfo/@jobID)[1]', 'INT'), 0)
and prop.attrname = 'vmStatus' and prop.attrval in ('1', '5', '6') and prop.vmclientId = T1.clientId
and vmStatus = 2
DECLARE @commCellName NVARCHAR(256)
DECLARE @csGuid NVARCHAR(40)
SELECT 	@commCellName = aliasName,
		@csGuid = csGUID
FROM APP_CommCell
WHERE id = 2
-- 5. finally generate message
SET @o_xmlVMStatusInfoResp =
(
    SELECT  @o_errCode    AS '@errorCode',
            @o_errString  AS '@errorMessage',
            @pageNo       AS '@pageNo',
            @pageSize     AS '@pageSize',
            @totalRecords AS '@totalRecords',
            (
                SELECT
                        Vm.displayname				AS '@name',
                        Vm.sGUID					AS '@strGUID',
                        Vm.simOSName				AS '@strOSName',
                        Vm.vsObjType				AS '@type',
                        Vm.vmStatus					AS '@vmStatus',
						Vm.vmstatusError			AS '@vmStatusError',
						vmFailureReasonForWarning   AS '@vmFailureReasonForWarning',
                        Vm.subclientId				AS '@subclientId',
                        Vm.subclientName			AS '@subclientName',
                        VM.jobId					AS '@vmBackupJob',
                        Vm.vmSize					AS '@vmSize',
                        Vm.vmUsedSpace				AS '@vmUsedSpace',
                        Vm.vmGuestSize				AS '@vmGuestSpace',
                        Vm.bkpStartTime				AS '@bkpStartTime',
                        Vm.bkpEndTime				AS '@bkpEndTime',
                        Vm.vmHardware				AS '@vmHardwareVer',
                        Vm.vmHost					AS '@vmHost',
                        Vm.vmAgent					AS '@vmAgent',
                        Vm.vmVendor					AS '@vendor',
						Vm.osType					AS '@osType',
						VM.vmGuestSize				AS '@applicationSize', -- Use Guest size itself as appsize for live values.
						VM.isIndexingV2     		AS '@isIndexingV2',
						Vm.isDeleted				AS '@isDeleted',
						Vm.isContentIndexded		AS '@isContentIndexded',
						Vm.OldestRecoveryPoint		AS  '@OldestRecoveryPoint',
						Vm.LatestRecoveryTime		AS '@LatestRecoveryTime',
						Vm.latestBackupTimeCatalogedSuccessfully AS '@latestBackupTimeCatalogedSuccessfully',
						Vm.storagepolicyName    AS  '@storagepolicyName',
						Vm.schedulePolicy		AS  '@schedulePolicy',
						VM.isFSAgentBackedUp	AS	'@isFSAgentBackedUp',
						VM.slaStatus				AS	'@slaStatus',
						VM.slaCategory				AS	'@slaCategory',
						VM.slaCategoryDescription	AS	'@slaCategoryDescription',
						VM.showBackupOption		AS '@isBackupAllowed',
						VM.retireClientPhase	AS '@retireClientPhase',
                        (SELECT Vm.clientId           AS '@clientId',
                                Vm.clientName         AS '@clientName',
								Vm.displayname        AS '@displayName' FOR XML PATH('client'),       TYPE),
						 replicationResp.query('.'),
                        (SELECT Vm.pseudoClientId     AS '@clientId',
                                Vm.pseudoClientName   AS '@clientName',
                                (SELECT CASE WHEN VM.pseudoClientStatus&2<>0 THEN '1'
                                            ELSE '0' END AS '@disabled'
                                    FOR XML PATH('flags'), TYPE) FOR XML PATH('pseudoClient')
                            , TYPE),
                        (SELECT Vm.proxyClientId      AS '@clientId',
                                Vm.proxyClientName    AS '@clientName' FOR XML PATH('proxyClient'),  TYPE),
                        (
                            CASE Vm.isIndexingV2 WHEN 1 THEN
                            (SELECT Vm.vmSubclientId     AS '@subclientId',
                                    Vm.vmSubclientName   AS '@subclientName',
									VM.vmBackupsetId	 AS '@backupsetId',
									VM.vmInstanceId as '@instanceId'
									FOR XML PATH('vmSubClientEntity'), TYPE)
                                ELSE NULL
                                END
                        ),
						(SELECT VM.subclientId AS '@subclientId',
                                    VM.subclientName AS '@subclientName',
                                    VM.backupsetId AS '@backupsetId'
                                    FOR XML PATH('vsaSubClientEntity'),TYPE),
						(SELECT VM.nextBackupSubclientId AS '@subclientId',
                                    VM.nextBackupSubclientName AS '@subclientName',
                                    VM.nextBackupBackupsetId AS '@backupsetId',
(SELECT CASE WHEN VM.nextBackupSubclientStatus&0x00004<>0 THEN '1'
                                            ELSE NULL END AS '@deleted'
                                    FOR XML PATH('flags'), TYPE)
                                    FOR XML PATH('vsaNextBackupSubClientEntity'),TYPE),
						(SELECT Vm.dcPlanID AS '@planId',
                                Vm.dcPlanName AS '@planName'
								FOR XML PATH('dcPlan'),TYPE),
                        (SELECT Vm.planId AS '@planId',
                                Vm.planName AS '@planName'
                        FOR XML PATH('plan'),TYPE),
						(SELECT Vm.instanceId AS '@instanceId'
						FOR XML PATH('instanceEntity'),TYPE),
						(
						SELECT	@commCellName AS '@commCellName',
								@csGuid AS '@csGUID',
1 '@_type_'
						FOR XML PATH('commCell'),TYPE
						),
						( SELECT appXML
							FROM #tempTableForVsaApps
							where clientId = Vm.clientId
						),
						vm.passkeyXML.query('.'),
						(SELECT Vm.lastBackupJobInfo.query('.'))
                FROM    #APPGetVMInfoForUser_tmp__VMInfo Vm
                INNER JOIN
                    (SELECT clientId, MAX(jobId) AS JOB
                    FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
                    GROUP BY clientId) groupedVM
                ON Vm.clientId = groupedVM.clientId
                AND Vm.jobId = groupedVM.job
                AND vm.clientName IS NOT NULL
                AND Vm.vmStatus<>0
				WHERE ((@status = 0) OR (Vm.vmStatus = @status))
                FOR XML PATH('vmStatusInfoList'), TYPE
            )
    FOR XML PATH('App_VMStatusInfoResp')
)
-- 5. clean up
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfo'           ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfo
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'        ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#idaClientList'							 ) IS NOT NULL DROP TABLE #idaClientList
IF OBJECT_ID('tempdb.dbo.#CompanyClients'							 ) IS NOT NULL DROP TABLE #CompanyClients
IF object_id('tempdb.dbo.#tempTableForVsaApps'						 ) IS NOT null DROP TABLE #tempTableForVsaApps
IF OBJECT_ID('tempdb.dbo.#tempTableForPasskey'						 ) IS NOT null DROP TABLE #tempTableForPasskey
IF object_id('tempdb.dbo.#RetireInProgressClientListTbl'             ) IS NOT NULL DROP TABLE #RetireInProgressClientListTbl
RETURN
ERROR_EXIT:
SET @o_xmlVMStatusInfoResp =
(
    SELECT  @o_errCode AS '@errorCode',
            @o_errString AS '@errorMessage'
    FOR XML PATH('App_VMStatusInfoResp')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMStatusInfoForUser')
	delete from GxQscripts where name = 'AppGetVMStatusInfoForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoForUser')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoForUser'
GO

insert into GXDBVersions values(2, 'AppGetVMStatusInfoForUser',  'v1.1.2.61.6.1', 'AppGetVMStatusInfoForUser', 'v1.1.2.61.6.1')
GO

