

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMStatusInfoForClient.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMStatusInfoForClient.sp,v $ $Id: AppGetVMStatusInfoForClient.sp,v 1.1.2.15 2020/08/07 09:13:05 scheppuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMStatusInfoForClient')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMStatusInfoForClient <<<'
	drop procedure AppGetVMStatusInfoForClient
END
IF EXISTS (select * from GxQscripts where name='AppGetVMStatusInfoForClient')
	delete from GxQscripts where name = 'AppGetVMStatusInfoForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoForClient')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoForClient'
GO
print '... Creating Procedure: AppGetVMStatusInfoForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMStatusInfoForClient
  @clientID INT,
  @o_xmlVMStatusInfoResp XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX)
IF @clientID = 0
BEGIN
	SET @errorCode = 100
	SET @errorString = 'Client Id must be provided'
	GOTO ERROR_EXIT
END
IF @clientID > 0 AND NOT EXISTS(SELECT 1 FROM APP_Client WHERE id = @clientID)
BEGIN
	SET @errorCode = 101
	SET @errorString = 'Client with provided Id does not exist.'
	GOTO ERROR_EXIT
END
-- 0.2 table variable that will hold protected vms info
DECLARE @VmInfoTbl TABLE
(
	clientID	    int,
vmName	    nvarchar(1024 ),
sGUID 		    nvarchar(1024 ),
	vsObjType	    int,
    jobId           int,
	commCellId      int,
vmStatus	    nvarchar(1024 ),
simOSName	    nvarchar(1024 ),
    subclientId     int,
    subclientName   nvarchar(512),
    vmSize          bigint,
    vmUsedSpace     bigint,
    vmGuestSize     bigint,
    bkpStartTime    int,
    bkpEndTime      int,
vmHardware      nvarchar(1024 ),
vmHost          nvarchar(1024 ),
vmHostVersion          nvarchar(1024 ),
vmAgent          nvarchar(1024 ),
	vmVendor			int,
	pseudoClientId			int,
pseudoClientName     nvarchar(1024 ),
	applicationId			INT,
appName					 nvarchar(1024 ),
    instanceId				INT,
instanceName			 nvarchar(1024 ),
	backupsetId             INT,
backupsetName            nvarchar(1024 )
)
INSERT INTO @VmInfoTbl (clientID)
	select @clientID
--update basic details
UPDATE @VmInfoTbl
	SET jobId = ISNULL(( select max(VM.jobid) from app_vmprop VM
	INNER JOIN JMBkpStats JM WITH (NOLOCK) ON JM.jobId = VM.jobId AND JM.bkpLevel <> 64
	where VM.VMclientId=VMInfo.clientID and VM.attrName='vmStatus' and VM.attrVal in ('0','3') group by VMclientId),0),
	vmName	  =ISNULL((select attrVal from APP_ClientProp CP WITH (NOLOCK) WHERE CP.componentNameId = VMInfo.clientID and CP.attrName='Virtual Machine Name' and modified=0),''),
    subclientId  = ISNULL((select top 1 CAST(attrVal AS INT) from APP_ClientProp CP WITH (NOLOCK) WHERE CP.componentNameId = VMInfo.clientID and CP.attrName='VSA Discover Subclient ID' and modified=0 order by created desc),0),
	sGUID		= ISNULL((select attrVal from APP_ClientProp CP WITH (NOLOCK) WHERE CP.componentNameId = VMInfo.clientID and CP.attrName='Virtual Machine Instance UUID' and modified=0),''),
	instanceId  = ISNULL((select top 1 CAST(attrVal AS INT) from APP_ClientProp CP WITH (NOLOCK) WHERE CP.componentNameId = VMInfo.clientID and CP.attrName='Virtual Machine Instance ID' and modified=0 order by created desc),0)
FROM @VmInfoTbl VMInfo
-- and backup properties
UPDATE @VmInfoTbl
SET		commCellId	  =	(SELECT commCellId FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmStatus'),
		vmSize        = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmSize'),
        vmUsedSpace   = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmUsedSpace'),
        vmGuestSize   = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmGuestSize'),
        bkpStartTime  = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupStartTime'),
        bkpEndTime    = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupEndTime'),
        vmHardware    = (SELECT attrVal                 FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = S.clientID AND ACP.attrName = 'Virtual Machine Hardware Version' AND ACP.modified = 0),
        vmHost        = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmHost'),
        vmHostVersion = (SELECT attrVal                 FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = S.clientID AND ACP.attrName = 'Virtual Machine Host Version' AND ACP.modified = 0),
		vmAgent       = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmAgent')
FROM    @VmInfoTbl S WHERE S.jobId <> 0
--Set subclientId for VMs which are stopped getting backup but it has successful backups
UPDATE @VmInfoTbl
	SET subclientId  = ISNULL((select appid from JMBkpStats JM WITH (NOLOCK) WHERE JM.jobId = VMInfo.jobId and JM.commCellId = VMInfo.commCellId),0)
FROM @VmInfoTbl VMInfo where jobId <> 0 and subclientId = 0
--update pseudo client, backupset and instance details
UPDATE VMInfo
     SET applicationId = ida.type,appName =ida.displayName,
     backupsetId =backupset.id,backupsetName =backupset.name,
     subclientName = APP.subclientName,pseudoClientName = Cl.name,pseudoClientId=Cl.id, instanceName =instance.name,instanceId=instance.id,
     vmVendor =(SELECT  dbo.MapVSVendorId(CAST(attrVal AS INT), -1)  FROM APP_InstanceProp WHERE	attrName = 'Virtual Server Instance Type' AND componentNameId = instance.id)
FROM @VmInfoTbl VMInfo
	INNER JOIN APP_Application APP WITH (NOLOCK) ON  VMInfo.subclientId = APP.id
	INNER JOIN App_iDatype AS ida WITH(NOLOCK) ON APP.appTypeId = ida.type
	INNER JOIN APP_BackupSetName AS backupset WITH(NOLOCK) ON APP.backupSet = backupSet.id
	INNER JOIN APP_InstanceName AS instance WITH(NOLOCK) ON APP.instance = instance.id
	INNER JOIN APP_Client Cl WITH (NOLOCK) ON APP.clientId = Cl.id
where VMInfo.subclientId <> 0
--set the details if it is not already set using subclientId
UPDATE VMInfo
SET vmVendor =(SELECT  dbo.MapVSVendorId(CAST(attrVal AS INT), -1)  FROM APP_InstanceProp WHERE	attrName = 'Virtual Server Instance Type' AND componentNameId = instanceId)	,
pseudoClientId= (select top 1 clientID from APP_Application APP WITH (NOLOCK)  where APP.instance= VMInfo.instanceId),pseudoClientName='',instanceName=''
FROM @VmInfoTbl VMInfo
where VMInfo.instanceId <> 0 and VMInfo.subclientId =0
--update pseudo client name and instance name
UPDATE VMInfo
     SET pseudoClientName = Cl.name, instanceName =instance.name
FROM @VmInfoTbl VMInfo
	INNER JOIN APP_InstanceName AS instance WITH(NOLOCK) ON VMInfo.instanceId = instance.id
	INNER JOIN APP_Client Cl WITH (NOLOCK) ON VMInfo.pseudoClientId = Cl.id
WHERE VMInfo.pseudoClientName = '' OR VMInfo.instanceName = ''
-- generate xml message
SET @o_xmlVMStatusInfoResp =
(
	SELECT	Vm.vmName	    AS '@name',
			Vm.sGUID		    AS '@strGUID',
			Vm.simOSName	    AS '@strOSName',
			Vm.vsObjType	    AS '@type',
			Vm.vmStatus		    AS '@vmStatus',
            Vm.subclientId      AS '@subclientId',
            Vm.subclientName    AS '@subclientName',
            VM.jobId            AS '@vmBackupJob',
            Vm.vmSize           AS '@vmSize',
            Vm.vmUsedSpace      AS '@vmUsedSpace',
            Vm.vmGuestSize      AS '@vmGuestSpace',
            Vm.bkpStartTime     AS '@bkpStartTime',
            Vm.bkpEndTime       AS '@bkpEndTime',
            Vm.vmHardware       AS '@vmHardwareVer',
            Vm.vmHost           AS '@vmHost',
			Vm.vmHostVersion	AS '@vmHostVersion',
            Vm.vmAgent          AS '@vmAgent',
			Vm.vmVendor			AS '@vendor',
			(SELECT Vm.pseudoClientId     AS '@clientId',
                                Vm.pseudoClientName   AS '@clientName' FOR XML PATH('pseudoClient'), TYPE),
			 (SELECT VM.subclientId AS '@subclientId',
                                    VM.subclientName AS '@subclientName',
                                    VM.backupsetId AS '@backupsetId',
                                    VM.backupsetName AS '@backupsetName',
                                    VM.instanceId AS '@instanceId',
                                    VM.instanceName AS '@instanceName',
                                    VM.applicationId AS '@applicationId',
                                    VM.appName AS '@appName',
                                    VM.pseudoClientId AS '@clientId',
                                    VM.pseudoClientName AS '@clientName',
                                    7 AS '@_type_'
									FOR XML PATH('vsaSubClientEntity'),TYPE)
	FROM    @VmInfoTbl Vm
	FOR XML PATH('vmStatusInfo')
)
RETURN
ERROR_EXIT:
SET @o_xmlVMStatusInfoResp =
(
	SELECT	@errorString AS '@name'
	FOR XML PATH('vmStatusInfo')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMStatusInfoForClient')
	delete from GxQscripts where name = 'AppGetVMStatusInfoForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoForClient')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoForClient'
GO

insert into GXDBVersions values(2, 'AppGetVMStatusInfoForClient',  '00010001000200150000', 'AppGetVMStatusInfoForClient', '00010001000200150000')
GO

