

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMStatusInfoEx.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMStatusInfoEx.sp,v $ $Id: AppGetVMStatusInfoEx.sp,v 1.1.2.10.20.1 2021/02/12 05:27:08 alakra Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVMStatusInfoEx')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMStatusInfoEx <<<'
	drop procedure AppGetVMStatusInfoEx
END
IF EXISTS (select * from GxQscripts where name='AppGetVMStatusInfoEx')
	delete from GxQscripts where name = 'AppGetVMStatusInfoEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoEx')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoEx'
GO
print '... Creating Procedure: AppGetVMStatusInfoEx'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVMStatusInfoEx
  @userId INT,
  @localeId INT,
  @i_xmlVMStatusInfoReq XML,
  @o_xmlVMStatusInfoResp XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @status					INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@vmStatus)[1]','INT'), 0)
DECLARE @pageNo					INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@pageNo)[1]','INT'), 0)
DECLARE @pageSize				INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@pageSize)[1]','INT'), 0x7fffffff)
DECLARE @order					NVARCHAR(255)	= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@order)[1]','NVARCHAR(255)'), '2 ASC')
DECLARE @o_pagesCount			INT				= 0
DECLARE @filterProviderId		INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/provider/@providerId)[1]','INT'), -1)
DECLARE @includeDeleted			INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/@includeDeleted)[1]','INT'), 1)
DECLARE @userHasDirectCapability	INT             = 1
DECLARE @permissionString		NVARCHAR(MAX)	= ''
DECLARE @entityId	    		INT				= 0
DECLARE @entityType	    		INT				= 0
DECLARE @isPermissionFailed     INT             = 0
DECLARE @clientID				INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nClientId)[1]', 'INT'), 0)
DECLARE @subclientID			INT				= ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nSubclientId)[1]', 'INT'), 0)
SET @o_errCode = 0
SET @o_errString = ''
DECLARE @debug                INT = 0
-- 0. preapare temporary tables
IF LEN(ISNULL(@order, '')) = 0 BEGIN SET @order = '2 ASC' END
IF @debug <> 0 BEGIN
    SELECT @userId AS userID, @status AS [Status], @pageNo AS pageNo, @pageSize AS pageSize, @order AS [Order]
END
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfo'           ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfo
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'        ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#APPJobCycleTbl_tmp_VM'                     ) IS NOT null DROP TABLE #APPJobCycleTbl_tmp_VM
-- Both Client Id and Subclient can't be 0
IF @clientID = 0 AND @subclientID = 0
BEGIN
SET @o_errCode = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1)) AND [localeId] = @localeId)
	GOTO ERROR_EXIT
END
-- Provided id should be valid ones
IF (@clientID > 0) AND (@subclientID = 0)
BEGIN
	IF NOT EXISTS(SELECT 1 FROM APP_Client WHERE id = @clientID)
	BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Client Id')
		GOTO ERROR_EXIT
	END
	SET @entityId = @clientID
SET @entityType = 3
END
ELSE
BEGIN
	IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @subclientID)
	BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Subclient Id')
		GOTO ERROR_EXIT
	END
	SET @entityId = @subclientID
SET @entityType = 7
END
IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
CREATE TABLE #idaListTemp
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
--VIEW CAPABILITY
EXECUTE sec_getIdaObjectsForUser @userId, @entityType , 0, 0, '#idaListTemp'
-- Check if user have VIEW rights on hypervisior or subclient.
IF NOT EXISTS (SELECT 1 FROM #idaListTemp WHERE ((@entityType=7 AND (t_subclientId=@entityId))) OR ((@entityType=3 AND (t_clientId=@entityId))))
BEGIN
	SET @userHasDirectCapability =0
SET @o_errCode = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
SET @o_errString = REPLACE(@o_errString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
	GOTO ERROR_EXIT
END
-- 0.1 table variable that will hold vm backup job ids
CREATE TABLE #APPJobCycleTbl_tmp_VM
(
    vmClientId          INT,
    jobId               INT,
    clientId            INT,
    instanceId          INT,
    appId               INT,
    subClientName       NVARCHAR(1024)
)
-- 0.3 table variable that will hold proxy clients id for each instance
DECLARE @proxyClientsTbl TABLE
(
    instanceId  INT,
    clientId    INT,
    clientName  NVARCHAR(1024)
)
-- 0.3 table variable that will hold protected vms info
CREATE TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
(
    clientId					INT,
    clientName					NVARCHAR(1024),
	displayName					NVARCHAR(1024),
    sGUID						NVARCHAR(1024),
    vsObjType					INT,
    jobId						INT,
    vmStatus					NVARCHAR(1024),
    simOSName					NVARCHAR(1024),
    subclientId					INT,
    subclientName				NVARCHAR(512),
    vmSize						BIGINT,
    vmUsedSpace					BIGINT,
    vmGuestSize					BIGINT,
    bkpStartTime				INT,
    bkpEndTime					INT,
    vmHardware					NVARCHAR(1024),
    vmHost						NVARCHAR(1024),
    vmAgent						NVARCHAR(1024),
    pseudoClientId				INT,
    pseudoClientName			NVARCHAR(1024),
    pseudoClientStatus			INT,
    proxyClientId				INT,
    proxyClientName				NVARCHAR(1024),
    vmSubclientId				INT DEFAULT 0,
    vmSubclientName				NVARCHAR(512) DEFAULT N'',
    isIndexingV2				INT DEFAULT 0,
    vmVendor					INT,
    planId						INT,
    planName					NVARCHAR(1024) NULL,
	osType						int,
	isDeleted					INT  DEFAULT 0
)
CREATE TABLE #APPGetVMInfoForUser_tmp__VMInfo
(
    id                  INT IDENTITY(1,1),
    clientId					INT,
    clientName					NVARCHAR(1024),
	displayName					NVARCHAR(1024),
    sGUID						NVARCHAR(1024),
    vsObjType					INT,
    jobId						INT,
    vmStatus					NVARCHAR(1024),
    simOSName					NVARCHAR(1024),
    subclientId					INT,
    subclientName				NVARCHAR(512),
    vmSize						BIGINT,
    vmUsedSpace					BIGINT,
    vmGuestSize					BIGINT,
    bkpStartTime				INT,
    bkpEndTime					INT,
    vmHardware					NVARCHAR(1024),
    vmHost						NVARCHAR(1024),
    vmAgent						NVARCHAR(1024),
    pseudoClientId				INT,
    pseudoClientName			NVARCHAR(1024),
    pseudoClientStatus			INT,
    proxyClientId				INT,
    proxyClientName				NVARCHAR(1024),
    vmSubclientId				INT DEFAULT 0,
    vmSubclientName				NVARCHAR(512) DEFAULT N'',
    isIndexingV2				INT DEFAULT 0,
    vmVendor					INT,
    planId						INT,
    planName					NVARCHAR(1024) NULL,
	osType						int,
	isDeleted			       INT  DEFAULT 0
)
-- get list of jobs
-- Get List of All VM's for there last job
-- Table Varible is fine here as we won't be looking at too large data set here
DECLARE @clientListTbl Table
(
    clientId            INT,
    jobId               INT
)
-- Get All VM's that have "last backup Job Id" but don't include deleted VM's is not requested in the XML request
INSERT INTO @clientListTbl
SELECT ACP.componentNameId , CAST(ACP.attrVal AS INT) FROM APP_ClientProp ACP WITH (NOLOCK)
LEFT OUTER JOIN APP_ClientProp ACP1
	ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Virtual Machine Deletion Time' AND ACP1.modified=0 AND ACP1.attrVal<>'0' AND @includeDeleted=0
WHERE ACP.attrName='Last Backup JobID' AND ACP.modified=0 AND ACP1.id is NULL
-- Get All VM's in APP_VMProp
INSERT INTO #APPJobCycleTbl_tmp_VM
SELECT CLT.clientId, CLT.jobId, AAP.clientId, AAP.instance, AAP.id, AAP.subclientName FROM @clientListTbl CLT
    INNER JOIN JMBkpStats JMB WITH (NOLOCK)
        ON JMB.jobId= CLT.jobId
    INNER JOIN APP_Application AAP WITH (NOLOCK)
            ON AAP.id= JMB.appId AND AAP.appTypeId=106
IF @debug <> 0 BEGIN
    SELECT 'Final VM List', * FROM #APPJobCycleTbl_tmp_VM
END
-- We have basic information of all VM's. Keep one's which fit the criteria
-- We are not yet certain whether we will keep storing Synth Full job for "Last Backup jobid" or not.
-- In V2 case, that jobid is of VM child job and not mapped to parent subclient. Hence, we might have to introduce one extra check above to get parent subclient and hyper v details.
-- Therefore we have to do explicit delete here
IF (@subclientID > 0)
BEGIN
	-- Delete all VM's which doesn't belong to provided subclient
	DELETE FROM #APPJobCycleTbl_tmp_VM WHERE appId<>@subclientID
END
ELSE
BEGIN
	-- Delete all VM's which doesn't belong to provided hypervisior
	DELETE FROM #APPJobCycleTbl_tmp_VM WHERE clientId<>@clientID
END
-- get list of proxies
INSERT INTO @proxyClientsTbl
    SELECT AIP.componentNameId,
    CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'int'),
    CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'nvarchar(1024)')
    FROM APP_InstanceProp AIP WITH (NOLOCK) INNER JOIN #APPJobCycleTbl_tmp_VM JID ON AIP.componentNameId = JID.instanceId AND AIP.attrName = 'Vs Member Servers'
IF @debug <> 0 BEGIN
    SELECT 'proxies', * FROM @proxyClientsTbl
END
-- Following below changes, VM will not have pending state. In case we want this, we will have to revisit this SP to figure out such details.
-- get vms information into the table
INSERT INTO #APPGetVMInfoForUser_tmp__VMInfoRaw (clientID, vmStatus, vsObjType, jobId, pseudoClientId, proxyClientId, proxyClientName, subclientId, subclientName)
SELECT  DISTINCT(VMP.VMclientId), CASE WHEN (VMP.attrVal = N'0') THEN 1
                                  WHEN (VMP.attrVal = N'1') THEN 2
                                  WHEN (VMP.attrVal = N'2' OR VMP.attrVal = N'4') THEN 3
                                  WHEN (VMP.attrVal = N'3') THEN 4
                                  ELSE 0
                                  END,
9 AS [type], VMP.jobId, JIT.clientId AS pseudoClientId, PCT.clientId AS proxyClientId, PCT.clientName AS proxyClientName, JIT.appId AS subClientId, JIT.subclientName AS subclientName
FROM    APP_VMProp VMP WITH (NOLOCK)
            INNER JOIN #APPJobCycleTbl_tmp_VM JIT ON VMP.jobId = JIT.jobId AND JIT.vmClientId=VMP.VMclientId
            LEFT OUTER JOIN @proxyClientsTbl PCT ON PCT.instanceId = JIT.instanceId
		WHERE  VMP.attrName = 'vmStatus'
IF @debug <> 0 BEGIN
    SELECT 'raw vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
IF @debug <> 0 BEGIN
    SELECT 'filtered vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
IF @filterProviderId <> -1
BEGIN
IF object_id('tempdb.dbo.#CompanyClients') IS NOT NULL
    DROP TABLE #CompanyClients
CREATE TABLE #CompanyClients
(
    clientId    INT
)
CREATE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
INSERT INTO #CompanyClients
    SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
        INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
DELETE
FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
WHERE ClientId NOT IN
            ( SELECT clientId FROM #CompanyClients)
IF @debug <> 0 BEGIN
    SELECT 'company vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
END
-- fill up output table
-- client name, OS name to all inserted clients
UPDATE  VM
    SET     VM.SimOsName   = ACP.attrVal
    FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
	INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
		ON ACP.attrName = 'Operating System Name' AND ACP.componentNameId = Vm.clientID AND ACP.modified = 0
UPDATE VM
	SET VM.clientName = AC.name,
		VM.displayname = AC.displayname
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
INNER JOIN APP_Client AC WITH (NOLOCK)
	ON  Vm.clientID = AC.id
-- and GUID to all inserted clients
UPDATE  #APPGetVMInfoForUser_tmp__VMInfoRaw
SET     sGUID = P.attrVal
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw Vm INNER JOIN APP_VMProp P WITH (NOLOCK) ON Vm.clientID = P.VMclientId AND P.jobId = VM.jobId
WHERE   P.attrName  = 'vmGUID'
-- At this moment, we have GUID for all VM's. We should get unprotected VM if requreid
-- For security check, user should have direct VIEW permission on the entity passed int the request
-- We have already checked for subclient if user have direct VIEW capability on subclient.
-- If hypervisior clientid is passed, then in that case we will check below again. As of now, we know that user have rights to atleast one of the subclient of passed hypervisior id
IF ((@status = 0 OR @status = 2) AND (@userHasDirectCapability =1))
BEGIN
	IF (@subclientID > 0)
	BEGIN
			MERGE #APPGetVMInfoForUser_tmp__VMInfoRaw AS target
				USING
				(
					SELECT DISTINCT JQ.clientid, AC.name, CAST(AC.guid AS NVARCHAR(MAX)), 9 FROM JMQinetixUpdateStatus JQ WITH (NOLOCK)
																INNER JOIN JMBkpStats JS WITH (NOLOCK)
																	ON JQ.jobId = JS.jobId AND JQ.commCellId = JS.commCellId AND JS.appId = @subclientId
																INNER JOIN APP_Client AC
																	ON AC.id = JQ.clientId
																LEFT OUTER JOIN #APPGetVMInfoForUser_tmp__VMInfoRaw CT ON CT.clientId = JQ.clientId
																WHERE CT.clientId IS NULL
				) AS source (id, name,guid,type)
				ON (target.sGuid = source.guid)
				WHEN NOT MATCHED THEN
					INSERT (displayname, vmStatus, sGUID, vsObjType)
					VALUES (source.name, 2, source.guid, source.type);
	END
	ELSE
	BEGIN
		-- View permission
		EXECUTE sec_checkPermissionOnEntity @userId, 0, @userHasDirectCapability OUTPUT, @entityType,@entityId
		-- If user have direct permission, then return all unprotected VM's
		IF (@userHasDirectCapability = 1)
		BEGIN
		-- Add unprotected VM's in case of request type is all or only unprotected
		DECLARE @vmContentStr VARCHAR(MAX)
		DECLARE @vmContent XML
		SET @vmContentStr = (SELECT TOP 1 attrVal FROM APP_ExtendedProperties WITH(NOLOCK) WHERE attrName = 'Virtual Server Content' AND clientId = @clientID)
		SET @vmContent = @vmContentStr
		DECLARE @count INT
		SET @count = ISNULL( (select @vmContent.value('count(/EVGui_ManualDiscoverResp/guestHosts2)', 'int')), 0 )
		IF @count > 0
		BEGIN
			MERGE #APPGetVMInfoForUser_tmp__VMInfoRaw AS target
			USING
			(
				SELECT ref.value('@name', 'nvarchar(max)'), ref.value('@guid', 'nvarchar(max)'), ref.value('@vsobjType', 'nvarchar(max)')
				FROM   @vmContent.nodes('EVGui_ManualDiscoverResp/guestHosts2') R ( ref )
			) AS source (name,guid,type)
			ON (target.sGuid = source.guid) and (target.displayname = source.name)
			WHEN NOT MATCHED THEN
				INSERT (displayname, vmStatus, sGUID, vsObjType)
				VALUES (source.name, 2, source.guid, source.type);
			SET @o_errCode = 1
			END
		END
	END
END
-- Update Name and status of Pseudo client
UPDATE  VM
SET     VM.pseudoClientName = Ac.displayName, VM.pseudoClientStatus=AC.status
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
    INNER JOIN APP_Client AC WITH (NOLOCK)
        ON Vm.pseudoClientId = AC.id
UPDATE  VM
SET     VM.isDeleted = 1
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw VM
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
        ON Vm.clientId = ACP.componentnameId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0'
-- and backup properties
UPDATE #APPGetVMInfoForUser_tmp__VMInfoRaw
SET     vmSize           = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmSize'),
        vmUsedSpace      = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmUsedSpace'),
        vmGuestSize      = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmGuestSize'),
        bkpStartTime     = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupStartTime'),
        bkpEndTime       = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupEndTime'),
        vmHardware       = (SELECT attrVal                 FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = S.clientID AND ACP.attrName = 'Virtual Machine Hardware Version' AND ACP.modified = 0),
        vmHost           = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmHost'),
        vmAgent          = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmAgent')
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw S
--updating planid,planname information.
UPDATE  S
SET     S.planId = AP.id,
        S.planName = AP.name
FROM    #APPGetVMInfoForUser_tmp__VMInfoRaw S
INNER JOIN APP_SubClientProp sprop
    ON S.subclientId = sprop.componentNameId
AND sprop.attrName = 'Associated Plan'
    AND sprop.modified =0
INNER JOIN App_Plan AP
     ON sprop.attrVal=CAST(AP.id AS NVARCHAR(MAX))
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
--update os type
update VMInfo
set osType = case when simOS.type ='Windows' then 1 else 2 end
from #APPGetVMInfoForUser_tmp__VMInfoRaw VMInfo
inner join app_client C
on VMInfo.clientId = C.id
inner join simOperatingSystem simOS
on simOS.id = C.simOperatingSystemId
IF @debug <> 0 BEGIN
    SELECT 'complete vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
-- 3.2 copy data into output table
DECLARE @sql AS NVARCHAR(256) = N'INSERT INTO #APPGetVMInfoForUser_tmp__VMInfo SELECT * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw ORDER BY ' +  @order
EXEC sp_executeSql @sql
DECLARE @totalRecords INT = (SELECT COUNT(clientId) FROM #APPGetVMInfoForUser_tmp__VMInfoRaw)
-- 3.3 remove from output table rows that will not be sent over to the caller
DELETE FROM #APPGetVMInfoForUser_tmp__VMInfo WHERE (id <= @pageNo * @pageSize) OR (id > (@pageNo + 1) * @pageSize)
IF @debug = 1 BEGIN
    SELECT 'output vms', * FROM #APPGetVMInfoForUser_tmp__VMInfo
END
UPDATE  O
SET     vmSubclientId = AAP2.id,
        vmSubclientName = AAP2.subclientName,
        isIndexingV2 = 1
FROM #APPGetVMInfoForUser_tmp__VMInfo O
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
    ON ACP.componentnameId=O.clientId AND ACP.attrName='IndexingV2_VSA' AND ACP.modified=0 AND ACP.attrVal=N'1'
INNER JOIN APP_Application APP1  WITH (NOLOCK)
        ON APP1.id=O.subclientId
INNER JOIN APP_VMBackupSet AVM WITH (NOLOCK)
    ON AVM.ParentBackupSetId=APP1.backupSet AND O.clientId=AVM.VMClientId
INNER JOIN APP_Application AAP2 WITH (NOLOCK)
    ON AAP2.backupSet=AVM.ChildBackupSetId AND AAP2.clientId=O.clientId
-- 3.4 get vendor
UPDATE  #APPGetVMInfoForUser_tmp__VMInfo
SET     vmVendor = (SELECT  dbo.MapVSVendorId(CAST(attrVal AS INT), -1)
                    FROM    APP_InstanceProp
                    WHERE   attrName = 'Virtual Server Instance Type' AND componentNameId = (SELECT instance FROM APP_Application WHERE id = O.subclientId))
FROM #APPGetVMInfoForUser_tmp__VMInfo O
-- 3.5 make sure display name is set
UPDATE  #APPGetVMInfoForUser_tmp__VMInfo
SET     displayName = clientName
WHERE   displayName IS NULL
-- 4. Finally generate message
SET @o_xmlVMStatusInfoResp =
(
    SELECT  @o_errCode    AS '@errorCode',
            @o_errString  AS '@errorMessage',
            @pageNo       AS '@pageNo',
            @pageSize     AS '@pageSize',
            @totalRecords AS '@totalRecords',
            (
                SELECT
                        Vm.displayname      AS '@name',
                        Vm.sGUID            AS '@strGUID',
                        Vm.simOSName        AS '@strOSName',
                        Vm.vsObjType        AS '@type',
                        Vm.vmStatus         AS '@vmStatus',
                        Vm.subclientId      AS '@subclientId',
                        Vm.subclientName    AS '@subclientName',
                        VM.jobId            AS '@vmBackupJob',
                        Vm.vmSize           AS '@vmSize',
                        Vm.vmUsedSpace      AS '@vmUsedSpace',
                        Vm.vmGuestSize      AS '@vmGuestSpace',
                        Vm.bkpStartTime     AS '@bkpStartTime',
                        Vm.bkpEndTime       AS '@bkpEndTime',
                        Vm.vmHardware       AS '@vmHardwareVer',
                        Vm.vmHost           AS '@vmHost',
                        Vm.vmAgent          AS '@vmAgent',
                        Vm.vmVendor         AS '@vendor',
						Vm.osType			AS '@osType',
						Vm.isDeleted		AS '@isDeleted',
                        (SELECT Vm.clientId           AS '@clientId',
                                Vm.clientName         AS '@clientName',
								Vm.displayname        AS '@displayName' FOR XML PATH('client'),       TYPE),
                        (SELECT Vm.pseudoClientId     AS '@clientId',
                                Vm.pseudoClientName   AS '@clientName',
                                (SELECT CASE WHEN VM.pseudoClientStatus&2<>0 THEN '1'
                                            ELSE '0' END AS '@disabled'
                                    FOR XML PATH('flags'), TYPE) FOR XML PATH('pseudoClient')
                            , TYPE),
                        (SELECT Vm.proxyClientId      AS '@clientId',
                                Vm.proxyClientName    AS '@clientName' FOR XML PATH('proxyClient'),  TYPE),
                        (
                            CASE Vm.isIndexingV2 WHEN 1 THEN
                            (SELECT Vm.vmSubclientId     AS '@subclientId',
                                    Vm.vmSubclientName   AS '@subclientName' FOR XML PATH('vmSubClientEntity'), TYPE)
                                ELSE NULL
                                END
                        ),
                        (SELECT Vm.planId AS '@planId',
                                Vm.planName AS '@planName'
                        FOR XML PATH('plan'),TYPE)
                FROM    #APPGetVMInfoForUser_tmp__VMInfo Vm
                WHERE (vm.displayName IS NOT NULL) AND (Vm.vmStatus != 0)
				AND ((@status = 0) OR (Vm.vmStatus = @status))
                FOR XML PATH('vmStatusInfoList'), TYPE
            )
    FOR XML PATH('App_VMStatusInfoResp')
)
-- 5. clean up
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'        ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfo'           ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfo
IF OBJECT_ID('tempdb.dbo.#APPJobCycleTbl_tmp_VM'                     ) IS NOT null DROP TABLE #APPJobCycleTbl_tmp_VM
RETURN
ERROR_EXIT:
SET @o_xmlVMStatusInfoResp =
(
    SELECT  @o_errCode AS '@errorCode',
            @o_errString AS '@errorMessage'
    FOR XML PATH('App_VMStatusInfoResp')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMStatusInfoEx')
	delete from GxQscripts where name = 'AppGetVMStatusInfoEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfoEx')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfoEx'
GO

insert into GXDBVersions values(2, 'AppGetVMStatusInfoEx',  'v1.1.2.10.20.1', 'AppGetVMStatusInfoEx', 'v1.1.2.10.20.1')
GO

