

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMStatusInfo.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMStatusInfo.sp,v $ $Id: AppGetVMStatusInfo.sp,v 1.8.14.19.20.1 2021/02/12 05:27:06 alakra Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVMStatusInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMStatusInfo <<<'
	drop procedure AppGetVMStatusInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetVMStatusInfo')
	delete from GxQscripts where name = 'AppGetVMStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfo'
GO
print '... Creating Procedure: AppGetVMStatusInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVMStatusInfo
  @i_xmlVMStatusInfoReq XML,
  @o_xmlVMStatusInfoResp XML OUTPUT,
  @i_jobsList INT = 0,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET @o_errCode = 0
SET @o_errString = ''
DECLARE @userId INT = 0
SET @userId = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@userId)[1]', 'integer')
DECLARE @localeId INT = 0
SET @localeId = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/locale/@localeId)[1]', 'integer'), 0)
DECLARE @clientID INT = 0
SET @clientID = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nClientId)[1]', 'integer')
DECLARE @subclientID INT = 0
SET @subclientID = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nSubclientId)[1]', 'integer')
DECLARE @propertyLevel	INT = 30
SET @propertyLevel = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@nPropertyLevel)[1]','INT')
DECLARE @status	INT = 0
SET @status = @i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@vmStatus)[1]','INT')
DECLARE @fromDate INT = NULL
SET @fromDate = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@fromDate)[1]','INT'), 0)
DECLARE @toDate INT = NULL
SET @toDate = ISNULL(@i_xmlVMStatusInfoReq.value('(/App_VMStatusInfoReq/@toDate)[1]','INT'), 0)
DECLARE @includeDeleted AS	INT	= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/@includeDeleted)[1]','INT'), 1)
DECLARE @bCurrentState AS	INT	= ISNULL(@i_xmlVMStatusInfoReq.value('(App_VMStatusInfoReq/@bCurrentState)[1]','INT'), 0)
-- If current state is requested, then simply send call to other SP. there is nothing to do here
IF @bCurrentState = 1
BEGIN
	EXEC AppGetVMStatusInfoEx @userId, @localeId , @i_xmlVMStatusInfoReq, @o_xmlVMStatusInfoResp OUTPUT, @o_errCode OUTPUT,  @o_errString OUTPUT
	GOTO SP_EXIT
END
IF @clientID = 0 AND @subclientID = 0
BEGIN
SET @o_errCode = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1 | (CAST(POWER(2, 24) AS BIGINT) * 1)) AND [localeId] = @localeId)
	GOTO ERROR_EXIT
END
IF (@clientID > 0) AND (@subclientID = 0)
BEGIN
	IF NOT EXISTS(SELECT 1 FROM APP_Client WHERE id = @clientID)
	BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Client Id')
		GOTO ERROR_EXIT
	END
END
ELSE
BEGIN
	IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @subclientID)
	BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', 'Subclient Id')
		GOTO ERROR_EXIT
	END
END
IF object_id('tempdb.dbo.#VmInfoTbl') is not null
	DROP TABLE #VmInfoTbl
CREATE TABLE #VmInfoTbl
(
	clientID			INT,
clientName			NVARCHAR(1024 ),
sGUID 				NVARCHAR(1024 ),
	vsObjType			INT,
    jobId				INT,
vmStatus			NVARCHAR(1024 ),
simOSName			NVARCHAR(1024 ),
    subclientId			INT,
    subclientName		NVARCHAR(512),
    vmSize				BIGINT,
    vmUsedSpace			BIGINT,
    vmGuestSize			BIGINT,
    bkpStartTime		INT,
    bkpEndTime			INT,
vmHardware			NVARCHAR(1024 ),
vmHost				NVARCHAR(1024 ),
vmAgent				NVARCHAR(1024 ),
	backupsetId			INT,
	backupsetName		NVARCHAR(1024 ),
	osType    			INT,
	isDeleted			INT  DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
CREATE TABLE #idaListTemp
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
--VIEW CAPABILITY
EXEC sec_getIdaObjectsForUser @userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#idaListTemp'
DECLARE @JobIDTbl TABLE (id int, vmclientId int)
-- For Any given time duration, we need to see if there was any job which successfully backed up vm.
-- For any VM, if no job in that duration failed to back it up, then for us, it is not protected.
-- If JMbkpstats have entry for the same, then we will assume that job is not pruned.
-- Corner case here will be that, job pruning is going on byt we still refer that jobid. But again, that's corner case and if we consider that, then our overall query becomses slow.
IF EXISTS (SELECT TOP 1 * FROM #idaListTemp WHERE @subclientID > 0 AND @subclientID=t_subclientId)
BEGIN
    IF @i_jobsList = 0
		BEGIN
				INSERT INTO @JobIDTbl
				SELECT  MAX(JB.jobId), AVP.VMclientId
				FROM    JMBkpStats JB WITH (NOLOCK)
				INNER JOIN APP_VMProp AVP WITH (NOLOCK)
					ON AVP.jobId = JB.jobId AND AVP.attrName='vmstatus' AND AVP.attrVal in ('0', '3')
				WHERE       JB.appId = @subclientId
						AND JB.status IN (1,3,14,16)
						AND ((JB.servStartDate BETWEEN @fromDate AND @toDate) OR (ISNULL(@fromDate, 0) = 0 AND ISNULL(@toDate, 0) = 0))
				GROUP BY AVP.VMclientId
		END
	ELSE
		BEGIN
			INSERT INTO @JobIDTbl
				SELECT  MAX(JB.jobId), AVP.VMclientId
				FROM    JMBkpStats JB WITH (NOLOCK)
				INNER JOIN APP_VMProp AVP WITH (NOLOCK)
					ON AVP.jobId = JB.jobId AND AVP.attrName='vmstatus' AND AVP.attrVal in ('0', '3')
				WHERE       JB.appId = @subclientId
						AND JB.status IN (1,3,14,16)
						AND JB.servStartDate BETWEEN @fromDate AND @toDate
				GROUP BY AVP.VMclientId
		END
END
ELSE IF @clientID > 0
BEGIN
    IF @i_jobsList = 0
		BEGIN
			INSERT INTO @JobIDTbl
				SELECT  MAX(JM.jobId), AVP.VMclientId
				FROM    JMBkpStats JM WITH (NOLOCK)
					INNER JOIN APP_Application APP WITH (NOLOCK)
						ON  JM.appId = APP.id AND APP.clientId = @clientID AND JM.status in (1,3,14,16)
					INNER JOIN #idaListTemp IDA  WITH (NOLOCK)
						ON IDA.t_subclientId = APP.id
					INNER JOIN APP_VMProp AVP WITH (NOLOCK)
						ON AVP.jobId = JM.jobId AND AVP.attrName='vmstatus' AND AVP.attrVal in ('0', '3')
				WHERE   ((servStartDate BETWEEN @fromDate AND @toDate) OR (ISNULL(@fromDate, 0) = 0 AND ISNULL(@toDate, 0) = 0))
				GROUP BY AVP.VMclientId
		END
	ELSE
		BEGIN
			INSERT INTO @JobIDTbl
				SELECT  MAX(JM.jobId), AVP.VMclientId
				FROM    JMBkpStats JM WITH (NOLOCK)
				INNER JOIN APP_Application APP WITH (NOLOCK)
					ON  JM.appId = APP.id AND APP.clientId = @clientID
				INNER JOIN #idaListTemp IDA  WITH (NOLOCK)
					ON IDA.t_subclientId = APP.id
				INNER JOIN APP_VMProp AVP WITH (NOLOCK)
						ON AVP.jobId = JM.jobId AND AVP.attrName='vmstatus' AND AVP.attrVal in ('0', '3')
				WHERE       JM.[status] IN (1,3,14,16)
						AND JM.servStartDate BETWEEN @fromDate AND @toDate
				GROUP BY AVP.VMclientId
		END
END
-- Following below changes, VM will not have pending state. In case we want this, we will have to revisit this SP to figure out such details.
	INSERT INTO #VmInfoTbl (clientID, vmStatus, vsObjType, jobId)
SELECT AVP.VMclientId, CASE WHEN (AVP.attrVal = N'0') THEN 1                                           -- ALL or Protected vms
                                  WHEN (AVP.attrVal = N'1') THEN 2                                     -- ALL or Not Protected vms
                                  WHEN (AVP.attrVal = N'2' OR AVP.attrVal = N'4') THEN 3               -- ALL or Pending vms
                                  WHEN (AVP.attrVal = N'3') THEN 4                                     -- ALL or Backed up with error vms
                                  ELSE 0
                                  END, 9, JD.id FROM APP_VMProp AVP WITH (NOLOCK)
INNER JOIN @JobIDTbl JD ON
	JD.vmclientId=AVP.VMclientId AND AVP.jobId=JD.id
	WHERE AVP.attrName = 'vmStatus' AND (
												(@status = 0) OR
												(
													((@status = 1) AND (AVP.attrVal = 0)) OR
													((@status = 2) AND (AVP.attrVal = 1)) OR
													((@status = 3) AND (AVP.attrVal = 2 OR AVP.attrVal = 4)) OR
													((@status = 4) AND (AVP.attrVal = 3))
												)
											)
-- Remove unwanted VM's based on input parameters
DELETE VM
FROM #VmInfoTbl VM
INNER JOIN APP_ClientProp ACP
	ON ACP.componentNameId=VM.clientId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0' AND @includeDeleted=0
DELETE FROM #VmInfoTbl
WHERE NOT EXISTS (SELECT 1 FROM APP_CLIENT C WHERE C.id = clientID)
-- and client name, OS name to all inserted clients
UPDATE  #VmInfoTbl
SET     clientName = Cl.displayName, simOSName = substring(P.attrVal, 0, CHARINDEX(':-', P.attrVal))
FROM    #VmInfoTbl Vm INNER JOIN APP_Client Cl    WITH (NOLOCK) ON VM.clientID = Cl.id
                      INNER JOIN APP_ClientProp P WITH (NOLOCK) ON P.componentNameId = Cl.id
WHERE   P.attrName = 'SIM OS INFO'
-- and GUID to all inserted clients
UPDATE  #VmInfoTbl
SET     sGUID = P.attrVal
FROM    #VmInfoTbl Vm INNER JOIN APP_VMProp P WITH (NOLOCK) ON Vm.clientID = P.VMclientId AND P.jobId = VM.jobId
WHERE   P.attrName  = 'vmGUID'
-- Get Deleted VM Flag
UPDATE  VM
SET     VM.isDeleted = 1
FROM    #VmInfoTbl VM
INNER JOIN APP_ClientProp ACP WITH (NOLOCK)
        ON Vm.clientID = ACP.componentnameId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0'
 --update os type
update VMInfo
set osType = case when simOS.type ='Windows' then 1 else 2 end
from #VmInfoTbl VMInfo
inner join app_client C
on VMInfo.clientId = C.id
inner join simOperatingSystem simOS
on simOS.id = C.simOperatingSystemId
-- and backup properties
UPDATE #VmInfoTbl
SET     vmSize       = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmSize'),
        vmUsedSpace  = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmUsedSpace'),
        vmGuestSize  = (SELECT CAST(attrVal AS BIGINT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmGuestSize'),
        bkpStartTime = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupStartTime'),
        bkpEndTime   = (SELECT CAST(attrVal AS    INT) FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmBackupEndTime'),
        vmHardware   = (SELECT attrVal                 FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = S.clientID AND ACP.attrName = 'Virtual Machine Hardware Version' AND ACP.modified = 0),
        vmHost       = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmHost'),
		vmAgent      = (SELECT attrVal                 FROM APP_VMProp P WITH (NOLOCK) WHERE P.jobId = S.jobId AND P.VMclientId = S.clientID AND P.attrName = 'vmAgent'),
        subclientId  = (SELECT appId FROM JMBkpStats  WITH (NOLOCK) WHERE jobId = S.jobId)
FROM    #VmInfoTbl S
DELETE FROM #idaListTemp
-- Check for VIEW capability instead of Browse Permission
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaListTemp'
-- ALL or Not Protected vms for the client --check if Db populated with all vm info
IF EXISTS (SELECT TOP 1 * from #idaListTemp WHERE @clientID > 0 AND @subclientID = 0 AND (@status = 0 OR @status = 2) AND @clientID=t_clientId)
BEGIN
	DECLARE @vmContentStr VARCHAR(MAX)
	DECLARE @vmContent XML
	SET @vmContentStr = (SELECT TOP 1 attrVal FROM APP_ExtendedProperties WITH(NOLOCK) WHERE attrName = 'Virtual Server Content' AND clientId = @clientID)
	SET @vmContent = @vmContentStr
	DECLARE @count INT
    SET @count = ISNULL( (select @vmContent.value('count(/EVGui_ManualDiscoverResp/guestHosts2)', 'int')), 0 )
    IF @count > 0
    BEGIN
		MERGE #VmInfoTbl AS target
		USING
		(
			SELECT ref.value('@name', 'nvarchar(max)'), ref.value('@guid', 'nvarchar(max)'), ref.value('@vsobjType', 'nvarchar(max)')
			FROM   @vmContent.nodes('EVGui_ManualDiscoverResp/guestHosts2') R ( ref )
		) AS source (name,guid,type)
		ON (target.sGuid = source.guid) and (target.clientName = source.name)
		WHEN NOT MATCHED THEN
			INSERT (clientName, vmStatus, sGUID, vsObjType)
			VALUES (source.name, 2, source.guid, source.type);
		SET @o_errCode = 1
	END
END
-- Issue with this SP is , with specific request for status 2, all vm will be considered as Not Protected.
-- This has been issue for long, so will fix the same in SP8 and not Hotfix for SP7
IF (@subclientID <> 0 AND (@status = 0 OR @status = 2))
BEGIN
	MERGE #VmInfoTbl AS target
		USING
		(
			SELECT DISTINCT JQ.clientid, AC.name, CAST(AC.guid AS NVARCHAR(MAX)), 9 FROM JMQinetixUpdateStatus JQ WITH (NOLOCK)
														INNER JOIN JMBkpStats JS WITH (NOLOCK)
															ON JQ.jobId = JS.jobId AND JQ.commCellId = JS.commCellId AND JS.appId = @subclientId
														INNER JOIN APP_Client AC
															ON AC.id = JQ.clientId
														LEFT OUTER JOIN #VmInfoTbl CT ON CT.clientId = JQ.clientId
														WHERE CT.clientId IS NULL
		) AS source (id, name,guid,type)
		ON (target.sGuid = source.guid)
		WHEN NOT MATCHED THEN
			INSERT (clientName, vmStatus, sGUID, vsObjType)
			VALUES (source.name, 2, source.guid, source.type);
		SET @o_errCode = 1
END
-- and subclient name
UPDATE  #VmInfoTbl
SET     subclientName = App.subclientName,
		backupsetId = App.backupSet,
		backupsetName = BS.name
FROM    #VmInfoTbl S
inner join APP_Application APP on App.id = S.subclientId
inner join APP_BackupSetName BS on BS.id = App.backupSet
-- generate xml message
SET @o_xmlVMStatusInfoResp =
(
	SELECT	@o_errCode AS '@errorCode',
			@o_errString AS '@errorMessage',
			(
				SELECT	Vm.clientName	    AS '@name',
						Vm.sGUID		    AS '@strGUID',
						Vm.simOSName	    AS '@strOSName',
						Vm.vsObjType	    AS '@type',
						Vm.vmStatus		    AS '@vmStatus',
                        Vm.subclientId      AS '@subclientId',
                        Vm.subclientName    AS '@subclientName',
                        VM.jobId            AS '@vmBackupJob',
                        Vm.vmSize           AS '@vmSize',
                        Vm.vmUsedSpace      AS '@vmUsedSpace',
                        Vm.vmGuestSize      AS '@vmGuestSpace',
                        Vm.bkpStartTime     AS '@bkpStartTime',
                        Vm.bkpEndTime       AS '@bkpEndTime',
                        Vm.vmHardware       AS '@vmHardwareVer',
                        Vm.vmHost           AS '@vmHost',
                        Vm.vmAgent          AS '@vmAgent',
						Vm.isDeleted		AS '@isDeleted',
						Vm.osType			AS '@osType',
						(select Vm.subclientId AS '@subclientId',
								Vm.subclientName AS '@subclientName',
								Vm.backupsetId AS '@backupsetId',
								Vm.backupsetName AS '@backupsetName'
						for xml path('vsaSubClientEntity'), TYPE)
				FROM    #VmInfoTbl Vm
                WHERE  Vm.vmStatus<>0
				FOR XML PATH('vmStatusInfoList'), TYPE
			)
	FOR XML PATH('App_VMStatusInfoResp')
)
SP_EXIT:
RETURN
ERROR_EXIT:
SET @o_xmlVMStatusInfoResp =
(
	SELECT	@o_errCode AS '@errorCode',
			@o_errString AS '@errorMessage'
	FOR XML PATH('App_VMStatusInfoResp')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMStatusInfo')
	delete from GxQscripts where name = 'AppGetVMStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusInfo'
GO

insert into GXDBVersions values(2, 'AppGetVMStatusInfo',  'v1.8.14.19.20.1', 'AppGetVMStatusInfo', 'v1.8.14.19.20.1')
GO

