

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMStatusForJob.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2016  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMStatusForJob.sp,v $ $Id: AppGetVMStatusForJob.sp,v 1.1.2.1 2017/04/06 19:47:56 sjoseph Exp $";
-- =========================================================
-- Author: Sarath Joseph
-- Description: Get the VMBackup status for job
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMStatusForJob <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMStatusForJob')
	drop procedure AppGetVMStatusForJob
IF EXISTS (select * from GxQscripts where name='AppGetVMStatusForJob')
	delete from GxQscripts where name = 'AppGetVMStatusForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusForJob')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusForJob'
GO
print '... Creating Procedure: AppGetVMStatusForJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMStatusForJob
  @xmlText XML
AS
SET NOCOUNT ON;
DECLARE @jobID INT = @xmlText.value('(Api_GetVMStatusReq)[1]/@jobId', 'int')
IF object_id('tempdb.dbo.#vmInfoTbl') IS NOT null DROP TABLE #vmInfoTbl
CREATE TABLE #vmInfoTbl
(
	clientID	    int,
	vmGUID 		    nvarchar(max),
	vmStatus	    int,
    vmHost          nvarchar(max),
	vmAgent         nvarchar(max),
    vmFailureReason nvarchar(max)
)
insert into #vmInfoTbl
select vmclientId, vmGUID, vmStatus, vmHost, vmAgent, vmFailureReason
FROM
(select VMclientId, attrName, attrVal
from app_vmprop WITH (NOLOCK)
where jobId = @jobId
and attrName in ( 'vmGUID', 'vmStatus','vmHost', 'vmAgent', 'vmFailureReason')
) T
PIVOT ( max(attrval) for attrName in ([vmGUID],[vmStatus],[vmHost],[vmAgent], [vmFailureReason]) )pv;
SET @xmlText = (
select
(
	select vmGUID as '@strGUID',
		   vmStatus as '@vmStatus',
		   vmFailureReason as '@vmFailureReason',
		   vmAgent as '@vmAgent',
		   vmHost as '@vmHost'
	from #vmInfoTbl V
	for xml path ('vmStatusInfo'),TYPE
)
	for xml path ('Api_GetVMStatusResp'),TYPE)
select @xmlText
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMStatusForJob')
	delete from GxQscripts where name = 'AppGetVMStatusForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMStatusForJob')
	delete from GXDBVersions where aliasname = 'AppGetVMStatusForJob'
GO

insert into GXDBVersions values(2, 'AppGetVMStatusForJob',  '00010001000200010000', 'AppGetVMStatusForJob', '00010001000200010000')
GO

