

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMRegionList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMRegionList.sp,v $ $Id: AppGetVMRegionList.sp,v 1.12.14.8 2018/06/25 21:01:41 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMRegionList"
--	|	This Procedure is used to get the list of available VM Amazon Region List
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMRegionList <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMRegionList')
	drop procedure AppGetVMRegionList
IF EXISTS (select * from GxQscripts where name='AppGetVMRegionList')
	delete from GxQscripts where name = 'AppGetVMRegionList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMRegionList')
	delete from GXDBVersions where aliasname = 'AppGetVMRegionList'
GO
print '... Creating Procedure: AppGetVMRegionList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMRegionList
-- Input arguments
  @i_xmlText XML
AS
DECLARE @userId		INT
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @capabilitiesRequired BIGINT
SET @capabilitiesRequired = CAST(POWER(2.0,2  - 1) AS BIGINT)
SET	@userId = ISNULL (( SELECT ref.value('@userId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetRegionListReq/user') R(ref)), 0)
--commenting instanceId code here, i don't think, it does any functionality changes.
--DECLARE @instanceId int
--SET	@instanceId = ISNULL (( SELECT ref.value('@userId', 'INT')
--					FROM  @i_xmlText.nodes ('Ida_GetRegionListReq/policyType') R(ref)), 0)
-- Policy type should be this: enum VMAllocationPolicyType{VMWARE =0,AMAZON =1,MICROSOFT =2,AZURE =3 }
DECLARE @policyType INT	= 	ISNULL (( SELECT ref.value('@policyType', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetRegionListReq/policyType') R(ref)), 1)
SET @policyType = CASE @policyType WHEN 1 THEN 301 WHEN 3 THEN 401 WHEN 7 THEN 402 WHEN 16 THEN 403 END
IF object_id('tempdb.dbo.#dCenterList') is not null DROP TABLE #dCenterList
CREATE TABLE #dCenterList  (dataCenterId INT,
                                                vCenterName NVARCHAR(255),
                                                dataCenterName NVARCHAR(255),
                                                instanceId INT,
												instanceName NVARCHAR(512),
                                                clientId INT,
												clientName NVARCHAR(512),
                                                canSee INT
                                                )
INSERT #dCenterList
SELECT d.id ,vCenter, case when d.name IS null then d.uniqueName else d.name end, IP.componentNameId, I.name, C.id, C.name, 0
            FROM    APP_InstanceName AS I
            INNER JOIN APP_InstanceProp AS IP ON
                IP.componentNameId = I.id
                AND IP.attrName LIKE 'Virtual Server Instance Type'
                AND IP.attrVal = @policyType
            --AND ( @instanceId =0 or @instanceId = I.id)
            INNER JOIN (select DISTINCT clientId, instance from APP_Application) APP on
            APP.instance = I.id
            INNER JOIN APP_Client C ON
            C.id = APP.clientId
            and C.status & 0x00002 = 0
                AND (I.status & 0x00002) = 0
 	    LEFT JOIN App_VMDataCenterMap AS dm ON
	    dm.instanceId = I.id
	    LEFT JOIN App_VMDataCenter d
	    on d.id = dm.vDataCenterId
	    AND scmOldId =0
            where  d.removalTimeStamp  is NULL
	    and dm.removalTimeStamp is NULL
IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
		DROP TABLE #clientLstWithAgentMgmtCap
	CREATE TABLE #clientLstWithAgentMgmtCap
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
EXEC sec_getIdaObjectsForUser @userId, 3 , 2, 0, '#clientLstWithAgentMgmtCap'
--Select only those objects on which user has Agent managemnet rights
Update DC   SET canSee = 1
FROM #dCenterList DC INNER JOIN #clientLstWithAgentMgmtCap CL ON DC.clientId = CL.clientId
IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
		DROP TABLE #clientLstWithAgentMgmtCap
if @userId = 0                                      -- emulates how it worked "without" security check
    UPDATE #dCenterList SET canSee = 1
SET @r_ReturnResult = ISNULL ((
					--(
					SELECT dataCenterId AS 'region/@regionId',
					 dataCenterName AS 'region/@regionName',
					 instanceId AS 'instance/@instanceId',
					 clientName AS 'instance/@instanceName',
					 clientName as 'instance/@clientName',
					 clientId as 'instance/@clientId'
					FROM #dCenterlist
					where canSee <> 0
					ORDER BY  dataCenterName
					FOR XML PATH('regionList'), ROOT('Ida_GetRegionListResp')
					), '<Ida_GetRegionListResp/>')
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMRegionList')
	delete from GxQscripts where name = 'AppGetVMRegionList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMRegionList')
	delete from GXDBVersions where aliasname = 'AppGetVMRegionList'
GO

insert into GXDBVersions values(2, 'AppGetVMRegionList',  '00010012001400080000', 'AppGetVMRegionList', '00010012001400080000')
GO

