

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMPolicy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMPolicy.sp,v $ $Id: AppGetVMPolicy.sp,v 1.37.12.32 2020/09/29 19:50:16 rsn Exp $";
-- +-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMPolicy"
--	|	This Procedure is used to get the VM Policy
-- +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMPolicy <<<'
	drop procedure AppGetVMPolicy
END
IF EXISTS (select * from GxQscripts where name='AppGetVMPolicy')
	delete from GxQscripts where name = 'AppGetVMPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMPolicy')
	delete from GXDBVersions where aliasname = 'AppGetVMPolicy'
GO
print '... Creating Procedure: AppGetVMPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMPolicy
-- Input arguments
  @i_uid INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @i_scope				INT
DECLARE @i_policyId			INT
DECLARE @i_showDisabled		INT
DECLARE @i_policyName		NVARCHAR(256)
DECLARE @rows					INT
DECLARE @errorString			NVARCHAR(MAX)
DECLARE @errorCode			INT = 0
DECLARE @userId				INT = 0
DECLARE @userGUID				nvarchar(512)
DECLARE @isUserAdmin			INT = 0
DECLARE @canView				INT = 0
DECLARE @checkUserAssoc		INT = 1
DECLARE @showSystemPolicy	INT
DECLARE @defaultPolicyId	INT
DECLARE @flags				INT = 0
DECLARE @labTemplatesOnly   INT = 0
DECLARE @showResourceGroupPolicy INT = 0
DECLARE @showNonResourceGroupPolicy INT = 1
DECLARE @destinationHyperVClient INT = 0
DECLARE	@destinationHyperVClientName NVARCHAR(MAX) = ''
declare @destinationHyperVClientXml xml
DECLARE @proxyClientEntityId Int = 0
DECLARE	@proxyClientEntityName NVARCHAR(MAX) = ''
declare @proxyClientEntityXml xml
declare @isoPolicyOnly int =0
--get how much information is required
SET	@i_scope 	= ISNULL (( SELECT ref.value('@deep', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET	@i_policyId = ISNULL (( SELECT ref.value('@policyid', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET	@i_showDisabled = ISNULL (( SELECT ref.value('@showDisabled', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET	@checkUserAssoc = ISNULL (( SELECT ref.value('@checkUserAssociation', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 1)
SET	@userId	= ISNULL (( SELECT ref.value('@userId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq/user') R(ref)), 0)
SET	@i_policyName = ISNULL (( SELECT ref.value('@policyName', 'NVARCHAR(256)')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), '')
SET	@showSystemPolicy = ~@i_showDisabled
SET	@flags = ISNULL (( SELECT ref.value('@flags', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET @defaultPolicyId  = ISNULL((SELECT id from App_VmAllocationPolicy WHERE name = '_NO_NAME_'),1)
SET	@labTemplatesOnly	= ISNULL (( SELECT ref.value('@labTemplatesOnly', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET	@showResourceGroupPolicy = ISNULL (( SELECT ref.value('@showResourceGroupPolicy', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
SET	@showNonResourceGroupPolicy = ISNULL (( SELECT ref.value('@showNonResourceGroupPolicy', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 1)
SET	@isoPolicyOnly	= ISNULL (( SELECT ref.value('@isoEnabledOnly', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)), 0)
--set policyId if policyName is used as parameter
IF @i_policyName !='' AND @i_policyId <= 0
BEGIN
	SET @i_policyId = ISNULL((SELECT id FROM App_VmAllocationPolicy WHERE name = @i_policyName and alive = 1), @i_policyId)
END
IF (@userId = 0)
BEGIN
	SET	@userGUID = ( SELECT ref.value('@userGUID', 'nvarchar(255)') FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq/user') R(ref))
	SET @userId = ( SELECT id from UMUsers WHERE userGuid=@userGUID and enabled =1)
END
EXECUTE sec_isUserAdmin   @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
DECLARE @UserTable TABLE(t_userId	integer, t_nodeCapabilities	bigint, t_childCapabilities	bigint)
INSERT INTO @UserTable EXEC Sec_iDaNodeAccess @userId, 2, 0, 0, 0, 0, 0
DECLARE @t_capabilities bigint = (SELECT TOP 1 t_nodeCapabilities from @UserTable)
IF ((@checkUserAssoc=0) AND (@t_capabilities & CAST(POWER(2.0, 31 - 1) AS bigint)) > 0)
	SET @canView = 1
IF @flags = 1 AND @checkUserAssoc = 1 AND @isUserAdmin <> 1 AND @canView <> 1 AND @i_policyId = 0
BEGIN
	CREATE TABLE #clientLstWithAgentMgmtCap
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
	DECLARE @visiblePolicies table(
		policyId INT
	)
EXEC sec_getIdaObjectsForUser @userId, 3 , 2, 0, '#clientLstWithAgentMgmtCap'
	INSERT INTO @visiblePolicies
	SELECT	DISTINCT P.id
	FROM	App_VMAllocationPolicy P
			INNER JOIN App_VMDataCenterMap M
				ON P.vDataCenterId = M.vDataCenterId
			INNER JOIN APP_Application A
				ON M.instanceId = A.instance
			INNER JOIN #clientLstWithAgentMgmtCap CL
				ON CL.clientId = A.clientId
	DECLARE @memberServers table(policyId INT, vsMemberServers xml);
	INSERT INTO @memberServers
	SELECT	P.id, CAST(IP.attrVal AS XML)
	FROM	App_VMAllocationPolicy P
			INNER JOIN App_VMDataCenterMap M
				ON P.vDataCenterId = M.vDataCenterId
			INNER JOIN APP_InstanceProp IP
				ON M.instanceId = IP.componentNameId AND IP.attrName = 'Vs Member Servers'
			LEFT OUTER JOIN @visiblePolicies VP
				ON P.id = VP.policyId
	WHERE	VP.policyId IS NULL
	INSERT INTO @visiblePolicies
	SELECT DISTINCT srvTab.policyId
	FROM  @memberServers srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
		  INNER JOIN #clientLstWithAgentMgmtCap CL
				ON CL.clientId = ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0)
	INSERT INTO @visiblePolicies
	SELECT	DISTINCT P.id
	FROM	App_VMAllocationPolicy P
			INNER JOIN APP_VMAllocationPolicyProp vmProp
			on vmProp.componentNameId = p.id
			and vmprop.attrName ='destinationHyperV'
			and vmprop.modified =0
			INNER JOIN #clientLstWithAgentMgmtCap CL
				ON CL.clientId = vmprop.attrVal
	IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
		DROP TABLE #clientLstWithAgentMgmtCap
END
IF (@i_scope = 0)
BEGIN
--Only partial information about the policy_id is required
IF (@i_policyId <> 0)
	BEGIN
	SET @r_ReturnResult = (
					SELECT description AS '@description', id AS 'entity/@vmAllocPolicyId', name AS 'entity/@vmAllocPolicyName',
						   vap.vDataCenterId AS 'dataCenter/@dataCenterId' , (SELECT ds.name FROM [dbo].[App_VMDataCenter] AS ds WHERE ds.id=vap.vDataCenterId) AS 'dataCenter/@dataCenterName'
					FROM         [dbo].[App_VMAllocationPolicy] AS vap
					WHERE 	id = @i_policyId
					FOR XML PATH('policy'), ROOT('Ida_GetVMPolicyResp')
					)
					SET @rows = @@ROWCOUNT
					if (@rows = 0)
					BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @userId, (1023 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0, 2);
     					SET @r_ReturnResult = (	SELECT	1				as TAG,
    					NULL			as Parent,
     					@errorCode		as [EVGui_GenericResp!1!errorCode],
     					@errorString	as [EVGui_GenericResp!1!errorMessage]
     					FOR XML EXPLICIT
     					);
     					SELECT @r_ReturnResult o_xmlString;
     					return;
					END
	END
ELSE
	BEGIN
		DECLARE @priceList TABLE (
			PolicyId		INT,
			CPUPrice		INT,
			MemoryPrice		INT,
			StoragePrice	INT
		)
		DECLARE @policyPrice TABLE (
			PolicyId	INT,
			TotalPrice	BIGINT
		)
		if (@i_showDisabled = 1)
		BEGIN
			INSERT INTO @priceList
			SELECT id, ISNULL(t.value('priceList[1]/@price', 'integer'), 0), ISNULL(t.value('priceList[2]/@price', 'integer'), 0), ISNULL(t.value('priceList[3]/@price', 'integer'), 0)
			FROM	APP_VMAllocationPolicy P
				CROSS APPLY P.vxml.nodes ('policy') M(t)
			WHERE	P.name <> '_NO_NAME_'
				AND	(ISNULL(t.value('priceList[1]/@price', 'integer'), 0) > 0 OR ISNULL(t.value('priceList[2]/@price', 'integer'), 0) > 0 OR ISNULL(t.value('priceList[3]/@price', 'integer'), 0) > 0)
				AND P.alive <> 0
				AND (
					 ( (flags&4)>0 and @showResourceGroupPolicy = 1) OR ( (flags&4)=0 and @showNonResourceGroupPolicy = 1)
				)
			INSERT INTO @policyPrice
			SELECT	POL.vmAllocationPolicyId, (POL.CPUUnits * P2.CPUPrice + POL.MemUnits * P2.MemoryPrice + POL.StUnits * P2.StoragePrice)
			FROM
			(SELECT	v.vmAllocationPolicyId,
					SUM(t.value('cpu[1]/@numCpu', 'integer')) AS 'CPUUnits',
					SUM(t.value('memory[1]/@memorySizeMB', 'float')/(1024 * 1024 * 1024)) AS 'MemUnits',
					SUM(ISNULL(t.value('hardDisks[1]/hardDisk[1]/@capacityInKb', 'float'), 0) + ISNULL(t.value('hardDisks[1]/hardDisk[2]/@capacityInKb', 'float'), 0)) /(1024 * 1024 * 1024) AS 'StUnits'
			FROM	@priceList P
					INNER JOIN APP_VM v
					ON v.vmAllocationPolicyId = P.PolicyId
					CROSS APPLY v.vxml.nodes('QSMServer_QVirtualMachineReq') VM(t)
			WHERE	v.removalTimeStamp IS NULL
				AND	P.CPUPrice IS NOT NULL
			GROUP BY v.vmAllocationPolicyId) AS POL
				INNER JOIN @priceList P2
					ON POL.vmAllocationPolicyId = P2.PolicyId
		END
		IF @flags = 1 AND @checkUserAssoc = 1 AND @isUserAdmin <> 1 AND @canView <> 1
		SET @r_ReturnResult = ISNULL((
					SELECT description AS '@description', vxml.value('(/policy/@enabled)[1]', 'int') AS '@enabled',
						ISNULL(vxml.value('(/policy/@isResourceGroupPolicy)[1]', 'int'),0) AS '@isResourceGroupPolicy',
						ISNULL(vxml.value('(/policy/@minutesRetainUntil)[1]', 'int'),0) AS '@minutesRetainUntil',
						ISNULL(vxml.value('(/policy/@daysRetainUntil)[1]', 'int'),-1) AS '@daysRetainUntil',
						ISNULL(vxml.value('(/policy/@vmPolicyAppType)[1]', 'int'),1) AS '@vmPolicyAppType', --set vmPolicyAppType to REGULAR (1) by default
						ISNULL(vxml.value('(/policy/@isLiveMountEnabled)[1]', 'int'),0) AS '@isLiveMountEnabled',
						ISNULL(vxml.value('(/policy/@createIsolatedNetwork)[1]', 'int'),0) AS '@createIsolatedNetwork', id AS 'entity/@vmAllocPolicyId', name AS 'entity/@vmAllocPolicyName',
						   ISNULL(vxml.value('(/policy/entity/@policyType)[1]', 'int'), 0) AS 'entity/@policyType',
						   (SELECT ds.vCenter FROM [dbo].[App_VMDataCenter] AS ds WHERE ds.id=vap.vDataCenterId) AS 'entity/@vCenterName',
						   vap.vDataCenterId AS 'dataCenter/@dataCenterId' , (SELECT ds.name FROM [dbo].[App_VMDataCenter] AS ds WHERE ds.id=vap.vDataCenterId) AS 'dataCenter/@dataCenterName',
						   vap.vxml.query('(/policy/dataCenter/instanceEntity)[1]') AS 'dataCenter',
						   vap.vxml.query('/policy/networkNames'),
						   vap.vxml.query('/policy/gatewayTemplate'),
						   vap.vxml.query('/policy/vmIPRangeSettings'),
						   vap.vxml.query('/policy/esxServers'),
						   vap.vxml.query('/policy/snapshotManagement'),
						   ISNULL(P.TotalPrice, 0) AS 'priceList/@price', 3 AS 'priceList/@resource',
						   (
								select VAP.vxml.value('(/policy/destinationHyperV/@clientId)[1]', 'int') as '@clientId',
									name as '@clientName'
									from App_client
									where id=vxml.value('(/policy/destinationHyperV/@clientId)[1]', 'int')
									for xml path('destinationHyperV'),TYPE
						   ),
						   (
								select VAP.vxml.value('(/policy/proxyClientEntity/@clientId)[1]', 'int') as '@clientId',
									name as '@clientName'
									from App_client
									where id=vxml.value('(/policy/proxyClientEntity/@clientId)[1]', 'int')
									for xml path('proxyClientEntity'),TYPE
						   ),
						     (
								select ISNULL(VAP.vxml.value('(/policy/HedvigDatastore/@dataStoreId)[1]', 'int'), 0) AS '@dataStoreId',
								  ISNULL(VAP.vxml.value('(/policy/HedvigDatastore/@vdiskName)[1]', 'NVARCHAR(255)'), '')  AS '@vdiskName',
								  name as 'distributedStorage/@distributedStorageName'
								 from App_DistributedStorage
								where id= (Select attrVal FROM HedVigDatastoreProp where attrName = 'Distributed Storage ID'
								and componentNameId = ISNULL(vxml.value('(/policy/HedvigDatastore/@dataStoreId)[1]', 'int'), 0) and modified = 0)
								FOR XML PATH('HedvigDatastore'),TYPE
						   )
					FROM         [dbo].[App_VMAllocationPolicy] AS vap
							INNER JOIN 	@visiblePolicies VP
								ON vap.id = VP.policyId
							LEFT OUTER JOIN @policyPrice P ON vap.id = P.PolicyId
					WHERE vap.alive = 1 AND ( (@i_showDisabled = 1) OR (vxml.value('(/policy/@enabled)[1]', 'int') = 1))  AND ((@showSystemPolicy=1) OR ((vap.flags&1)=0) OR (vap.flags IS NULL) )
					AND (
						( (vap.flags&4)>0 and @showResourceGroupPolicy = 1) OR ( (vap.flags&4)=0 and @showNonResourceGroupPolicy = 1)
					)
					order by vxml.value('(policy/entity/@vmAllocPolicyName)[1]', 'nvarchar(max)')
					FOR XML PATH('policy'), ROOT('Ida_GetVMPolicyResp')
					), '<Ida_GetVMPolicyResp/>')
		ELSE
		SET @r_ReturnResult = ISNULL((
						SELECT description AS '@description', vxml.value('(/policy/@enabled)[1]', 'int') AS '@enabled',
								ISNULL(vxml.value('(/policy/@isResourceGroupPolicy)[1]', 'int'),0) AS '@isResourceGroupPolicy',
								ISNULL(vxml.value('(/policy/@minutesRetainUntil)[1]', 'int'),0) AS '@minutesRetainUntil',
								ISNULL(vxml.value('(/policy/@daysRetainUntil)[1]', 'int'),-1) AS '@daysRetainUntil',
								ISNULL(vxml.value('(/policy/@vmPolicyAppType)[1]', 'int'),1) AS '@vmPolicyAppType', ----set vmPolicyAppType to REGULAR (1) by default
								ISNULL(vxml.value('(/policy/@isLiveMountEnabled)[1]', 'int'),0) AS '@isLiveMountEnabled',
								ISNULL(vxml.value('(/policy/@createIsolatedNetwork)[1]', 'int'),0) AS '@createIsolatedNetwork', id AS 'entity/@vmAllocPolicyId', name AS 'entity/@vmAllocPolicyName',
							   ISNULL(vxml.value('(/policy/entity/@policyType)[1]', 'int'), 0) AS 'entity/@policyType',
							   (SELECT ds.vCenter FROM [dbo].[App_VMDataCenter] AS ds WHERE ds.id=vap.vDataCenterId) AS 'entity/@vCenterName',
							   vap.vDataCenterId AS 'dataCenter/@dataCenterId' , (SELECT ds.name FROM [dbo].[App_VMDataCenter] AS ds WHERE ds.id=vap.vDataCenterId) AS 'dataCenter/@dataCenterName',
							   vap.vxml.query('(/policy/dataCenter/instanceEntity)[1]') AS 'dataCenter',
							   vap.vxml.query('/policy/networkNames'),
							   vap.vxml.query('/policy/gatewayTemplate'),
							   vap.vxml.query('/policy/vmIPRangeSettings'),
							   vap.vxml.query('/policy/esxServers'),
							   vap.vxml.query('/policy/snapshotManagement'),
							   ISNULL(P.TotalPrice, 0) AS 'priceList/@price', 3 AS 'priceList/@resource',
							   (
									select VAP.vxml.value('(/policy/destinationHyperV/@clientId)[1]', 'int') as '@clientId',
										name as '@clientName'
										from App_client
										where id=vxml.value('(/policy/destinationHyperV/@clientId)[1]', 'int')
										for xml path('destinationHyperV'),TYPE
							   ),
							   (
									select VAP.vxml.value('(/policy/proxyClientEntity/@clientId)[1]', 'int') as '@clientId',
										name as '@clientName'
										from App_client
										where id=vxml.value('(/policy/proxyClientEntity/@clientId)[1]', 'int')
										for xml path('proxyClientEntity'),TYPE
							   ),
							     (
								select ISNULL(VAP.vxml.value('(/policy/HedvigDatastore/@dataStoreId)[1]', 'int'), 0) AS '@dataStoreId',
								  ISNULL(VAP.vxml.value('(/policy/HedvigDatastore/@vdiskName)[1]', 'NVARCHAR(255)'), '')  AS '@vdiskName',
								  name as 'distributedStorage/@distributedStorageName'
								 from App_DistributedStorage
								where id= (Select attrVal FROM HedVigDatastoreProp where attrName = 'Distributed Storage ID'
								and componentNameId = ISNULL(vxml.value('(/policy/HedvigDatastore/@dataStoreId)[1]', 'int'), 0) and modified = 0)
								FOR XML PATH('HedvigDatastore'),TYPE
						   )
							    FROM [dbo].[App_VMAllocationPolicy] AS vap
								LEFT OUTER JOIN @policyPrice P ON vap.id = P.PolicyId
						WHERE (vap.alive = 1) AND ((@isUserAdmin = 1) OR (@canView=1) OR ((@checkUserAssoc=1) AND dbo.AppCheckVMPolicySecurityPermissions(@userId, id, @flags) = 1))
								AND ( (@i_showDisabled = 1) OR (vxml.value('(/policy/@enabled)[1]', 'int') = 1))  AND ((@showSystemPolicy=1) OR ((vap.flags&1)=0) OR (vap.flags IS NULL) )
                            AND ((@i_showDisabled = 1) OR  ( @labTemplatesOnly =0 and vap.vxml.value('policy[1]/entity[1]/@policyType','int') NOT IN (5,6)) or ( @labTemplatesOnly =1 and vap.vxml.value('policy[1]/entity[1]/@policyType','int') IN (5,6)) )
							AND (
									( (vap.flags&4)>0 and @showResourceGroupPolicy = 1) OR ( (vap.flags&4)=0 and @showNonResourceGroupPolicy = 1)
							)
							AND ( @isoPolicyOnly = 0 OR ( @isoPolicyOnly =1 AND  vap.vxml.value('count(/policy/isoInfo)','int') >0 ))
						order by vxml.value('(policy/entity/@vmAllocPolicyName)[1]', 'nvarchar(max)')
						FOR XML PATH('policy'), ROOT('Ida_GetVMPolicyResp')
						), '<Ida_GetVMPolicyResp/>')
	END
END
ELSE
BEGIN
-- all the detail of the policy is required
IF (@i_policyId <> 0)
	BEGIN
	SET @r_ReturnResult = (
					SELECT vxml.query('policy')
					FROM         [dbo].[App_VMAllocationPolicy]
					WHERE 	id = @i_policyId
					FOR XML PATH(''), ROOT('Ida_GetVMPolicyResp')
					)
					SET @rows = @@ROWCOUNT
					if (@rows = 0)
					BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @userId, (1023 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0, 2);
     					SET @r_ReturnResult = (	SELECT	1				as TAG,
    					NULL			as Parent,
     					@errorCode		as [EVGui_GenericResp!1!errorCode],
     					@errorString	as [EVGui_GenericResp!1!errorMessage]
     					FOR XML EXPLICIT
     					);
     					SELECT @r_ReturnResult o_xmlString;
     					return;
					END
	--current usage of this policy by user
	DECLARE @createdVMCount INT
	DECLARE	@usedMemoryInGB INT
	DECLARE	@usedCPUCores INT
	SELECT
					@usedCPUCores = SUM(t.value('cpu[1]/@numCpu', 'integer')) ,
					@usedMemoryInGB = SUM(t.value('memory[1]/@memorySizeMB', 'float')/(1024 * 1024 * 1024)) ,
					@createdVMCount = COUNT(V.id)
			FROM	APP_VM v
					INNER JOIN APP_ClientProp CP
					ON CP.componentNameId = v.clientId
					AND CP.attrName = 'Virtual Machine Created by User'
					AND CP.attrVal = @userId
					CROSS APPLY v.vxml.nodes('QSMServer_QVirtualMachineReq') VM(t)
			WHERE	v.removalTimeStamp IS NULL
			AND v.vmAllocationPolicyId = @i_policyId
	SET @r_ReturnResult.modify('insert attribute createdVMCount {sql:variable("@createdVMCount")} as last into (Ida_GetVMPolicyResp/policy)[1]')
	SET @r_ReturnResult.modify('insert attribute usedCPUCores {sql:variable("@usedCPUCores")} as last into (Ida_GetVMPolicyResp/policy)[1]')
	SET @r_ReturnResult.modify('insert attribute usedMemoryInGB {sql:variable("@usedMemoryInGB")} as last into (Ida_GetVMPolicyResp/policy)[1]')
	DECLARE @vendorType INT = 1
	SELECT	@vendorType = CASE CAST(I.attrVal AS INT) WHEN 101 THEN 1 WHEN 102 THEN 2 WHEN 301 THEN 3 WHEN 401 THEN 4 WHEN 402 THEN 7 WHEN 403 THEN 17 WHEN 1101 then 13 ELSE 0 END
	FROM	App_VMAllocationPolicy P, App_VMDataCenterMap D, APP_InstanceProp I
	WHERE	P.vDataCenterId = D.vDataCenterId AND I.componentNameId = D.instanceId
		AND	I.attrName = 'Virtual Server Instance Type'
		AND	I.modified = 0
		AND	P.id = @i_policyId
	--set @r_ReturnResult.modify('insert attribute vendor {sql:variable("@vendorType")} into (/Ida_GetVMPolicyResp/policy)[1]')
	--add disableSuccessEmail flag if exist in App_VMAllocationPolicyProp table
    DECLARE @disableSuccessEmail INT
    SELECT @disableSuccessEmail = attrVal FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='disableSuccessMails'  AND modified ='0'
	IF  @r_ReturnResult.exist('/Ida_GetVMPolicyResp/policy/@disableSuccessEmail')!= 1 AND ISNULL(@disableSuccessEmail,'')!=''
	BEGIN
		SET @r_ReturnResult.modify('insert attribute disableSuccessEmail {sql:variable("@disableSuccessEmail")} as last into (Ida_GetVMPolicyResp/policy)[1]')
	END
	DECLARE @dynDataCenter XML
	IF @r_ReturnResult.exist('/Ida_GetVMPolicyResp/policy/dataCenter') = 0
	BEGIN
		SET @dynDataCenter = (SELECT DC.id AS 'dataCenter/@dataCenterId', DC.vCenter AS 'dataCenter/@vCenterName', DC.name AS 'dataCenter/@dataCenterName'
				FROM  [dbo].[App_VMDataCenter] AS DC
				INNER JOIN  [dbo].[App_VMAllocationPolicy] AS VM_AP ON VM_AP.vDataCenterId=DC.id AND VM_AP.id=@i_policyId
				FOR XML PATH(''), ROOT('TEMP'))
	END
	DECLARE @dynDataStores XML
	IF ( @vendorType = 2)
	BEGIN
		SET @dynDataStores =	(
		    SELECT MIN(DS.id) AS '@dataStoreId', CASE WHEN COUNT(*) > 1 THEN MIN(DS.name) ELSE MIN(VH.name + ' - ' + DS.name) END AS '@dataStoreName'
			FROM  [dbo].[App_VMDataStore] AS DS
				INNER JOIN [dbo].[VMHostToDataStores] AS HD ON DS.id = HD.vDataStoreId
				INNER JOIN [dbo].[App_VMHost] AS VH ON HD.vHostId = VH.id
				INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = DS.id)
			WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='datastore' AND DS.removalTimeStamp IS NULL AND VH.removalTimeStamp IS NULL
			GROUP BY DS.uniqueName
			FOR XML PATH('dataStores'), ROOT('TEMP')
			)
	END
	ELSE
	BEGIN
		SET @dynDataStores =	(
		    SELECT DISTINCT DS.id AS '@dataStoreId',  DS.name AS '@dataStoreName'
			FROM  [dbo].[App_VMDataStore] AS DS
				INNER JOIN [dbo].[VMHostToDataStores] AS HD ON DS.id = HD.vDataStoreId
				INNER JOIN [dbo].[App_VMHost] AS VH ON HD.vHostId = VH.id
				INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = DS.id)
			WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='datastore' AND DS.removalTimeStamp IS NULL AND VH.removalTimeStamp IS NULL
			FOR XML PATH('dataStores'), ROOT('TEMP')
			)
	END
	DECLARE @hostNetworkInfo XML = ''
	IF @vendorType IN (4, 7, 17) -- Azure or ARM or AzureStack
	BEGIN
		DECLARE @vHostId INT = (SELECT CAST(attrVal AS INT) FROM App_VMAllocationPolicyProp WHERE componentNameId = @i_policyId AND attrName = 'esxserver' AND modified = 0 )
		SET @hostNetworkInfo = (
			SELECT H.vxml.query('/QSMServer_QVirtualHostReq/networkInfo')
				FROM APP_VMHost H
				WHERE id= @vHostId
				AND H.vxml.exist('/QSMServer_QVirtualHostReq/networkInfo') = 1
			FOR XML PATH(''), TYPE
			)
	END
	DECLARE @dynESXServers XML = (SELECT ESXT.id AS '@esxServerId', ESXT.name AS '@esxServerName'
			FROM  [dbo].[App_VMHost] AS ESXT
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = ESXT.id) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='esxserver' AND ESXT.removalTimeStamp IS NULL
			FOR XML PATH('esxServers'), ROOT('TEMP'))
	DECLARE @dynMediaAgent XML = (SELECT C.id AS '@clientId', C.name AS '@clientName'
			FROM  [dbo].[App_Client] AS C
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = C.id) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='mediaagent'
			FOR XML PATH('mediaAgent'), ROOT('TEMP'))
	DECLARE @dynTemplates	XML = (SELECT VMT.GUID AS '@vmGUID', CASE WHEN @vendorType IN (4, 7) THEN C.net_hostname ELSE VMT.name END AS '@vmName'
				FROM  [dbo].[APP_VM] AS VMT
				INNER JOIN	[dbo].APP_Client AS C ON (VMT.clientId = C.id)
				INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (VM_APP.attrVal = VMT.GUID) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='vmtemplate' AND VMT.removalTimeStamp IS NULL
				FOR XML PATH('templates'), ROOT('TEMP'))
	DECLARE @dynUsers XML = (SELECT U.userGUID AS '@userGUID',
									CASE WHEN ISNULL(U.name,'') = '' THEN U.login
										 ELSE U.name END AS '@userName' , U.id AS '@userId'
			FROM  [dbo].[umusers] AS U
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = U.id) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='user'
			FOR XML PATH('users'), ROOT('TEMP'))
	DECLARE @dynUserGroups XML = (SELECT UG.id AS '@userGroupId', UG.name AS '@userGroupName'
			FROM  [dbo].[umgroups] AS UG
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = UG.id) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='usergroup'
			FOR XML PATH('userGroups'), ROOT('TEMP'))
	DECLARE @dynExtUserGroups XML = (SELECT EUG.id AS '@groupId', name AS '@externalGroupName'
			FROM  [dbo].[umdsgroups] AS EUG
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (CAST(VM_APP.attrVal AS INT) = EUG.id) WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='extusergroup'
			FOR XML PATH('externalUserGroups'), ROOT('TEMP'))
-- Amazon
	DECLARE @dynAmazonavAilabilityZones XML = 	(SELECT AZone.id AS '@availabilityZoneId',AZone.name AS '@availabilityZoneName'
  			FROM     [dbo].[App_VMHost] AZone
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON	(CAST(VM_APP.attrVal AS INT) = AZone.id) WHERE VM_APP.componentNameId=@i_policyId
			AND VM_APP.attrName='availabilityZones' AND AZone.removalTimeStamp IS NULL
			FOR XML PATH('availabilityZones'), ROOT('TEMP'))
	DECLARE @dynvmInstanceTypes XML;
	declare @allInsSelected int = 0;
	declare @allTemplatesSelected int =0
	select @allInsSelected = isnull(vmx.value('amazonPolicy[1]/@allInstanceTypesSelected', 'int'),1),
		@allTemplatesSelected = isnull(vmx.value('@allTemplatesSelected', 'int'),1)	 from
	App_VMAllocationPolicy pol cross apply pol.vxml.nodes('policy') M(vmx)
	where pol.id = @i_policyId
	IF @i_policyId = @defaultPolicyId
	BEGIN
		-- vendor from @inputXML is VSVendor enum in common.x which needs to be converted to vendorType here which is corresponding to virtual instance type property
		SET @vendorType = ISNULL ((CASE (SELECT ref.value('@vendor', 'INT') FROM  @i_xmlText.nodes ('Ida_GetVMPolicyReq') R(ref)) WHEN 4 THEN 3 -- VSVendor: 4: Amazon ; vendorType(Virtual Server Instance Type) : 3 -> Amazon
									 WHEN 7 THEN 7 -- VSVendor: 7 -> ARM ; same is set above in @vendorType
									 ELSE 4 -- VSVendor: 3-> Azure ; vendorType(Virtual Server Instance Type) : 4 -> Azure
								END)
						, 4)
	END
	IF @vendorType in (7,17) -- for azure rm, stack we browse and get the templates
	BEGIN
		set @dynTemplates = ( SELECT VM_APP.attrVal AS '@vmGUID'
                    FROM [dbo].[App_VMAllocationPolicyProp] AS VM_APP
                    WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='vmtemplate'
                    FOR XML PATH('templates'), ROOT('TEMP'))
	END
	else if ( @allTemplatesSelected = 1 )
	BEGIN
		set @dynTemplates = ( select 	V.GUID AS '@vmGUID', V.name AS '@vmName'
					FROM         [dbo].[App_VM] V
					INNER JOIN [dbo].[App_VMHost] H
					ON V.vHostId = H.id
					AND H.removalTimeStamp IS NULL
					AND V.removalTimeStamp IS NULL
					INNER JOIN [dbo].[App_VMDataCenter] D
					ON H.vDataCenterId = D.id
					AND D.removalTimeStamp IS NULL
					INNER JOIN App_VMAllocationPolicy P
						ON P.vDataCenterId = D.id
						AND p.ID = @i_policyId
					INNER JOIN App_VMDataCenterMap DCM
						ON D.id = DCM.vDataCenterId
					INNER JOIN APP_InstanceProp AS IP ON
						IP.componentNameId = DCM.instanceId
						AND IP.attrName = 'Virtual Server Instance Type'
						AND IP.modified = 0
					LEFT OUTER JOIN APP_ClientProp AS CP2 ON
						V.clientId = CP2.componentNameID
						AND CP2.attrName = 'Virtual Entity Flags'
					CROSS APPLY V.vxml.nodes ('QSMServer_QVirtualMachineReq') M(ds)
					WHERE 	 (ds.value('@isTemplate', 'varchar(8)') = '1' OR CP2.attrVal = '2'
					AND(
							(
								( ISNULL(ds.value('@toolsVersion','INT'), 0) > 8288 )
								--Only following windows versions are supported
								AND ( ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'winVista%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'winLonghorn%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'windows7%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'windows8%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'rhel4%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'rhel5%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(100)'), '') like 'rhel6%' OR
									  --ISNULL(ds.value('@guestOSVersion','varchar(30)'), '') like 'freebsd%' OR
									  ISNULL(ds.value('@guestOSVersion','varchar(30)'), '') like 'ubuntu%'
								)
							 )
							 OR IP.attrVal = 401 OR IP.attrVal = 102
						))
					FOR XML PATH('templates'), ROOT('TEMP'))
	END
	ELSE
	BEGIN
			set @dynTemplates = ( SELECT VMT.GUID AS '@vmGUID', name AS '@vmName'
					FROM  [dbo].[App_VM] AS VMT
					INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON (VM_APP.attrVal = VMT.GUID)
					WHERE VM_APP.componentNameId=@i_policyId AND VM_APP.attrName='vmtemplate' AND VMT.removalTimeStamp IS NULL
					FOR XML PATH('templates'), ROOT('TEMP'))
	END
	if @allInsSelected = 0
		SET @dynvmInstanceTypes  = 	(SELECT Itype.cpuCores as '@cpuCores',
				Itype.cpuUnits as '@cpuUnits',
				Itype.memory as '@memory',
				(SELECT Itype.id AS '@vmInstanceTypeId',
					CASE WHEN @vendorType in(7,17) THEN Itype.instanceType ELSE dbo.GetVMInstanceTypeDesc(Itype.instanceType) END AS '@vmInstanceTypeName'
				FOR XML PATH('instanceType'), TYPE)
				FROM [dbo].[App_VMInstanceTypes] Itype
				INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON	(CAST(VM_APP.attrVal AS INT) = Itype.id) WHERE VM_APP.componentNameId=@i_policyId
				AND VM_APP.attrName='vmInstanceTypes' AND Itype.removalTimeStamp IS NULL
				AND (  (@vendorType =3 and flags =0) or (@vendorType =4 and flags =1) or (@vendorType =7 and flags =3) or (@vendorType =13 and flags =2) or (@vendorType =17 and flags =3))
				FOR XML PATH('instanceType'), ROOT('TEMP'))
	else
		set @dynvmInstanceTypes  = 	(SELECT Itype.cpuCores as '@cpuCores',
				Itype.cpuUnits as '@cpuUnits',
				Itype.memory as '@memory',
				(SELECT Itype.id AS '@vmInstanceTypeId',
					CASE WHEN @vendorType=7 THEN Itype.instanceType ELSE dbo.GetVMInstanceTypeDesc(Itype.instanceType) END AS '@vmInstanceTypeName'
				FOR XML PATH('instanceType'), TYPE)
				FROM [dbo].[App_VMInstanceTypes] Itype where Itype.removalTimeStamp is null
					AND (  (@vendorType =3 and flags =0) or (@vendorType =4 and flags =1) or (@vendorType =7 and flags =3) or (@vendorType =13 and flags =2) or (@vendorType =17 and flags =3))
				FOR XML PATH('instanceType'), ROOT('TEMP'))
	DECLARE @dynsecurityGroup XML = 	(SELECT Sgroup.id AS '@securityGroupId',Sgroup.name  AS '@securityGroupName'
			FROM    [dbo].[App_VMSecurityGroups] Sgroup
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON	(CAST(VM_APP.attrVal AS INT) = Sgroup.id) WHERE VM_APP.componentNameId=@i_policyId
			AND VM_APP.attrName='securityGroup' AND Sgroup.removalTimeStamp IS NULL
			FOR XML PATH('securityGroups'), ROOT('TEMP'))
	DECLARE @dynkeyPair XML = 	(SELECT Keypairs.id AS '@keyPairId',Keypairs.name AS '@keyPairName'
			FROM    [dbo].[App_VMKeyPairs] Keypairs
			INNER JOIN  [dbo].[App_VMAllocationPolicyProp] AS VM_APP ON	(CAST(VM_APP.attrVal AS INT) = Keypairs.id) WHERE VM_APP.componentNameId=@i_policyId
			AND VM_APP.attrName='keyPair' AND Keypairs.removalTimeStamp IS NULL
			FOR XML PATH('keyPair'), ROOT('TEMP'))
			--We have to strip out the <TEMP> and put it into the response XML
		DECLARE @tempXML XML
		SET @tempXML = @dynDataCenter.query('(/TEMP/*)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = @dynMediaAgent.query('(/TEMP/mediaAgent)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = @dynDataStores.query('(/TEMP/dataStores)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = @dynESXServers.query('(/TEMP/esxServers)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = @dynTemplates.query('(/TEMP/templates)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = '<securityAssociations> </securityAssociations>'
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @tempXML = @dynUsers.query('(/TEMP/users)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/securityAssociations)[1]');
		SET @tempXML = @dynUserGroups.query('(/TEMP/userGroups)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/securityAssociations)[1]');
		SET @tempXML = @dynExtUserGroups.query('(/TEMP/externalUserGroups)')
		IF (len (cast (@tempXML as nvarchar(max))) > 0)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/securityAssociations)[1]');
		SET @tempXML = @dynkeyPair.query('(/TEMP/keyPair)')
		--IF (len (cast (@tempXML as nvarchar(max))) > 0)
		BEGIN
			-- NO NEED TO INSERT IN CASE OF AMAZON WE WILL GET THIS XML NODES
			IF @r_ReturnResult.exist('Ida_GetVMPolicyResp/policy/amazonPolicy') = 0
			BEGIN
				DECLARE @tempXMLAMAZON XML
				SET @tempXMLAMAZON = '<amazonPolicy> </amazonPolicy>'
				SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXMLAMAZON")) into (Ida_GetVMPolicyResp/policy)[1]');
			END
      		-- SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/amazonPolicy)[1]');
			SET @tempXML = @dynsecurityGroup.query('(/TEMP/securityGroups)')
			IF (len (cast (@tempXML as nvarchar(max))) > 0)
				SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/amazonPolicy)[1]');
			SET @tempXML = @dynvmInstanceTypes.query('(/TEMP/instanceType)')
			IF (len (cast (@tempXML as nvarchar(max))) > 0)
      			SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/amazonPolicy)[1]');
			SET @tempXML = @dynAmazonavAilabilityZones.query('(/TEMP/availabilityZones)')
			IF (len (cast (@tempXML as nvarchar(max))) > 0)
      			SET @r_ReturnResult.modify(' insert ( sql:variable("@tempXML")) into (Ida_GetVMPolicyResp/policy/amazonPolicy)[1]');
      	END
		IF (@hostNetworkInfo IS NOT NULL AND @hostNetworkInfo.exist('/networkInfo') = 1)
      		SET @r_ReturnResult.modify(' insert ( sql:variable("@hostNetworkInfo")) into (Ida_GetVMPolicyResp/policy)[1]');
		select @destinationHyperVClient = CAST(attrVal AS INT) from [dbo].[App_VMAllocationPolicyProp]
		WHERE App_VMAllocationPolicyProp.componentNameId=@i_policyId
		and attrname='destinationHyperV'
		select @destinationHyperVClientName = name from App_client where id=@destinationHyperVClient
		set @destinationHyperVClientXml = (select @destinationHyperVClient '@clientId',
					@destinationHyperVClientName '@clientName'
					for xml path('destinationHyperV')
				)
		select @proxyClientEntityId = CAST(attrVal AS INT) from [dbo].[App_VMAllocationPolicyProp]
		WHERE App_VMAllocationPolicyProp.componentNameId=@i_policyId
		and attrname='ProxyClientEntity'
		select @proxyClientEntityName = name from App_client where id=@proxyClientEntityId
		set @proxyClientEntityXml = (select @proxyClientEntityId '@clientId',
					@proxyClientEntityName '@clientName'
					for xml path('proxyClientEntity')
				)
		SET @r_ReturnResult.modify('delete (Ida_GetVMPolicyResp/policy/destinationHyperV)')
		SET @r_ReturnResult.modify(' insert ( sql:variable("@destinationHyperVClientXml")) into (Ida_GetVMPolicyResp/policy)[1]');
		SET @r_ReturnResult.modify('delete (Ida_GetVMPolicyResp/policy/proxyClientEntity)')
		SET @r_ReturnResult.modify(' insert ( sql:variable("@proxyClientEntityXml")) into (Ida_GetVMPolicyResp/policy)[1]');
	END
ELSE
	BEGIN
	IF @flags = 1 AND @checkUserAssoc = 1 AND @isUserAdmin <> 1 AND @canView <> 1
	SET @r_ReturnResult = ISNULL((
					SELECT vxml.query('policy')
					FROM         [dbo].[App_VMAllocationPolicy] AS vap
								 INNER JOIN 	@visiblePolicies VP
									ON vap.id = VP.policyId
					WHERE (vap.alive = 1) AND ( (@i_showDisabled = 1) OR (vxml.value('(/policy/@enabled)[1]', 'int') = 1))  AND ((@showSystemPolicy=1) OR ((vap.flags&1)=0) OR ( vap.flags IS NULL) )
					AND (
						( (vap.flags&4)>0 and @showResourceGroupPolicy = 1) OR ( (vap.flags&4)=0 and @showNonResourceGroupPolicy = 1)
					)
					order by vxml.value('(policy/entity/@vmAllocPolicyName)[1]', 'nvarchar(max)')
					FOR XML PATH(''), ROOT('Ida_GetVMPolicyResp')
					), '<Ida_GetVMPolicyResp/>')
	ELSE
	SET @r_ReturnResult = ISNULL((
					SELECT vxml.query('policy')
					FROM         [dbo].[App_VMAllocationPolicy] AS vap
					WHERE (vap.alive = 1) AND ((@isUserAdmin = 1) OR (@canView=1) OR ((@checkUserAssoc=1) AND dbo.AppCheckVMPolicySecurityPermissions(@userId, id, @flags) = 1))
							AND ( (@i_showDisabled = 1) OR (vxml.value('(/policy/@enabled)[1]', 'int') = 1))  AND ((@showSystemPolicy=1) OR ((vap.flags&1)=0) OR ( vap.flags IS NULL) )
							AND (
									( (vap.flags&4)>0 and @showResourceGroupPolicy = 1) OR ( (vap.flags&4)=0 and @showNonResourceGroupPolicy = 1)
							)
				    order by vxml.value('(policy/entity/@vmAllocPolicyName)[1]', 'nvarchar(max)')
					FOR XML PATH(''), ROOT('Ida_GetVMPolicyResp')
					), '<Ida_GetVMPolicyResp/>')
	END
END
SELECT @r_ReturnResult o_xmlString;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMPolicy')
	delete from GxQscripts where name = 'AppGetVMPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMPolicy')
	delete from GXDBVersions where aliasname = 'AppGetVMPolicy'
GO

insert into GXDBVersions values(2, 'AppGetVMPolicy',  '00010037001200320000', 'AppGetVMPolicy', '00010037001200320000')
GO

