

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMParentInstanceId.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetVMParentInstanceId
--  | Description: It will take input VM SubClientId and retrieves
--  | VM parent(VSA client under which VM is present) backupsetId and InstanceId
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetVMParentInstanceId')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMParentInstanceId <<<'
	drop procedure AppGetVMParentInstanceId
END
IF EXISTS (select * from GxQscripts where name='AppGetVMParentInstanceId')
	delete from GxQscripts where name = 'AppGetVMParentInstanceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMParentInstanceId')
	delete from GXDBVersions where aliasname = 'AppGetVMParentInstanceId'
GO
print '... Creating Procedure: AppGetVMParentInstanceId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetVMParentInstanceId
  @inXML XML
AS
  DECLARE @o_xmlMsg XML;
BEGIN TRY
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(1024) = N''
	DECLARE @vmParentBackupSetId INT=0
	DECLARE @vmParentBackupSetGUID varchar(max)
	DECLARE @instanceId INT=0
	DECLARE @ParentClientId INT=0
	DECLARE @vmSubclientId int = @inXML.value('(/App_GetVMParentInstanceIdReq/vmSubclient/@subclientId)[1]', 'integer')
	DECLARE @childBackupSetId int = @inXML.value('(/App_GetVMParentInstanceIdReq/vmSubclient/@backupsetId)[1]', 'integer')
	DECLARE @childBackupSetGuid varchar(max) = @inXML.value('(/App_GetVMParentInstanceIdReq/vmSubclient/@backupsetGUID)[1]', 'varchar(max)')
	DECLARE @vmInstanceId int = @inXML.value('(/App_GetVMParentInstanceIdReq/vmSubclient/@instanceId)[1]', 'integer')
	DECLARE @vmClientId int = @inXML.value('(/App_GetVMParentInstanceIdReq/vmSubclient/@clientId)[1]', 'integer')
	IF @childBackupSetGuid IS NOT NULL
		SELECT @childBackupSetId = id FROM APP_BackupSetName(nolock) WHERE GUID = @childBackupSetGuid
	if(@childBackupSetId > 0)
		SET @vmParentBackupSetId = ISNULL((Select TOP 1 ParentBackupSetId from APP_VMBackupSet(nolock) where ChildBackupSetId = @childBackupSetId), 0)
	else
		SET @vmParentBackupSetId = ISNULL((Select TOP 1 ParentBackupSetId from APP_VMBackupSet(nolock)  where ChildBackupSetId in
																	(select backupset from APP_Application (nolock) where id = @vmSubclientId or  (clientId = @vmClientId and instance = @vmInstanceId))), 0)
	SET @instanceId= ISNULL((SELECT TOP 1 instance from app_application(nolock) where backupset = @vmParentBackupSetId ), 0)
	SET @ParentClientId= ISNULL((SELECT TOP 1 clientId from app_application(nolock) where backupset = @vmParentBackupSetId ), 0)
	SELECT @vmParentBackupSetGUID = GUID FROM APP_BackupSetName(nolock) WHERE id = @vmParentBackupSetId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
IF (@vmParentBackupSetId = 0 or @instanceId = 0)
BEGIN
	SET @errorStr = 'failed to get instanceId'
	SET @errorCode = -1
END
SET @o_xmlMsg = (
		SELECT
		@errorCode as 'error/@errorCode',
		@errorStr as 'error/@errorMessage',
		@vmParentBackupSetId as 'vmParentSubclient/@backupsetId',
		@vmParentBackupSetGUID as 'vmParentSubclient/@backupsetGUID',
		@instanceId as 'vmParentSubclient/@instanceId',
		@ParentClientId as 'vmParentSubclient/@clientId'
		 FOR XML PATH('App_GetVMParentInstanceIdResp'), TYPE)
SELECT @o_xmlMsg AS [o_xmlMsg]
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMParentInstanceId')
	delete from GxQscripts where name = 'AppGetVMParentInstanceId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMParentInstanceId')
	delete from GXDBVersions where aliasname = 'AppGetVMParentInstanceId'
GO

insert into GXDBVersions values(2, 'AppGetVMParentInstanceId',  '00000000000000000000', 'AppGetVMParentInstanceId', '00000000000000000000')
GO

