

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMInstanceTypeList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMInstanceTypeList.sp,v $ $Id: AppGetVMInstanceTypeList.sp,v 1.6.46.4 2018/03/27 08:11:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMInstanceTypeList"
--	|	This Procedure is used to get the list of available VM Amazon Instance type List
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMInstanceTypeList <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMInstanceTypeList')
	drop procedure AppGetVMInstanceTypeList
IF EXISTS (select * from GxQscripts where name='AppGetVMInstanceTypeList')
	delete from GxQscripts where name = 'AppGetVMInstanceTypeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInstanceTypeList')
	delete from GXDBVersions where aliasname = 'AppGetVMInstanceTypeList'
GO
print '... Creating Procedure: AppGetVMInstanceTypeList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMInstanceTypeList
-- Input arguments
  @i_xmlText XML
AS
DECLARE @i_regionId		INT
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
	SET	@i_regionId = ISNULL (( SELECT ref.value('@regionId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetAmazonVMInstanceTypeListReq/region') R(ref)), 0)
	DECLARE @instanceType INT = 301
	SELECT @instanceType = ISNULL(ip.attrVal, 301)
	FROM   [dbo].[APP_InstanceName] AS I
					INNER JOIN      [dbo].[APP_Application] as APP  on I.id = APP.instance
					INNER JOIN      [dbo].[APP_Client] as C on APP.clientId = C.id
					INNER JOIN      [dbo].[App_VMDataCenter] D on C.name = D.vCenter
										AND 	D.removalTimeStamp IS NULL
										AND		D.id = @i_regionId
					INNER JOIN APP_InstanceProp AS IP ON
						IP.componentNameId = I.id
					AND IP.attrName LIKE 'Virtual Server Instance Type'
	DECLARE @flags INT = 0
	SET @flags = CASE @instanceType WHEN 301 THEN 0 WHEN 401 THEN 1  WHEN 402 THEN 3 WHEN 403 THEN 3 WHEN 1101 THEN 2 END
	DECLARE @InstanceTable TABLE (
		instanceId	INTEGER
	)
	IF EXISTS (SELECT
					item.c.value('./@vmInstanceTypeId', 'int') AS instanceId
				FROM
					@i_xmlText.nodes('Ida_GetAmazonVMInstanceTypeListReq/entities') item(c)
				)
		BEGIN
			INSERT INTO @InstanceTable(instanceId)
				SELECT
					item.c.value('./@vmInstanceTypeId', 'int') AS instanceId
				FROM
					@i_xmlText.nodes('Ida_GetAmazonVMInstanceTypeListReq/entities') item(c)
					SET @r_ReturnResult = ISNULL ((
						SELECT
						 I.cpuUnits AS '@cpuUnits',
		    			 I.cpuCores AS '@cpuCores',
						 I.memory  AS '@memory',
						 I.id AS 'instanceType/@vmInstanceTypeId',
						 CASE WHEN @instanceType = 402 THEN I.instanceType ELSE dbo.GetVMInstanceTypeDesc(I.instanceType) END AS 'instanceType/@vmInstanceTypeName'
					FROM     [dbo].[App_VMInstanceTypes] I
					INNER JOIN @InstanceTable AS ins ON
					ins.instanceId = I.id
					AND I.removalTimeStamp IS NULL
					AND I.flags = @flags
					FOR XML PATH('instanceType'), ROOT('Ida_GetAmazonVMInstanceTypeListResp')
					), '<Ida_GetAmazonVMInstanceTypeListResp/>')
			END
    ELSE
		BEGIN
			SET @r_ReturnResult = ISNULL ((
						SELECT
						 I.cpuUnits AS '@cpuUnits',
		    			 I.cpuCores AS '@cpuCores',
						 I.memory  AS '@memory',
						 I.id AS 'instanceType/@vmInstanceTypeId',
						 CASE WHEN @instanceType in (402,403) THEN I.instanceType ELSE dbo.GetVMInstanceTypeDesc(I.instanceType) END AS 'instanceType/@vmInstanceTypeName'
					FROM     [dbo].[App_VMInstanceTypes] I
					WHERE
					I.removalTimeStamp IS NULL
					AND I.flags = @flags
					FOR XML PATH('instanceType'), ROOT('Ida_GetAmazonVMInstanceTypeListResp')
					), '<Ida_GetAmazonVMInstanceTypeListResp/>')
		END
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMInstanceTypeList')
	delete from GxQscripts where name = 'AppGetVMInstanceTypeList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInstanceTypeList')
	delete from GXDBVersions where aliasname = 'AppGetVMInstanceTypeList'
GO

insert into GXDBVersions values(2, 'AppGetVMInstanceTypeList',  '00010006004600040000', 'AppGetVMInstanceTypeList', '00010006004600040000')
GO

