

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMInstanceList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMInstanceList.sp,v $ $Id: AppGetVMInstanceList.sp,v 1.7.46.4 2018/03/27 08:10:39 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMInstanceList"
--	|	This Procedure is used to get the list of available VM Amazon Instance List
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMInstanceList <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMInstanceList')
	drop procedure AppGetVMInstanceList
IF EXISTS (select * from GxQscripts where name='AppGetVMInstanceList')
	delete from GxQscripts where name = 'AppGetVMInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetVMInstanceList'
GO
print '... Creating Procedure: AppGetVMInstanceList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMInstanceList
-- Input arguments
  @i_xmlText XML
AS
  DECLARE @r_ReturnResult XML;
DECLARE @capabilitiesRequired BIGINT
SET @capabilitiesRequired = CAST(POWER(2.0,2  - 1) AS BIGINT)
DECLARE		@i_userId AS INT = ISNULL (( SELECT ref.value('@userId', 'INT')
								FROM  @i_xmlText.nodes ('Ida_GetInstanceListReq/user') R(ref)), 0)
DECLARE @policyType INT = ISNULL((SELECT ref.value('@policyType', 'INT')
							FROM @i_xmlText.nodes ('Ida_GetInstanceListReq/policyType') R(ref)), 1)
-- FOLLOWING BLOCK SO WE CAN "TRACE" WHAT IS ACTUALLY BEING PASSED DOWN TO DB in Table "TrackNotificationProcs"
DECLARE @brAlertTrace AS INT =ISNULL((select value from gxglobalParam Where name = 'bralertTrace'), 0)
if @brAlertTrace <> 0
BEGIN
	DECLARE @xmlStr AS VARCHAR(MAX) = CONVERT(varchar(MAX), @i_xmlText)
	exec br_ntTrace '.. AppGetVMInstanceList2', @i_userId, 0, 0, 0, @xmlStr
END
--
--
-- USING THIS TEMPORARY TABLE IS A BIT OF AN OVER-KILL, BUT THE VOLUME OF USAGE/DATA IS SMALL, AND IT'S USE
-- FACILITATES THE EASY ADDITION OF CREDENTIALS CHECKS SO MORE USERS THAN JUST THE OWNER CAN SEE THE CLIENT/INSTANCE,
-- IF IT IS DECIDED LATER THAT "JUST THE OWNER" IS TOO RESTRICTIVE    -StuK 03-Apr-2014
--
IF object_id('tempdb.dbo.#InstanceList') is not null DROP TABLE #InstanceList
CREATE TABLE #InstanceList ( clientid INT,
							canSee int,
							instanceId INT,
							instanceName NVARCHAR(255),
							clientName NVARCHAR(255)
							)
INSERT #InstanceList
	SELECT 0, 0, I.id, I.name, ''
		FROM APP_InstanceName AS I
		INNER JOIN APP_InstanceProp AS IP ON
			IP.componentNameId = I.id
		AND IP.attrName LIKE 'Virtual Server Instance Type'
		AND ((IP.attrVal = 301 AND @policyType = 1) OR (IP.attrVal = 401 AND @policyType = 3) OR (IP.attrVal = 402 AND @policyType = 7)  OR (IP.attrVal = 403 AND @policyType = 16))
UPDATE #InstanceList	SET clientid = (select distinct clientid from APP_Application where instance = instanceId)
UPDATE #InstanceList	SET clientName = (Select name from APP_Client where id = clientid)
IF object_id('tempdb.dbo.#VMUserObjects') IS NOT null DROP TABLE #VMUserObjects
create table  #VMUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2009, 0, '#VMUserObjects'
 DELETE #VMUserObjects
    WHERE clientGroupId <> 0 OR libraryID <> 0 OR archGroupID <> 0
    OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
    OR taskId <> 0 OR mediaAgentId <>0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
    OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
    OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
    OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
Update #InstanceList  SET canSee = 1
WHERE exists(select * from #VMUserObjects where #VMUserObjects.clientId in (#InstanceList.clientId,0) and (#VMUserObjects.Capabilities & @capabilitiesRequired = @capabilitiesRequired) )
SET @r_ReturnResult = ISNULL ((
					SELECT instanceId AS '@instanceId',
							clientName AS '@instanceName'
					FROM #InstanceList
					Where canSee <> 0
					FOR XML PATH('amazonInstanceList'), ROOT('Ida_GetInstanceListResp')
					), '<Ida_GetInstanceListResp/>')
DROP TABLE #VMUserObjects
DROP TABLE #InstanceList
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMInstanceList')
	delete from GxQscripts where name = 'AppGetVMInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetVMInstanceList'
GO

insert into GXDBVersions values(2, 'AppGetVMInstanceList',  '00010007004600040000', 'AppGetVMInstanceList', '00010007004600040000')
GO

