

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMInfoFromGuid.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMInfoFromGuid.sp,v $ $Id: AppGetVMInfoFromGuid.sp,v 1.1.2.32 2020/01/14 19:30:21 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMInfoFromGuid')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMInfoFromGuid <<<'
	drop procedure AppGetVMInfoFromGuid
END
IF EXISTS (select * from GxQscripts where name='AppGetVMInfoFromGuid')
	delete from GxQscripts where name = 'AppGetVMInfoFromGuid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInfoFromGuid')
	delete from GXDBVersions where aliasname = 'AppGetVMInfoFromGuid'
GO
print '... Creating Procedure: AppGetVMInfoFromGuid'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMInfoFromGuid
  @i_userId INT,
  @i_localeId INT,
  @i_VMGUID nvarchar(1024),
  @o_xmlVMStatusInfoResp XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(MAX) = 'Success'
DECLARE @VMClientId INT = 0
IF LEN(@i_VMGUID) <= 0
BEGIN
SET @errorCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', 'VM GUID')
    GOTO ERROR_EXIT
END
-- No need for any order by here. We just want to match with the first vmclientid
SET @vmClientId = ISNULL((SELECT TOP 1 VMclientId FROM APP_VMProp WITH(NOLOCK) WHERE attrName='vmGUID' AND attrval=@i_VMGUID),
							(SELECT TOP 1 componentNameId FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.attrName='Virtual Machine Instance UUID' AND ACP.attrVal=@i_VMGUID AND ACP.modified=0))
IF (@vmClientId IS NULL OR @vmClientId=0)
BEGIN
SET @errorCode=(2753 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (2753 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @i_localeId)
    GOTO ERROR_EXIT
END
DECLARE @spInput XML = (SELECT 0 AS '@pageNo', @i_userId AS '@userId', 1 AS '@includeDiscovered', 30 AS '@nPropertyLevel',	-- AllProperties
							(SELECT @vmClientId AS '@clientId'
								FOR XML PATH('vmClients'), TYPE
						),
						(SELECT @i_localeId AS '@localeId'
							FOR XML PATH('locale'), TYPE
						)
						FOR XML PATH('App_VMStatusInfoReq')
						)
EXEC dbo.AppGetVMStatusInfoForUser @spInput , @o_xmlVMStatusInfoResp OUTPUT, @errorCode output, @errorString output
RETURN
ERROR_EXIT:
SET @o_xmlVMStatusInfoResp =
(
    SELECT  @errorCode AS '@errorCode',
            @errorString AS '@errorMessage'
    FOR XML PATH('App_VMStatusInfoResp')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMInfoFromGuid')
	delete from GxQscripts where name = 'AppGetVMInfoFromGuid'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInfoFromGuid')
	delete from GXDBVersions where aliasname = 'AppGetVMInfoFromGuid'
GO

insert into GXDBVersions values(2, 'AppGetVMInfoFromGuid',  '00010001000200320000', 'AppGetVMInfoFromGuid', '00010001000200320000')
GO

