

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMInfo.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetVMInfo
--  | Description:  Gets VM backup information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMInfo.sp,v $ $Id: AppGetVMInfo.sp,v 1.6.50.1 2018/03/27 08:04:26 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMInfo')
	drop procedure AppGetVMInfo
IF EXISTS (select * from GxQscripts where name='AppGetVMInfo')
	delete from GxQscripts where name = 'AppGetVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMInfo'
GO
print '... Creating Procedure: AppGetVMInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_vmGuid VARCHAR(36),
  @i_vmName NVARCHAR(255)
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xml XML
DECLARE @lastBackup INT = 0
DECLARE @clientId	INT
DECLARE @sameHostVMs INT =0
SELECT @clientId = clientId FROM App_VM where GUID = @i_vmGuid
SELECT @sameHostVMs =COUNT(clientId) FROM App_VM where clientId = @clientId and removalTimeStamp IS NULL GROUP BY clientId
IF ( @clientId IS NOT NULL AND @sameHostVMs = 1 )
BEGIN
	SET @lastBackup = (
		SELECT TOP(1) servEndDate
		FROM JMBkpStats JS INNER JOIN JMQinetixUpdateStatus JU
		ON JS.jobId = JU.jobId
		AND JS.status = 1 AND JS.appType = 106
		AND (JS.bkpattributes & 0x18000000000) = 0x18000000000
		AND JU.clientId in
		(
			SELECt CLIENTiD from APP_VM where GUID = @i_vmGuid
		)
		ORDER BY servEndDate DESC)
END
	SET @o_xml =
	(
			SELECT	1					as TAG,
				0					as Parent,
				@lastBackup			as [Ida_GetVMInfoResp!1!lastBackupTime]
			FOR XML EXPLICIT
	)
	IF @o_xml IS null
		SET @o_xml = '<Ida_GetVMInfoResp/>'
	SELECT @o_xml as xml
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMInfo')
	delete from GxQscripts where name = 'AppGetVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMInfo'
GO

insert into GXDBVersions values(2, 'AppGetVMInfo',  '00010006005000010000', 'AppGetVMInfo', '00010006005000010000')
GO

