

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMHostNetworkList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMHostNetworkList.sp,v $ $Id: AppGetVMHostNetworkList.sp,v 1.1.2.1 2018/06/25 21:01:29 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetVMHostNetworkList"
--	|	This Procedure is used to get the list of available VM Amazon Region List
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMHostNetworkList <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMHostNetworkList')
	drop procedure AppGetVMHostNetworkList
IF EXISTS (select * from GxQscripts where name='AppGetVMHostNetworkList')
	delete from GxQscripts where name = 'AppGetVMHostNetworkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMHostNetworkList')
	delete from GXDBVersions where aliasname = 'AppGetVMHostNetworkList'
GO
print '... Creating Procedure: AppGetVMHostNetworkList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMHostNetworkList
-- Input arguments
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
 DECLARE @i_dataCenterId		INT
 DECLARE @vendorId INTEGER = 101
 SET	@i_dataCenterId = ISNULL (( SELECT ref.value('@dataCenterId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_GetHostNetworkListReq') R(ref)), 0)
SELECT @vendorId = CAST(attrVal AS INT)
			FROM App_VMDataCenterMap M
			INNER JOIN APP_InstanceProp IP
				ON M.vDataCenterId = @i_dataCenterId
				AND M.instanceId = IP.componentNameId
				AND M.removalTimeStamp IS NULL
	WHERE	IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
--For Azure Vendors, all network are currently accesible to any resource group in the region.
IF @vendorId IN (401,402,403)
	SET @r_ReturnResult = ISNULL ((
					SELECT TOP 1
						( SELECT
							hn.value('@networkName','nvarchar(max)') as '@label',
							hn.value('@uuid','nvarchar(max)') as '@networkName',
							hn.query('./child::node()')
						  FROM APP_VMHost VN
						  CROSS APPLY VN.vxml.nodes('QSMServer_QVirtualHostReq/networkInfo') M(hn)
						  WHERE VN.id = H.id
						FOR XML PATH ('NetworkList'), TYPE)
					FROM     [dbo].[App_VMHost] H
					INNER JOIN [dbo].[App_VMDataCenter] D
					ON H.vDataCenterId = D.id
					AND D.id = @i_dataCenterId
					AND D.removalTimeStamp IS NULL
					AND H.removalTimeStamp IS NULL
					FOR XML PATH('HostNetworkInfoList'), ROOT('Ida_GetHostNetworkListResp')
					), '<Ida_GetHostNetworkListResp/>')
ELSE
	SET @r_ReturnResult = ISNULL ((
					SELECT
						 ( SELECT H.id as '@esxServerId', H.name as '@esxServerName' FOR XML PATH ('hostEntity'), TYPE),
						( SELECT
							hn.value('@networkName','nvarchar(max)') as '@label',
							hn.value('@uuid','nvarchar(max)') as '@networkName',
							hn.query('./child::node()')
						  FROM APP_VMHost VN
						  CROSS APPLY VN.vxml.nodes('QSMServer_QVirtualHostReq/networkInfo') M(hn)
						  WHERE VN.id = H.id
						FOR XML PATH ('NetworkList'), TYPE)
					FROM     [dbo].[App_VMHost] H
					INNER JOIN [dbo].[App_VMDataCenter] D
					ON H.vDataCenterId = D.id
					AND D.id = @i_dataCenterId
					AND D.removalTimeStamp IS NULL
					AND H.removalTimeStamp IS NULL
					FOR XML PATH('HostNetworkInfoList'), ROOT('Ida_GetHostNetworkListResp')
					), '<Ida_GetHostNetworkListResp/>')
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMHostNetworkList')
	delete from GxQscripts where name = 'AppGetVMHostNetworkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMHostNetworkList')
	delete from GXDBVersions where aliasname = 'AppGetVMHostNetworkList'
GO

insert into GXDBVersions values(2, 'AppGetVMHostNetworkList',  '00010001000200010000', 'AppGetVMHostNetworkList', '00010001000200010000')
GO

