

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMCountForUser.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMCountForUser.sp,v $ $Id: AppGetVMCountForUser.sp,v 1.1.2.2 2019/12/21 21:52:54 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMCountForUser')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMCountForUser <<<'
	drop procedure AppGetVMCountForUser
END
IF EXISTS (select * from GxQscripts where name='AppGetVMCountForUser')
	delete from GxQscripts where name = 'AppGetVMCountForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMCountForUser')
	delete from GXDBVersions where aliasname = 'AppGetVMCountForUser'
GO
print '... Creating Procedure: AppGetVMCountForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMCountForUser
  @userId INT,
  @totalVMs INT OUTPUT,
  @protectedVMs INT OUTPUT,
  @unProtectedVMs INT OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @debug                INT = 0
--- CODE BELOW HERE IS FROM AppGetVMForUser.spb  ----------
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'        ) IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#idaClientList') IS NOT NULL DROP TABLE #idaClientList
IF OBJECT_ID('tempdb.dbo.#idaSubClientList') IS NOT NULL DROP TABLE #idaSubClientList
IF OBJECT_ID('tempdb.dbo.#hypervisorClients') IS NOT NULL DROP TABLE #hypervisorClients
IF OBJECT_ID('tempdb.dbo.#unProtectedVMTable') IS NOT NULL DROP TABLE #unProtectedVMTable
-- 0.0 temporary table that will hold objects available for curent user.
CREATE TABLE #idaClientList
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
-- 0.0 temporary table that will hold subclient objects available for curent user.
CREATE TABLE #idaSubClientList
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
-- 0.1 table variable that will hold vm backup job ids
CREATE TABLE #APPJobCycleTbl_tmp_VM
(
    vmClientId          INT,
    jobId               INT,
    clientId            INT,
    instanceId          INT,
    appId               INT,
    subClientName       NVARCHAR(1024)
)
-- 0.2 table variable that will hold protected vms info
CREATE TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
(
    clientId            INT,
    clientName          NVARCHAR(1024),
    sGUID               NVARCHAR(1024),
    vsObjType           INT,
    jobId               INT,
    vmStatus            NVARCHAR(1024),
)
-- 0.3 Table for Hypervisor Client List for unprotected VM's
CREATE TABLE #hypervisorClients
(
    clientId			INT PRIMARY KEY,
    unprotectedVMs		INT,
    protectedVMs		INT,
	discoveredXML		XML,
    host				NVARCHAR(256),
    duplicate			INT
)
-- 0.4 Table for unprotected VM's from Discovery XML
-- Adding Primary Identity column increased execution time by factor of 9
CREATE TABLE #unProtectedVMTable
(
    vmName			NVARCHAR(MAX),
	sGuid			NVARCHAR(64),
	hyperVisorId	INT
)
-- Check for VIEW capability for all clients and also allow to inherit from child
-- We will keep our idaClientList handy as that will help us get visible unprotected VM added into the list
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaClientList'
-- Once we are done with this, now get ALL VM's backed up via subclient's for which user have rights
-- We will keep our idaSubClientList handy as that will help us get visible unprotected VM added into the list
EXEC sec_getIdaObjectsForUser @userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#idaSubClientList'
-- Get All VM's in APP_VMProp
-- We will keep the relevant one once basic info has been fetched
INSERT INTO #APPJobCycleTbl_tmp_VM
SELECT APCP.componentNameId, APCP.attrval, AAP.clientId, AAP.instance, AAP.id, AAP.subclientName
	FROM APP_ClientProp APCP
	INNER JOIN APP_ClientProp APCP1 WITH (NOLOCK)
            ON APCP1.componentnameid= APCP.componentnameid AND APCP1.attrname='Last Backup subclient' AND APCP1.modified=0
    INNER JOIN APP_Application AAP WITH (NOLOCK)
            ON CAST(AAP.id AS NVARCHAR(64))= APCP1.attrval AND AAP.appTypeId=106
	WHERE APCP.attrName='Last Backup JobID' AND APCP.modified=0
IF @debug <> 0 BEGIN
    SELECT 'Intial VM List', * FROM #APPJobCycleTbl_tmp_VM
END
-- Implement Security Check
-- Either user should have VIEW rights on the VM or VIEW rights on the subclient that backed it up
DELETE FROM #APPJobCycleTbl_tmp_VM WHERE vmClientId NOT IN
	( SELECT AJCT.vmClientId FROM #APPJobCycleTbl_tmp_VM AJCT
		INNER JOIN #idaClientList IDCL
			ON IDCL.t_clientId=AJCT.vmClientId
		UNION
		SELECT AJCT.vmClientId FROM #APPJobCycleTbl_tmp_VM AJCT
			INNER JOIN #idaSubClientList IDSCL
				ON IDSCL.t_subclientId=AJCT.appId)
IF @debug <> 0 BEGIN
    SELECT 'Final VM List', * FROM #APPJobCycleTbl_tmp_VM
END
-- Following below changes, VM will not have pending state. In case we want this, we will have to revisit this SP to figure out such details.
-- get vms information into the table
INSERT INTO #APPGetVMInfoForUser_tmp__VMInfoRaw (clientID, clientName, sGUID, vmStatus)
SELECT  DISTINCT(VMP.VMclientId), AC.displayName, P.attrVal, CASE WHEN (VMP.attrVal = N'0') THEN 1
                                  WHEN (VMP.attrVal = N'1') THEN 2
                                  WHEN (VMP.attrVal = N'2' OR VMP.attrVal = N'4') THEN 3
                                  WHEN (VMP.attrVal = N'3') THEN 4
                                  ELSE 0
                                  END
FROM    APP_VMProp VMP WITH (NOLOCK)
            INNER JOIN #APPJobCycleTbl_tmp_VM JIT ON VMP.jobId = JIT.jobId AND JIT.vmClientId=VMP.VMclientId
            INNER JOIN APP_Client AC ON AC.id=VMP.VMclientId
			INNER JOIN APP_ClientProp P WITH (NOLOCK) ON AC.id = P.componentNameId AND P.attrName  = 'Virtual Machine Instance UUID' AND P.modified=0
WHERE       VMP.attrName = 'vmStatus'
IF @debug <> 0 BEGIN
    SELECT 'raw vms', * FROM #APPGetVMInfoForUser_tmp__VMInfoRaw
END
-- Calculate Unprotected VM's
INSERT INTO #hypervisorClients ( clientId, unprotectedVMs, protectedVMs, host, duplicate)
SELECT DISTINCT A.clientId ,0,0, I2.attrval,0
	FROM APP_InstanceProp  Iprop  WITH (NOLOCK)
		INNER JOIN APP_Application A WITH (NOLOCK)
			ON A.instance = Iprop.componentNameId AND Iprop.attrName ='Virtual Server Instance Type'
				AND Iprop.modified =0 AND Iprop.attrval in ( '101','102','601','301','401','402','403','901','1101','1301')
		INNER JOIN APP_InstanceProp I2 WITH (NOLOCK)
			ON I2.componentNameId = Iprop.componentNameId AND I2.attrName ='Virtual Server Host' AND I2.modified =0
		INNER JOIN #idaClientList T
			ON T.t_clientId = A.clientId
		LEFT OUTER JOIN  APP_InstanceProp AIP
			ON AIP.componentNameId=Iprop.componentNameId AND AIP.attrName = 'Cloud Apps Instance Type' AND AIP.modified =0
		WHERE AIP.componentNameId IS NULL
UPDATE HV
	SET duplicate = 1
FROM #hypervisorClients HV
INNER JOIN ( SELECT  clientid, row_number() OVER (partition by host ORDER BY clientid desc) AS rn from #hypervisorClients) T
ON HV.clientId = T.clientId
WHERE T.rn >1 AND host !=''
UPDATE HV
SET HV.discoveredXML=CAST(REPLACE(CAST(AEP.attrval AS NVARCHAR(MAX)),'utf-8','utf-16') AS XML)
FROM #hypervisorClients HV
INNER JOIN APP_ExtendedProperties AEP WITH(NOLOCK)
	ON AEP.attrName = 'Virtual Server Content' AND AEP.clientId = HV.clientId
WHERE duplicate <> 1
INSERT INTO #unProtectedVMTable (vmName,sGuid,hyperVisorId)
SELECT cl.value('@name', 'nvarchar(max)'),cl.value('@guid', 'nvarchar(64)'), clientId
	FROM #hypervisorClients HV
CROSS APPLY HV.discoveredXML.nodes('EVGui_ManualDiscoverResp/guestHosts2') AS P(cl)
UPDATE HVO
SET HVO.unprotectedVMs=(SELECT COUNT(TT.vmName)
							FROM #unProtectedVMTable TT
						LEFT OUTER JOIN #APPGetVMInfoForUser_tmp__VMInfoRaw VM
								ON VM.sGUID=TT.sGuid AND VM.clientName=TT.vmName
							WHERE TT.hyperVisorId=HVO.clientId AND VM.clientName IS NULL)
FROM #hypervisorClients HVO
WHERE HVO.duplicate <> 1
SET @protectedVMs = (SELECT COUNT(*) FROM #APPGetVMInfoForUser_tmp__VMInfoRaw)
SET @unProtectedVMs = ISNULL((SELECT SUM(unprotectedVMs) FROM #hypervisorClients WHERE duplicate <> 1),0)
SET @totalVMs = @protectedVMs + @unProtectedVMs
IF OBJECT_ID('tempdb.dbo.#APPGetVMInfoForUser_tmp__VMInfoRaw'       )	IS NOT null DROP TABLE #APPGetVMInfoForUser_tmp__VMInfoRaw
IF OBJECT_ID('tempdb.dbo.#idaClientList'							)	IS NOT NULL DROP TABLE #idaClientList
IF OBJECT_ID('tempdb.dbo.#idaSubClientList'							)	IS NOT NULL DROP TABLE #idaSubClientList
IF OBJECT_ID('tempdb.dbo.#hypervisorClients') IS NOT NULL DROP TABLE #hypervisorClients
IF OBJECT_ID('tempdb.dbo.#unProtectedVMTable') IS NOT NULL DROP TABLE #unProtectedVMTable
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMCountForUser')
	delete from GxQscripts where name = 'AppGetVMCountForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMCountForUser')
	delete from GXDBVersions where aliasname = 'AppGetVMCountForUser'
GO

insert into GXDBVersions values(2, 'AppGetVMCountForUser',  '00010001000200020000', 'AppGetVMCountForUser', '00010001000200020000')
GO

