

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMClientBackupSetId.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetVMClientBackupSetId
--  | Description: It will take input as list of VM ClientIds and VSA backupset Id
--  | and retrieves corresponding backupset\subclient under each VM client
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMClientBackupSetId <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMClientBackupSetId')
	drop procedure AppGetVMClientBackupSetId
IF EXISTS (select * from GxQscripts where name='AppGetVMClientBackupSetId')
	delete from GxQscripts where name = 'AppGetVMClientBackupSetId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMClientBackupSetId')
	delete from GXDBVersions where aliasname = 'AppGetVMClientBackupSetId'
GO
print '... Creating Procedure: AppGetVMClientBackupSetId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMClientBackupSetId
  @i_xmlText XML
AS
  DECLARE @o_xmlMsg XML;
BEGIN TRY
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(1024) = N''
	DECLARE @vmClientId bigint
	DECLARE @vsaBackupSetId INT=0
	IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
	CREATE  TABLE #tmpVMclientInfo
	(
		clientId bigint,
		parentBackupSet int,
		chldBackupSetId int,
		chldBackupSetGuid uniqueidentifier
	)
	INSERT INTO #tmpVMclientInfo
		SELECT
				cl.value('@clientId', 'int') AS clientId,
				bs.value('@backupsetId', 'int') AS parentBackupSetId,
				S.ChildBackupSetId AS chldBackupSetId,
				BS.GUID AS chldBackupSetGuid
              FROM    @i_xmlText.nodes('App_GetVMClientBackupSetIdReq/vmClients') R(ref)
			  CROSS APPLY ref.nodes('./vmClient') C(cl)
			  CROSS APPLY ref.nodes('./backupset') B(bs)
			  JOIN APP_VMBackupSet S (NOLOCK) ON S.VMClientId = cl.value('@clientId', 'int') AND S.ParentBackupSetId= bs.value('@backupsetId', 'int')
			  JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = S.ChildBackupSetId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
SET @o_xmlMsg = (
	(SELECT
		@errorCode as 'error/@errorCode',
		@errorStr as 'error/@errorMessage',
		( select
			clientId as 'vmClient/@clientId',
			chldBackupSetId as 'backupset/@backupsetId',
			chldBackupSetGUID as 'backupset/@backupsetGUID'
			from #tmpVMclientInfo FOR XML PATH('vmClient'), TYPE )
			FOR XML PATH('APP_GetVMClientBackupSetIdResp'), TYPE)
		)
SELECT @o_xmlMsg AS [o_xmlMsg]
IF object_id('tempdb.dbo.#tmpVMclientInfo') IS NOT null DROP TABLE #tmpVMclientInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMClientBackupSetId')
	delete from GxQscripts where name = 'AppGetVMClientBackupSetId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMClientBackupSetId')
	delete from GXDBVersions where aliasname = 'AppGetVMClientBackupSetId'
GO

insert into GXDBVersions values(2, 'AppGetVMClientBackupSetId',  '00000000000000000000', 'AppGetVMClientBackupSetId', '00000000000000000000')
GO

