

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMClientAssoc.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMClientAssoc.sp,v $ $Id: AppGetVMClientAssoc.sp,v 1.1.2.1 2020/02/18 15:40:13 vmishra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMClientAssoc')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMClientAssoc <<<'
	drop procedure AppGetVMClientAssoc
END
IF EXISTS (select * from GxQscripts where name='AppGetVMClientAssoc')
	delete from GxQscripts where name = 'AppGetVMClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetVMClientAssoc'
GO
print '... Creating Procedure: AppGetVMClientAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMClientAssoc
  @i_xml XML,
  @o_xml XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT=0
DECLARE @errorString nvarchar(MAX)=N''
BEGIN TRY
	DECLARE @VMClientAssoc TABLE (vmGUID varchar(255), VMName nvarchar(255), clientId INT, hypervisorClientId INT, hypervisorName nvarchar(255), planId INT, planName nvarchar(255), instanceId INT)
	INSERT INTO @VMClientAssoc(vmGUID, VMName, clientId, hypervisorClientId, hypervisorName, planId, planName)
	SELECT c.n.value('@clientGUID','varchar(255)'), c.n.value('@clientName','nvarchar(255)'),
		   ACP.componentNameId, v.m.value('(hypervisor/@clientId)[1]', 'INT'), v.m.value('(hypervisor/@clientName)[1]', 'nvarchar(255)'),
		   v.m.value('(plan/@planId)[1]', 'INT'), v.m.value('(plan/@planName)[1]', 'nvarchar(255)')
	FROM @i_xml.nodes('App_AssociateVMToPlanRequest/vmInfo') AS v(m)
		CROSS APPLY v.m.nodes('vmClients') c(n)
			LEFT OUTER JOIN App_clientProp ACP
				ON ACP.attrName = 'Virtual Machine Instance UUID' AND attrVal = c.n.value('@clientGUID','varchar(255)') AND ACP.modified=0
	IF EXISTS(SELECT TOP 1 * FROM @VMClientAssoc WHERE clientId IS NULL)
	BEGIN
		UPDATE VCA
		SET instanceId = AAP.instance
		FROM @VMClientAssoc VCA INNER JOIN APP_Application AAP
ON appTypeId = 106 AND VCA.hypervisorClientId = AAP.clientId
		SET @o_xml = (SELECT 1 AS '@createClientsForDiscoveredVms', 2 AS '@previewInventoryRespType',
(SELECT 106 AS '@apptypeId', VA.hypervisorClientId AS '@clientId', VA.hypervisorName AS '@clientName', VA.instanceId AS '@instanceId' FOR XML PATH('appId'), TYPE),
			 (SELECT S.vmGUID AS 'children/@name', 9 AS 'children/@type'
				FROM @VMClientAssoc S WHERE clientId IS NULL AND S.hypervisorClientId = VA.hypervisorClientId
				FOR XML PATH('contentEntity'), TYPE
			)
		FROM @VMClientAssoc VA WHERE clientId IS NULL
		GROUP BY hypervisorClientId, hypervisorName, instanceId
		FOR XML PATH('previewInventoryReq'), ROOT('EVGui_PreviewInventoryBulkReq'))
	END
	ELSE
	BEGIN
		SET @o_xml = (SELECT planId AS 'plan/@planId',planName AS 'plan/@planName',
			(SELECT S.clientId AS '@clientId', S.VMName AS '@clientName'
				FROM @VMClientAssoc S WHERE S.planId = VCA.planId FOR XML PATH('vmClients'), TYPE)
		FROM @VMClientAssoc VCA
		GROUP BY planId, planName
		FOR XML PATH('vmInfo'), ROOT('App_AssociateVMToPlanRequest'))
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = N'Error During SP:[AppGetVMClientAssoc] Execution. Error Message :' + ERROR_MESSAGE()
	SET @o_xml = (
                        SELECT @errorCode as '@errorCode',
							   @errorString as '@errorMessage'
                              FOR XML PATH('response'),ROOT('App_AssociateVMToPlanResponse')
                        )
END  CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMClientAssoc')
	delete from GxQscripts where name = 'AppGetVMClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetVMClientAssoc'
GO

insert into GXDBVersions values(2, 'AppGetVMClientAssoc',  '00010001000200010000', 'AppGetVMClientAssoc', '00010001000200010000')
GO

