

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMBrowseDetails.sp] ---------- 

--      +-----------------------------------------------------------------------+
--      |                       Procedure : "AppGetVMBrowseDetails"
--      +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetVMBrowseDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetVMBrowseDetails <<<'
	drop procedure AppGetVMBrowseDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetVMBrowseDetails')
	delete from GxQscripts where name = 'AppGetVMBrowseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMBrowseDetails')
	delete from GXDBVersions where aliasname = 'AppGetVMBrowseDetails'
GO
print '... Creating Procedure: AppGetVMBrowseDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMBrowseDetails
  @VMGUID NVARCHAR(MAX),
  @VCenterBackupsetId INTEGER
AS
  DECLARE @VMClientID INTEGER;
  DECLARE @VMInstanceId INTEGER;
  DECLARE @VMBackupsetId INTEGER;
  DECLARE @VMSubclientId INTEGER;
BEGIN TRY
	SELECT @VMClientId = componentNameId FROM APP_ClientProp (NOLOCK) WHERE attrName = 'Virtual Machine Instance UUID' and attrVal = @VMGUID
SELECT @VMBackupsetId = bSet.ChildBackupSetId, @VMSubclientId = appl.id FROM APP_VMBackupSet bSet (NOLOCK) JOIN APP_Application appl ON bSet.ChildBackupSetId = appl.backupSet AND (appl.subClientStatus & 0x00008 <> 0) WHERE bSet.VMClientId = @VMClientId and bSet.ParentBackupsetId = @VCenterBackupsetId
	SELECT TOP 1 @VMInstanceId = app.instance FROM APP_Application app (NOLOCK) WHERE app.backupset = @VMBackupsetId
	SELECT @VMClientID, @VMInstanceId, @VMBackupsetId, @VMSubclientId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT CONVERT(VARCHAR (128), ERROR_NUMBER()) as '@errorCode',
	'Exception Caught with FATAL ERROR : ' + ERROR_MESSAGE() as '@errorMessage'
END CATCH
CX_EXIT:
SELECT NULL, NULL, NULL, NULL
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMBrowseDetails')
	delete from GxQscripts where name = 'AppGetVMBrowseDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMBrowseDetails')
	delete from GXDBVersions where aliasname = 'AppGetVMBrowseDetails'
GO

insert into GXDBVersions values(2, 'AppGetVMBrowseDetails',  '00000000000000000000', 'AppGetVMBrowseDetails', '00000000000000000000')
GO

