

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetVMBackupInfo.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetVMBackupInfo
--  | Description:  Gets VM backup information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetVMBackupInfo.sp,v $ $Id: AppGetVMBackupInfo.sp,v 1.8.188.1 2018/03/27 08:19:22 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetVMBackupInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetVMBackupInfo')
	drop procedure AppGetVMBackupInfo
IF EXISTS (select * from GxQscripts where name='AppGetVMBackupInfo')
	delete from GxQscripts where name = 'AppGetVMBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMBackupInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMBackupInfo'
GO
print '... Creating Procedure: AppGetVMBackupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetVMBackupInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_vmGuid VARCHAR(36),
  @i_vmName NVARCHAR(255),
  @i_uuid VARCHAR(36),
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorString NVARCHAR(MAX) = N''
	SET @o_xml =
	(
			SELECT DISTINCT @i_vmGuid '@vmGUID', @i_vmName '@vmName', C.id '@clientId', C.name '@clientName'
		        FROM App_ClientProp CP
		        INNER JOIN APP_Client C ON
           		CP.componentNameId = C.id
            		AND CP.attrName = 'Virtual Machine GUID'
            		AND ( CP.attrVal = @i_vmGuid  OR CP.attrVal = @i_uuid)
            		AND CP.modified =0
		FOR XML PATH('vmEntity'), ROOT('Ida_GetVMBackupInfoResp')
	)
	IF @o_xml IS null
		SET @o_xml = '<Ida_GetVMBackupInfoResp/>'
	SELECT @o_xml
EXIT_ERROR:
	IF @o_errorCode <> 0
	BEGIN
			SELECT	1					as TAG,
				0					as Parent,
				@o_errorCode			as [CVGui_GenericResp!1!errorCode],
				@o_errorString			as [CVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetVMBackupInfo')
	delete from GxQscripts where name = 'AppGetVMBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetVMBackupInfo')
	delete from GXDBVersions where aliasname = 'AppGetVMBackupInfo'
GO

insert into GXDBVersions values(2, 'AppGetVMBackupInfo',  '00010008018800010000', 'AppGetVMBackupInfo', '00010008018800010000')
GO

