

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetV1SubClientRetentionProps.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetV1SubClientRetentionProps')
BEGIN
	print '>>> Drop Stored Procedure: AppGetV1SubClientRetentionProps <<<'
	drop procedure AppGetV1SubClientRetentionProps
END
IF EXISTS (select * from GxQscripts where name='AppGetV1SubClientRetentionProps')
	delete from GxQscripts where name = 'AppGetV1SubClientRetentionProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetV1SubClientRetentionProps')
	delete from GXDBVersions where aliasname = 'AppGetV1SubClientRetentionProps'
GO
print '... Creating Procedure: AppGetV1SubClientRetentionProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetV1SubClientRetentionProps
  @inXML xml
AS
  DECLARE @outXML xml
SET NOCOUNT OFF
------------------------------------------------------------------------------------------------------------------------------
----Need for this stored proc to fetch retention properties of v1 subclient from subclient policy is assigned
----1) When associating v1 subclient to policy, Java GUI doesnt expire (set modified time = <current>) for retention properties
----	Other subclient properties like DM rule flag get expired on associating
----2) Old Subclient and SubclientConf APIs get unexpired options from both subclient and subclient policy
----  Then fetch the value which was created latest.
----  CommServer/Db/Sp/APPGetSubclientProp.sp
----3) v1 and v2 retention screens are different.
----	But when v2 style subclient policy gets associated to v1 subclient, we fill in v1 retention paramters accordingly
------------------------------------------------------------------------------------------------------------------------------
--input xml attributes
DECLARE @inAppId INT = @inXML.value('(/App_GetV1SubClientRetentionPropsReq/@appId)[1]', 'integer')
--output variables
--Set subclient level defaults for CV_PROP_NOT_FOUND from Subclient.cpp
DECLARE @usrDeletedDataRetDays INT = 0 --CV_ITEM_PAST_EXPIRY_DAYS
DECLARE @sysDeletedStubRetDays INT = 730 --CV_ITEM_ARCHIVED_EXPIRATION_DAYS
DECLARE @usrDeletedStubRetDays INT = -1 --CV_ITEM_USER_DELETED_STUBS_EXPIRATION_DAYS
DECLARE @numPrevVersions INT = 0 --CV_PROP_NUMBER_OF_SYNTH_FULL_VERSIONS is 0
DECLARE @numVersions INT = 1 --CV_PROP_NUMBER_OF_SYNTH_FULL_VERSIONS is 0
DECLARE @keepOlderVersions INT = 2 --CV_PROP_OLDER_FILE_VERSION_MODE
DECLARE @numDaysOfVersions INT = 0 --CV_PROP_NUMBER_OF_DAYS_SYNTH_FULL_REGULAR is used in v1 And CV_PROP_NUMBER_OF_DAYS_OF_SYNTH_FULL_VERSIONS is used for v1 subclient policy
DECLARE @dmRuleFlag INT = -1 --No default For CV_DM_RULE_FLAG. Set -1 and caller irestore.cpp would fail.
DECLARE @outErrorCode int = 0
DECLARE @outErrorMessage nvarchar(max) = N''
--temp variables
DECLARE @backupRetentionModeV1 int = 1 --CV_ITEM_PAST_EXPIRY_TIME
DECLARE @backupRetentionMode int = 0
DECLARE @archiveRetentionMode int = 0
DECLARE @extendedStoragePolicyRetentionMode int = 0
DECLARE @maxIntVal INT = 2147483647
DECLARE @componentNameId INT = 0
DECLARE @maxIntValNumDays INT = 12427 --34 years. Since we have only signed int in sql, 68 years max reduced to 34 years.
DECLARE @associatedPolicyId INT = 0
DECLARE @retentionPolicyEnabled INT = 0
SET @outXML = N''
--argument error check
IF (@inAppId='' or @inAppId is null)
BEGIN
	SET @outErrorCode = 1
	SET @outErrorMessage = N'AppId input missing'
	GOTO CX_EXIT
END
SET @associatedPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @inAppId AND attrName = N'Associated subclient Policy' AND modified = 0 AND cs_attrName = checksum(N'Associated subclient Policy') ), 0)
SET @retentionPolicyEnabled = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = N'Subclient Policy Has Retention' AND modified = 0 AND cs_attrName = checksum(N'Subclient Policy Has Retention') ),0)
SET @componentNameId = @inAppId
IF @retentionPolicyEnabled > 0
BEGIN
	--set component name Id to subclient policy ID
	SET @componentNameId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @inAppId AND attrName = 'Associated subclient Policy' AND modified = 0), 0)
END
SELECT TOP 1 @dmRuleFlag = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Data Migrator Rule Flag' AND modified = 0 AND cs_attrName = checksum(N'Data Migrator Rule Flag') ORDER BY id DESC
--Do not fetch common retention properties to v2 subclient policy and v1 subclient here
--Although individual days property might be set by GUI even when root properties are off.
--v2 based subclient policy honours the properties only if ESP/Backup retention is set, else defaults are applied.
--Get extended storage policy retention settings
IF @retentionPolicyEnabled > 0
BEGIN
	--Isturbo subclient was repurposed in SP7 for ESP.
SET @extendedStoragePolicyRetentionMode = ISNULL((SELECT TOP 1 attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Turbo Subclient' AND modified = 0 AND cs_attrName = checksum(N'Is Turbo Subclient') ORDER BY id DESC), 0)
	IF @extendedStoragePolicyRetentionMode = 1
	BEGIN
		--Subclient policy GUI sets only v2 style params
SELECT TOP 1 @backupRetentionMode = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Backup Retention Mode Enabled' AND modified = 0 AND cs_attrName = checksum(N'Is Backup Retention Mode Enabled') ORDER BY id DESC
SELECT TOP 1 @archiveRetentionMode = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Archive Retention Mode Enabled' AND modified = 0 AND cs_attrName = checksum(N'Is Archive Retention Mode Enabled') ORDER BY id DESC
		--As per v2 retention, both user deleted files and stubs are retained based on CV_ITEM_PAST_EXPIRY_DAYS in backup retention mode
		IF @backupRetentionMode = 1
		BEGIN
			DECLARE @tmpMaxRetentionDays INT = -1
			DECLARE @tmpDays INT = 0
SELECT TOP 1 @tmpMaxRetentionDays=attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Days to keep items past their expiration' AND modified = 0 AND cs_attrName = checksum(N'Days to keep items past their expiration') ORDER BY id DESC
			--If archive mode is set, set tmpMaxRetentionDays as max of all values
			IF @archiveRetentionMode = 1
			BEGIN
SELECT TOP 1 @tmpDays = attrVal from APP_SubClientProp WITH (NOLOCK) where componentNameId = @componentNameId and attrName = N'Archived expiration days' and modified=0 AND cs_attrName = checksum(N'Archived expiration days') ORDER BY id DESC
				IF @tmpMaxRetentionDays < @tmpDays
					SET @tmpMaxRetentionDays = @tmpDays
SELECT TOP 1 @tmpDays = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'User deleted stubs expiration days' AND modified = 0 AND cs_attrName = checksum(N'User deleted stubs expiration days') ORDER BY id DESC
				IF @tmpMaxRetentionDays < @tmpDays
					SET @tmpMaxRetentionDays = @tmpDays
			END
			--Set all v1 retention value to max of v2 subclient property value
			SET @usrDeletedDataRetDays = @tmpMaxRetentionDays
			SET @usrDeletedStubRetDays = @tmpMaxRetentionDays
			--For system deleted stubs, Take max of default 730 and CV_ITEM_PAST_EXPIRY_DAYS
			IF @tmpMaxRetentionDays > @sysDeletedStubRetDays OR @tmpMaxRetentionDays = -1
				SET @sysDeletedStubRetDays = @tmpMaxRetentionDays
		END
		--Raise error on other invalid options
		IF @archiveRetentionMode = 0 AND @backupRetentionMode = 0
		BEGIN
			SET @outErrorCode = 1
			SET @outErrorMessage = N'Both modes are not set'
			goto CX_EXIT
		END
		IF @archiveRetentionMode = 1 AND @backupRetentionMode = 0
		BEGIN
			SET @outErrorCode = 1
			SET @outErrorMessage = N'Job based retention doesnt support synthetic full'
			goto CX_EXIT
		END
		--Get versions options
SELECT TOP 1 @keepOlderVersions = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Keep older Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Keep older Synth Full Versions') ORDER BY id DESC
		IF @keepOlderVersions <> 1 AND @keepOlderVersions <> 2
		BEGIN
			--On unsupported versions options, carry forward 10 versions
			SET @keepOlderVersions = 2
			SET @numPrevVersions = 10
			SET @numDaysOfVersions = 0
		END
		ELSE
		BEGIN
SELECT TOP 1 @numPrevVersions = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Number of Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Number of Synth Full Versions') ORDER BY id DESC
SELECT TOP 1 @numDaysOfVersions = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Number of Days of Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Number of Days of Synth Full Versions') ORDER BY id DESC
			--Set default for unused version option
			--Since v1 uses both options and doesnt worry about keepOlderVersions (1/2) checkbox selection
			IF @keepOlderVersions = 1 --App::RetainOlderFileVersions_KEEP_OLDER_VERSIONS_FOR_DAYS
			BEGIN
				SET @numPrevVersions = 0
			END
			IF @keepOlderVersions = 2 --App::RetainOlderFileVersions_KEEP_OLDER_VERSIONS
			BEGIN
				SET @numDaysOfVersions = 0
			END
		END
	END
END
ELSE
BEGIN
	--Maintaining v1 behaviour from getExpireTimeout() in irestore.cpp
SELECT TOP 1 @backupRetentionModeV1 = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Is Backup Retention Mode Enabled' AND modified = 0 AND cs_attrName = checksum(N'Is Backup Retention Mode Enabled') ORDER BY id DESC
	IF @backupRetentionModeV1 = 1
SELECT TOP 1 @usrDeletedDataRetDays = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Days to keep items past their expiration' AND modified = 0 AND cs_attrName = checksum(N'Days to keep items past their expiration') ORDER BY id DESC
	ELSE
		SET @usrDeletedDataRetDays = -1
	--Maintaining v1 behaviour from getArchivalTimeout() in irestore.cpp. Set system deleted only when donotcreatestub is set
IF @dmRuleFlag & 0x000004 = 0x000004
SELECT TOP 1 @sysDeletedStubRetDays = attrVal from APP_SubClientProp WITH (NOLOCK) where componentNameId = @componentNameId and attrName = N'Archived expiration days' and modified=0 AND cs_attrName = checksum(N'Archived expiration days') ORDER BY id DESC
	ELSE
		SET @sysDeletedStubRetDays = -1
	--Fetch other options blindly. as in irestore.
SELECT TOP 1 @usrDeletedStubRetDays = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'User deleted stubs expiration days' AND modified = 0 AND cs_attrName = checksum(N'User deleted stubs expiration days') ORDER BY id DESC
SELECT TOP 1 @numPrevVersions = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Number of Synth Full Versions' AND modified = 0 AND cs_attrName = checksum(N'Number of Synth Full Versions') ORDER BY id DESC
SELECT TOP 1 @numDaysOfVersions = attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @componentNameId AND attrName = N'Max Days Synth Full Carry Forward Regular' AND modified = 0 AND cs_attrName = checksum(N'Max Days Synth Full Carry Forward Regular') ORDER BY id DESC
END
--v1 GUI & Subclient policy v2 GUI takes in previous versions and irestore takes in total versions, hence add 1
set @numVersions = @numPrevVersions
IF (@numVersions < @maxIntVal)
	set @numVersions = @numVersions + 1
SET @outXML = (SELECT @numVersions as '@numVersions', @numDaysOfVersions as '@numDaysOfVersions',
	@usrDeletedDataRetDays as '@usrDeletedDataRetDays', @usrDeletedStubRetDays as '@usrDeletedStubRetDays', @sysDeletedStubRetDays as '@sysDeletedStubRetDays',
	@retentionPolicyEnabled as '@retentionPolicyEnabled'
	FOR XML PATH('App_GetV1SubClientRetentionPropsResp') , TYPE)
CX_EXIT:
IF @outErrorCode <> 0
BEGIN
	SET @outXml = ( SELECT
	(SELECT @outErrorCode as '@errorCode',
	@outErrorMessage as '@errorMessage'
    FOR XML PATH('errorResp'), TYPE)
	FOR XML PATH('App_GetV1SubClientRetentionPropsResp'), TYPE)
END
SELECT @outXML
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetV1SubClientRetentionProps')
	delete from GxQscripts where name = 'AppGetV1SubClientRetentionProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetV1SubClientRetentionProps')
	delete from GXDBVersions where aliasname = 'AppGetV1SubClientRetentionProps'
GO

insert into GXDBVersions values(2, 'AppGetV1SubClientRetentionProps',  '00000000000000000000', 'AppGetV1SubClientRetentionProps', '00000000000000000000')
GO

