

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUsersToMigrateToAD.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Get all the users that belongs to the organization of the userId and that are not of provider type 2(AD)
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetUsersToMigrateToAD')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUsersToMigrateToAD <<<'
	drop procedure AppGetUsersToMigrateToAD
END
IF EXISTS (select * from GxQscripts where name='AppGetUsersToMigrateToAD')
	delete from GxQscripts where name = 'AppGetUsersToMigrateToAD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUsersToMigrateToAD')
	delete from GXDBVersions where aliasname = 'AppGetUsersToMigrateToAD'
GO
print '... Creating Procedure: AppGetUsersToMigrateToAD'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUsersToMigrateToAD
  @userId INT,
  @forCompanyId INT
AS
  DECLARE @domain NVARCHAR(MAX) = N''
  DECLARE @ProviderAD NVARCHAR(MAX) = N''
  DECLARE @emailList NVARCHAR(MAX) = N''
BEGIN TRY
DECLARE  @i_includeFlags integer = CAST( 0x001 AS INT)
DECLARE @i_excludeFlags integer = CAST(0x200 AS INT)|CAST(0x004 AS INT)|CAST(0x080 AS INT)|CAST(0x100 AS INT)
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(max)
	DECLARE @UsersToMigrate table (domain nvarchar(255), providerOfAd nvarchar(max), emails nvarchar(max))
	DECLARE @providerId int = 0
	IF(@forCompanyId > 0)--This takes a priority. If the request is for certain company use that company and not the logged in userId providerId
	BEGIN
		SET @providerId = dbo.AppGetCompanyForProvider(@forCompanyId)
	END
	ELSE
	BEGIN
		SET @providerId=(SELECT  umdsproviderId FROM umusers u
INNER JOIN UMDSProviders p ON u.umDSproviderId=p.id AND p.serviceType=5
								WHERE u.id=@userId)
	END
	IF(@providerId>0)
	BEGIN
		INSERT INTO @UsersToMigrate
		SELECT RIGHT(email, (len(email)- (CHARINDEX('@', email)))) ,ISNULL(p.domainName,''),email
		FROM umusers u
		LEFT JOIN APP_ComponentProp prop on componentType=112 and right(email, (len(email)- (CHARINDEX('@', email)))) = prop.stringVal
		LEFT JOIN UMDSProviders p on p.id=prop.componentId
		WHERE umDSproviderId=@providerId AND email<>''
		AND U.flags & @i_excludeFlags = 0 AND U.flags & @i_includeFlags <> 0
		GROUP BY RIGHT(email, (len(email)- (CHARINDEX('@', email)))) ,p.domainName, email
	END
	SELECT  domain,providerOfAd,
		SUBSTRING(d.EmailList,1, LEN(d.EmailList) - 1) EmailList
		FROM
		(
			SELECT DISTINCT domain, providerOfAd
			FROM @UsersToMigrate
		) a
		CROSS APPLY
		(
			SELECT emails + ','
			FROM @UsersToMigrate AS B
			WHERE A.[domain] = B.[domain]
			FOR XML PATH('')
		) D (emailList)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUsersToMigrateToAD')
	delete from GxQscripts where name = 'AppGetUsersToMigrateToAD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUsersToMigrateToAD')
	delete from GXDBVersions where aliasname = 'AppGetUsersToMigrateToAD'
GO

insert into GXDBVersions values(2, 'AppGetUsersToMigrateToAD',  '00000000000000000000', 'AppGetUsersToMigrateToAD', '00000000000000000000')
GO

