

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUsersForEdgeSystemDrive.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_sharingGetUsersAndGroupsList()
--  | Description:  Gets list of Users and User Groups
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUsersForEdgeSystemDrive.sp,v $ $Id: AppGetUsersForEdgeSystemDrive.sp,v 1.3.40.4 2018/07/05 16:32:46 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUsersForEdgeSystemDrive <<<'

IF EXISTS (select * from sysobjects where name='AppGetUsersForEdgeSystemDrive')
	drop procedure AppGetUsersForEdgeSystemDrive
IF EXISTS (select * from GxQscripts where name='AppGetUsersForEdgeSystemDrive')
	delete from GxQscripts where name = 'AppGetUsersForEdgeSystemDrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUsersForEdgeSystemDrive')
	delete from GXDBVersions where aliasname = 'AppGetUsersForEdgeSystemDrive'
GO
print '... Creating Procedure: AppGetUsersForEdgeSystemDrive'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUsersForEdgeSystemDrive
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	-- Fetch the user list who do not have any edge drive backupset and who do not have edge drive client association.
	-- Later handling for specific system drive type can come in.
 DECLARE @isADUsersEnabled INT = ISNULL((SELECT 1 from GXGlobalParam(NOLOCK) WHERE name ='EnableADForObjectStoreSystemUsers' and value='true'),0)
	SET @o_xmlText =
		(
			SELECT
				(
					SELECT	UM.id AS '@userId',
							UM.login AS '@userName'
					FROM UMUsers UM WITH(NOLOCK)
					WHERE UM.id > 0
					AND UM.flags & 0x001 <> 0  -- USERS_VALID
					AND UM.flags & 0x004 = 0 -- USERS_HIDE
					AND (@isADUsersEnabled = 1 OR UM.umDSProviderId = 0 /** Non AD users only**/ )
					AND NOT EXISTS(SELECT 1 FROM APP_BackupSetProp WITH(NOLOCK)
									 WHERE attrName = 'Edge Drive User Id' AND modified = 0
									 AND attrVal = CAST(UM.id AS NVARCHAR(MAX))
									 )
					AND NOT EXISTS(	SELECT 1 FROM App_EdgeDriveAssociation WITH(NOLOCK)
									WHERE entityType = 1 AND entityId = UM.id
									)
					FOR XML PATH('userList'), TYPE
				)
			FOR XML PATH('App_GetEdgeDriveSystemUsersResp'), TYPE
		)
	SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUsersForEdgeSystemDrive')
	delete from GxQscripts where name = 'AppGetUsersForEdgeSystemDrive'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUsersForEdgeSystemDrive')
	delete from GXDBVersions where aliasname = 'AppGetUsersForEdgeSystemDrive'
GO

insert into GXDBVersions values(2, 'AppGetUsersForEdgeSystemDrive',  '00010003004000040000', 'AppGetUsersForEdgeSystemDrive', '00010003004000040000')
GO

