

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserRoleType.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetUserRoleType()
--  | Description:  Allows for GET of user role and provider ID in Plan context as MSP Admin, Tenant Admin and Tenant User
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserRoleType.sp,v $ $Id: AppGetUserRoleType.sp,v 1.1.2.7 2020/10/22 14:57:16 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetUserRoleType')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUserRoleType <<<'
	drop procedure AppGetUserRoleType
END
IF EXISTS (select * from GxQscripts where name='AppGetUserRoleType')
	delete from GxQscripts where name = 'AppGetUserRoleType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserRoleType')
	delete from GXDBVersions where aliasname = 'AppGetUserRoleType'
GO
print '... Creating Procedure: AppGetUserRoleType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserRoleType
  @i_userId INTEGER,
  @o_userRole INTEGER OUTPUT,
  @o_providerId INTEGER OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString nvarchar(1024) OUTPUT,
  @returnCursor INT = 0
AS
  DECLARE @userRoleOutput INTEGER
  DECLARE @providerIdOutput INTEGER
  DECLARE @errCodeOutput INT
  DECLARE @errStringOutput nvarchar(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isMSPUserComcellAdmin INTEGER = 0
DECLARE @deniedNavItems NVARCHAR(1024)
BEGIN TRY
	IF EXISTS(SELECT 1 FROM UMUsers Where id=@i_userId)
	BEGIN
        SET @o_providerId = dbo.AppGetOrganizationForUser(@i_userId)
        DECLARE @o_isRestrictedUser INTEGER = 0
        DECLARE @isRestrictedViewEnabled INT = ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
        IF @isRestrictedViewEnabled <> 0
            EXEC sec_isUserInRestrictedGroup @i_userId, @o_isRestrictedUser OUTPUT
        IF @o_isRestrictedUser = 0
        BEGIN
IF EXISTS(SELECT 1 FROM UMDSProviders WITH (NOLOCK) WHERE id=@o_providerId AND serviceType !=5)
		    BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isMSPUserComcellAdmin OUT,1,2
			    IF (@isMSPUserComcellAdmin = 1)
				    BEGIN
				    -- MSP Admin
				    -- User Enum defined in api.x
SET @o_userRole = 0
				    END
			    ELSE
			    BEGIN
				    -- MSP User with limited capability
				    -- User Enum defined in api.x
SET @o_userRole = 3
			    END
		    END
		    ELSE
		    BEGIN
IF EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x10000 <> 0 and UU.userId=@i_userId)
OR EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags&0x40000<> 0 and UU.userId=@i_userId)
OR EXISTS(SELECT 1 FROM UMDSGroupMaps ugm INNER JOIN UMUserGroup uu ON ugm.umDSgroupId = uu.groupId INNER JOIN UMGroups UG ON ug.id=ugm.umgroupId AND UG.groupFlags&0x10000 <> 0 WHERE UU.userId=@i_userId )
				-- Till SP22, since the Tenant Opreator UG was visible, some setups had users manually added into it. We moved them out and made those User Ids directly as Operators.
				-- Left-side navigation pane in Command center, was preiously shown to these users, as they part of the group. Now as they moved out, we need this code, for it to work.
				OR EXISTS(SELECT 1 FROM UMOperators UMO WHERE userOrgroupId = @i_userId AND isUser = 1)
				    BEGIN
					    -- User has rights
					    -- Tenant Admin
SET @o_userRole = 1
				    END
			    ELSE
				    BEGIN
					    -- User does not have all rights
					    -- Tenant User
SET @o_userRole = 2
				    END
		    END
        END
        ELSE
        BEGIN
            -- Restricted user
            -- User from group named  - CV_Restricted_Visibility and setting 'Restricted View Enabled' being set
SET @o_userRole = 4
        END
		set @o_errCode = 0
		set @o_errString = ''
	END
	ELSE
    BEGIN
		set @o_errCode = 1001
		set @o_errString = 'Not able to determine user role'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = ERROR_MESSAGE()
END CATCH
IF @returnCursor <> 0
     SELECT @o_userRole, @o_providerId, @o_errCode, @o_errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserRoleType')
	delete from GxQscripts where name = 'AppGetUserRoleType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserRoleType')
	delete from GXDBVersions where aliasname = 'AppGetUserRoleType'
GO

insert into GXDBVersions values(2, 'AppGetUserRoleType',  '00010001000200070000', 'AppGetUserRoleType', '00010001000200070000')
GO

