

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserRole.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetUserRole()
--  | Description:  Allows for GET of user role in Plan context as MSP Admin, Tenant Admin and Tenant User
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserRole.sp,v $ $Id: AppGetUserRole.sp,v 1.1.2.22.6.1 2021/04/06 04:19:11 sthakkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetUserRole')
BEGIN
	print '>>> Drop Stored Procedure: AppGetUserRole <<<'
	drop procedure AppGetUserRole
END
IF EXISTS (select * from GxQscripts where name='AppGetUserRole')
	delete from GxQscripts where name = 'AppGetUserRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserRole')
	delete from GXDBVersions where aliasname = 'AppGetUserRole'
GO
print '... Creating Procedure: AppGetUserRole'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetUserRole
  @i_userId INTEGER,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString nvarchar(1024) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @providerId     INTEGER
	DECLARE @userRole      	INTEGER
	DECLARE @deniedNavItems NVARCHAR(MAX)
	DECLARE @includeNavItems NVARCHAR(MAX)
	DECLARE @defaultLandingPage NVARCHAR(1024) = ''
	DECLARE @isGlobalNavSettingPresent INTEGER = 0
	DECLARE @isAllowedtoCreateCompanies   INTEGER = 0
	DECLARE @showDistributedStorage INTEGER = 0
	EXEC AppGetUserRoleType  @i_userId, @userRole OUTPUT, @providerId OUTPUT,  @o_errCode OUTPUT, @o_errString OUTPUT
	IF @o_errCode = 0
	BEGIN
		DECLARE @impersonatedUserRole INT, @impersonatedUserProviderId INT
		-- If user is a reseller operator and he has a default operator company, then get the get user mappings of that impersonated user as well.
		DECLARE @operatorCompanyId INT
		SELECT @operatorCompanyId = CAST(attrVal AS INT)
		FROM UMUsersProp (NOLOCK)
		WHERE
			componentNameId = @i_userId
AND attrName = 'DefaultOperatorCompany'
			AND modified = 0
		IF @operatorCompanyID IS NOT NULL AND @operatorCompanyID <> 0			-- When default operator company is unset, it is set as 0 in DB. So check for 0 as well explicitly.
		AND (dbo.sec_isUserOperator(@i_userId, @operatorCompanyId) = 1)			-- User might be marked operator before, but then removed from operator list. So confirm once before proceeding.
		BEGIN
			DECLARE @impersonatedUserID INT
			SET @impersonatedUserID = dbo.sec_getImpersonationUserIdForReseller(@i_userId, @operatorCompanyId)
		END
		ELSE
		BEGIN
			SET @operatorCompanyId = NULL
		END
		IF @impersonatedUserID <> 0
			EXEC AppGetUserRoleType @impersonatedUserID, @impersonatedUserRole OUTPUT, @impersonatedUserProviderId OUTPUT,  @o_errCode OUTPUT, @o_errString OUTPUT
	END
	IF @o_errCode=0
	BEGIN
		-- Role_Tenant_Admin
		IF (@userRole = 1)
		BEGIN
			-- We need to check companies properties only for Tenant Admin. Only Tenant Admin will be able to Manage other Companies if required property is set.
SET @isAllowedtoCreateCompanies = (SELECT attrValInt FROM  App_CompanyProp WHERE componentNameId=@providerId AND attrName  = 'Allow to Manage Other Companies' AND modified=0)
		END
		-- Get 1 Table for mapping with user role and there property name
		DECLARE @navSettings          TABLE (roleType INT PRIMARY KEY , propertyName VARCHAR(64), landingPagePropertyName VARCHAR(64), includePropName VARCHAR(64))
		INSERT INTO @navSettings
VALUES (0, 'Restricted Nav Items For MSP Admin', 'Default Landing Page For MSP Admin',NULL),
(1, 'Restricted Nav Items For Tenant Admin', 'Default Landing Page For Tenant Admin','Include Nav Items For Tenant Admin'),
(2, 'Restricted Nav Items For Tenant User', 'Default Landing Page For Tenant User','Include Nav Items For Tenant User'),
(3, 'Restricted Nav Items For MSP User', 'Default Landing Page For MSP User',NULL),
(4, 'Restricted Nav Items For Restricted Admin', 'Default Landing Page For Restricted Admin',NULL)
		SELECT @deniedNavItems = COALESCE(@deniedNavItems + ',','') + TBL.Data FROM
		(SELECT S.Data AS Data from
		(SELECT value FROM GXGlobalParam gp
			INNER JOIN @navSettings NS
				ON GP.name=NS.propertyName AND NS.roleType=@userRole) C
			CROSS APPLY dbo.SplitString(C.value, ',') S
		EXCEPT
		SELECT T.Data  AS Data from
		(SELECT attrVal FROM App_CompanyProp ACP1
			INNER JOIN @navSettings NS
				ON ACP1.attrName=NS.includePropName AND NS.roleType=@userRole AND ACP1.componentNameId=@providerId AND attrVal IS NOT NULL) C
			CROSS APPLY dbo.SplitString(C.attrVal, ',') T
		UNION
		SELECT W.Data  AS Data from
		(SELECT attrVal FROM App_CompanyProp ACP
			INNER JOIN @navSettings NS
				ON ACP.attrName=NS.propertyName AND NS.roleType=@userRole AND ACP.componentNameId=@providerId AND attrVal IS NOT NULL) C
			CROSS APPLY dbo.SplitString(C.attrVal, ',') W
		UNION
		SELECT U.Data AS Data from
(SELECT cast(value as nvarchar(max)) as value from app_advancesettings where keyName = 'hideNavItems' AND entityId = @i_userId AND entityType = 13) C
			CROSS APPLY  dbo.SplitString(C.value, ',') U) TBL
SET @includeNavItems = ISNULL((SELECT value FROM APP_AdvanceSettings where keyName = 'includeNavItems' AND entityId =
@i_userId AND entityType = 13),NULL)
		SET @defaultLandingPage = (SELECT attrVal FROM App_CompanyProp ACP
									INNER JOIN @navSettings NS
										ON ACP.attrName=NS.landingPagePropertyName AND NS.roleType=@userRole AND ACP.componentNameId=@providerId AND attrVal IS NOT NULL)
		IF @defaultLandingPage IS NULL OR @defaultLandingPage = ''
		BEGIN
			SET @defaultLandingPage = (SELECT value FROM GXGlobalParam gp
										INNER JOIN @navSettings NS
											ON GP.name=NS.landingPagePropertyName AND NS.roleType=@userRole)
		END
		-- AdminConsole Navigation items are not correctly aligned if tenant admin overwrites some items for himself and there is no denied navigation setting at global level.
		-- MR - 202982
		SELECT @isGlobalNavSettingPresent=1 FROM GXGlobalParam gp
						INNER JOIN @navSettings NS
						ON GP.name=NS.propertyName AND NS.roleType=@userRole
		DECLARE @operatorCompaniesXML XML
				,@operatorCompaniesNewXML XML
				,@deactivatedOperatorCompaniesXML XML
		EXEC sec_getResellerCompaniesForUserForUI @i_userId, @operatorCompaniesXML OUTPUT, @operatorCompaniesNewXML OUTPUT, @deactivatedOperatorCompaniesXML OUTPUT
		------ CHECK IF DISTRIBUTED STORAGE SHOULD BE SHOWN ON THE LFET NAV FOR THIS USER STARTS ------
		-- MSP ADMIN CAN ALWAYS SEE THE DISTRIBUTED STORAGE ON THE LEFT NAV
		DECLARE @masterGroupId INT = dbo.getMasterGroupId()
		IF @masterGroupId IN (SELECT groupId FROM UMUserGroup (NOLOCK) WHERE userId = @i_userId)
		BEGIN
			SET @showDistributedStorage = 1
		END
		-- CHECK IF USER CAN VIEW OR MANAGE AT LEAST ONE DISTRIBUTED STORAGE
		IF @showDistributedStorage = 0
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
				DROP TABLE #getObjectsTable
			CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
			IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
				DROP TABLE #permissionIdTable
			CREATE TABLE #permissionIdTable (permissionId INT)
			INSERT INTO  #permissionIdTable
			(permissionId)
VALUES (260), (261)
EXEC sec_getObjectsWithPermissionsV2 @i_userId, 195, 0
			IF EXISTS (SELECT TOP 1 entityId FROM #getObjectsTable)
			BEGIN
				SET @showDistributedStorage = 1
			END
		END
		-- CHECK IF USER HAS REGISTER DISTRIBUTED STORAGE PERMISSION AT CC LEVEL
		IF @showDistributedStorage = 0
		BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 259, @showDistributedStorage OUTPUT, 1, 2
		END
		-- IF USER HAS NO REGISTER PERMISSION AT CC LEVEL, CHECK IF USER HAS REGISTER DISTRIBUTED STORAGE PERMISSION AT COMPANY LEVEL
		IF @showDistributedStorage = 0
		BEGIN
			DECLARE @organizationId	INT = dbo.AppGetOrganizationForUser(@i_userId)
			IF @organizationId <> 0
			BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 259, @showDistributedStorage OUTPUT, 61, @organizationId
			END
		END
		------ CHECK IF DISTRIBUTED STORAGE SHOULD BE SHOWN ON THE LFET NAV FOR THIS USER ENDS ------
		SET @o_xmlText = (SELECT @providerId AS '@providerId',
				@userRole AS '@userRole',
								@deniedNavItems AS '@deniedNavItems',
								@includeNavItems AS '@includeNavItems',
								@defaultLandingPage AS '@defaultLandingPage',
								@isGlobalNavSettingPresent AS '@isGlobalNavSettingPresent',
								@isAllowedtoCreateCompanies AS '@isAllowedtoCreateCompanies',
								@showDistributedStorage AS '@showDistributedStorage',
								@operatorCompaniesXML,
								@deactivatedOperatorCompaniesXML,
								@operatorCompaniesNewXML,
								(
									SELECT @impersonatedUserRole AS '@userRole'
											,(
												SELECT id AS '@providerId'
													   ,hostName AS '@providerDomainName'
,61 AS '@_type_'
												FROM UMDSProviders (NOLOCK)
												WHERE
													id = @operatorCompanyID
												FOR XML PATH('operatorCompany'), TYPE
											)
									FOR XML PATH('defaultOperator'), TYPE
								)
		FOR XML PATH('Api_GetUserMappings'),TYPE)
	END
	ELSE
    BEGIN
		set @o_errCode = 1001
		set @o_errString = 'Not able to determine user role'
		set @o_xmlText = '<Api_GetUserMappings/>'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = '<Api_GetUserMappings/>'
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserRole')
	delete from GxQscripts where name = 'AppGetUserRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserRole')
	delete from GXDBVersions where aliasname = 'AppGetUserRole'
GO

insert into GXDBVersions values(2, 'AppGetUserRole',  'v1.1.2.22.6.1', 'AppGetUserRole', 'v1.1.2.22.6.1')
GO

