

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetUserProfilesListForAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetUserProfilesListForAppId.sp,v $ $Id: AppGetUserProfilesListForAppId.sp,v 1.3.34.2 2018/03/27 09:18:24 jiechen Exp $";
-- =========================================================
-- Description:	Get the user profile value for given subclient id.
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetUserProfilesListForAppId <<<'

IF EXISTS (select * from sysobjects where name='AppGetUserProfilesListForAppId')
	drop procedure AppGetUserProfilesListForAppId
IF EXISTS (select * from GxQscripts where name='AppGetUserProfilesListForAppId')
	delete from GxQscripts where name = 'AppGetUserProfilesListForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserProfilesListForAppId')
	delete from GXDBVersions where aliasname = 'AppGetUserProfilesListForAppId'
GO
print '... Creating Procedure: AppGetUserProfilesListForAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetUserProfilesListForAppId
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
DECLARE @inAppId INT = 0
SET @inAppId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
                    FROM @i_xmlText.nodes ('App_GetUserProfilesRequest/entity') R(ref)), 0)
DECLARE @excludeStatusMask int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
DECLARE @o_xmlText XML
SET @o_xmlText =
	( SELECT p.attrVal AS '@val'
			FROM app_application a WITH (NOLOCK)
			INNER JOIN APP_SubClientProp p WITH (NOLOCK) ON p.componentNameId=a.id and p.attrName='userprofile' and p.modified=0
			WHERE a.id=@inAppId and subclientStatus&@excludeStatusMask = 0
			FOR XML PATH('userProfiles'), ROOT ('App_GetUserProfilesResponse') )
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetUserProfilesListForAppId')
	delete from GxQscripts where name = 'AppGetUserProfilesListForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetUserProfilesListForAppId')
	delete from GXDBVersions where aliasname = 'AppGetUserProfilesListForAppId'
GO

insert into GXDBVersions values(2, 'AppGetUserProfilesListForAppId',  '00010003003400020000', 'AppGetUserProfilesListForAppId', '00010003003400020000')
GO

